/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.attachment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.tool.jsf.attachment.RemoveAttachment;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;

public class AttachmentHandler
implements Serializable {
    private static Log log = LogFactory.getLog(AttachmentHandler.class);
    private List<SignupAttachment> attachments;
    private SakaiFacade sakaiFacade;
    private SignupMeetingService signupMeetingService;

    public AttachmentHandler() {
    }

    public AttachmentHandler(SakaiFacade sakaiFacade, SignupMeetingService signupMeetingService) {
        this.sakaiFacade = sakaiFacade;
        this.signupMeetingService = signupMeetingService;
    }

    public void clear() {
        this.attachments = null;
    }

    public String processAddAttachRedirect(List attachList, SignupMeeting sMeeting, boolean isOrganizer) {
        this.attachments = attachList;
        try {
            List filePickerList = this.prepareReferenceList(this.attachments, sMeeting, isOrganizer);
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("sakaiproject.filepicker.attachments", (Object)filePickerList);
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.filepicker.helper/tool");
        }
        catch (Exception e) {
            log.error((Object)("fail to redirect to attachment page: " + e.getMessage()));
        }
        return null;
    }

    private List prepareReferenceList(List attachmentList, SignupMeeting sMeeting, boolean isOrganizer) {
        ArrayList<Reference> list = new ArrayList<Reference>();
        if (attachmentList == null) {
            return list;
        }
        for (int i = 0; i < attachmentList.size(); ++i) {
            Reference ref;
            ContentResource cr = null;
            SignupAttachment attach = (SignupAttachment)attachmentList.get(i);
            try {
                cr = this.getSakaiFacade().getContentHostingService().getResource(attach.getResourceId());
            }
            catch (PermissionException e) {
                log.warn((Object)("ContentHostingService.getResource() throws PermissionException=" + e.getMessage()));
            }
            catch (IdUnusedException e) {
                log.warn((Object)("ContentHostingService.getResource() throws IdUnusedException=" + e.getMessage()));
                RemoveAttachment removeAttach = new RemoveAttachment(this.signupMeetingService, this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId(), isOrganizer);
                removeAttach.removeAttachment(sMeeting, attach);
            }
            catch (TypeException e) {
                log.warn((Object)("ContentHostingService.getResource() throws TypeException=" + e.getMessage()));
            }
            catch (Exception e) {
                log.warn((Object)("Exception: " + e.getMessage()));
            }
            if (cr == null || (ref = EntityManager.newReference((String)cr.getReference())) == null) continue;
            list.add(ref);
        }
        return list;
    }

    public void setAttachmentItems() {
        this.processItemAttachment();
    }

    private void processItemAttachment() {
        ToolSession session = SessionManager.getCurrentToolSession();
        if (session.getAttribute("sakaiproject.filepicker.attachments") != null) {
            HashMap map = this.getResourceIdHash(this.attachments);
            ArrayList<SignupAttachment> newAttachmentList = new ArrayList<SignupAttachment>();
            String protocol = this.getSakaiFacade().getServerConfigurationService().getServerUrl();
            List refs = (List)session.getAttribute("sakaiproject.filepicker.attachments");
            if (refs != null && refs.size() > 0) {
                for (int i = 0; i < refs.size(); ++i) {
                    Reference ref = (Reference)refs.get(i);
                    String resourceId = ref.getId();
                    if (map.get(resourceId) == null) {
                        SignupAttachment newAttach = this.createSignupAttachment(ref.getId(), ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName()), protocol);
                        newAttachmentList.add(newAttach);
                        continue;
                    }
                    newAttachmentList.add((SignupAttachment)map.get(resourceId));
                    map.remove(resourceId);
                }
            }
            session.removeAttribute("sakaiproject.filepicker.attachments");
            session.removeAttribute("sakaiproject.filepicker.cancel");
            this.attachments.clear();
            this.attachments.addAll(newAttachmentList);
        }
    }

    private HashMap<String, SignupAttachment> getResourceIdHash(List<SignupAttachment> attachList) {
        HashMap<String, SignupAttachment> map = new HashMap<String, SignupAttachment>();
        if (attachList != null) {
            for (SignupAttachment attach : attachList) {
                map.put(attach.getResourceId(), attach);
            }
        }
        return map;
    }

    public SignupAttachment copySignupAttachment(SignupMeeting sMeeting, boolean isOrganizer, SignupAttachment attach, String folderId) {
        SignupAttachment newAttach = null;
        ContentResource cr = null;
        ContentResource newCr = null;
        if (attach == null || attach.getResourceId().trim().length() < 1) {
            return null;
        }
        String newResourceId = attach.getResourceId();
        int index = attach.getResourceId().lastIndexOf("/");
        if (index > -1) {
            newResourceId = newResourceId.substring(0, index + 1) + folderId + "/" + newResourceId.substring(index + 1, newResourceId.length());
        }
        try {
            cr = this.getSakaiFacade().getContentHostingService().getResource(attach.getResourceId());
            if (cr != null) {
                String protocol = this.getSakaiFacade().getServerConfigurationService().getServerUrl();
                newResourceId = this.getSakaiFacade().getContentHostingService().copy(attach.getResourceId(), newResourceId);
                newCr = this.getSakaiFacade().getContentHostingService().getResource(newResourceId);
                Reference ref = EntityManager.newReference((String)newCr.getReference());
                if (ref != null) {
                    newAttach = this.createSignupAttachment(ref.getId(), ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName()), protocol);
                    this.determineAndAssignPublicView(sMeeting, newAttach);
                }
            }
        }
        catch (PermissionException e) {
            log.warn((Object)("ContentHostingService.getResource() throws PermissionException=" + e.getMessage()));
        }
        catch (IdUnusedException e) {
            log.warn((Object)("ContentHostingService.getResource() throws IdUnusedException=" + e.getMessage()));
            RemoveAttachment removeAttach = new RemoveAttachment(this.signupMeetingService, this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId(), isOrganizer);
            removeAttach.removeAttachment(sMeeting, attach);
        }
        catch (TypeException e) {
            log.warn((Object)("ContentHostingService.getResource() throws TypeException=" + e.getMessage()));
        }
        catch (Exception e) {
            log.warn((Object)("ContentHostingService.getResource() throws Exception=" + e.getMessage()));
        }
        return newAttach;
    }

    public void removeAttachmentInContentHost(SignupAttachment attach) {
        if (attach == null || attach.getResourceId() == null) {
            return;
        }
        try {
            this.getSakaiFacade().getContentHostingService().removeResource(attach.getResourceId());
        }
        catch (PermissionException e) {
            log.warn((Object)("ContentHostingService.getResource() throws PermissionException=" + e.getMessage()));
        }
        catch (IdUnusedException e) {
            log.warn((Object)("ContentHostingService.getResource() throws IdUnusedException=" + e.getMessage()));
        }
        catch (TypeException e) {
            log.warn((Object)("ContentHostingService.getResource() throws TypeException=" + e.getMessage()));
        }
        catch (InUseException e) {
            log.warn((Object)("ContentHostingService.getResource() throws InUseException=" + e.getMessage()));
        }
        catch (Exception e) {
            log.warn((Object)("ContentHostingService.getResource() throws Exception=" + e.getMessage()));
        }
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeetingService getSignupMeetingService() {
        return this.signupMeetingService;
    }

    public void setSignupMeetingService(SignupMeetingService signupMeetingService) {
        this.signupMeetingService = signupMeetingService;
    }

    public List<SignupAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<SignupAttachment> attachments) {
        this.attachments = attachments;
    }

    protected SignupAttachment createSignupAttachment(String resourceId, String filename, String protocol) {
        SignupAttachment attach = new SignupAttachment();
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = this.getSakaiFacade().getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new SignupAttachment();
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(new Long("" + this.fileSizeInKB((int)cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            log.warn((Object)("PermissionException: " + pe.getMessage()));
        }
        catch (IdUnusedException ie) {
            log.warn((Object)("IdUnusedException: " + ie.getMessage()));
        }
        catch (TypeException te) {
            log.warn((Object)("TypeException: " + te.getMessage()));
        }
        return attach;
    }

    private String fileSizeInKB(int fileSize) {
        String fileSizeString = "1";
        int size = Math.round((float)fileSize / 1024.0f);
        if (size > 0) {
            fileSizeString = size + "";
        }
        return fileSizeString;
    }

    public String getRelativePath(String url, String protocol) {
        int index = (url = this.replaceSpace(url)).lastIndexOf(protocol);
        if (index == 0) {
            url = url.substring(protocol.length());
        }
        return url;
    }

    public void setPublicView(String resourceId, boolean pubview) {
        this.getSakaiFacade().getContentHostingService().setPubView(resourceId, pubview);
    }

    private String replaceSpace(String tempString) {
        String newString = "";
        char[] oneChar = new char[1];
        for (int i = 0; i < tempString.length(); ++i) {
            if (tempString.charAt(i) != ' ') {
                oneChar[0] = tempString.charAt(i);
                String concatString = new String(oneChar);
                newString = newString.concat(concatString);
                continue;
            }
            newString = newString.concat("%20");
        }
        return newString;
    }

    public void determineAndAssignPublicView(SignupMeeting sMeeting, SignupAttachment attach) {
        if (attach == null) {
            return;
        }
        if (sMeeting.getSignupSites() != null && sMeeting.getSignupSites().size() > 1) {
            this.getSakaiFacade().getContentHostingService().setPubView(attach.getResourceId(), true);
            return;
        }
        Site site = null;
        if (sMeeting.getSignupSites() == null || sMeeting.getSignupSites().isEmpty()) {
            return;
        }
        SignupSite signupSite = (SignupSite)sMeeting.getSignupSites().get(0);
        try {
            site = this.getSakaiFacade().getSiteService().getSite(signupSite.getSiteId());
        }
        catch (IdUnusedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (site == null) {
            return;
        }
        if (!site.getId().equals(this.sakaiFacade.getCurrentLocationId())) {
            this.getSakaiFacade().getContentHostingService().setPubView(attach.getResourceId(), true);
            return;
        }
        Set siteRoles = site.getRoles();
        if (siteRoles != null) {
            for (Role role : siteRoles) {
                if (!".auth".equals(role.getId())) continue;
                this.getSakaiFacade().getContentHostingService().setPubView(attach.getResourceId(), true);
                break;
            }
        }
    }
}

