/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.signup.logic.SignupUser;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfo;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.tool.jsf.AttendeeWrapper;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.signup.tool.jsf.SignupUIBaseBean;
import org.sakaiproject.signup.tool.jsf.TimeslotWrapper;
import org.sakaiproject.signup.tool.jsf.organizer.CopyMeetingSignupMBean;
import org.sakaiproject.signup.tool.jsf.organizer.EditMeetingSignupMBean;
import org.sakaiproject.signup.tool.jsf.organizer.ViewCommentSignupMBean;
import org.sakaiproject.signup.tool.jsf.organizer.action.AddAttendee;
import org.sakaiproject.signup.tool.jsf.organizer.action.AddWaiter;
import org.sakaiproject.signup.tool.jsf.organizer.action.CancelAttendee;
import org.sakaiproject.signup.tool.jsf.organizer.action.CancelRestoreTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.LockUnlockTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.MoveAttendee;
import org.sakaiproject.signup.tool.jsf.organizer.action.RemoveWaiter;
import org.sakaiproject.signup.tool.jsf.organizer.action.ReplaceAttendee;
import org.sakaiproject.signup.tool.jsf.organizer.action.SwapAttendee;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.user.api.UserNotDefinedException;

public class OrganizerSignupMBean
extends SignupUIBaseBean {
    private UIData timeslotWrapperTable;
    private UIInput attendeeTimeSlotWithId;
    private UIInput replacedAttendeeEidOrEmail;
    private String eidOrEmailByUser;
    private UIInput waiterEidOrEmail;
    private UIData attendeeWrapperTable;
    private UIData waiterWrapperTable;
    private List<SelectItem> allAttendees;
    private List<SignupUser> allSignupUsers;
    public static final String DELIMITER = "::";
    private String selectedAction = "replaceAction";
    private String selectedEditTimeslotId;
    private UIInput selectedTimeslotId;
    private Log logger = LogFactoryImpl.getLog(this.getClass());
    private boolean addNewAttendee;
    private UIInput addNewAttendeeUserEidOrEmail;
    private UIInput listPendingType;
    private String userActionType = "replaceAction";
    private String selectedFirstUser = "gl256";
    private String currentUserId;
    private String currentSiteId;
    private CopyMeetingSignupMBean copyMeetingMBean;
    private EditMeetingSignupMBean editMeetingMBean;
    private ViewCommentSignupMBean viewCommentMBean;
    private CancelRestoreTimeslot cancelRestoreTimeslot;
    private boolean collapsedMeetingInfo;
    private boolean eidInputMode = false;

    public void init(SignupMeetingWrapper meetingWrapper) throws Exception {
        this.eidInputMode = false;
        this.collapsedMeetingInfo = false;
        this.reset(meetingWrapper);
        this.loadAllAttendees(meetingWrapper.getMeeting());
    }

    public void reset(SignupMeetingWrapper meetingWrapper) {
        this.setMeetingWrapper(meetingWrapper);
        this.updateTimeSlotWrappers(meetingWrapper);
        this.setEidInputMode(meetingWrapper.getMeeting().isEidInputMode());
        if (!this.isEidInputMode() && (this.getAllAttendees() == null || this.getAllAttendees().isEmpty())) {
            this.loadAllAttendees(meetingWrapper.getMeeting());
        }
        this.sendEmail = meetingWrapper.getMeeting().isSendEmailByOwner();
    }

    public String modifyMeeting() {
        SignupMeeting meeting = null;
        String goMainPageDueToError = this.updateMeetingwrapper(meeting, "organizerMeeting");
        if (goMainPageDueToError.equals("listMeetings")) {
            return goMainPageDueToError;
        }
        this.editMeetingMBean.setMeetingWrapper(this.getMeetingWrapper());
        this.editMeetingMBean.reset();
        return "modifyMeeting";
    }

    public String copyMeeting() {
        this.copyMeetingMBean.setMeetingWrapper(this.getMeetingWrapper());
        this.copyMeetingMBean.reset();
        return "copyMeeting";
    }

    public String processLockTsAction() {
        SignupMeeting meeting = null;
        try {
            TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
            LockUnlockTimeslot lockTimeslot = new LockUnlockTimeslot(this.getMeetingWrapper().getMeeting(), timeslotWrapper.getTimeSlot(), this.currentUserId(), this.currentSiteId(), this.signupMeetingService);
            meeting = lockTimeslot.lockOrUnlock();
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        return this.updateMeetingwrapper(meeting, "organizerMeeting");
    }

    public String initiateCancelTimeslot() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        this.cancelRestoreTimeslot = new CancelRestoreTimeslot(this.getMeetingWrapper().getMeeting(), timeslotWrapper.getTimeSlot(), this.currentUserId(), this.currentSiteId(), this.signupMeetingService);
        return this.cancelRestoreTimeslot();
    }

    public String restoreTimeslot() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        this.cancelRestoreTimeslot = new CancelRestoreTimeslot(this.getMeetingWrapper().getMeeting(), timeslotWrapper.getTimeSlot(), this.currentUserId(), this.currentSiteId(), this.signupMeetingService);
        return this.cancelRestoreTimeslot();
    }

    public String cancelTimeslot() {
        return this.cancelRestoreTimeslot();
    }

    public String viewAttendeeComment() {
        String attUserId = Utilities.getRequestParam((String)"attendeeUserId");
        String timeslotId = Utilities.getRequestParam((String)"timeslotId");
        if (attUserId == null || timeslotId == null) {
            return "";
        }
        AttendeeWrapper attWrp = this.findAttendee(timeslotId, attUserId);
        if (attWrp == null) {
            return "";
        }
        this.viewCommentMBean.init(attWrp, this.getAttendeeRole(attUserId), this.getMeetingWrapper());
        return "viewComment";
    }

    private AttendeeWrapper findAttendee(String timeslotId, String userId) {
        if (this.getTimeslotWrappers() == null || this.getTimeslotWrappers().isEmpty()) {
            return null;
        }
        String timeslotPeriod = null;
        for (TimeslotWrapper wraper : this.getTimeslotWrappers()) {
            if (!wraper.getTimeSlot().getId().toString().equals(timeslotId)) continue;
            timeslotPeriod = this.getSakaiFacade().getTimeService().newTime(wraper.getTimeSlot().getStartTime().getTime()).toStringLocalTime() + " - " + this.getSakaiFacade().getTimeService().newTime(wraper.getTimeSlot().getEndTime().getTime()).toStringLocalTime();
            List attWrp = wraper.getAttendeeWrappers();
            for (AttendeeWrapper att : attWrp) {
                if (!att.getSignupAttendee().getAttendeeUserId().equals(userId)) continue;
                att.setTimeslotPeriod(timeslotPeriod);
                return att;
            }
        }
        return null;
    }

    private String getAttendeeRole(String attendeeUserId) {
        SignupUser sUser = this.getSakaiFacade().getSignupUser(this.getMeetingWrapper().getMeeting(), attendeeUserId);
        if (sUser == null) {
            return "unknown";
        }
        return sUser.getUserRole().getId();
    }

    private String cancelRestoreTimeslot() {
        if (this.cancelRestoreTimeslot == null) {
            return "organizerMeeting";
        }
        SignupMeeting meeting = null;
        try {
            meeting = this.cancelRestoreTimeslot.cancelOrRestore();
            if (this.sendEmail) {
                try {
                    this.signupMeetingService.sendEmailToParticipantsByOrganizerAction(this.cancelRestoreTimeslot.getSignupEventTrackingInfo());
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                    Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        return this.updateMeetingwrapper(meeting, "organizerMeeting");
    }

    public String editTimeslotAttendee() {
        SignupMeeting meeting = null;
        try {
            SignupEventTrackingInfo signupEventTrackingInfo = null;
            if (this.userActionType.equals("moveAction")) {
                signupEventTrackingInfo = this.moveAttendee();
            }
            if (this.userActionType.equals("replaceAction")) {
                try {
                    signupEventTrackingInfo = this.replaceAttendee();
                }
                catch (UserNotDefinedException e) {
                    this.logger.warn((Object)(Utilities.rb.getString("exception.no.such.user") + (String)this.replacedAttendeeEidOrEmail.getValue() + " -- " + e.getMessage()));
                    Utilities.addErrorMessage((String)(Utilities.rb.getString("exception.no.such.user") + (String)this.replacedAttendeeEidOrEmail.getValue()));
                    return "";
                }
            }
            if (this.userActionType.equals("swapAction")) {
                signupEventTrackingInfo = this.swapAttendees();
            }
            if (this.sendEmail) {
                try {
                    this.signupMeetingService.sendEmailToParticipantsByOrganizerAction(signupEventTrackingInfo);
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                    Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
                }
            }
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        this.setSelectedAction("replaceAction");
        if (Utilities.getSignupMeetingsBean().isShowMyAppointmentTime()) {
            Utilities.resetMeetingList();
        }
        return this.updateMeetingwrapper(meeting, "organizerMeeting");
    }

    private SignupEventTrackingInfo swapAttendees() throws Exception {
        SwapAttendee swapAttendee = new SwapAttendee(this.currentUserId(), this.currentSiteId(), this.signupMeetingService);
        TimeslotWrapper currentTimeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        swapAttendee.swapAttendee(this.getMeetingWrapper().getMeeting(), currentTimeslotWrapper.getTimeSlot(), this.selectedFirstUser, (String)this.attendeeTimeSlotWithId.getValue());
        return swapAttendee.getSignupEventTrackingInfo();
    }

    private SignupEventTrackingInfo replaceAttendee() throws Exception {
        String userEidOrEmail = null;
        userEidOrEmail = this.isEidInputMode() ? this.getEidOrEmailInputByUser() : (String)this.replacedAttendeeEidOrEmail.getValue();
        List associatedEids = this.getEidsForEmail(userEidOrEmail.trim());
        if (associatedEids.size() > 1) {
            throw new SignupUserActionException(MessageFormat.format(Utilities.rb.getString("exception.multiple.eids"), userEidOrEmail, StringUtils.join((Collection)associatedEids, (String)", ")));
        }
        String replacerUserId = this.getUserIdForEidOrEmail(userEidOrEmail);
        SignupUser replSignUser = this.getSakaiFacade().getSignupUser(this.getMeetingWrapper().getMeeting(), replacerUserId);
        if (replSignUser == null) {
            throw new SignupUserActionException(MessageFormat.format(Utilities.rb.getString("user.has.no.permission.attend"), userEidOrEmail));
        }
        TimeslotWrapper wrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        ReplaceAttendee replaceAttendee = new ReplaceAttendee(this.currentUserId(), this.currentSiteId(), this.signupMeetingService);
        replaceAttendee.replace(this.getMeetingWrapper().getMeeting(), wrapper.getTimeSlot(), this.selectedFirstUser, replacerUserId, replSignUser.getMainSiteId());
        return replaceAttendee.getSignupEventTrackingInfo();
    }

    private SignupEventTrackingInfo moveAttendee() throws Exception {
        TimeslotWrapper wrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        MoveAttendee moveAttendee = new MoveAttendee(this.currentUserId(), this.currentSiteId(), this.signupMeetingService);
        moveAttendee.move(this.getMeetingWrapper().getMeeting(), wrapper.getTimeSlot(), this.selectedFirstUser, (String)this.selectedTimeslotId.getValue());
        return moveAttendee.getSignupEventTrackingInfo();
    }

    public void loadAllAttendees(SignupMeeting meeting) {
        if (meeting.isEidInputMode()) {
            this.setEidInputMode(true);
            return;
        }
        try {
            Site site = this.getSakaiFacade().getSiteService().getSite(this.getSakaiFacade().getCurrentLocationId());
            if (site != null) {
                int allMemeberSize;
                int n = allMemeberSize = site.getMembers() != null ? site.getMembers().size() : 0;
                if (allMemeberSize > 600) {
                    this.setEidInputMode(true);
                    return;
                }
            }
        }
        catch (IdUnusedException e) {
            e.printStackTrace();
        }
        this.allSignupUsers = this.sakaiFacade.getAllPossibleAttendees(meeting);
        if (this.allSignupUsers != null && this.allSignupUsers.size() > 600) {
            this.setEidInputMode(true);
            return;
        }
        this.setEidInputMode(false);
        this.allAttendees = new ArrayList();
        String previous_displayName = "";
        int index = 0;
        for (SignupUser user : this.allSignupUsers) {
            if (user.getDisplayName().equals(previous_displayName)) {
                this.allAttendees.add(new SelectItem((Object)user.getEid(), user.getDisplayName() + "(" + user.getEid() + ")"));
                SelectItem prev_sItem = (SelectItem)this.allAttendees.get(index - 1);
                if (!prev_sItem.getLabel().contains("(")) {
                    prev_sItem.setLabel(prev_sItem.getLabel() + " (" + prev_sItem.getValue() + ")");
                }
            } else {
                this.allAttendees.add(new SelectItem((Object)user.getEid(), user.getDisplayName()));
            }
            previous_displayName = user.getDisplayName();
            ++index;
        }
    }

    protected void updateTimeSlotWrappers(SignupMeetingWrapper meetingWrapper) {
        super.updateTimeSlotWrappers(meetingWrapper);
        this.createUISwapListForEachTimeSlot(this.getTimeslotWrappers());
        this.createMoveAvailabelTimeSlots(this.getTimeslotWrappers());
    }

    private void createMoveAvailabelTimeSlots(List<TimeslotWrapper> timeslotWrapperList) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (TimeslotWrapper wrapper : timeslotWrapperList) {
            list.add(new SelectItem((Object)wrapper.getTimeSlot().getId().toString(), wrapper.getLabel()));
        }
        for (int i = 0; i < list.size(); ++i) {
            ArrayList moveAvailableTimeSlots = new ArrayList(list);
            moveAvailableTimeSlots.remove(i);
            TimeslotWrapper wrapper = timeslotWrapperList.get(i);
            wrapper.setMoveAvailableTimeSlots(moveAvailableTimeSlots);
        }
    }

    private void createUISwapListForEachTimeSlot(List<TimeslotWrapper> timeslotWrapperList) {
        ArrayList<SelectItemGroup> tsAttendeeGroups = new ArrayList<SelectItemGroup>();
        for (TimeslotWrapper wrapper : timeslotWrapperList) {
            String grpLabel = wrapper.getLabel();
            ArrayList<SelectItem> attendeeOnTS = new ArrayList<SelectItem>();
            List attendees = this.getValidAttendees(wrapper.getTimeSlot().getAttendees());
            if (attendees != null && !attendees.isEmpty()) {
                for (SignupAttendee att : attendees) {
                    SelectItem sItem = new SelectItem((Object)(wrapper.getTimeSlot().getId() + DELIMITER + att.getAttendeeUserId()), this.sakaiFacade.getUserDisplayName(att.getAttendeeUserId()));
                    attendeeOnTS.add(sItem);
                }
            }
            SelectItemGroup sigrp = new SelectItemGroup(grpLabel, "Timeslot Name", false, attendeeOnTS.toArray(new SelectItem[0]));
            tsAttendeeGroups.add(sigrp);
        }
        for (int i = 0; i < tsAttendeeGroups.size(); ++i) {
            ArrayList swapAvailableTimeSlots = new ArrayList(tsAttendeeGroups);
            swapAvailableTimeSlots.remove(i);
            TimeslotWrapper wrapper = timeslotWrapperList.get(i);
            wrapper.setSwapDropDownList(swapAvailableTimeSlots);
        }
    }

    public UIData getTimeslotWrapperTable() {
        return this.timeslotWrapperTable;
    }

    public void setTimeslotWrapperTable(UIData timeslotWrapperTable) {
        this.timeslotWrapperTable = timeslotWrapperTable;
    }

    public UIInput getAttendeeTimeSlotWithId() {
        return this.attendeeTimeSlotWithId;
    }

    public void setAttendeeTimeSlotWithId(UIInput attendeeEid) {
        this.attendeeTimeSlotWithId = attendeeEid;
    }

    public UIInput getWaiterEidOrEmail() {
        return this.waiterEidOrEmail;
    }

    public void setWaiterEidOrEmail(UIInput waiterEidOrEmail) {
        this.waiterEidOrEmail = waiterEidOrEmail;
    }

    public String prepareAddAttendee() {
        this.setAddNewAttendee(true);
        this.setSelectedEditTimeslotId(null);
        return "organizerMeeting";
    }

    public String addAttendee() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        String newAttendeeEidOrEmail = null;
        if (this.isEidInputMode()) {
            newAttendeeEidOrEmail = this.getEidOrEmailInputByUser();
        } else if (this.addNewAttendeeUserEidOrEmail != null && ((String)this.addNewAttendeeUserEidOrEmail.getValue()).trim().length() > 0) {
            newAttendeeEidOrEmail = ((String)this.addNewAttendeeUserEidOrEmail.getValue()).trim();
        }
        if (StringUtils.isBlank((String)newAttendeeEidOrEmail)) {
            return "organizerMeeting";
        }
        List associatedEids = this.getEidsForEmail(newAttendeeEidOrEmail.trim());
        if (associatedEids.size() > 1) {
            Utilities.addErrorMessage((String)MessageFormat.format(Utilities.rb.getString("exception.multiple.eids"), newAttendeeEidOrEmail, StringUtils.join((Collection)associatedEids, (String)", ")));
            return "organizerMeeting";
        }
        String newUserId = this.getUserIdForEidOrEmail(newAttendeeEidOrEmail.trim());
        if (StringUtils.isBlank((String)newUserId)) {
            Utilities.addErrorMessage((String)(Utilities.rb.getString("exception.no.such.user") + newAttendeeEidOrEmail));
            return "organizerMeeting";
        }
        SignupUser newAttendeeSignUser = this.getSakaiFacade().getSignupUser(this.getMeetingWrapper().getMeeting(), newUserId);
        if (newAttendeeSignUser == null) {
            Utilities.addErrorMessage((String)MessageFormat.format(Utilities.rb.getString("user.has.no.permission.attend"), newAttendeeEidOrEmail));
            return "organizerMeeting";
        }
        SignupAttendee newAttendee = new SignupAttendee(newUserId, newAttendeeSignUser.getMainSiteId());
        timeslotWrapper.setNewAttendee(newAttendee);
        SignupMeeting meeting = null;
        try {
            AddAttendee addAttendee = new AddAttendee(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), true);
            meeting = addAttendee.signup(this.getMeetingWrapper().getMeeting(), timeslotWrapper.getTimeSlot(), timeslotWrapper.getNewAttendee());
            boolean sendAttendeeEmail = false;
            if (this.sendEmail || sendAttendeeEmail) {
                try {
                    this.signupMeetingService.sendEmailToParticipantsByOrganizerAction(addAttendee.getSignupEventTrackingInfo());
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                    Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
                }
            }
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        String nextPage = this.updateMeetingwrapper(meeting, "organizerMeeting");
        if ("organizerMeeting".equals(nextPage)) {
            this.setAddNewAttendee(false);
            this.setSelectedTimeslotId(null);
        }
        return nextPage;
    }

    public String cancelAddAttendee() {
        this.setAddNewAttendee(false);
        this.setAddNewAttendeeUserEidOrEmail(null);
        return "organizerMeeting";
    }

    public String removeAttendee() {
        SignupMeeting meeting = null;
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        String removedUserId = Utilities.getRequestParam((String)"attendeeUserId");
        try {
            CancelAttendee remove = new CancelAttendee(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), true);
            SignupAttendee removedAttendee = new SignupAttendee(removedUserId, this.currentSiteId());
            meeting = remove.cancelSignup(this.getMeetingWrapper().getMeeting(), timeslotWrapper.getTimeSlot(), removedAttendee);
            if (this.sendEmail) {
                try {
                    this.signupMeetingService.sendEmailToParticipantsByOrganizerAction(remove.getSignupEventTrackingInfo());
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                    Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
                }
            }
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        if (Utilities.getSignupMeetingsBean().isShowMyAppointmentTime()) {
            Utilities.resetMeetingList();
        }
        return this.updateMeetingwrapper(meeting, "organizerMeeting");
    }

    public String addAttendeeToWList() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        String newWaiterEidOrEmail = null;
        if (this.isEidInputMode()) {
            newWaiterEidOrEmail = this.getEidOrEmailInputByUser();
        } else if (this.waiterEidOrEmail != null && ((String)this.waiterEidOrEmail.getValue()).trim().length() > 0) {
            newWaiterEidOrEmail = ((String)this.waiterEidOrEmail.getValue()).trim();
        }
        if (StringUtils.isBlank((String)newWaiterEidOrEmail)) {
            return "organizerMeeting";
        }
        List associatedEids = this.getEidsForEmail(newWaiterEidOrEmail.trim());
        if (associatedEids.size() > 1) {
            Utilities.addErrorMessage((String)MessageFormat.format(Utilities.rb.getString("exception.multiple.eids"), newWaiterEidOrEmail, StringUtils.join((Collection)associatedEids, (String)", ")));
            return "organizerMeeting";
        }
        String waiterUserId = this.getUserIdForEidOrEmail(newWaiterEidOrEmail.trim());
        if (StringUtils.isBlank((String)waiterUserId)) {
            Utilities.addErrorMessage((String)(Utilities.rb.getString("exception.no.such.user") + newWaiterEidOrEmail));
            return "organizerMeeting";
        }
        SignupUser waiterSignUser = this.getSakaiFacade().getSignupUser(this.getMeetingWrapper().getMeeting(), waiterUserId);
        if (waiterSignUser == null) {
            Utilities.addErrorMessage((String)MessageFormat.format(Utilities.rb.getString("user.has.no.permission.attend"), newWaiterEidOrEmail));
            return "organizerMeeting";
        }
        SignupAttendee newWaiter = new SignupAttendee(waiterUserId, waiterSignUser.getMainSiteId());
        SignupMeeting meeting = null;
        try {
            AddWaiter addWaiter = new AddWaiter(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), this.getListOperationType(), true);
            meeting = addWaiter.addToWaitingList(this.getMeetingWrapper().getMeeting(), timeslotWrapper.getTimeSlot(), newWaiter);
            this.resetWaitingListPendingType();
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        return this.updateMeetingwrapper(meeting, "organizerMeeting");
    }

    private void resetWaitingListPendingType() {
        this.setListPendingType(null);
    }

    public String removeAttendeeFromWList() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        String removedUserId = Utilities.getRequestParam((String)"attendeeUserId");
        if (StringUtils.isBlank((String)removedUserId)) {
            return "organizerMeeting";
        }
        SignupAttendee removedWaiter = new SignupAttendee(removedUserId, this.currentSiteId());
        SignupMeeting meeting = null;
        try {
            RemoveWaiter removeWaiter = new RemoveWaiter(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), this.getListOperationType(), true);
            meeting = removeWaiter.removeFromWaitingList(this.getMeetingWrapper().getMeeting(), timeslotWrapper.getTimeSlot(), removedWaiter);
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        return this.updateMeetingwrapper(meeting, "organizerMeeting");
    }

    public UIData getAttendeeWrapperTable() {
        return this.attendeeWrapperTable;
    }

    public void setAttendeeWrapperTable(UIData attendeeWrapperTable) {
        this.attendeeWrapperTable = attendeeWrapperTable;
    }

    public UIData getWaiterWrapperTable() {
        return this.waiterWrapperTable;
    }

    public void setWaiterWrapperTable(UIData waiterWrapperTable) {
        this.waiterWrapperTable = waiterWrapperTable;
    }

    public List<SelectItem> getAllAttendees() {
        return this.allAttendees;
    }

    public void setAllAttendees(List<SelectItem> allAttendees) {
        this.allAttendees = allAttendees;
    }

    public String getAttendeeUserId() {
        return "attendeeUserId";
    }

    public String getSelectedEditTimeslotId() {
        return this.selectedEditTimeslotId;
    }

    public void setSelectedEditTimeslotId(String selectedEditTimeslotId) {
        this.selectedEditTimeslotId = selectedEditTimeslotId;
    }

    public String getMoveAction() {
        return "moveAction";
    }

    public String getReplaceAction() {
        return "replaceAction";
    }

    public String getSwapAction() {
        return "swapAction";
    }

    public String getOnTopList() {
        return "toTopOfList";
    }

    public String getOnBottomList() {
        return "toBbottomOfList";
    }

    public String getSelectedAction() {
        return this.selectedAction;
    }

    public void setSelectedAction(String selectedAction) {
        this.selectedAction = selectedAction;
    }

    public UIInput getReplacedAttendeeEidOrEmail() {
        return this.replacedAttendeeEidOrEmail;
    }

    public void setReplacedAttendeeEidOrEmail(UIInput replacedAttendeeEidOrEmail) {
        this.replacedAttendeeEidOrEmail = replacedAttendeeEidOrEmail;
    }

    public UIInput getSelectedTimeslotId() {
        return this.selectedTimeslotId;
    }

    public void setSelectedTimeslotId(UIInput selectedTimeslotId) {
        this.selectedTimeslotId = selectedTimeslotId;
    }

    public boolean isAddNewAttendee() {
        return this.addNewAttendee;
    }

    public void setAddNewAttendee(boolean addNewAttendee) {
        this.addNewAttendee = addNewAttendee;
    }

    public UIInput getAddNewAttendeeUserEidOrEmail() {
        return this.addNewAttendeeUserEidOrEmail;
    }

    public void setAddNewAttendeeUserEidOrEmail(UIInput addNewAttendeeUserEidOrEmail) {
        this.addNewAttendeeUserEidOrEmail = addNewAttendeeUserEidOrEmail;
    }

    public String getSelectedFirstUser() {
        return this.selectedFirstUser;
    }

    public void setSelectedFirstUser(String selectedFirstUser) {
        this.selectedFirstUser = selectedFirstUser;
    }

    public String getUserActionType() {
        return this.userActionType;
    }

    public void setUserActionType(String userActionType) {
        this.userActionType = userActionType;
    }

    public UIInput getListPendingType() {
        return this.listPendingType;
    }

    public void setListPendingType(UIInput listPendingType) {
        this.listPendingType = listPendingType;
    }

    private String getListOperationType() {
        if (this.listPendingType != null && this.listPendingType.getValue() != null && ((String)this.listPendingType.getValue()).trim().length() > 0) {
            return ((String)this.listPendingType.getValue()).trim();
        }
        return "toBbottomOfList";
    }

    private String currentUserId() {
        if (this.currentUserId == null) {
            this.currentUserId = this.sakaiFacade.getCurrentUserId();
        }
        return this.currentUserId;
    }

    private String currentSiteId() {
        if (this.currentSiteId == null) {
            this.currentSiteId = this.sakaiFacade.getCurrentLocationId();
        }
        return this.currentSiteId;
    }

    public CopyMeetingSignupMBean getCopyMeetingMBean() {
        return this.copyMeetingMBean;
    }

    public void setCopyMeetingMBean(CopyMeetingSignupMBean copyMeetingMBean) {
        this.copyMeetingMBean = copyMeetingMBean;
    }

    public EditMeetingSignupMBean getEditMeetingMBean() {
        return this.editMeetingMBean;
    }

    public void setEditMeetingMBean(EditMeetingSignupMBean editMeetingMBean) {
        this.editMeetingMBean = editMeetingMBean;
    }

    public ViewCommentSignupMBean getViewCommentMBean() {
        return this.viewCommentMBean;
    }

    public void setViewCommentMBean(ViewCommentSignupMBean viewCommentMBean) {
        this.viewCommentMBean = viewCommentMBean;
    }

    public boolean isEidInputMode() {
        return this.eidInputMode;
    }

    public void setEidInputMode(boolean eidInputMode) {
        this.eidInputMode = eidInputMode;
    }

    public String getUserInputEidOrEmail() {
        return "";
    }

    public void setUserInputEidOrEmail(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.eidOrEmailByUser = value;
        }
    }

    public List<SignupSite> getPublishedSignupSites() {
        return this.getMeetingWrapper().getMeeting().getSignupSites();
    }

    private String getEidOrEmailInputByUser() {
        String value = this.eidOrEmailByUser;
        this.eidOrEmailByUser = null;
        return value;
    }

    public boolean isCollapsedMeetingInfo() {
        return this.collapsedMeetingInfo;
    }

    public void setCollapsedMeetingInfo(boolean collapsedMeetingInfo) {
        this.collapsedMeetingInfo = collapsedMeetingInfo;
    }

    public String synchroniseGroupMembership() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        String groupId = timeslotWrapper.getGroupId();
        if (StringUtils.isBlank((String)groupId)) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.no_group_for_timeslot"));
            return "organizerMeeting";
        }
        List attendeeUserIds = this.convertAttendeeWrappersToUuids(timeslotWrapper.getAttendeeWrappers());
        if (!this.sakaiFacade.addUsersToGroup((Collection)attendeeUserIds, this.currentSiteId(), groupId)) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.group_sync_failed"));
            return "organizerMeeting";
        }
        List groupMembers = this.sakaiFacade.getGroupMembers(this.currentSiteId(), groupId);
        groupMembers.removeAll(attendeeUserIds);
        return this.addAttendeesToTimeslot(this.currentSiteId(), timeslotWrapper, groupMembers);
    }

    private String addAttendeesToTimeslot(String siteId, TimeslotWrapper timeslotWrapper, List<String> userIds) {
        boolean errors = false;
        SignupMeeting meeting = null;
        for (String userId : userIds) {
            SignupAttendee attendee = new SignupAttendee(userId, siteId);
            timeslotWrapper.setNewAttendee(attendee);
            try {
                AddAttendee addAttendee = new AddAttendee(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), true);
                meeting = addAttendee.signup(this.getMeetingWrapper().getMeeting(), timeslotWrapper.getTimeSlot(), timeslotWrapper.getNewAttendee());
                if (!this.sendEmail) continue;
                try {
                    this.signupMeetingService.sendEmailToParticipantsByOrganizerAction(addAttendee.getSignupEventTrackingInfo());
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                }
            }
            catch (SignupUserActionException ue) {
                Utilities.addErrorMessage((String)ue.getMessage());
                this.logger.error((Object)ue.getMessage());
                errors = true;
                break;
            }
            catch (Exception e) {
                this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()), (Throwable)e);
                errors = true;
                break;
            }
        }
        if (errors) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
            return "organizerMeeting";
        }
        String nextPage = this.updateMeetingwrapper(meeting, "organizerMeeting");
        if ("organizerMeeting".equals(nextPage)) {
            this.setAddNewAttendee(false);
            this.setSelectedTimeslotId(null);
            Utilities.addInfoMessage((String)Utilities.rb.getString("group_synchronise_done"));
        }
        return nextPage;
    }

    public boolean isShowEmailAllAttendeesLink() {
        return StringUtils.isNotBlank((String)this.getAllAttendeesEmailAddressesFormatted());
    }

    public String getCurrentUserEmailAddress() {
        return this.sakaiFacade.getUser(this.sakaiFacade.getCurrentUserId()).getEmail();
    }
}

