/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.TimeslotWrapper;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;

public class UserDefineTimeslotBean
implements SignupBeanConstants {
    SakaiFacade sakaiFacade;
    private final int MAX_NUM_PARTICIPANTS = 1;
    private String gobackURL = "";
    private boolean validationError = false;
    private boolean userEverCreateCTS = false;
    private SignupMeeting signupMeeting;
    protected UIData tsTable;
    public String placeOrderBean;
    public static final String NEW_MEETING = "new_meeting";
    public static final String MODIFY_MEETING = "modify_meeting";
    public static final String COPY_MEETING = "copy_meeting";
    private List<TimeslotWrapper> timeSlotWrpList;
    private List<TimeslotWrapper> destTSwrpList;
    private boolean someoneSignedUp;
    private boolean putInMultipleCalendarBlocks = true;
    String errorStyleValue = "background: #EEF3F6;";

    public void init(SignupMeeting sMeeting, String backPageURL, List<TimeslotWrapper> origTSwrpList, String whoPlaceOrder) {
        this.signupMeeting = sMeeting;
        this.destTSwrpList = origTSwrpList;
        this.placeOrderBean = whoPlaceOrder;
        this.setGobackURL(backPageURL);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (origTSwrpList == null || origTSwrpList.size() == 0) {
            this.timeSlotWrpList = new ArrayList();
            SignupTimeslot ts = new SignupTimeslot();
            ts.setStartTime(calendar.getTime());
            ts.setEndTime(calendar.getTime());
            ts.setMaxNoOfAttendees(1);
            TimeslotWrapper tsWrp = new TimeslotWrapper(ts);
            this.timeSlotWrpList.add(tsWrp);
        } else {
            this.timeSlotWrpList = new ArrayList();
            for (TimeslotWrapper origTswrp : origTSwrpList) {
                this.timeSlotWrpList.add(this.deepCopyTimeslotWrapper(origTswrp));
            }
        }
        if (MODIFY_MEETING.equals(this.getPlaceOrderBean())) {
            this.someoneSignedUp = true;
        }
        this.validationError = false;
        this.setPositionIndex(this.timeSlotWrpList);
    }

    public void modifyTimesSlotsWithChanges(List<TimeslotWrapper> userModifiedTSwrapperList, List<SignupTimeslot> needUpdateTimeslots, Calendar newEventStartTime, boolean showAttendeeName, List<SignupTimeslot> deletedTSList) throws Exception {
        if (userModifiedTSwrapperList != null && !userModifiedTSwrapperList.isEmpty()) {
            int markerPos;
            Date userMdfEventStartDate = this.getStartTime(userModifiedTSwrapperList);
            for (TimeslotWrapper tsWrp : userModifiedTSwrapperList) {
                if (tsWrp.getDeleted()) continue;
                SignupTimeslot userModifiedOne = tsWrp.getTimeSlot();
                markerPos = tsWrp.getTsMarker();
                if (markerPos >= needUpdateTimeslots.size()) continue;
                SignupTimeslot needUPdateOne = needUpdateTimeslots.get(markerPos);
                needUPdateOne.setStartTime(this.getUpdatedTime(newEventStartTime, userMdfEventStartDate, userModifiedOne.getStartTime()));
                needUPdateOne.setEndTime(this.getUpdatedTime(newEventStartTime, userMdfEventStartDate, userModifiedOne.getEndTime()));
                needUPdateOne.setMaxNoOfAttendees(userModifiedOne.getMaxNoOfAttendees());
                needUPdateOne.setDisplayAttendees(showAttendeeName);
            }
            int orignalTS_size = needUpdateTimeslots.size();
            List removedList = this.getUserDeletedTSItems(userModifiedTSwrapperList);
            for (int i = removedList.size() - 1; i >= 0; --i) {
                markerPos = (Integer)removedList.get(i);
                if (markerPos >= orignalTS_size) continue;
                deletedTSList.add(needUpdateTimeslots.get(markerPos));
                needUpdateTimeslots.remove(markerPos);
            }
            for (TimeslotWrapper tsWrp : userModifiedTSwrapperList) {
                SignupTimeslot userModifiedOne = tsWrp.getTimeSlot();
                int markerPos2 = tsWrp.getTsMarker();
                if (markerPos2 != Integer.MAX_VALUE) continue;
                SignupTimeslot newTs = new SignupTimeslot();
                newTs.setStartTime(this.getUpdatedTime(newEventStartTime, userMdfEventStartDate, userModifiedOne.getStartTime()));
                newTs.setEndTime(this.getUpdatedTime(newEventStartTime, userMdfEventStartDate, userModifiedOne.getEndTime()));
                newTs.setMaxNoOfAttendees(userModifiedOne.getMaxNoOfAttendees());
                newTs.setDisplayAttendees(showAttendeeName);
                needUpdateTimeslots.add(newTs);
            }
            this.doSort(needUpdateTimeslots);
        }
    }

    private TimeslotWrapper deepCopyTimeslotWrapper(TimeslotWrapper copyOne) {
        SignupAttendee one;
        List atts;
        SignupTimeslot old = copyOne.getTimeSlot();
        SignupTimeslot newTs = new SignupTimeslot();
        newTs.setId(old.getId());
        newTs.setStartTime(old.getStartTime());
        newTs.setEndTime(old.getEndTime());
        newTs.setCanceled(old.isCanceled());
        newTs.setLocked(old.isLocked());
        newTs.setDisplayAttendees(old.isDisplayAttendees());
        newTs.setMaxNoOfAttendees(old.getMaxNoOfAttendees());
        newTs.setAttendees(null);
        newTs.setWaitingList(null);
        if (old.getAttendees() != null) {
            atts = old.getAttendees();
            ArrayList<SignupAttendee> newOnes = new ArrayList<SignupAttendee>();
            for (SignupAttendee s : atts) {
                one = new SignupAttendee();
                one.setAttendeeUserId(s.getAttendeeUserId());
                one.setDisplayName(s.getDisplayName());
                one.setSignupSiteId(s.getSignupSiteId());
                one.setComments(s.getComments());
                one.setCalendarId(s.getCalendarId());
                one.setCalendarEventId(s.getCalendarEventId());
                newOnes.add(one);
            }
            newTs.setAttendees(newOnes);
        }
        if (old.getWaitingList() != null) {
            atts = old.getWaitingList();
            ArrayList<SignupAttendee> waitList = new ArrayList<SignupAttendee>();
            for (SignupAttendee s : atts) {
                one = new SignupAttendee();
                one.setAttendeeUserId(s.getAttendeeUserId());
                one.setDisplayName(s.getDisplayName());
                one.setSignupSiteId(s.getSignupSiteId());
                one.setComments(s.getComments());
                waitList.add(one);
            }
        }
        TimeslotWrapper newTsWrp = new TimeslotWrapper(newTs);
        newTsWrp.setPositionInTSlist(copyOne.getPositionInTSlist());
        newTsWrp.setTsMarker(copyOne.getTsMarker());
        newTsWrp.setDeleted(copyOne.getDeleted());
        newTsWrp.setCurrentUserId(copyOne.getCurrentUserId());
        return newTsWrp;
    }

    private List<Integer> getUserDeletedTSItems(List<TimeslotWrapper> userModifiedTSwrapperList) {
        ArrayList<Integer> deletedTSlist = new ArrayList<Integer>();
        for (TimeslotWrapper tsWrp : userModifiedTSwrapperList) {
            if (!tsWrp.getDeleted()) continue;
            int markerPos = tsWrp.getTsMarker();
            deletedTSlist.add(new Integer(markerPos));
        }
        this.doSort(deletedTSlist);
        return deletedTSlist;
    }

    public String doSave() {
        if (this.validationError) {
            this.validationError = false;
            return "userDefinedTsBlocks";
        }
        this.preProcess();
        this.setUserEverCreateCTS(true);
        this.destTSwrpList = this.getTimeSlotWrpList();
        this.signupMeeting.setStartTime(this.getEventStartTime());
        this.signupMeeting.setEndTime(this.getEventEndTime());
        return this.getGobackURL();
    }

    public String doCancel() {
        this.signupMeeting.setStartTime(this.getEventStartTime());
        this.signupMeeting.setEndTime(this.getEventEndTime());
        String goBackUrl = this.getGobackURL();
        this.clear();
        return goBackUrl;
    }

    public String addOneTSBlock() {
        this.someoneSignedUp = false;
        if (this.validationError) {
            this.validationError = false;
            return "userDefinedTsBlocks";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        SignupTimeslot ts = new SignupTimeslot();
        ts.setStartTime(calendar.getTime());
        ts.setEndTime(calendar.getTime());
        ts.setMaxNoOfAttendees(1);
        TimeslotWrapper tsWrp = new TimeslotWrapper(ts);
        this.getTimeSlotWrpList().add(tsWrp);
        this.setPositionIndex(this.timeSlotWrpList);
        return "userDefinedTsBlocks";
    }

    public String deleteTSblock() {
        this.someoneSignedUp = false;
        TimeslotWrapper tsWrapper = (TimeslotWrapper)this.tsTable.getRowData();
        if (this.timeSlotWrpList != null) {
            for (TimeslotWrapper tmp : this.timeSlotWrpList) {
                if (tmp.getDeleted() || tmp.getPositionInTSlist() != tsWrapper.getPositionInTSlist()) continue;
                if (tmp.getTsMarker() == Integer.MAX_VALUE) {
                    this.timeSlotWrpList.remove(tmp);
                    break;
                }
                tmp.setDeleted(true);
                break;
            }
            if (this.isEmptyTimeslotWrpList()) {
                this.addOneTSBlock();
            }
        }
        return "userDefinedTsBlocks";
    }

    private boolean isEmptyTimeslotWrpList() {
        if (this.timeSlotWrpList.size() == 0) {
            return true;
        }
        for (TimeslotWrapper wrp : this.timeSlotWrpList) {
            if (wrp.getDeleted()) continue;
            return false;
        }
        return true;
    }

    public void validateTimeslots(ActionEvent e) {
        if (this.timeSlotWrpList == null) {
            return;
        }
        int position = 1;
        for (TimeslotWrapper tsWrp : this.timeSlotWrpList) {
            Date startTime;
            if (tsWrp.getDeleted()) continue;
            Date endTime = tsWrp.getTimeSlot().getEndTime();
            if (endTime.before(startTime = tsWrp.getTimeSlot().getStartTime()) || endTime.equals(startTime)) {
                this.validationError = true;
                tsWrp.setErrorStyle(this.errorStyleValue);
                Utilities.addErrorMessage((String)MessageFormat.format(Utilities.rb.getString("event.endTimeslot_should_after_startTimeslot"), position));
                return;
            }
            ++position;
        }
    }

    private void preProcess() {
        for (TimeslotWrapper wrp : this.timeSlotWrpList) {
            if (!wrp.getDeleted()) continue;
            wrp.getTimeSlot().setStartTime(new Date());
            wrp.getTimeSlot().setEndTime(new Date(new Date().getTime() + 100L));
        }
        this.doSort(this.getTimeSlotWrpList());
        this.setPositionIndex(this.timeSlotWrpList);
    }

    private void clear() {
        this.someoneSignedUp = false;
        this.timeSlotWrpList = null;
        this.gobackURL = "";
        this.putInMultipleCalendarBlocks = true;
    }

    public void reset(String whoCalled) {
        if (whoCalled.equals(this.placeOrderBean)) {
            this.timeSlotWrpList = null;
            this.destTSwrpList = null;
            this.validationError = false;
            this.placeOrderBean = "";
            this.gobackURL = "";
            this.someoneSignedUp = false;
            this.userEverCreateCTS = false;
            this.putInMultipleCalendarBlocks = true;
        }
    }

    public boolean getTruncatedAttendees() {
        if (this.destTSwrpList != null && this.signupMeeting.getSignupTimeSlots() != null) {
            List orgTsList = this.signupMeeting.getSignupTimeSlots();
            int count = 0;
            for (TimeslotWrapper tsWrp : this.destTSwrpList) {
                SignupTimeslot userModifiedOne = tsWrp.getTimeSlot();
                int markerPos = tsWrp.getTsMarker();
                if (markerPos >= orgTsList.size()) continue;
                List atts = ((SignupTimeslot)orgTsList.get(markerPos)).getAttendees();
                if (atts != null && tsWrp.getTimeSlot().getMaxNoOfAttendees() < atts.size()) {
                    return true;
                }
                ++count;
            }
            if (count < orgTsList.size()) {
                return true;
            }
        }
        return false;
    }

    private void doSort(List ls) {
        Collections.sort(ls);
    }

    private void setPositionIndex(List<TimeslotWrapper> ls) {
        if (ls != null && ls.size() > 0) {
            int i = 0;
            for (TimeslotWrapper tsWrp : ls) {
                if (tsWrp.getDeleted()) continue;
                tsWrp.setPositionInTSlist(i);
                ++i;
            }
        }
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public List<TimeslotWrapper> getTimeSlotWrpList() {
        return this.timeSlotWrpList;
    }

    public void setTimeSlotWrpList(List<TimeslotWrapper> timeSlotWrpList) {
        this.timeSlotWrpList = timeSlotWrpList;
    }

    public String getGobackURL() {
        return this.gobackURL;
    }

    public void setGobackURL(String gobackURL) {
        this.gobackURL = gobackURL;
    }

    public String getIframeId() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String iFrameId = (String)request.getAttribute("sakai.tool.placement.id");
        return iFrameId;
    }

    public UIData getTsTable() {
        return this.tsTable;
    }

    public void setTsTable(UIData tsTable) {
        this.tsTable = tsTable;
    }

    public Date getEventStartTime() {
        return this.getStartTime(this.destTSwrpList);
    }

    public Date getEventEndTime() {
        if (this.destTSwrpList == null || this.destTSwrpList.isEmpty()) {
            return new Date();
        }
        this.doSort(this.destTSwrpList);
        Date endTime = null;
        for (int i = 0; i < this.destTSwrpList.size(); ++i) {
            TimeslotWrapper ts = (TimeslotWrapper)this.destTSwrpList.get(i);
            if (ts.getDeleted()) continue;
            endTime = ts.getTimeSlot().getEndTime();
            break;
        }
        for (TimeslotWrapper tsWrp : this.destTSwrpList) {
            Date tmpDate;
            if (tsWrp.getDeleted() || !endTime.before(tmpDate = tsWrp.getTimeSlot().getEndTime())) continue;
            endTime = tmpDate;
        }
        return endTime;
    }

    private Date getStartTime(List<TimeslotWrapper> tsList) {
        if (tsList == null || tsList.isEmpty()) {
            return new Date();
        }
        this.doSort(tsList);
        for (int i = 0; i < tsList.size(); ++i) {
            TimeslotWrapper ts = tsList.get(i);
            if (ts.getDeleted()) continue;
            return ts.getTimeSlot().getStartTime();
        }
        return new Date();
    }

    public int getEventDuration() {
        long duration = (this.getEventEndTime().getTime() - this.getEventStartTime().getTime()) / 60000L;
        return (int)duration;
    }

    private Date getUpdatedTime(Calendar newEventStartDate, Date origEventDate, Date d) {
        long diffs = newEventStartDate.getTime().getTime() - origEventDate.getTime();
        Date date = new Date(diffs + d.getTime());
        return date;
    }

    public List<TimeslotWrapper> getDestTSwrpList() {
        return this.destTSwrpList;
    }

    public void setDestTSwrpList(List<TimeslotWrapper> destTSwrpList) {
        this.destTSwrpList = destTSwrpList;
    }

    public String getPlaceOrderBean() {
        return this.placeOrderBean;
    }

    public void setPlaceOrderBean(String placeOrderBean) {
        this.placeOrderBean = placeOrderBean;
    }

    public String getCopyBeanOrderName() {
        return COPY_MEETING;
    }

    public String getNewMeetingBeanOrderName() {
        return NEW_MEETING;
    }

    public boolean getWarnUserModify() {
        return MODIFY_MEETING.equals(this.getPlaceOrderBean());
    }

    public boolean getSomeoneSignedUp() {
        return this.someoneSignedUp;
    }

    public void setSomeoneSignedUp(boolean someoneSignedUp) {
        this.someoneSignedUp = someoneSignedUp;
    }

    public boolean getPutInMultipleCalendarBlocks() {
        return this.putInMultipleCalendarBlocks;
    }

    public void setPutInMultipleCalendarBlocks(boolean putInMultipleCalendarBlocks) {
        this.putInMultipleCalendarBlocks = putInMultipleCalendarBlocks;
    }

    public boolean isUserEverCreateCTS() {
        return this.userEverCreateCTS;
    }

    public void setUserEverCreateCTS(boolean userEverCreateCTS) {
        this.userEverCreateCTS = userEverCreateCTS;
    }
}

