/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.Date;
import java.util.List;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfoImpl;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class AddAttendee
extends SignupAction {
    public AddAttendee(SignupMeetingService signupMeetingService, String currentUserId, String currentSiteId, boolean isOrganizer) {
        super(currentUserId, currentSiteId, signupMeetingService, isOrganizer);
    }

    public SignupMeeting signup(SignupMeeting meeting, SignupTimeslot currentTimeslot, SignupAttendee newAttendee) throws Exception {
        boolean hasException = false;
        try {
            this.handleVersion(meeting, currentTimeslot, newAttendee);
            if (ToolManager.getCurrentPlacement() != null) {
                String signupEventType = this.isOrganizer ? SignupEventTypes.EVENT_SIGNUP_ADD_ATTENDEE_L : SignupEventTypes.EVENT_SIGNUP_ADD_ATTENDEE_S;
                Utilities.postEventTracking((String)signupEventType, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + meeting.getId() + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
            }
            this.logger.debug((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.userId + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
        }
        catch (PermissionException pe) {
            hasException = false;
            throw new SignupUserActionException(Utilities.rb.getString("no.permissoin.do_it"));
        }
        finally {
            meeting = this.reloadMeeting(meeting.getId());
            if (!hasException) {
                try {
                    this.signupMeetingService.modifyCalendar(meeting);
                }
                catch (Exception exception) {}
            }
        }
        return meeting;
    }

    public void actionsForOptimisticVersioning(SignupMeeting meeting, SignupTimeslot currentTimeslot, SignupAttendee newAttendee) throws Exception {
        this.signupEventTrackingInfo = new SignupEventTrackingInfoImpl();
        this.signupEventTrackingInfo.setMeeting(meeting);
        if (!meeting.getPermission().isUpdate()) {
            this.checkTimeSlotStillAvailable(meeting, currentTimeslot);
            this.checkForPromotion(meeting, newAttendee);
        }
        this.addAttendeeToTimeSlot(meeting, currentTimeslot, newAttendee);
        this.removeNewAttendeeFromWaitingList(meeting, newAttendee);
    }

    private SignupMeeting handleVersion(SignupMeeting meeting, SignupTimeslot currentTimeslot, SignupAttendee currentAttendee) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                this.actionsForOptimisticVersioning(meeting, currentTimeslot, currentAttendee);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                return meeting;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("someone.already.updated.db"));
    }

    private void checkTimeSlotStillAvailable(SignupMeeting meeting, SignupTimeslot currentTimeslot) throws Exception {
        List signupTimeSlots = meeting.getSignupTimeSlots();
        Long changedTimeslotId = currentTimeslot.getId();
        if (new Date().after(meeting.getSignupDeadline())) {
            throw new SignupUserActionException(Utilities.rb.getString("event.signup.deadline.passed"));
        }
        for (SignupTimeslot upTodateTimeslot : signupTimeSlots) {
            if (!upTodateTimeslot.getId().equals(changedTimeslotId)) continue;
            if (upTodateTimeslot.isCanceled()) {
                throw new SignupUserActionException(Utilities.rb.getString("timeslot.just.canceled"));
            }
            if (upTodateTimeslot.isLocked()) {
                throw new SignupUserActionException(Utilities.rb.getString("timeslot.just.locked"));
            }
            if (upTodateTimeslot.isAvailable()) continue;
            throw new SignupUserActionException(Utilities.rb.getString("someone.already.taken.theTimeslot"));
        }
    }

    private void checkForPromotion(SignupMeeting meeting, SignupAttendee newAttendee) throws Exception {
        String attendeeUserId = newAttendee.getAttendeeUserId();
        List signupTimeSlots = meeting.getSignupTimeSlots();
        int totalSignupSlots = 0;
        for (SignupTimeslot timeslot : signupTimeSlots) {
            List attendees = timeslot.getAttendees();
            for (SignupAttendee attendee : attendees) {
                if (!attendee.getAttendeeUserId().equals(attendeeUserId)) continue;
                ++totalSignupSlots;
            }
        }
        int preferredSlot = meeting.getMaxNumOfSlots();
        if (totalSignupSlots >= preferredSlot) {
            throw new SignupUserActionException(Utilities.rb.getString("you.promoted.to.another.ts_meanwhile"));
        }
    }

    private SignupMeeting reloadMeeting(Long meetingId) {
        SignupMeeting m = this.signupMeetingService.loadSignupMeeting(meetingId, this.userId, this.siteId);
        return m;
    }

    private void addAttendeeToTimeSlot(SignupMeeting meeting, SignupTimeslot selectedTimeSlot, SignupAttendee newAttendee) throws Exception {
        List signupTimeSlots = meeting.getSignupTimeSlots();
        for (SignupTimeslot upTodateTimeslot : signupTimeSlots) {
            if (!selectedTimeSlot.getId().equals(upTodateTimeslot.getId())) continue;
            List attendees = upTodateTimeslot.getAttendees();
            if (attendees != null && !attendees.isEmpty()) {
                for (SignupAttendee attendee : attendees) {
                    if (!attendee.getAttendeeUserId().equals(newAttendee.getAttendeeUserId())) continue;
                    throw new SignupUserActionException(Utilities.rb.getString("attendee.already.in.timeslot"));
                }
            }
            if (upTodateTimeslot.isCanceled()) {
                throw new SignupUserActionException(Utilities.rb.getString("timeslot.just.canceled"));
            }
            upTodateTimeslot.getAttendees().add(newAttendee);
            this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(newAttendee, upTodateTimeslot, "signup.email.attendee.signup", true);
        }
    }

    private void removeNewAttendeeFromWaitingList(SignupMeeting meeting, SignupAttendee newAttendee) {
        super.removeAttendeeFromWaitingList(meeting, newAttendee);
    }
}

