/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.model.SignupGroup;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.tool.jsf.SignupGroupWrapper;
import org.sakaiproject.signup.tool.jsf.SignupSiteWrapper;

public class CreateSitesGroups {
    private SignupMeeting signupMeeting;
    private final SakaiFacade sakaiFacade;
    private SignupSiteWrapper currentSite;
    private List<SignupSiteWrapper> otherSites;
    private SignupMeetingService signupMeetingService;
    private boolean siteOrGroupTruncated = false;
    private List<String> missingSites;
    private List<String> missingGroups;

    public CreateSitesGroups(SignupMeeting signupMeeting, SakaiFacade sakaiFacade, SignupMeetingService signupMeetingService) {
        this.signupMeeting = signupMeeting;
        this.sakaiFacade = sakaiFacade;
        this.signupMeetingService = signupMeetingService;
        this.setupSingupSites();
    }

    private void setupSingupSites() {
        String currentUserId = this.sakaiFacade.getCurrentUserId();
        String currentSiteId = this.sakaiFacade.getCurrentLocationId();
        List tmpSites = this.sakaiFacade.getUserSites(currentUserId);
        ArrayList<SignupSiteWrapper> siteWrappers = new ArrayList<SignupSiteWrapper>();
        for (SignupSite signupSite : tmpSites) {
            String siteId = signupSite.getSiteId();
            boolean siteAllowed = this.signupMeetingService.isAllowedToCreateinSite(currentUserId, siteId);
            SignupSiteWrapper sSiteWrapper = new SignupSiteWrapper(signupSite, siteAllowed);
            List signupGroups = signupSite.getSignupGroups();
            ArrayList<SignupGroupWrapper> groupWrappers = new ArrayList<SignupGroupWrapper>();
            for (SignupGroup group : signupGroups) {
                boolean groupAllowed = false;
                groupAllowed = siteAllowed ? true : this.signupMeetingService.isAllowedToCreateinGroup(currentUserId, siteId, group.getGroupId());
                if (!groupAllowed) continue;
                SignupGroupWrapper groupWrapper = new SignupGroupWrapper(group, groupAllowed);
                groupWrappers.add(groupWrapper);
            }
            sSiteWrapper.setSignupGroupWrappers(groupWrappers);
            if (siteId.equals(currentSiteId)) {
                sSiteWrapper.setSelected(siteAllowed);
            }
            if (!currentSiteId.equals(signupSite.getSiteId())) {
                siteWrappers.add(sSiteWrapper);
                continue;
            }
            this.currentSite = sSiteWrapper;
        }
        this.otherSites = siteWrappers;
    }

    public void resetSiteGroupCheckboxMark() {
        List otherSiteWrpList;
        SignupSiteWrapper siteWrp = this.getCurrentSite();
        if (siteWrp != null) {
            List grpWrpList;
            if (siteWrp.isAllowedToCreate()) {
                siteWrp.setSelected(true);
            }
            if ((grpWrpList = siteWrp.getSignupGroupWrappers()) != null) {
                for (SignupGroupWrapper grpWrp : grpWrpList) {
                    grpWrp.setSelected(false);
                }
            }
        }
        if ((otherSiteWrpList = this.getOtherSites()) != null) {
            for (SignupSiteWrapper oSiteWrp : otherSiteWrpList) {
                oSiteWrp.setSelected(false);
                List otherGrpWrpList = oSiteWrp.getSignupGroupWrappers();
                if (otherGrpWrpList == null) continue;
                for (SignupGroupWrapper oGrpWrp : otherGrpWrpList) {
                    oGrpWrp.setSelected(false);
                }
            }
        }
    }

    public static List<SignupSite> getSelectedSignupSites(SignupSiteWrapper currentSite, List<SignupSiteWrapper> otherSites) {
        ArrayList<SignupSite> sites = new ArrayList<SignupSite>();
        ArrayList<SignupSiteWrapper> siteWrappers = new ArrayList<SignupSiteWrapper>(otherSites);
        siteWrappers.add(0, currentSite);
        for (SignupSiteWrapper wrapper : siteWrappers) {
            SignupSite site = wrapper.getSignupSite();
            if (wrapper.isSelected()) {
                site.setSignupGroups(null);
            } else {
                List signupGroupWrappers = wrapper.getSignupGroupWrappers();
                ArrayList<SignupGroup> groups = new ArrayList<SignupGroup>();
                for (SignupGroupWrapper groupWrapper : signupGroupWrappers) {
                    if (!groupWrapper.isSelected()) continue;
                    groups.add(groupWrapper.getSignupGroup());
                }
                if (groups.isEmpty()) continue;
                site.setSignupGroups(groups);
            }
            sites.add(site);
        }
        return sites;
    }

    public static boolean isAtleastASiteOrGroupSelected(SignupSiteWrapper currentSite, List<SignupSiteWrapper> otherSites) {
        if (currentSite != null && currentSite.isSelected()) {
            return true;
        }
        if (currentSite != null) {
            List currentGroupsW = currentSite.getSignupGroupWrappers();
            for (SignupGroupWrapper wrapper : currentGroupsW) {
                if (!wrapper.isSelected()) continue;
                return true;
            }
        }
        if (otherSites != null) {
            for (SignupSiteWrapper siteW : otherSites) {
                if (siteW.isSelected()) {
                    return true;
                }
                List otherGroupsW = siteW.getSignupGroupWrappers();
                for (SignupGroupWrapper groupW : otherGroupsW) {
                    if (!groupW.isSelected()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public SignupSiteWrapper getCurrentSite() {
        return this.currentSite;
    }

    public void setCurrentSite(SignupSiteWrapper currentSite) {
        this.currentSite = currentSite;
    }

    public List<SignupSiteWrapper> getOtherSites() {
        return this.otherSites;
    }

    public void setOtherSites(List<SignupSiteWrapper> otherSites) {
        this.otherSites = otherSites;
    }

    public void processSiteGroupSelectionMarks() {
        if (this.signupMeeting != null && this.signupMeeting.getSignupSites() != null && this.signupMeeting.getSignupSites().size() > 0) {
            List origSiteList = this.signupMeeting.getSignupSites();
            for (SignupSite origSite : origSiteList) {
                this.markSelectedSite(origSite, this.getCurrentSite());
                if (this.getOtherSites() == null) continue;
                for (SignupSiteWrapper otherSiteWrp : this.getOtherSites()) {
                    this.markSelectedSite(origSite, otherSiteWrp);
                }
            }
            this.scanMissingSiteGroups(origSiteList);
        }
    }

    private void markSelectedSite(SignupSite origSite, SignupSiteWrapper siteWrp) {
        if (origSite.getSiteId().equals(siteWrp.getSignupSite().getSiteId())) {
            if ((origSite.getSignupGroups() == null || origSite.getSignupGroups().isEmpty()) && siteWrp.isAllowedToCreate()) {
                siteWrp.setSelected(true);
            } else {
                siteWrp.setSelected(false);
                List origGrpList = origSite.getSignupGroups();
                List grpWrpList = siteWrp.getSignupGroupWrappers();
                this.markSelectedGroups(origGrpList, grpWrpList);
            }
        }
    }

    private void markSelectedGroups(List<SignupGroup> origGrpList, List<SignupGroupWrapper> grpWrpList) {
        if (origGrpList == null || grpWrpList == null) {
            return;
        }
        for (SignupGroup origGrp : origGrpList) {
            for (SignupGroupWrapper grpWrp : grpWrpList) {
                if (!origGrp.getGroupId().equals(grpWrp.getSignupGroup().getGroupId())) continue;
                grpWrp.setSelected(true);
            }
        }
    }

    private void scanMissingSiteGroups(List<SignupSite> origSiteList) {
        this.siteOrGroupTruncated = false;
        this.missingSites = new ArrayList();
        this.missingGroups = new ArrayList();
        if (origSiteList == null || origSiteList.isEmpty()) {
            return;
        }
        boolean foundMissingOne = false;
        ArrayList<SignupSiteWrapper> copyAllSites = new ArrayList<SignupSiteWrapper>(this.getOtherSites());
        copyAllSites.add(0, this.getCurrentSite());
        for (SignupSite orgSite : origSiteList) {
            List origGroups;
            foundMissingOne = true;
            String orgSiteId = orgSite.getSiteId();
            SignupSiteWrapper matchedSiteWrp = null;
            boolean lackSiteScope = false;
            for (SignupSiteWrapper cpSiteWrp : copyAllSites) {
                if (!cpSiteWrp.getSignupSite().getSiteId().equals(orgSiteId)) continue;
                matchedSiteWrp = cpSiteWrp;
                if (!cpSiteWrp.isAllowedToCreate() && orgSite.isSiteScope()) {
                    lackSiteScope = true;
                    break;
                }
                foundMissingOne = false;
                break;
            }
            if (foundMissingOne) {
                this.siteOrGroupTruncated = true;
                if (lackSiteScope) {
                    this.getMissingSites().add(orgSite.getTitle() + "  - Lack site scope permission.");
                } else {
                    this.getMissingSites().add(orgSite.getTitle());
                }
            }
            if ((origGroups = orgSite.getSignupGroups()) == null || origGroups.isEmpty()) continue;
            if (matchedSiteWrp == null) {
                for (SignupGroup origGrp : origGroups) {
                    this.getMissingGroups().add(orgSite.getTitle() + "  - " + origGrp.getTitle());
                }
                this.getMissingSites().remove(orgSite.getTitle());
                continue;
            }
            List copyGrpWrpList = matchedSiteWrp.getSignupGroupWrappers();
            for (SignupGroup origGrp : origGroups) {
                foundMissingOne = true;
                String origGrpId = origGrp.getGroupId();
                if (copyGrpWrpList == null || copyGrpWrpList.isEmpty()) {
                    this.siteOrGroupTruncated = true;
                    this.getMissingGroups().add(orgSite.getTitle() + "  - " + origGrp.getTitle());
                    foundMissingOne = false;
                }
                for (SignupGroupWrapper cpGrpWrp : copyGrpWrpList) {
                    if (!origGrpId.equals(cpGrpWrp.getSignupGroup().getGroupId())) continue;
                    foundMissingOne = false;
                    break;
                }
                if (!foundMissingOne) continue;
                this.siteOrGroupTruncated = true;
                this.getMissingGroups().add(orgSite.getTitle() + "  - " + origGrp.getTitle());
            }
        }
    }

    public boolean isSiteOrGroupTruncated() {
        return this.siteOrGroupTruncated;
    }

    public List<String> getMissingSites() {
        return this.missingSites;
    }

    public void setMissingSites(List<String> missingSites) {
        this.missingSites = missingSites;
    }

    public List<String> getMissingGroups() {
        return this.missingGroups;
    }

    public void setMissingGroups(List<String> missingGroups) {
        this.missingGroups = missingGroups;
    }

    public void setSignupMeeting(SignupMeeting signupMeeting) {
        this.signupMeeting = signupMeeting;
    }
}

