/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfoImpl;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.TimeslotWrapper;
import org.sakaiproject.signup.tool.jsf.attachment.AttachmentHandler;
import org.sakaiproject.signup.tool.jsf.organizer.UserDefineTimeslotBean;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.signup.util.SignupDateFormat;
import org.springframework.dao.OptimisticLockingFailureException;

public class EditMeeting
extends SignupAction
implements MeetingTypes {
    private int maxNumOfAttendees;
    private boolean showAttendeeName;
    private int currentNumberOfSlots;
    private int timeSlotDuration;
    private boolean unlimited;
    private SignupMeeting originalMeetingCopy;
    private String signupBeginsType;
    private int signupBegins;
    private boolean isStartNowTypeForRecurEvents = false;
    private boolean signupBeginModifiedByUser;
    private String deadlineTimeType;
    private int deadlineTime;
    private boolean convertToNoRecurrent;
    private List<SignupMeeting> savedMeetings;
    private String recurringType = null;
    private Date firstRecurMeetingModifyDate = null;
    private Date lastRecurMeetingModifyDate = null;
    private List<SignupAttachment> currentAttachList;
    private List<SignupAttachment> needToCleanUpAttachInContentHS = new ArrayList();
    private List<SignupAttachment> attachsForFutureRecurrences = new ArrayList();
    private AttachmentHandler attachmentHandler;
    private List<TimeslotWrapper> customTimeSlotWrpList = null;
    private boolean userDefinedTS = false;
    private UserDefineTimeslotBean userDefineTimeslotBean;
    private List<SignupTimeslot> toBedeletedTSList = null;
    private SakaiFacade sakaiFacade;
    private boolean createGroups;
    private String coordinators;
    private boolean sendEmailByOwner;
    private boolean hasProcessedSyn_createGroups_job = false;

    public EditMeeting(String userId, String siteId, SignupMeetingService signupMeetingService, AttachmentHandler attachmentHandler, boolean isOrganizer) {
        super(userId, siteId, signupMeetingService, isOrganizer);
        this.attachmentHandler = attachmentHandler;
    }

    public void saveModifiedMeeting(SignupMeeting meeting) throws Exception {
        this.handleVersion(meeting);
        if (!this.unlimited && this.maxNumOfAttendees < this.originalMeetingCopy.getMaxNumberOfAttendees()) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("max.num_attendee_changed_and_attendee_mayOver_limit_inTS"));
        }
        this.logger.info((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.userId + " - has modified the meeting at meeting time:" + SignupDateFormat.format_date_h_mm_a((Date)meeting.getStartTime())));
        if (this.getMaxNumOfAttendees() > this.originalMeetingCopy.getMaxNumberOfAttendees()) {
            this.logger.info((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.userId + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
        }
        if (this.needToCleanUpAttachInContentHS != null) {
            for (SignupAttachment one : this.needToCleanUpAttachInContentHS) {
                this.getAttachmentHandler().removeAttachmentInContentHost(one);
            }
        }
    }

    public void handleVersion(SignupMeeting meeting) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                this.signupEventTrackingInfo = new SignupEventTrackingInfoImpl();
                this.signupEventTrackingInfo.setMeeting(meeting);
                this.toBedeletedTSList = null;
                List sMeetings = this.prepareModify(meeting);
                this.signupMeetingService.updateModifiedMeetings(sMeetings, this.toBedeletedTSList, true);
                this.setSavedMeetings(sMeetings);
                return;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("edit.failed_due_to_other_updated_db"));
    }

    private SignupMeeting reloadMeeting(SignupMeeting meeting) {
        return this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
    }

    private List<SignupMeeting> prepareModify(SignupMeeting userModifiedMeeting) throws Exception {
        List upTodateOrginMeetings = null;
        ArrayList<SignupMeeting> newlyModifyMeetings = new ArrayList<SignupMeeting>();
        Long recurrenceId = userModifiedMeeting.getRecurrenceId();
        if (recurrenceId != null && recurrenceId > 0L && !this.isConvertToNoRecurrent()) {
            upTodateOrginMeetings = this.signupMeetingService.getRecurringSignupMeetings(this.siteId, this.userId, recurrenceId, new Date());
            this.retrieveRecurrenceData(upTodateOrginMeetings);
        } else {
            SignupMeeting upTodateOrginMeeting = this.reloadMeeting(userModifiedMeeting);
            upTodateOrginMeetings = new ArrayList<SignupMeeting>();
            upTodateOrginMeetings.add(upTodateOrginMeeting);
        }
        SignupMeeting upToDateMatchOne = this.getCorrespondingMeeting(upTodateOrginMeetings, userModifiedMeeting);
        this.checkPreCondition(upToDateMatchOne, upTodateOrginMeetings);
        Calendar calendar = Calendar.getInstance();
        int recurNum = 0;
        this.toBedeletedTSList = new ArrayList();
        Iterator i$ = upTodateOrginMeetings.iterator();
        while (i$.hasNext()) {
            SignupMeeting upTodateOrginMeeting;
            SignupMeeting newlyModifyMeeting = upTodateOrginMeeting = (SignupMeeting)i$.next();
            long startTimeChangeDiff = userModifiedMeeting.getStartTime().getTime() - this.getOriginalMeetingCopy().getStartTime().getTime();
            calendar.setTimeInMillis(upTodateOrginMeeting.getStartTime().getTime() + startTimeChangeDiff);
            this.passModifiedValues(userModifiedMeeting, calendar, newlyModifyMeeting, recurNum);
            ++recurNum;
            newlyModifyMeetings.add(newlyModifyMeeting);
        }
        return newlyModifyMeetings;
    }

    private void passModifiedValues(SignupMeeting modifiedMeeting, Calendar calendar, SignupMeeting newlyModifyMeeting, int recurNum) throws Exception {
        block21: {
            UserDefineTimeslotBean uBean;
            List timeslots;
            block23: {
                block22: {
                    boolean hasMeetingTitleChanged = false;
                    if (!newlyModifyMeeting.getTitle().equals(modifiedMeeting.getTitle())) {
                        hasMeetingTitleChanged = true;
                    }
                    newlyModifyMeeting.setTitle(modifiedMeeting.getTitle());
                    newlyModifyMeeting.setLocation(modifiedMeeting.getLocation());
                    newlyModifyMeeting.setCategory(modifiedMeeting.getCategory());
                    newlyModifyMeeting.setCreatorUserId(modifiedMeeting.getCreatorUserId());
                    newlyModifyMeeting.setStartTime(calendar.getTime());
                    newlyModifyMeeting.setDescription(modifiedMeeting.getDescription());
                    newlyModifyMeeting.setLocked(modifiedMeeting.isLocked());
                    newlyModifyMeeting.setCanceled(modifiedMeeting.isCanceled());
                    newlyModifyMeeting.setReceiveEmailByOwner(modifiedMeeting.isReceiveEmailByOwner());
                    newlyModifyMeeting.setAllowWaitList(modifiedMeeting.isAllowWaitList());
                    newlyModifyMeeting.setAllowComment(modifiedMeeting.isAllowComment());
                    newlyModifyMeeting.setAutoReminder(modifiedMeeting.isAutoReminder());
                    newlyModifyMeeting.setEidInputMode(modifiedMeeting.isEidInputMode());
                    newlyModifyMeeting.setAllowAttendance(modifiedMeeting.isAllowAttendance());
                    newlyModifyMeeting.setCreateGroups(modifiedMeeting.isCreateGroups());
                    newlyModifyMeeting.setMaxNumOfSlots(modifiedMeeting.getMaxNumOfSlots());
                    newlyModifyMeeting.setSendEmailByOwner(this.isSendEmailByOwner());
                    newlyModifyMeeting.setCoordinatorIds(this.getCoordinators());
                    if (this.currentAttachList != null) {
                        this.updateWithOrigalAttachments(newlyModifyMeeting, this.currentAttachList, recurNum);
                    }
                    if (newlyModifyMeeting.getMeetingType().equals("individual") && !this.isUserDefinedTS()) {
                        timeslots = newlyModifyMeeting.getSignupTimeSlots();
                        int newAddTs = this.getCurrentNumberOfSlots() - timeslots.size();
                        for (int i = 0; i < newAddTs; ++i) {
                            SignupTimeslot newTs = new SignupTimeslot();
                            newTs.setMaxNoOfAttendees(this.maxNumOfAttendees);
                            newTs.setDisplayAttendees(this.showAttendeeName);
                            timeslots.add(newTs);
                        }
                        int rownum = 1;
                        for (SignupTimeslot timeslot : timeslots) {
                            timeslot.setMaxNoOfAttendees(this.maxNumOfAttendees);
                            timeslot.setDisplayAttendees(this.showAttendeeName);
                            timeslot.setStartTime(calendar.getTime());
                            calendar.add(12, this.timeSlotDuration);
                            timeslot.setEndTime(calendar.getTime());
                            if (!newlyModifyMeeting.isAllowWaitList()) {
                                timeslot.setWaitingList(null);
                            }
                            if (this.isCreateGroups() && !this.hasProcessedSyn_createGroups_job) {
                                this.logger.error((Object)("Timeslot groupId: " + timeslot.getGroupId()));
                                boolean justCreated = false;
                                if (StringUtils.isBlank((String)timeslot.getGroupId()) || !this.sakaiFacade.checkForGroup(this.sakaiFacade.getCurrentLocationId(), timeslot.getGroupId())) {
                                    this.logger.error((Object)"Need to create a group for timeslot... ");
                                    String title = this.generateGroupTitle(newlyModifyMeeting.getTitle(), timeslot, rownum);
                                    String description = this.generateGroupDescription(newlyModifyMeeting.getTitle(), timeslot);
                                    String groupId = this.sakaiFacade.createGroup(this.sakaiFacade.getCurrentLocationId(), title, description, null);
                                    this.logger.error((Object)("Created group for timeslot: " + groupId));
                                    timeslot.setGroupId(groupId);
                                    justCreated = true;
                                }
                                if (hasMeetingTitleChanged && !justCreated) {
                                    String newTitle = this.generateGroupTitle(newlyModifyMeeting.getTitle(), timeslot, rownum);
                                    boolean success = this.sakaiFacade.synchonizeGroupTitle(this.sakaiFacade.getCurrentLocationId(), timeslot.getGroupId(), newTitle);
                                    if (!success) {
                                        Utilities.addErrorMessage((String)Utilities.rb.getString("error.no.change.group.title"));
                                    }
                                }
                            }
                            ++rownum;
                        }
                        if (this.isCreateGroups()) {
                            this.hasProcessedSyn_createGroups_job = true;
                        }
                    }
                    if (!newlyModifyMeeting.getMeetingType().equals("custom_ts") && !this.isUserDefinedTS()) break block21;
                    timeslots = newlyModifyMeeting.getSignupTimeSlots();
                    uBean = this.getUserDefineTimeslotBean();
                    if (uBean == null) break block22;
                    if ("modify_meeting".equals(uBean.getPlaceOrderBean())) break block23;
                }
                throw new SignupUserActionException(MessageFormat.format(Utilities.rb.getString("you.have.multiple.tabs.in.browser"), ServerConfigurationService.getServerName()));
            }
            uBean.modifyTimesSlotsWithChanges(this.customTimeSlotWrpList, timeslots, calendar, this.showAttendeeName, this.toBedeletedTSList);
            if (recurNum == 0) {
                this.notifyAttendeeIndeleteTimeslots(this.toBedeletedTSList);
            }
            newlyModifyMeeting.setMeetingType("custom_ts");
            int duration = this.getUserDefineTimeslotBean().getEventDuration();
            calendar.add(12, duration);
        }
        if (newlyModifyMeeting.getMeetingType().equals("group")) {
            List signupTimeSlots = newlyModifyMeeting.getSignupTimeSlots();
            SignupTimeslot timeslot = (SignupTimeslot)signupTimeSlots.get(0);
            timeslot.setStartTime(newlyModifyMeeting.getStartTime());
            calendar.add(12, this.getTimeSlotDuration());
            timeslot.setEndTime(calendar.getTime());
            timeslot.setDisplayAttendees(this.showAttendeeName);
            int maxAttendees = this.unlimited ? Integer.MAX_VALUE : this.maxNumOfAttendees;
            timeslot.setMaxNoOfAttendees(maxAttendees);
            if (!newlyModifyMeeting.isAllowWaitList()) {
                timeslot.setWaitingList(null);
            }
        }
        if (newlyModifyMeeting.getMeetingType().equals("announcement")) {
            calendar.add(12, this.getTimeSlotDuration());
        }
        if (this.maxNumOfAttendees > this.originalMeetingCopy.getMaxNumberOfAttendees()) {
            this.promotingWaiters(newlyModifyMeeting);
        }
        newlyModifyMeeting.setEndTime(calendar.getTime());
        this.setSignupBeginDeadlineData(newlyModifyMeeting, this.getSignupBegins(), this.getSignupBeginsType(), this.getDeadlineTime(), this.getDeadlineTimeType());
        if (this.isConvertToNoRecurrent()) {
            newlyModifyMeeting.setRecurrenceId(null);
        }
        if (newlyModifyMeeting.getRecurrenceId() != null) {
            newlyModifyMeeting.setRepeatType(this.getRecurringType());
            newlyModifyMeeting.setRepeatUntil(this.getLastRecurMeetingModifyDate());
        }
    }

    private void notifyAttendeeIndeleteTimeslots(List<SignupTimeslot> toBedeletedTSList) {
        for (SignupTimeslot timeslot : toBedeletedTSList) {
            List attendees = timeslot.getAttendees();
            if (attendees == null || attendees.isEmpty()) continue;
            for (SignupAttendee attendee : attendees) {
                this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(attendee, timeslot, "signup.email.attendee.cancel", true);
            }
        }
    }

    private SignupMeeting getCorrespondingMeeting(List<SignupMeeting> upTodateOrginMeetings, SignupMeeting modifyMeeting) {
        for (SignupMeeting sm : upTodateOrginMeetings) {
            if (!sm.getId().equals(modifyMeeting.getId())) continue;
            return sm;
        }
        return null;
    }

    private void promotingWaiters(SignupMeeting modifiedMeeting) {
        List timeSlots = modifiedMeeting.getSignupTimeSlots();
        if (timeSlots == null || timeSlots.isEmpty()) {
            return;
        }
        for (SignupTimeslot timeslot : timeSlots) {
            List attList = timeslot.getAttendees();
            int maxNumOfAttendees = timeslot.getMaxNoOfAttendees();
            if (attList == null || attList.size() >= maxNumOfAttendees) continue;
            int availNum = maxNumOfAttendees - attList.size();
            for (int i = 0; i < availNum; ++i) {
                this.promoteAttendeeFromWaitingList(modifiedMeeting, timeslot);
            }
        }
    }

    private void checkPreCondition(SignupMeeting upTodateMeeting, List<SignupMeeting> upTodateOrginMeetings) throws SignupUserActionException {
        if (!(upTodateMeeting != null && this.originalMeetingCopy.getTitle().equals(upTodateMeeting.getTitle()) && this.originalMeetingCopy.getLocation().equals(upTodateMeeting.getLocation()) && StringUtils.equals((String)this.originalMeetingCopy.getCategory(), (String)upTodateMeeting.getCategory()) && StringUtils.equals((String)this.originalMeetingCopy.getCreatorUserId(), (String)upTodateMeeting.getCreatorUserId()) && this.originalMeetingCopy.getStartTime().getTime() == upTodateMeeting.getStartTime().getTime() && this.originalMeetingCopy.getEndTime().getTime() == upTodateMeeting.getEndTime().getTime() && this.originalMeetingCopy.getSignupBegins().getTime() == upTodateMeeting.getSignupBegins().getTime() && this.originalMeetingCopy.getSignupDeadline().getTime() == upTodateMeeting.getSignupDeadline().getTime() && this.originalMeetingCopy.getMeetingType().equals(upTodateMeeting.getMeetingType()) && (this.originalMeetingCopy.getRecurrenceId() == null && upTodateMeeting.getRecurrenceId() == null || this.originalMeetingCopy.getRecurrenceId() != null && this.originalMeetingCopy.getRecurrenceId().equals(upTodateMeeting.getRecurrenceId())) && this.originalMeetingCopy.getNoOfTimeSlots() == upTodateMeeting.getNoOfTimeSlots() && this.originalMeetingCopy.getMaxNumOfSlots().intValue() == upTodateMeeting.getMaxNumOfSlots().intValue() && this.originalMeetingCopy.isSendEmailByOwner() == upTodateMeeting.isSendEmailByOwner() && (this.originalMeetingCopy.getDescription() == null && upTodateMeeting.getDescription() == null || this.originalMeetingCopy.getDescription() != null && upTodateMeeting.getDescription() != null && this.originalMeetingCopy.getDescription().length() == upTodateMeeting.getDescription().length()) && !this.checkAttachmentsChanges(upTodateMeeting) && !this.checkAdvancedUserDefinedTSCase(this.originalMeetingCopy, upTodateMeeting, upTodateOrginMeetings))) {
            throw new SignupUserActionException(Utilities.rb.getString("someone.modified.event.content"));
        }
    }

    private boolean checkAdvancedUserDefinedTSCase(SignupMeeting originalMeetingCopy, SignupMeeting upTodateMeeting, List<SignupMeeting> upTodateOrginMeetings) throws SignupUserActionException {
        if (!upTodateMeeting.getMeetingType().equals("custom_ts") && !this.isUserDefinedTS()) {
            return false;
        }
        List origTSList = originalMeetingCopy.getSignupTimeSlots();
        if (origTSList != null) {
            int numOf_ts = origTSList.size();
            for (SignupMeeting upMeeting : upTodateOrginMeetings) {
                if (numOf_ts == upMeeting.getNoOfTimeSlots()) continue;
                throw new SignupUserActionException("One of the recurring event has been modified without synchronization with others! You have to disassociate it from the recurring events. The event starting date:" + upMeeting.getStartTime().toLocaleString());
            }
        }
        List upTodateTSList = upTodateMeeting.getSignupTimeSlots();
        if (origTSList != null && upTodateTSList != null) {
            for (SignupTimeslot oTS : origTSList) {
                if (oTS.getId() == null) continue;
                boolean found = false;
                for (SignupTimeslot uTS : upTodateTSList) {
                    if (!oTS.getId().equals(uTS.getId())) continue;
                    found = true;
                    if (oTS.getMaxNoOfAttendees() != uTS.getMaxNoOfAttendees()) {
                        return true;
                    }
                    if (oTS.getStartTime().getTime() == uTS.getStartTime().getTime() && oTS.getEndTime().getTime() == uTS.getEndTime().getTime()) break;
                    return true;
                }
                if (found) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean checkAttachmentsChanges(SignupMeeting latestOne) {
        List latestList = this.getEventMainAttachments(latestOne.getSignupAttachments());
        List orignalAttachList = this.getEventMainAttachments(this.originalMeetingCopy.getSignupAttachments());
        if (latestList.isEmpty() != orignalAttachList.isEmpty()) {
            return true;
        }
        if (latestList.size() != orignalAttachList.size()) {
            return true;
        }
        for (int i = 0; i < latestList.size(); ++i) {
            Date orignal;
            Date latest = ((SignupAttachment)latestList.get(i)).getLastModifiedDate();
            if (latest.equals(orignal = ((SignupAttachment)orignalAttachList.get(i)).getLastModifiedDate())) continue;
            return true;
        }
        return false;
    }

    private void setSignupBeginDeadlineData(SignupMeeting meeting, int signupBegin, String signupBeginType, int signupDeadline, String signupDeadlineType) throws Exception {
        Date sBegin = Utilities.subTractTimeToDate((Date)meeting.getStartTime(), (int)signupBegin, (String)signupBeginType);
        Date sDeadline = Utilities.subTractTimeToDate((Date)meeting.getEndTime(), (int)signupDeadline, (String)signupDeadlineType);
        boolean origSignupStarted = this.originalMeetingCopy.getSignupBegins().before(new Date());
        if (!"startNow".equals(signupBeginType) && sBegin.before(new Date()) && !origSignupStarted) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("warning.your.event.singup.begin.time.passed.today.time"));
        }
        if (this.isSignupBeginModifiedByUser() || !this.isStartNowTypeForRecurEvents) {
            meeting.setSignupBegins(sBegin);
        }
        if (sBegin.after(sDeadline)) {
            throw new SignupUserActionException(Utilities.rb.getString("signup.deadline.is.before.signup.begin"));
        }
        meeting.setSignupDeadline(sDeadline);
    }

    public int getCurrentNumberOfSlots() {
        return this.currentNumberOfSlots;
    }

    public void setCurrentNumberOfSlots(int currentNumberOfSlots) {
        this.currentNumberOfSlots = currentNumberOfSlots;
    }

    public int getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(int deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getDeadlineTimeType() {
        return this.deadlineTimeType;
    }

    public void setDeadlineTimeType(String deadlineTimeType) {
        this.deadlineTimeType = deadlineTimeType;
    }

    public int getTimeSlotDuration() {
        return this.timeSlotDuration;
    }

    public void setTimeSlotDuration(int timeSlotDuration) {
        this.timeSlotDuration = timeSlotDuration;
    }

    public int getMaxNumOfAttendees() {
        return this.maxNumOfAttendees;
    }

    public void setMaxNumOfAttendees(int maxNumOfAttendees) {
        this.maxNumOfAttendees = maxNumOfAttendees;
    }

    public SignupMeeting getOriginalMeetingCopy() {
        return this.originalMeetingCopy;
    }

    public void setOriginalMeetingCopy(SignupMeeting originalMeetingCopy) {
        this.originalMeetingCopy = originalMeetingCopy;
    }

    public boolean isShowAttendeeName() {
        return this.showAttendeeName;
    }

    public void setShowAttendeeName(boolean showAttendeeName) {
        this.showAttendeeName = showAttendeeName;
    }

    public int getSignupBegins() {
        return this.signupBegins;
    }

    public void setSignupBegins(int signupBegins) {
        this.signupBegins = signupBegins;
    }

    public String getSignupBeginsType() {
        return this.signupBeginsType;
    }

    public void setSignupBeginsType(String signupBeginsType) {
        this.signupBeginsType = signupBeginsType;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(boolean unlimited) {
        this.unlimited = unlimited;
    }

    public boolean isConvertToNoRecurrent() {
        return this.convertToNoRecurrent;
    }

    public void setConvertToNoRecurrent(boolean convertToNoRecurrent) {
        this.convertToNoRecurrent = convertToNoRecurrent;
    }

    public List<SignupMeeting> getSavedMeetings() {
        return this.savedMeetings;
    }

    private void setSavedMeetings(List<SignupMeeting> savedMeetings) {
        this.savedMeetings = savedMeetings;
    }

    public List<SignupAttachment> getCurrentAttachList() {
        return this.currentAttachList;
    }

    public void setCurrentAttachList(List<SignupAttachment> currentAttachList) {
        this.currentAttachList = currentAttachList;
    }

    public AttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public boolean isSignupBeginModifiedByUser() {
        return this.signupBeginModifiedByUser;
    }

    public void setSignupBeginModifiedByUser(boolean signupBeginModifiedByUser) {
        this.signupBeginModifiedByUser = signupBeginModifiedByUser;
    }

    private void retrieveRecurrenceData(List<SignupMeeting> upTodateOrginMeetings) {
        this.isStartNowTypeForRecurEvents = Utilities.testSignupBeginStartNowType(upTodateOrginMeetings);
        String repeatType = upTodateOrginMeetings.get(0).getRepeatType();
        if (repeatType != null && !"no_repeat".equals(repeatType)) {
            int lSize = upTodateOrginMeetings.size();
            this.setLastRecurMeetingModifyDate(upTodateOrginMeetings.get(lSize - 1).getStartTime());
            this.setRecurringType(repeatType);
            return;
        }
        this.setFirstRecurMeetingModifyDate(null);
        this.setLastRecurMeetingModifyDate(null);
        if (upTodateOrginMeetings == null || upTodateOrginMeetings.isEmpty()) {
            return;
        }
        this.setFirstRecurMeetingModifyDate(upTodateOrginMeetings.get(0).getStartTime());
        this.setLastRecurMeetingModifyDate(upTodateOrginMeetings.get(0).getStartTime());
        int listSize = upTodateOrginMeetings.size();
        if (listSize > 1) {
            this.setLastRecurMeetingModifyDate(upTodateOrginMeetings.get(listSize - 1).getStartTime());
            Calendar calFirst = Calendar.getInstance();
            Calendar calSecond = Calendar.getInstance();
            calFirst.setTime(upTodateOrginMeetings.get(listSize - 2).getStartTime());
            calFirst.set(13, 0);
            calFirst.set(14, 0);
            calSecond.setTime(upTodateOrginMeetings.get(listSize - 1).getStartTime());
            calSecond.set(13, 0);
            calSecond.set(14, 0);
            int tmp = calSecond.get(5);
            int daysDiff = (int)(calSecond.getTimeInMillis() - calFirst.getTimeInMillis()) / 86400000;
            if (daysDiff == 1) {
                this.setRecurringType("daily");
            } else if (daysDiff == 7) {
                this.setRecurringType("weekly");
            } else if (daysDiff == 14) {
                this.setRecurringType("biweekly");
            } else if (daysDiff == 3 && calFirst.get(7) == 6) {
                this.setRecurringType("wkdays_mon-fri");
            }
        }
    }

    private Date getFirstRecurMeetingModifyDate() {
        return this.firstRecurMeetingModifyDate;
    }

    private void setFirstRecurMeetingModifyDate(Date firstRecurMeetingModifyDate) {
        this.firstRecurMeetingModifyDate = firstRecurMeetingModifyDate;
    }

    private Date getLastRecurMeetingModifyDate() {
        return this.lastRecurMeetingModifyDate;
    }

    private void setLastRecurMeetingModifyDate(Date lastRecurMeetingModifyDate) {
        this.lastRecurMeetingModifyDate = lastRecurMeetingModifyDate;
    }

    private String getRecurringType() {
        return this.recurringType;
    }

    private void setRecurringType(String recurringType) {
        this.recurringType = recurringType;
    }

    private void updateWithOrigalAttachments(SignupMeeting sMeeting, List<SignupAttachment> currentAttachList, int recurNum) {
        ArrayList<SignupAttachment> upToDateList = sMeeting.getSignupAttachments();
        if (upToDateList == null) {
            upToDateList = new ArrayList<SignupAttachment>();
        }
        if (currentAttachList == null) {
            currentAttachList = new ArrayList<SignupAttachment>();
        }
        if (upToDateList.isEmpty()) {
            for (SignupAttachment curAttach : currentAttachList) {
                upToDateList.add(this.getAttachmentHandler().copySignupAttachment(sMeeting, true, curAttach, "mdf" + recurNum));
            }
            sMeeting.setSignupAttachments(upToDateList);
            return;
        }
        if (recurNum == 0) {
            for (int i = upToDateList.size() - 1; i >= 0; --i) {
                String upToDateResourceId = ((SignupAttachment)upToDateList.get(i)).getResourceId();
                int index = upToDateResourceId.lastIndexOf("/");
                if (index > -1) {
                    upToDateResourceId = upToDateResourceId.substring(0, index + 1) + "tmp" + "/" + upToDateResourceId.substring(index + 1, upToDateResourceId.length());
                }
                boolean found = false;
                Iterator<SignupAttachment> iter = currentAttachList.iterator();
                while (iter.hasNext()) {
                    SignupAttachment mdOne = iter.next();
                    String tm = mdOne.getResourceId();
                    if (!upToDateResourceId.equals(mdOne.getResourceId())) continue;
                    found = true;
                    this.needToCleanUpAttachInContentHS.add(mdOne);
                    iter.remove();
                    break;
                }
                if (found || ((SignupAttachment)upToDateList.get(i)).getTimeslotId() != null) continue;
                this.needToCleanUpAttachInContentHS.add(upToDateList.get(i));
                upToDateList.remove(i);
            }
            ArrayList tempList = new ArrayList(upToDateList);
            for (SignupAttachment curAttach : currentAttachList) {
                upToDateList.add(this.getAttachmentHandler().copySignupAttachment(sMeeting, true, curAttach, "mdf" + recurNum));
            }
            for (SignupAttachment tmp : tempList) {
                if (tmp.getTimeslotId() != null) continue;
                currentAttachList.add(this.getAttachmentHandler().copySignupAttachment(sMeeting, true, tmp, "tmp"));
            }
        } else {
            if (upToDateList.size() > 0) {
                for (int i = upToDateList.size() - 1; i >= 0; --i) {
                    SignupAttachment one = (SignupAttachment)upToDateList.get(i);
                    if (one.getTimeslotId() != null) continue;
                    this.needToCleanUpAttachInContentHS.add(one);
                    upToDateList.remove(i);
                }
            }
            for (SignupAttachment curAttach : currentAttachList) {
                upToDateList.add(this.getAttachmentHandler().copySignupAttachment(sMeeting, true, curAttach, "mdf" + recurNum));
            }
        }
    }

    public List<TimeslotWrapper> getCustomTimeSlotWrpList() {
        return this.customTimeSlotWrpList;
    }

    public void setCustomTimeSlotWrpList(List<TimeslotWrapper> customTimeSlotWrpList) {
        this.customTimeSlotWrpList = customTimeSlotWrpList;
    }

    public boolean isUserDefinedTS() {
        return this.userDefinedTS;
    }

    public void setUserDefinedTS(boolean userDefinedTS) {
        this.userDefinedTS = userDefinedTS;
    }

    public UserDefineTimeslotBean getUserDefineTimeslotBean() {
        return this.userDefineTimeslotBean;
    }

    public void setUserDefineTimeslotBean(UserDefineTimeslotBean userDefineTimeslotBean) {
        this.userDefineTimeslotBean = userDefineTimeslotBean;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public boolean isCreateGroups() {
        return this.createGroups;
    }

    public void setCreateGroups(boolean createGroups) {
        this.createGroups = createGroups;
    }

    public String getCoordinators() {
        return this.coordinators;
    }

    public void setCoordinators(String coordinators) {
        this.coordinators = coordinators;
    }

    public boolean isSendEmailByOwner() {
        return this.sendEmailByOwner;
    }

    public void setSendEmailByOwner(boolean sendEmailByOwner) {
        this.sendEmailByOwner = sendEmailByOwner;
    }
}

