/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.List;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfoImpl;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class ReplaceAttendee
extends SignupAction {
    public ReplaceAttendee(String userId, String siteId, SignupMeetingService signupMeetingService) {
        super(userId, siteId, signupMeetingService, true);
    }

    public void replace(SignupMeeting meeting, SignupTimeslot currentTimeslot, String toBeReplacedUserId, String replacerUserId, String replacerMainActiveSiteId) throws Exception {
        SignupAttendee replacer = new SignupAttendee(replacerUserId, replacerMainActiveSiteId);
        try {
            this.handleVersion(meeting, currentTimeslot, toBeReplacedUserId, replacer);
            Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_REPLACE_ATTENDEE_L, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + meeting.getId() + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
            this.logger.debug((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.userId + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
        }
        catch (PermissionException pe) {
            throw new SignupUserActionException(Utilities.rb.getString("no.permissoin.do_it"));
        }
    }

    private void replace(SignupMeeting meeting, SignupTimeslot currentTimeslot, String toBeReplacedUserId, SignupAttendee replacer) throws Exception {
        List attendees = currentTimeslot.getAttendees();
        int count = 0;
        if (currentTimeslot.getAttendee(replacer.getAttendeeUserId()) != null) {
            throw new SignupUserActionException(Utilities.rb.getString("failed.replaced_due_to_already_in_ts"));
        }
        for (SignupAttendee att : attendees) {
            if (toBeReplacedUserId.equals(att.getAttendeeUserId())) {
                attendees.remove(att);
                attendees.add(count, replacer);
                this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(replacer, currentTimeslot, "signup.email.attendee.replace", true, att);
                this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(att, currentTimeslot, "signup.email.attendee.cancel", false);
                this.removeAttendeeFromWaitingList(meeting, replacer);
                break;
            }
            ++count;
        }
    }

    private void handleVersion(SignupMeeting meeting, SignupTimeslot currentTimeslot, String toBeReplacedUserId, SignupAttendee newAttendee) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                this.signupEventTrackingInfo = new SignupEventTrackingInfoImpl();
                this.signupEventTrackingInfo.setMeeting(meeting);
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                currentTimeslot = meeting.getTimeslot(currentTimeslot.getId());
                if (currentTimeslot.getAttendee(toBeReplacedUserId) == null) {
                    throw new SignupUserActionException(Utilities.rb.getString("failed.replaced_due_to_attendee_notExisted_in_ts"));
                }
                this.replace(meeting, currentTimeslot, toBeReplacedUserId, newAttendee);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                return;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("failed.replace.someone.already.updated.db"));
    }
}

