/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfo;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfoImpl;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;

public abstract class SignupAction
implements SignupBeanConstants {
    protected final String userId;
    protected final String siteId;
    protected final SignupMeetingService signupMeetingService;
    protected SignupEventTrackingInfo signupEventTrackingInfo;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected final boolean isOrganizer;

    public SignupAction(String userId, String siteId, SignupMeetingService signupMeetingService, boolean isOrganizer) {
        this.userId = userId;
        this.siteId = siteId;
        this.signupMeetingService = signupMeetingService;
        this.isOrganizer = isOrganizer;
        this.signupEventTrackingInfo = new SignupEventTrackingInfoImpl();
    }

    public void removeAttendeeFromWaitingList(SignupMeeting meeting, SignupAttendee attendee) {
        List signupTimeSlots = meeting.getSignupTimeSlots();
        for (SignupTimeslot timeslot : signupTimeSlots) {
            List waiters = timeslot.getWaitingList();
            SignupAttendee waiter = timeslot.getWaiter(attendee.getAttendeeUserId());
            if (waiter == null) continue;
            waiters.remove(waiter);
        }
    }

    protected void removeAttendeeFromWaitingList(SignupTimeslot timeslot, SignupAttendee attendee) {
        List waiters = timeslot.getWaitingList();
        SignupAttendee waiter = timeslot.getWaiter(attendee.getAttendeeUserId());
        if (waiter != null) {
            waiters.remove(waiter);
        }
    }

    protected void promoteAttendeeFromWaitingList(SignupMeeting meeting, SignupTimeslot timeSlot) {
        List attendees = timeSlot.getAttendees();
        if (attendees != null && timeSlot.getMaxNoOfAttendees() <= attendees.size()) {
            return;
        }
        List waitingList = timeSlot.getWaitingList();
        if (waitingList == null || waitingList.isEmpty()) {
            return;
        }
        SignupAttendee promotedAttendee = (SignupAttendee)waitingList.get(0);
        SignupAttendee att = new SignupAttendee();
        att.setAttendeeUserId(promotedAttendee.getAttendeeUserId());
        att.setComments(promotedAttendee.getComments());
        att.setSignupSiteId(promotedAttendee.getSignupSiteId());
        timeSlot.getAttendees().add(att);
        this.removeAttendeeFromWaitingList(meeting, promotedAttendee);
        this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(att, timeSlot, "signup.email.attedee.promote", false);
        this.removeAttendeeFromAttendeesList(meeting, timeSlot, promotedAttendee);
    }

    protected void removeAttendeeFromAttendeesList(SignupMeeting meeting, SignupTimeslot currentTimeslot, SignupAttendee attendee) {
        String attendeeUserId = attendee.getAttendeeUserId();
        List signupTimeSlots = meeting.getSignupTimeSlots();
        int maxAllowedTimeslotsPerAttn = meeting.getMaxNumOfSlots();
        int currentCountForAttn = 1;
        for (SignupTimeslot upToDateTimeslot : signupTimeSlots) {
            if (currentTimeslot.getId().equals(upToDateTimeslot.getId())) continue;
            List attendees = upToDateTimeslot.getAttendees();
            boolean foundAttendee = false;
            Iterator iter = attendees.iterator();
            while (iter.hasNext()) {
                SignupAttendee att = (SignupAttendee)iter.next();
                if (!attendeeUserId.equals(att.getAttendeeUserId()) || ++currentCountForAttn <= maxAllowedTimeslotsPerAttn) continue;
                iter.remove();
                this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(att, upToDateTimeslot, "signup.email.attendee.cancel", false);
                this.promoteAttendeeFromWaitingList(meeting, upToDateTimeslot);
                foundAttendee = true;
                break;
            }
            if (!foundAttendee) continue;
            break;
        }
    }

    public SignupEventTrackingInfo getSignupEventTrackingInfo() {
        return this.signupEventTrackingInfo;
    }

    public void setSignupEventTrackingInfo(SignupEventTrackingInfo signupEventTrackingInfo) {
        this.signupEventTrackingInfo = signupEventTrackingInfo;
    }

    public List<SignupAttachment> getAttendeeAttachments(List<SignupAttachment> sAttachList) {
        return this.getCorrespondingAttachment(sAttachList, false);
    }

    public List<SignupAttachment> getEventMainAttachments(List<SignupAttachment> sAttachList) {
        return this.getCorrespondingAttachment(sAttachList, true);
    }

    private List<SignupAttachment> getCorrespondingAttachment(List<SignupAttachment> sAttachList, boolean isMainEventAttachs) {
        ArrayList<SignupAttachment> tmp = new ArrayList<SignupAttachment>();
        if (sAttachList != null) {
            for (SignupAttachment attach : sAttachList) {
                if (isMainEventAttachs) {
                    if (attach.getTimeslotId() != null) continue;
                    tmp.add(attach);
                    continue;
                }
                if (attach.getTimeslotId() == null || attach.getViewByAll().booleanValue()) continue;
                tmp.add(attach);
            }
        }
        return tmp;
    }

    public String generateGroupTitle(String meetingTitle, SignupTimeslot timeslot, int rowNum) {
        int TITLE_MAX_LENGTH = 99;
        int SEPARATOR = 45;
        DateFormat df = DateFormat.getDateInstance(3);
        int titleSize = 99 - "SIGNUP_".length();
        String dateString = df.format(timeslot.getStartTime());
        StringBuilder sb = new StringBuilder(titleSize);
        sb.append(" ");
        sb.append('-');
        sb.append(Utilities.rb.getString("group_slot_in_group_titlename"));
        sb.append(" " + rowNum);
        titleSize -= sb.length();
        if ((titleSize -= dateString.length() + 2) > 0) {
            sb.insert(0, meetingTitle.substring(0, Math.min(titleSize, meetingTitle.length())));
        }
        sb.append(" _" + dateString);
        return sb.toString();
    }

    public String getFormatTimeslotDateTime(SignupTimeslot timeslot) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        int SEPARATOR = 45;
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(timeslot.getStartTime()));
        sb.append('-');
        sb.append(df.format(timeslot.getEndTime()));
        return sb.toString();
    }

    public String generateGroupDescription(String meetingTitle, SignupTimeslot timeslot) {
        Object[] params = new Object[]{this.getFormatTimeslotDateTime(timeslot)};
        return MessageFormat.format(Utilities.rb.getString("group_description_default"), params);
    }

    public List<String> convertAttendeesToUuids(List<SignupAttendee> attendees) {
        ArrayList<String> uuids = new ArrayList<String>();
        for (SignupAttendee a : attendees) {
            uuids.add(a.getAttendeeUserId());
        }
        return uuids;
    }
}

