/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.List;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfoImpl;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class SwapAttendee
extends SignupAction {
    public SwapAttendee(String userId, String siteId, SignupMeetingService signupMeetingService) {
        super(userId, siteId, signupMeetingService, true);
    }

    public void swapAttendee(SignupMeeting meeting, SignupTimeslot currentTimeslot, String selectedAttendeeUserId, String attendeeTimeSlotWithId) throws Exception {
        String[] values = attendeeTimeSlotWithId.split("::");
        String swapTimeSlotId = values[0];
        String swapAttendeeId = values[1];
        try {
            this.handleVersion(meeting, currentTimeslot, selectedAttendeeUserId, swapTimeSlotId, swapAttendeeId);
            Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_SWAP_ATTENDEE_L, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + meeting.getId() + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
            this.logger.debug((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.userId + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
        }
        catch (PermissionException pe) {
            throw new SignupUserActionException(Utilities.rb.getString("no.permissoin.do_it"));
        }
    }

    private void handleVersion(SignupMeeting meeting, SignupTimeslot currentTimeslot, String selectedAttendeeUserId, String swapTimeSlotId, String swapAttendeeId) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                this.signupEventTrackingInfo = new SignupEventTrackingInfoImpl();
                this.signupEventTrackingInfo.setMeeting(meeting);
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                currentTimeslot = meeting.getTimeslot(currentTimeslot.getId());
                if (currentTimeslot.getAttendee(selectedAttendeeUserId) == null) {
                    throw new SignupUserActionException(Utilities.rb.getString("failed.swap_due_to_selected_attendee_notExited"));
                }
                if (meeting.getTimeslot(Long.valueOf(Long.parseLong(swapTimeSlotId))).getAttendee(swapAttendeeId) == null) {
                    throw new SignupUserActionException(Utilities.rb.getString("failed.swap_due_to_attendee_notExited"));
                }
                this.swap(meeting, currentTimeslot, selectedAttendeeUserId, swapTimeSlotId, swapAttendeeId);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                return;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("someone.already.updated.db"));
    }

    private void swap(SignupMeeting meeting, SignupTimeslot currentTimeslot, String selectedAttendeeUserId, String swapTimeSlotId, String swapAttendeeId) throws Exception {
        int currentAttendeeIndex = 0;
        int currentTimeslotIndex = 0;
        int swapTimeslotIndex = 0;
        int swapAttendeeIndex = 0;
        int timeSlotCounter = 0;
        List signupTimeSlots = meeting.getSignupTimeSlots();
        for (SignupTimeslot timeslot : signupTimeSlots) {
            List currentAttendees = timeslot.getAttendees();
            int counter = 0;
            for (SignupAttendee att : currentAttendees) {
                if (att.getAttendeeUserId().equals(selectedAttendeeUserId) && timeslot.getId().equals(currentTimeslot.getId())) {
                    currentTimeslotIndex = timeSlotCounter;
                    currentAttendeeIndex = counter;
                    break;
                }
                if (att.getAttendeeUserId().equals(swapAttendeeId) && timeslot.getId().toString().equals(swapTimeSlotId)) {
                    swapTimeslotIndex = timeSlotCounter;
                    swapAttendeeIndex = counter;
                    break;
                }
                ++counter;
            }
            ++timeSlotCounter;
        }
        SignupTimeslot currentimeslot = (SignupTimeslot)signupTimeSlots.get(currentTimeslotIndex);
        List currentAttendees = currentimeslot.getAttendees();
        SignupAttendee currentAttendee = (SignupAttendee)currentAttendees.get(currentAttendeeIndex);
        SignupTimeslot swapTimeslot = (SignupTimeslot)signupTimeSlots.get(swapTimeslotIndex);
        List swapAttendees = swapTimeslot.getAttendees();
        SignupAttendee swapAttendee = (SignupAttendee)swapAttendees.get(swapAttendeeIndex);
        if (currentTimeslot.getAttendee(swapAttendee.getAttendeeUserId()) != null) {
            throw new SignupUserActionException(Utilities.rb.getString("failed.swap.due_to_swapped_attendee_already_in_ts"));
        }
        if (swapTimeslot.getAttendee(currentAttendee.getAttendeeUserId()) != null) {
            throw new SignupUserActionException(Utilities.rb.getString("failed.swap.due_to_current_attendee_already_in_swapped_ts"));
        }
        currentAttendees.remove(currentAttendee);
        currentAttendees.add(currentAttendeeIndex, swapAttendee);
        this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(currentAttendee, swapTimeslot, "signup.email.attendee.swap", true, swapAttendee);
        this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(currentAttendee, currentTimeslot, "signup.email.attendee.cancel", false);
        swapAttendees.remove(swapAttendee);
        swapAttendees.add(swapAttendeeIndex, currentAttendee);
        this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(swapAttendee, currentTimeslot, "signup.email.attendee.swap", true, currentAttendee);
        this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(swapAttendee, swapTimeslot, "signup.email.attendee.cancel", false);
        this.removeAttendeeFromWaitingList(currentTimeslot, swapAttendee);
        this.removeAttendeeFromWaitingList(swapTimeslot, currentAttendee);
    }
}

