/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupUser;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.MessageUIBean;
import org.sakaiproject.signup.tool.jsf.SignupMeetingsBean;
import org.sakaiproject.signup.tool.jsf.organizer.UserDefineTimeslotBean;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.util.ResourceLoader;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Utilities
implements SignupBeanConstants,
MeetingTypes {
    public static ResourceLoader rb = new ResourceLoader("messages");
    public static ResourceLoader rbConf = new ResourceLoader("signupConfig");
    public static final String MESSAGE_UIBEAN = "messageUIBean";
    private static final int TYPE_ERROR = 1;
    private static final int TYPE_INFO = 2;
    protected static Log logger = LogFactoryImpl.getLog(Utilities.class);
    private static boolean postToDatabase = !"false".equals(Utilities.getSignupConfigParamVal((String)"signup.post.eventTracking.info.to.DB", (String)"true"));

    public static void addErrorMessage(String errorMsg) {
        Utilities.addMessage((String)"messageUIBean", (int)1, (String)errorMsg);
    }

    public static void addInfoMessage(String infoMsg) {
        Utilities.addMessage((String)"messageUIBean", (int)2, (String)infoMsg);
    }

    private static void addMessage(String key, int type, String msg) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        MessageUIBean msgBean = (MessageUIBean)sessionMap.get("messageUIBean");
        switch (type) {
            case 1: {
                msgBean.setErrorMessage(msg);
                break;
            }
            case 2: {
                msgBean.setInfoMessage(msg);
                break;
            }
            default: {
                logger.error((Object)("Invalid mesage type (" + type + "). No message will be set"));
            }
        }
        sessionMap.put(key, msgBean);
        context.renderResponse();
    }

    public static String getRequestParam(String attrName) {
        String value = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(attrName);
        if (value == null || value.trim().length() == 0) {
            value = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(attrName);
        }
        return value;
    }

    public static void resetMeetingList() {
        SignupMeetingsBean meetingsBean = (SignupMeetingsBean)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("SignupMeetingsBean");
        meetingsBean.setSignupMeetings(null);
    }

    public static SignupMeetingsBean getSignupMeetingsBean() {
        return (SignupMeetingsBean)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("SignupMeetingsBean");
    }

    public static Date reAllocateTimeslots(Date startTime, int timeSlotDuration, int numOfTimeslot, List<SignupTimeslot> tsList) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        if (tsList == null || tsList.isEmpty()) {
            return startTime;
        }
        for (SignupTimeslot timeslot : tsList) {
            timeslot.setStartTime(calendar.getTime());
            calendar.add(12, timeSlotDuration);
            timeslot.setEndTime(calendar.getTime());
        }
        return calendar.getTime();
    }

    public static Date subTractTimeToDate(Date date, int time, String dateType) {
        if (time == 0) {
            return date;
        }
        int type = -1;
        if (dateType.equals("minutes")) {
            type = 12;
        } else if (dateType.equals("hours")) {
            type = 10;
        } else {
            if (dateType.equals("startNow")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                cal.set(13, 0);
                cal.set(14, 0);
                return cal.getTime();
            }
            time = 24 * time;
            type = 10;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(type, -1 * time);
        return calendar.getTime();
    }

    public static String getTimeScaleType(long timeLength) {
        String timeUnitType = "minutes";
        if (timeLength == timeLength / 1440L * 1440L) {
            timeUnitType = "days";
        } else if (timeLength == timeLength / 60L * 60L) {
            timeUnitType = "hours";
        }
        return timeUnitType;
    }

    public static int getRelativeTimeValue(String timeScaleType, long timeLength) {
        long rValue = timeLength;
        if ("days".equals(timeScaleType)) {
            rValue = timeLength / 1440L;
        }
        if ("hours".equals(timeScaleType)) {
            rValue = timeLength / 60L;
        }
        return (int)rValue;
    }

    public static boolean testSignupBeginStartNowType(List<SignupMeeting> recurringMeetings) {
        boolean isStartNowTypeForRecurEvents = false;
        if (recurringMeetings != null && recurringMeetings.size() > 1) {
            long signupBeginsTimeLastOne;
            long signupBeginsTimeSecLastOne = recurringMeetings.get(recurringMeetings.size() - 2).getSignupBegins() == null ? new Date().getTime() : recurringMeetings.get(recurringMeetings.size() - 2).getSignupBegins().getTime();
            long l = signupBeginsTimeLastOne = recurringMeetings.get(recurringMeetings.size() - 1).getSignupBegins() == null ? new Date().getTime() : recurringMeetings.get(recurringMeetings.size() - 1).getSignupBegins().getTime();
            if (signupBeginsTimeSecLastOne == signupBeginsTimeLastOne) {
                isStartNowTypeForRecurEvents = true;
                for (SignupMeeting sm : recurringMeetings) {
                    if (sm.getSignupBegins().before(new Date())) continue;
                    isStartNowTypeForRecurEvents = false;
                    break;
                }
            }
        }
        return isStartNowTypeForRecurEvents;
    }

    public static List<SelectItem> getMeetingTypeSelectItems(String mSelectedType, boolean disableNotSelectedOnes) {
        ArrayList<SelectItem> meetingTypeItems = new ArrayList<SelectItem>();
        SelectItem announ = new SelectItem((Object)"announcement", rb.getString("label_announcement"), "anouncment");
        SelectItem multiple = new SelectItem((Object)"individual", rb.getString("label_individaul"), "individaul");
        SelectItem group = new SelectItem((Object)"group", rb.getString("label_group"), "group");
        if (disableNotSelectedOnes) {
            if (!"announcement".equals(mSelectedType)) {
                announ.setDisabled(true);
            }
            if (!"group".equals(mSelectedType)) {
                group.setDisabled(true);
            }
            if (!"individual".equals(mSelectedType)) {
                multiple.setDisabled(true);
            }
        }
        meetingTypeItems.add(announ);
        meetingTypeItems.add(group);
        meetingTypeItems.add(multiple);
        return meetingTypeItems;
    }

    public static void postEventTracking(String mainSignupEventType, String eventActionInfo) {
        if (postToDatabase) {
            UsageSession usageSession = UsageSessionService.getSession();
            if (eventActionInfo != null && eventActionInfo.length() >= 256) {
                eventActionInfo = eventActionInfo.substring(0, 252) + "...";
            }
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)mainSignupEventType, (String)eventActionInfo, (boolean)false), (UsageSession)usageSession);
        }
    }

    public static String retrieveAvailStatus(SignupMeeting meeting, String currentUserId, SakaiFacade sakaiFacade) {
        long curTime = new Date().getTime();
        long meetingStartTime = meeting.getStartTime().getTime();
        long meetingEndTime = meeting.getEndTime().getTime();
        long meetingSignupBegin = meeting.getSignupBegins().getTime();
        if (meetingEndTime < curTime) {
            return rb.getString("event.closed");
        }
        if (meetingEndTime > curTime && meetingStartTime < curTime) {
            return rb.getString("event.inProgress");
        }
        if (meeting.getMeetingType().equals("announcement")) {
            return rb.getString("event.SignupNotRequire");
        }
        String availableStatus = rb.getString("event.unavailable");
        boolean isSignupBegin = true;
        if (meetingSignupBegin > curTime) {
            isSignupBegin = false;
            availableStatus = rb.getString("event.Signup.not.started.yet") + " " + sakaiFacade.getTimeService().newTime(meeting.getSignupBegins().getTime()).toStringLocalShortDate();
        }
        boolean isOnWaitingList = false;
        boolean isMeetingSpaceAvail = false;
        List signupTimeSlots = meeting.getSignupTimeSlots();
        for (SignupTimeslot timeslot : signupTimeSlots) {
            int size;
            List attendees = timeslot.getAttendees();
            for (SignupAttendee attendee : attendees) {
                if (!attendee.getAttendeeUserId().equals(currentUserId)) continue;
                return rb.getString("event.youSignedUp");
            }
            List waiters = timeslot.getWaitingList();
            if (!isOnWaitingList) {
                for (SignupAttendee waiter : waiters) {
                    if (!waiter.getAttendeeUserId().equals(currentUserId)) continue;
                    availableStatus = rb.getString("event.youOnWaitList");
                    isOnWaitingList = true;
                    break;
                }
            }
            int n = size = attendees == null ? 0 : attendees.size();
            if (isOnWaitingList || !isSignupBegin || timeslot.isLocked() || timeslot.isCanceled() || size >= timeslot.getMaxNoOfAttendees() && timeslot.getMaxNoOfAttendees() != Integer.MAX_VALUE) continue;
            availableStatus = rb.getString("event.available");
            isMeetingSpaceAvail = true;
        }
        if (isMeetingSpaceAvail && meeting.isLocked()) {
            availableStatus = rb.getString("event.meeting.locked");
        }
        return availableStatus;
    }

    public static Date getUserDefinedDate(int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, 24 * days);
        return cal.getTime();
    }

    public static String getSignupConfigParamVal(String paramName, String defaultValue) {
        String myConfigValue = defaultValue;
        if (paramName != null) {
            try {
                int index;
                myConfigValue = ServerConfigurationService.getString((String)paramName);
                if ((myConfigValue == null || myConfigValue.trim().length() < 1) && (index = (myConfigValue = rbConf.getString(paramName)).indexOf("missing key")) >= 0) {
                    myConfigValue = defaultValue;
                }
            }
            catch (Exception e) {
                myConfigValue = defaultValue;
            }
        }
        return myConfigValue;
    }

    public static boolean getSignupConfigParamVal(String paramname, boolean defaultValue) {
        String stringValue = Utilities.getSignupConfigParamVal((String)paramname, (String)String.valueOf(defaultValue));
        return "true".equalsIgnoreCase(stringValue);
    }

    public static boolean isDataIntegritySafe(boolean isUserDefinedTS, String callerBeanType, UserDefineTimeslotBean uBean) {
        if (isUserDefinedTS && !callerBeanType.equals(uBean.getPlaceOrderBean())) {
            Utilities.addErrorMessage((String)"You may have opened multiple Tabs in your browser, please close them and try again.");
            return false;
        }
        return true;
    }

    public static String getSelectedCoordinators(List<SignupUser> coordinators, String organizerId) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (SignupUser co : coordinators) {
            if (!co.isChecked()) continue;
            if (isFirst) {
                sb.append(co.getInternalUserId());
                isFirst = false;
                continue;
            }
            if (sb.length() >= 950) continue;
            sb.append("|" + co.getInternalUserId());
        }
        return sb.length() < 1 ? null : sb.toString();
    }
}

