/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.signup.logic.SignupMessageTypes;
import org.sakaiproject.signup.logic.SignupTrackingItem;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfo;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.util.SignupDateFormat;

public class SignupEventTrackingInfoImpl
implements SignupEventTrackingInfo,
SignupMessageTypes {
    private List<SignupTrackingItem> attendeeAllocationInfos = new ArrayList<SignupTrackingItem>();
    private SignupMeeting meeting;

    @Override
    public List<SignupTrackingItem> getAttendeeTransferInfos() {
        return this.attendeeAllocationInfos;
    }

    private SignupTrackingItem findOrCreateAttendeeTransferInfo(SignupAttendee attendee, String messageType) {
        for (SignupTrackingItem allocInfo : this.attendeeAllocationInfos) {
            if (!allocInfo.getAttendee().getAttendeeUserId().equals(attendee.getAttendeeUserId())) continue;
            return allocInfo;
        }
        SignupTrackingItem stItem = new SignupTrackingItem(attendee, messageType);
        this.attendeeAllocationInfos.add(stItem);
        return stItem;
    }

    @Override
    public void addOrUpdateAttendeeAllocationInfo(SignupAttendee attendee, SignupTimeslot timeslot, String messageType, boolean isInitiator) {
        SignupTrackingItem allocInfo = this.findOrCreateAttendeeTransferInfo(attendee, messageType);
        allocInfo.setInitiator(isInitiator);
        if ("signup.email.attedee.promote".equals(messageType) || "signup.email.attendee.move".equals(messageType) || "signup.email.attendee.signup".equals(messageType)) {
            allocInfo.setAddToTimeslot(timeslot);
            allocInfo.setMessageType(messageType);
        } else if ("signup.email.attendee.cancel".equals(messageType)) {
            allocInfo.addToRemovedTimeslotList(timeslot);
            if (isInitiator) {
                allocInfo.setMessageType(messageType);
            }
        }
    }

    @Override
    public void addOrUpdateAttendeeAllocationInfo(SignupAttendee attendee, SignupTimeslot timeslot, String messageType, boolean isInitiator, SignupAttendee replacedAttendee) {
        SignupTrackingItem allocInfo = this.findOrCreateAttendeeTransferInfo(attendee, messageType);
        allocInfo.setInitiator(isInitiator);
        if ("signup.email.attedee.promote".equals(messageType) || "signup.email.attendee.move".equals(messageType)) {
            allocInfo.setAddToTimeslot(timeslot);
            allocInfo.setMessageType(messageType);
        } else if ("signup.email.attendee.cancel".equals(messageType)) {
            allocInfo.addToRemovedTimeslotList(timeslot);
            if (isInitiator) {
                allocInfo.setMessageType(messageType);
            }
        } else if ("signup.email.attendee.swap".equals(messageType) || "signup.email.attendee.replace".equals(messageType)) {
            allocInfo.setAddToTimeslot(timeslot);
            allocInfo.setMessageType(messageType);
            allocInfo.setReplacedAttendde(replacedAttendee);
        }
    }

    @Override
    public SignupTrackingItem getInitiatorAllocationInfo() {
        for (SignupTrackingItem allocInfo : this.attendeeAllocationInfos) {
            if (!allocInfo.isInitiator()) continue;
            return allocInfo;
        }
        return null;
    }

    @Override
    public SignupMeeting getMeeting() {
        return this.meeting;
    }

    @Override
    public void setMeeting(SignupMeeting meeting) {
        this.meeting = meeting;
    }

    @Override
    public String getAllAttendeeTransferLogInfo() {
        StringBuilder sb = new StringBuilder();
        List<SignupTrackingItem> trackItemList = this.getAttendeeTransferInfos();
        sb.append(" Acts:");
        for (SignupTrackingItem item : trackItemList) {
            if (item.getMessageType().equals("signup.email.attendee.signup")) {
                sb.append("-att:" + item.getAttendee().getAttendeeUserId() + " signUpToTs: " + this.getTimeSlot(item.getAddToTimeslot()));
                continue;
            }
            if (item.getMessageType().equals("signup.email.attendee.cancel")) {
                sb.append("-att:" + item.getAttendee().getAttendeeUserId() + " canclFrTs: " + this.getTimeSlot(item.getRemovedFromTimeslot()));
                continue;
            }
            if (item.getMessageType().equals("signup.email.orgranizer.remove")) {
                sb.append("-att:" + item.getAttendee().getAttendeeUserId() + " rmvFrTs: " + this.getTimeSlot(item.getRemovedFromTimeslot()));
                continue;
            }
            if (item.getMessageType().equals("signup.email.attedee.promote")) {
                sb.append("-att:" + item.getAttendee().getAttendeeUserId() + " promtToTs: " + this.getTimeSlot(item.getAddToTimeslot()));
                continue;
            }
            if (item.getMessageType().equals("signup.email.attendee.swap")) {
                sb.append("-att:" + item.getAttendee().getAttendeeUserId() + " swapToTs: " + this.getTimeSlot(item.getAddToTimeslot()));
                continue;
            }
            if (item.getMessageType().equals("signup.email.attendee.move")) {
                sb.append("-att:" + item.getAttendee().getAttendeeUserId() + " movToTs: " + this.getTimeSlot(item.getAddToTimeslot()));
                continue;
            }
            if (!item.getMessageType().equals("signup.email.attendee.replace")) continue;
            sb.append("-att:" + item.getAttendee().getAttendeeUserId() + " add(replace)ToTs: " + this.getTimeSlot(item.getAddToTimeslot()));
        }
        sb.append(" on " + SignupDateFormat.format_date_mm_dd_yy(this.meeting.getStartTime()));
        return sb.toString();
    }

    private String getTimeSlot(SignupTimeslot timeslot) {
        String s = " " + SignupDateFormat.format_h_mm_a(timeslot.getStartTime()) + "-" + SignupDateFormat.format_h_mm_a(timeslot.getEndTime()) + " ";
        return s;
    }

    private String getTimeSlot(List<SignupTimeslot> timeslots) {
        if (timeslots == null || timeslots.isEmpty()) {
            return " ";
        }
        StringBuilder sb = new StringBuilder();
        for (SignupTimeslot timeslot : timeslots) {
            sb.append(" " + SignupDateFormat.format_h_mm_a(timeslot.getStartTime()) + "-" + SignupDateFormat.format_h_mm_a(timeslot.getEndTime()) + " ");
        }
        return sb.toString();
    }
}

