/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.fortuna.ical4j.model.component.VEvent;
import org.sakaiproject.signup.model.SignupAttendee;

public class SignupTimeslot
implements Comparable {
    private Long id;
    private int version;
    private Date startTime;
    private Date endTime;
    private boolean locked;
    private String groupId;
    private boolean canceled;
    private int maxNoOfAttendees;
    private boolean displayAttendees;
    private List<SignupAttendee> attendees = new ArrayList<SignupAttendee>();
    private List<SignupAttendee> waitingList = new ArrayList<SignupAttendee>();
    private VEvent vevent;
    private String uuid = UUID.randomUUID().toString();
    public static final int UNLIMITED = Integer.MAX_VALUE;

    public boolean isAvailable() {
        if (this.attendees == null) {
            return true;
        }
        return this.attendees.size() < this.maxNoOfAttendees;
    }

    public SignupAttendee getAttendee(String attendeeId) {
        if (this.attendees == null) {
            return null;
        }
        for (SignupAttendee attendee : this.attendees) {
            if (!attendee.getAttendeeUserId().equals(attendeeId)) continue;
            return attendee;
        }
        return null;
    }

    public SignupAttendee getWaiter(String attendeeId) {
        if (this.waitingList == null) {
            return null;
        }
        for (SignupAttendee waiter : this.waitingList) {
            if (!waiter.getAttendeeUserId().equals(attendeeId)) continue;
            return waiter;
        }
        return null;
    }

    public boolean isUnlimitedAttendee() {
        return this.maxNoOfAttendees == Integer.MAX_VALUE;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (!(o instanceof SignupTimeslot)) {
            throw new ClassCastException("SignupTimeslot object expected.");
        }
        int result = this.getStartTime().compareTo(((SignupTimeslot)o).getStartTime());
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public int getMaxNoOfAttendees() {
        return this.maxNoOfAttendees;
    }

    public boolean isDisplayAttendees() {
        return this.displayAttendees;
    }

    public List<SignupAttendee> getAttendees() {
        return this.attendees;
    }

    public List<SignupAttendee> getWaitingList() {
        return this.waitingList;
    }

    public VEvent getVevent() {
        return this.vevent;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setMaxNoOfAttendees(int maxNoOfAttendees) {
        this.maxNoOfAttendees = maxNoOfAttendees;
    }

    public void setDisplayAttendees(boolean displayAttendees) {
        this.displayAttendees = displayAttendees;
    }

    public void setAttendees(List<SignupAttendee> attendees) {
        this.attendees = attendees;
    }

    public void setWaitingList(List<SignupAttendee> waitingList) {
        this.waitingList = waitingList;
    }

    public void setVevent(VEvent vevent) {
        this.vevent = vevent;
    }

    private void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

