/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import net.fortuna.ical4j.model.component.VEvent;
import org.sakaiproject.signup.logic.Permission;
import org.sakaiproject.signup.logic.SignupMessageTypes;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;

public class SignupMeeting
implements MeetingTypes,
SignupMessageTypes {
    private Long id;
    private Long recurrenceId;
    private int version;
    private String title;
    private String description;
    private String location;
    private String category;
    private String creatorUserId;
    private String coordinatorIds;
    private Date startTime;
    private Date endTime;
    private Date signupBegins;
    private Date signupDeadline;
    private boolean canceled;
    private boolean locked;
    private String meetingType;
    private String repeatType;
    private boolean allowWaitList;
    private boolean allowComment;
    private boolean autoReminder;
    private boolean eidInputMode;
    private boolean receiveEmailByOwner;
    private boolean sendEmailByOwner;
    private List<SignupTimeslot> signupTimeSlots;
    private List<SignupSite> signupSites;
    private List<SignupAttachment> signupAttachments;
    private Permission permission;
    private String sendEmailToSelectedPeopleOnly;
    private boolean allowAttendance;
    private boolean createGroups;
    private Integer maxNumOfSlots;
    private int repeatNum;
    private boolean applyToAllRecurMeetings;
    private String currentSiteId;
    private Calendar cal = Calendar.getInstance();
    private Date repeatUntil;
    private boolean inMultipleCalendarBlocks = false;
    private VEvent vevent;
    private String uuid = UUID.randomUUID().toString();

    public Integer getMaxNumOfSlots() {
        if (this.maxNumOfSlots == null) {
            this.maxNumOfSlots = new Integer(1);
        }
        return this.maxNumOfSlots;
    }

    public void setEndTime(Date endTime) {
        this.endTime = this.truncateSeconds(endTime);
    }

    public int getNoOfTimeSlots() {
        return this.signupTimeSlots == null ? 0 : this.signupTimeSlots.size();
    }

    public void setSignupBegins(Date signupBegins) {
        this.signupBegins = this.truncateSeconds(signupBegins);
    }

    public void setSignupDeadline(Date signupDeadLine) {
        this.signupDeadline = this.truncateSeconds(signupDeadLine);
    }

    public void setStartTime(Date startTime) {
        this.startTime = this.truncateSeconds(startTime);
    }

    public int getMaxNumberOfAttendees() {
        if (this.signupTimeSlots == null || this.signupTimeSlots.isEmpty()) {
            return 0;
        }
        return this.signupTimeSlots.get(0).getMaxNoOfAttendees();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SignupMeeting)) {
            return false;
        }
        SignupMeeting other = (SignupMeeting)object;
        if (this.id == null) {
            return false;
        }
        return this.id.equals(other.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public SignupTimeslot getTimeslot(Long timeslotId) {
        if (this.signupTimeSlots == null) {
            return null;
        }
        for (SignupTimeslot timeslot : this.signupTimeSlots) {
            if (!timeslot.getId().equals(timeslotId)) continue;
            return timeslot;
        }
        return null;
    }

    public boolean isMeetingExpired() {
        Date today = new Date();
        int value = today.compareTo(this.endTime);
        return value > 0;
    }

    public boolean isPassedDeadline() {
        Date today = new Date();
        int value = today.compareTo(this.signupDeadline);
        return value > 0;
    }

    public boolean isMeetingCrossDays() {
        this.cal.setTime(this.getStartTime());
        int startingDay = this.cal.get(6);
        this.cal.setTime(this.getEndTime());
        int endingDay = this.cal.get(6);
        return startingDay != endingDay;
    }

    public boolean isStartToSignUp() {
        return this.signupBegins.before(new Date());
    }

    private Date truncateSeconds(Date time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public boolean isRecurredMeeting() {
        return this.recurrenceId != null || "daily".equals(this.getRepeatType()) || "weekly".equals(this.getRepeatType()) || "biweekly".equals(this.getRepeatType()) || "wkdays_mon-fri".equals(this.getRepeatType());
    }

    public boolean hasSignupAttachments() {
        return this.signupAttachments != null && !this.signupAttachments.isEmpty();
    }

    public List<String> getCoordinatorIdsList() {
        ArrayList<String> coUsers = new ArrayList<String>();
        if (this.coordinatorIds != null && this.coordinatorIds.trim().length() > 0) {
            StringTokenizer userIdTokens = new StringTokenizer(this.coordinatorIds, "|");
            while (userIdTokens.hasMoreTokens()) {
                String uId = userIdTokens.nextToken();
                coUsers.add(uId);
            }
        }
        return coUsers;
    }

    public Long getId() {
        return this.id;
    }

    public Long getRecurrenceId() {
        return this.recurrenceId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public String getCoordinatorIds() {
        return this.coordinatorIds;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getSignupBegins() {
        return this.signupBegins;
    }

    public Date getSignupDeadline() {
        return this.signupDeadline;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getMeetingType() {
        return this.meetingType;
    }

    public String getRepeatType() {
        return this.repeatType;
    }

    public boolean isAllowWaitList() {
        return this.allowWaitList;
    }

    public boolean isAllowComment() {
        return this.allowComment;
    }

    public boolean isAutoReminder() {
        return this.autoReminder;
    }

    public boolean isEidInputMode() {
        return this.eidInputMode;
    }

    public boolean isReceiveEmailByOwner() {
        return this.receiveEmailByOwner;
    }

    public boolean isSendEmailByOwner() {
        return this.sendEmailByOwner;
    }

    public List<SignupTimeslot> getSignupTimeSlots() {
        return this.signupTimeSlots;
    }

    public List<SignupSite> getSignupSites() {
        return this.signupSites;
    }

    public List<SignupAttachment> getSignupAttachments() {
        return this.signupAttachments;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public String getSendEmailToSelectedPeopleOnly() {
        return this.sendEmailToSelectedPeopleOnly;
    }

    public boolean isAllowAttendance() {
        return this.allowAttendance;
    }

    public boolean isCreateGroups() {
        return this.createGroups;
    }

    public int getRepeatNum() {
        return this.repeatNum;
    }

    public boolean isApplyToAllRecurMeetings() {
        return this.applyToAllRecurMeetings;
    }

    public String getCurrentSiteId() {
        return this.currentSiteId;
    }

    public Calendar getCal() {
        return this.cal;
    }

    public Date getRepeatUntil() {
        return this.repeatUntil;
    }

    public boolean isInMultipleCalendarBlocks() {
        return this.inMultipleCalendarBlocks;
    }

    public VEvent getVevent() {
        return this.vevent;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRecurrenceId(Long recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public void setCoordinatorIds(String coordinatorIds) {
        this.coordinatorIds = coordinatorIds;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setMeetingType(String meetingType) {
        this.meetingType = meetingType;
    }

    public void setRepeatType(String repeatType) {
        this.repeatType = repeatType;
    }

    public void setAllowWaitList(boolean allowWaitList) {
        this.allowWaitList = allowWaitList;
    }

    public void setAllowComment(boolean allowComment) {
        this.allowComment = allowComment;
    }

    public void setAutoReminder(boolean autoReminder) {
        this.autoReminder = autoReminder;
    }

    public void setEidInputMode(boolean eidInputMode) {
        this.eidInputMode = eidInputMode;
    }

    public void setReceiveEmailByOwner(boolean receiveEmailByOwner) {
        this.receiveEmailByOwner = receiveEmailByOwner;
    }

    public void setSendEmailByOwner(boolean sendEmailByOwner) {
        this.sendEmailByOwner = sendEmailByOwner;
    }

    public void setSignupTimeSlots(List<SignupTimeslot> signupTimeSlots) {
        this.signupTimeSlots = signupTimeSlots;
    }

    public void setSignupSites(List<SignupSite> signupSites) {
        this.signupSites = signupSites;
    }

    public void setSignupAttachments(List<SignupAttachment> signupAttachments) {
        this.signupAttachments = signupAttachments;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public void setSendEmailToSelectedPeopleOnly(String sendEmailToSelectedPeopleOnly) {
        this.sendEmailToSelectedPeopleOnly = sendEmailToSelectedPeopleOnly;
    }

    public void setAllowAttendance(boolean allowAttendance) {
        this.allowAttendance = allowAttendance;
    }

    public void setCreateGroups(boolean createGroups) {
        this.createGroups = createGroups;
    }

    public void setMaxNumOfSlots(Integer maxNumOfSlots) {
        this.maxNumOfSlots = maxNumOfSlots;
    }

    public void setRepeatNum(int repeatNum) {
        this.repeatNum = repeatNum;
    }

    public void setApplyToAllRecurMeetings(boolean applyToAllRecurMeetings) {
        this.applyToAllRecurMeetings = applyToAllRecurMeetings;
    }

    public void setCurrentSiteId(String currentSiteId) {
        this.currentSiteId = currentSiteId;
    }

    public void setCal(Calendar cal) {
        this.cal = cal;
    }

    public void setRepeatUntil(Date repeatUntil) {
        this.repeatUntil = repeatUntil;
    }

    public void setInMultipleCalendarBlocks(boolean inMultipleCalendarBlocks) {
        this.inMultipleCalendarBlocks = inMultipleCalendarBlocks;
    }

    public void setVevent(VEvent vevent) {
        this.vevent = vevent;
    }

    private void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

