/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.restful;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.signup.logic.Permission;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.restful.SignupSiteItem;
import org.sakaiproject.signup.restful.SignupTimeslotItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignupEvent
implements Entity,
MeetingTypes {
    public static final String USER_SIGNUP = "signup";
    public static final String USER_CANCEL_SIGNUP = "cancelSignup";
    public static final String USER_ADD_TO_WAITLIST = "addToWaitList";
    public static final String USER_REMOVE_FROM_WAITLIST = "removeWaitList";
    public static final String USER_ACTION_TYPE_FIELD_NAME = "userActionType";
    public static final String ALLOCATE_TO_TS_ID_FIELD_NAME = "allocToTSid";
    public static final String SITE_ID_FIELD_NAME = "siteId";
    private static final long serialVersionUID = 2L;
    public static final String[] USER_ATION_Types = new String[]{"signup", "cancelSignup", "addToWaitList", "removeWaitList"};
    private Long id;
    private Long recurrenceId;
    private String title;
    private String description;
    private String location;
    private String organizerName;
    private Date startTime;
    private Date endTime;
    private Date myStartTime;
    private Date myEndTime;
    private Date signupBegins;
    private Date signupDeadline;
    private String meetingType;
    private String repeatType;
    private boolean allowWaitList;
    private boolean allowComment;
    private boolean eidInputMode;
    private boolean autoReminder;
    private List<SignupTimeslotItem> signupTimeSlotItems;
    private List<SignupSiteItem> signupSiteItems;
    private List<SignupAttachment> signupMainEventAttachItems;
    private Permission permission;
    private String entityID;
    private String siteId;
    private boolean currentUserSignedUp;
    private String allocToTSid;
    private String availableStatus = null;
    private String userActionType;
    private boolean allowAttendance;
    private Integer maxNumOfSlots;
    private Calendar cal = Calendar.getInstance();
    private String[] allowedUserActionTypes;
    private String userActionWarningMsg;

    public String getId() {
        if (this.entityID == null) {
            this.entityID = this.id + "";
        }
        return this.entityID;
    }

    public void setId(String s) {
        this.entityID = s;
    }

    public Long getEventId() {
        return this.id;
    }

    public void setEventId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOrganizerName() {
        return this.organizerName;
    }

    public void setOrganizerName(String organizerName) {
        this.organizerName = organizerName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = this.truncateSeconds(endTime);
    }

    public String getAvailableStatus() {
        return this.availableStatus;
    }

    public void setAvailableStatus(String availableStatus) {
        this.availableStatus = availableStatus;
    }

    public String getMeetingType() {
        return this.meetingType;
    }

    public void setMeetingType(String meetingType) {
        this.meetingType = meetingType;
    }

    public int getNoOfTimeSlots() {
        return this.signupTimeSlotItems == null ? 0 : this.signupTimeSlotItems.size();
    }

    public Long getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setRecurrenceId(Long recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = this.truncateSeconds(startTime);
    }

    public Date getDate() {
        return this.getStartTime();
    }

    public Date getSignupBegins() {
        return this.signupBegins;
    }

    public void setSignupBegins(Date signupBegins) {
        this.signupBegins = this.truncateSeconds(signupBegins);
    }

    public Date getSignupDeadline() {
        return this.signupDeadline;
    }

    public void setSignupDeadline(Date signupDeadLine) {
        this.signupDeadline = this.truncateSeconds(signupDeadLine);
    }

    public boolean isAllowWaitList() {
        return this.allowWaitList;
    }

    public void setAllowWaitList(boolean allowWaitList) {
        this.allowWaitList = allowWaitList;
    }

    public boolean isAllowComment() {
        return this.allowComment;
    }

    public void setAllowComment(boolean allowComment) {
        this.allowComment = allowComment;
    }

    public String getRepeatType() {
        return this.repeatType;
    }

    public void setRepeatType(String repeatType) {
        this.repeatType = repeatType;
    }

    public boolean isMySignupEvents() {
        return this.myStartTime != null && this.myEndTime != null;
    }

    public Date getMyStartTime() {
        return this.myStartTime;
    }

    public void setMyStartTime(Date myStartTime) {
        this.myStartTime = myStartTime;
    }

    public Date getMyEndTime() {
        return this.myEndTime;
    }

    public void setMyEndTime(Date myEndTime) {
        this.myEndTime = myEndTime;
    }

    public boolean isallowAttendance() {
        return this.allowAttendance;
    }

    public void setAllowAttendance(boolean allowAttendance) {
        this.allowAttendance = allowAttendance;
    }

    public int getMaxNumberOfAttendees() {
        if (this.signupTimeSlotItems == null || this.signupTimeSlotItems.isEmpty()) {
            return 0;
        }
        return this.signupTimeSlotItems.get(0).getMaxNoOfAttendees();
    }

    public List<SignupSiteItem> getSignupSiteItems() {
        return this.signupSiteItems;
    }

    public void setSignupSiteItems(List<SignupSiteItem> signupSites) {
        this.signupSiteItems = signupSites;
    }

    public boolean isStartToSignUp() {
        return this.signupBegins.before(new Date());
    }

    public boolean isMeetingExpired() {
        Date today = new Date();
        int value = today.compareTo(this.endTime);
        return value > 0;
    }

    public boolean isPassedDeadline() {
        Date today = new Date();
        int value = today.compareTo(this.signupDeadline);
        return value > 0;
    }

    public boolean isMeetingCrossDays() {
        this.cal.setTime(this.getStartTime());
        int startingDay = this.cal.get(6);
        this.cal.setTime(this.getEndTime());
        int endingDay = this.cal.get(6);
        return startingDay != endingDay;
    }

    public boolean isCurrentUserSignedUp() {
        return this.currentUserSignedUp;
    }

    public void setCurrentUserSignedUp(boolean currentUserSignedUp) {
        this.currentUserSignedUp = currentUserSignedUp;
    }

    public String[] getAllowedUserActionTypes() {
        return this.allowedUserActionTypes;
    }

    public void setAllowedUserActionTypes(String[] types) {
        this.allowedUserActionTypes = types;
    }

    public List<SignupTimeslotItem> getSignupTimeSlotItems() {
        return this.signupTimeSlotItems;
    }

    public void setSignupTimeSlotItems(List<SignupTimeslotItem> signupTimeSlotItems) {
        this.signupTimeSlotItems = signupTimeSlotItems;
    }

    public List<SignupAttachment> getSignupMainEventAttachItems() {
        return this.signupMainEventAttachItems;
    }

    public void setSignupMainEventAttachItems(List<SignupAttachment> signupMainEventAttachItems) {
        this.signupMainEventAttachItems = signupMainEventAttachItems;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public String getAllocToTSid() {
        return this.allocToTSid;
    }

    public void setAllocToTSid(String allocToTSid) {
        this.allocToTSid = allocToTSid;
    }

    public String getUserActionType() {
        return this.userActionType;
    }

    public void setUserActionType(String userActionType) {
        this.userActionType = userActionType;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public boolean isEidInputMode() {
        return this.eidInputMode;
    }

    public void setEidInputMode(boolean eidInputMode) {
        this.eidInputMode = eidInputMode;
    }

    public boolean isAutoReminder() {
        return this.autoReminder;
    }

    public void setAutoReminder(boolean autoReminder) {
        this.autoReminder = autoReminder;
    }

    private Date truncateSeconds(Date time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public ResourceProperties getProperties() {
        return null;
    }

    public String getReference() {
        return ServerConfigurationService.getAccessUrl() + "/signupEvent/" + "/" + this.getId();
    }

    public String getReference(String arg0) {
        return this.getReference();
    }

    public String getServerUrl() {
        return ServerConfigurationService.getServerUrl();
    }

    public String getUrl() {
        return ServerConfigurationService.getAccessUrl() + "/signupEvent/" + this.getId();
    }

    public String getUrl(String arg0) {
        return this.getUrl();
    }

    public Element toXml(Document doc, Stack stack) {
        Element event = doc.createElement("signupEvent");
        if (stack.isEmpty()) {
            doc.appendChild(event);
        } else {
            ((Element)stack.peek()).appendChild(event);
        }
        stack.push(event);
        event.setAttribute("id", this.getId());
        event.setAttribute("eventid", this.getEventId().toString());
        event.setAttribute("title", this.getTitle());
        event.setAttribute("organizer", this.getOrganizerName());
        event.setAttribute("location", this.getLocation());
        event.setAttribute("event-type", this.getMeetingType());
        event.setAttribute("event-recurrenceId", this.getRecurrenceId().toString());
        if (this.description != null) {
            event.setAttribute("description", this.description);
        }
        event.setAttribute("start-time", this.getStartTime().toString());
        event.setAttribute("end-time", this.getEndTime().toString());
        event.setAttribute("signup-begin", this.getSignupBegins().toString());
        event.setAttribute("signup-deadline", this.getSignupDeadline().toString());
        stack.pop();
        return event;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.id).append((Object)this.organizerName).append((Object)this.title).append((Object)this.location).append((Object)this.startTime).append((Object)this.endTime).append((Object)this.description).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignupEvent other = (SignupEvent)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getUserActionWarningMsg() {
        String msg = this.userActionWarningMsg;
        this.userActionWarningMsg = null;
        return msg;
    }

    public void setUserActionWarningMsg(String userActionWarningMsg) {
        this.userActionWarningMsg = userActionWarningMsg;
    }

    public Integer getMaxNumOfSlots() {
        return this.maxNumOfSlots;
    }

    public void setMaxNumOfSlots(Integer maxNumOfSlots) {
        this.maxNumOfSlots = maxNumOfSlots;
    }
}

