/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic;

import org.sakaiproject.authz.api.Role;

public class SignupUser {
    private String eid;
    private String internalUserId;
    private String firstName;
    private String lastName;
    private Role userRole;
    private String mainSiteId;
    private boolean publishedSite;
    private boolean checked;

    public SignupUser(String eid, String internalUserId, String firstName, String lastName, Role role, String siteId, boolean publishedSite) {
        this.eid = eid;
        this.internalUserId = internalUserId;
        this.firstName = firstName;
        this.lastName = this.firstCharToUppercase(lastName);
        this.userRole = role;
        this.mainSiteId = siteId;
        this.publishedSite = publishedSite;
        if (!(this.lastName != null && this.lastName.trim().length() != 0 || this.firstName != null && this.firstName.trim().length() != 0)) {
            this.lastName = eid;
        }
    }

    public String getEid() {
        return this.eid;
    }

    public String getInternalUserId() {
        return this.internalUserId;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof SignupUser)) {
            return false;
        }
        SignupUser user = (SignupUser)other;
        return this.eid.equals(user.getEid());
    }

    public int hashCode() {
        return this.eid.hashCode();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDisplayName() {
        String name = this.lastName + ", " + (this.firstName != null ? this.firstName : "");
        if (name.trim().length() == 1) {
            name = this.eid;
        }
        return name;
    }

    public Role getUserRole() {
        return this.userRole;
    }

    public void setUserRole(Role userRole) {
        this.userRole = userRole;
    }

    public String getMainSiteId() {
        return this.mainSiteId;
    }

    public void setMainSiteId(String mainSiteId) {
        this.mainSiteId = mainSiteId;
    }

    public boolean isPublishedSite() {
        return this.publishedSite;
    }

    public void setPublishedSite(boolean publishedSite) {
        this.publishedSite = publishedSite;
    }

    private String firstCharToUppercase(String name) {
        if (name != null && name.length() > 0) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return name;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }
}

