/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.user.api.User;

public class EmailDeliverer
implements Runnable {
    private List<User> sakaiUsers;
    private final EmailService emailService;
    private Log logger = LogFactoryImpl.getLog(this.getClass());
    private final List<String> headers;
    private final String message;

    public EmailDeliverer(List<User> sakaiUsers, List<String> headers, String message, EmailService emailService) {
        this.sakaiUsers = sakaiUsers;
        this.headers = headers;
        this.message = message;
        this.emailService = emailService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.emailService.sendToUsers(this.sakaiUsers, this.headers, this.message);
        }
        catch (Exception e) {
            this.logger.warn((Object)("The emails may not be sent away due to error: " + e.getMessage()));
        }
        finally {
            if (this.sakaiUsers != null) {
                this.sakaiUsers.clear();
            }
            this.sakaiUsers = null;
        }
    }
}

