/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupTrackingItem;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.logic.messages.SignupTimeslotChanges;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class SwapAttendeeEmail
extends SignupEmailBase
implements SignupTimeslotChanges {
    private final User organizer;
    private final User attendee1;
    private final User attendee2;
    private final SignupTrackingItem item;
    private String emailReturnSiteId;
    private List<SignupTimeslot> removed;
    private List<SignupTimeslot> added;

    public SwapAttendeeEmail(User organizer, User attendee1, User attendee2, SignupTrackingItem item, SignupMeeting meeting, SakaiFacade sakaiFacade) {
        this.organizer = organizer;
        this.attendee1 = attendee1;
        this.attendee2 = attendee2;
        this.item = item;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
        this.emailReturnSiteId = item.getAttendee().getSignupSiteId();
        this.removed = item.getRemovedFromTimeslot();
        this.added = Collections.singletonList(item.getAddToTimeslot());
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.attendee1.getEmail());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.attendee1.getDisplayName())));
        Object[] params = new Object[]{this.makeFirstCapLetter(this.organizer.getDisplayName()), "'" + this.meeting.getTitle() + "'", this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalDate(), this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.change.appointment.part"), params));
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalTime(), this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getEndTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalTime(), "<BR>\r\n "};
            message.append("<BR>\r\n<BR>\r\n " + MessageFormat.format(rb.getString("body.organizer.change.appointment.timeframe"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe = new Object[]{this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalTime(), this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalShortDate(), this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getEndTime()).toStringLocalTime(), this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getEndTime()).toStringLocalShortDate(), this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalShortDate(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalShortDate(), "<BR>\r\n "};
            message.append("<BR>\r\n<BR>\r\n " + MessageFormat.format(rb.getString("body.organizer.change.appointment.crossdays.timeframe"), paramsTimeframe));
        }
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendeeCheck.meetingStatus.B"), this.getServiceName()));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return StringUtils.defaultIfEmpty((String)this.organizer.getEmail(), (String)this.getServerFromAddress());
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.organizer.change.appointment.field"), this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalDate(), this.getTime(((SignupTimeslot)this.item.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalTime(), this.getAbbreviatedMeetingTitle());
    }

    public List<SignupTimeslot> getRemoved() {
        return this.removed;
    }

    public List<SignupTimeslot> getAdded() {
        return this.added;
    }
}

