/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupTrackingItem;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class PromoteAttendeeEmail
extends SignupEmailBase {
    private final User attendee;
    private final SignupTrackingItem item;
    private String emailReturnSiteId;

    public PromoteAttendeeEmail(User attendee, SignupTrackingItem item, SignupMeeting meeting, SakaiFacade sakaiFacade) {
        this.attendee = attendee;
        this.item = item;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
        this.emailReturnSiteId = item.getAttendee().getSignupSiteId();
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.attendee.getEmail());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.attendee.getDisplayName())));
        Object[] params = new Object[]{this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.assigned.promote.appointment.part"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.meeting.timeslot"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalShortDate(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.meeting.crossdays.timeslot"), paramsTimeframe));
        }
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendeeCheck.meetingStatus.B"), this.getServiceName()));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    private String getCancelledSlots() {
        StringBuilder tmp = new StringBuilder();
        List rmList = this.item.getRemovedFromTimeslot();
        if (rmList != null || !rmList.isEmpty()) {
            tmp.append("<BR>\r\n<BR>\r\n" + rb.getString("body.cancelled.timeSlots"));
            for (SignupTimeslot rmSlot : rmList) {
                tmp.append("<BR>\r\n  " + this.getSakaiFacade().getTimeService().newTime(rmSlot.getStartTime().getTime()).toStringLocalTime() + " - " + this.getSakaiFacade().getTimeService().newTime(rmSlot.getEndTime().getTime()).toStringLocalTime());
            }
        }
        return tmp.length() < 1 ? null : tmp.toString();
    }

    @Override
    public String getFromAddress() {
        return this.getServerFromAddress();
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.promote.appointment.field"), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getAbbreviatedMeetingTitle());
    }
}

