/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.user.api.User;

public class ModifyMeetingEmail
extends SignupEmailBase {
    private final User organizer;
    private final String emailReturnSiteId;

    public ModifyMeetingEmail(User orgainzer, SignupMeeting meeting, SakaiFacade sakaiFacade, String emailReturnSiteId) {
        this.organizer = orgainzer;
        this.meeting = meeting;
        this.emailReturnSiteId = emailReturnSiteId;
        this.setSakaiFacade(sakaiFacade);
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.getSakaiFacade().getServerConfigurationService().getString("setup.request", "no-reply@" + this.getSakaiFacade().getServerConfigurationService().getServerName()));
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        Object[] params = new Object[]{this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName(), this.makeFirstCapLetter(this.organizer.getDisplayName())};
        message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizerModified.meeting.field"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getTime(this.meeting.getStartTime()).toStringLocalTime(), this.getTime(this.meeting.getEndTime()).toStringLocalTime(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.meeting.timeframe"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe1 = new Object[]{this.getTime(this.meeting.getStartTime()).toStringLocalTime(), this.getTime(this.meeting.getStartTime()).toStringLocalShortDate(), this.getTime(this.meeting.getEndTime()).toStringLocalTime(), this.getTime(this.meeting.getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.meeting.crossdays.timeframe"), paramsTimeframe1));
        }
        message.append("<BR>\r\n" + rb.getString("body.meeting.place") + " " + this.meeting.getLocation());
        if (this.meeting.getRecurrenceId() != null) {
            message.append("<BR>\r\n<BR>\r\n<b>Attention:</b>");
            String recurFrqs = this.getRepeatTypeMessage(this.meeting);
            Object[] paramsRecur = new Object[]{recurFrqs, this.getTime(this.meeting.getRepeatUntil()).toStringLocalDate()};
            message.append("<BR>\r\n  - " + MessageFormat.format(rb.getString("body.recurrence.meeting.status"), paramsRecur));
            message.append("<BR>\r\n  " + rb.getString("body.meeting.recurrences.changed.note"));
            message.append("<BR>\r\n  " + rb.getString("body.meeting.recurrences.check.status.note"));
        }
        message.append("<BR>\r\n<BR>\r\n" + this.meeting.getDescription());
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendeeCheck.meetingStatus"), this.getServiceName()));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return StringUtils.defaultIfEmpty((String)this.organizer.getEmail(), (String)this.getServerFromAddress());
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.meeting.modification.field"), this.organizer.getDisplayName(), this.getShortSiteTitleWithQuote(this.emailReturnSiteId), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getTime(this.meeting.getStartTime()).toStringLocalTime(), this.getAbbreviatedMeetingTitle());
    }
}

