/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.component.VEvent;
import org.sakaiproject.signup.logic.SignupCalendarHelper;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.user.api.User;

public abstract class AllUsersEmailBase
extends SignupEmailBase {
    public List<VEvent> generateEvents(User user, SignupCalendarHelper calendarHelper) {
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        if (this.userIsAnOrganiser(user)) {
            VEvent meetingEvent = this.meeting.getVevent();
            if (meetingEvent != null) {
                events.add(meetingEvent);
            }
        } else {
            events.addAll(this.eventsWhichUserIsAttending(user));
        }
        if (this.cancellation) {
            for (VEvent event : events) {
                calendarHelper.cancelVEvent(event);
            }
        }
        return events;
    }

    private List<String> meetingCreatorAndOrganisers() {
        String creatorUserId = this.meeting.getCreatorUserId();
        List coordinatorIds = this.meeting.getCoordinatorIdsList();
        coordinatorIds.add(creatorUserId);
        return coordinatorIds;
    }

    private boolean userIsAnOrganiser(User user) {
        return this.meetingCreatorAndOrganisers().contains(user.getId());
    }
}

