/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.component.VEvent;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupCalendarHelper;
import org.sakaiproject.signup.logic.messages.AttendeeComment;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.user.api.User;

public class AttendeeModifiedCommentEmail
extends SignupEmailBase {
    private final User modifier;
    private final String emailReturnSiteId;
    private AttendeeComment attendeeComment;

    public AttendeeModifiedCommentEmail(User modifier, SignupMeeting meeting, SakaiFacade sakaiFacade, String emailReturnSiteId, AttendeeComment attendeeComment) {
        this.modifier = modifier;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
        this.emailReturnSiteId = emailReturnSiteId;
        this.attendeeComment = attendeeComment;
        this.modifyComment = true;
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.getSakaiFacade().getServerConfigurationService().getString("setup.request", "no-reply@" + this.getSakaiFacade().getServerConfigurationService().getServerName()));
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        Object[] params = new Object[]{this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName(), this.makeFirstCapLetter(this.modifier.getDisplayName()), this.getSakaiFacade().getUserDisplayLastFirstName(this.getSakaiFacade().getCurrentUserId())};
        message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.comment.update"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getTime(this.meeting.getStartTime()).toStringLocalTime(), this.getTime(this.meeting.getEndTime()).toStringLocalTime(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.meeting.timeframe"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe1 = new Object[]{this.getTime(this.meeting.getStartTime()).toStringLocalTime(), this.getTime(this.meeting.getStartTime()).toStringLocalShortDate(), this.getTime(this.meeting.getEndTime()).toStringLocalTime(), this.getTime(this.meeting.getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.meeting.crossdays.timeframe"), paramsTimeframe1));
        }
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.comment"), this.makeFirstCapLetter(this.attendeeComment.getAttendeeComment())));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return this.modifier.getEmail();
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.comment.modification.field"), this.getShortSiteTitleWithQuote(this.emailReturnSiteId), this.modifier.getDisplayName(), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getTime(this.meeting.getStartTime()).toStringLocalTime());
    }

    public List<VEvent> generateEvents(User user, SignupCalendarHelper calendarHelper) {
        return null;
    }
}

