/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.fortuna.ical4j.model.component.VEvent;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupCalendarHelper;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class AutoReminderEmail
extends SignupEmailBase {
    private final User attendee;
    private final SignupTimeslot item;
    private String emailReturnSiteId;
    private SimpleDateFormat dateFormat;

    public AutoReminderEmail(User attendee, SignupTimeslot item, SignupMeeting meeting, String attendeeSiteId, SakaiFacade sakaiFacade) {
        this.attendee = attendee;
        this.item = item;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
        this.emailReturnSiteId = attendeeSiteId;
        this.dateFormat = new SimpleDateFormat("", rb.getLocale());
        this.dateFormat.setTimeZone(sakaiFacade.getTimeService().getLocalTimeZone());
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.attendee.getEmail());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.attendee.getDisplayName())));
        Object[] params = new Object[]{this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.auto.reminder.part"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        message.append("<BR>\r\n" + rb.getString("body.meeting.place") + " " + this.meeting.getLocation());
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.item.getStartTime()).toStringLocalTime(), this.getTime(this.item.getEndTime()).toStringLocalTime(), this.getTime(this.item.getStartTime()).toStringLocalDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.meeting.timeslot"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.item.getStartTime()).toStringLocalTime(), this.getTime(this.item.getStartTime()).toStringLocalShortDate(), this.getTime(this.item.getEndTime()).toStringLocalTime(), this.getTime(this.item.getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.meeting.crossdays.timeslot"), paramsTimeframe));
        }
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.auto.reminder.check.meetingStatus"), this.getServiceName()));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    private String getShortWeekDayName(Date date) {
        this.dateFormat.applyLocalizedPattern("EEE");
        return this.dateFormat.format(date);
    }

    @Override
    public String getFromAddress() {
        return this.getServerFromAddress();
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.auto.reminder.appointment.field"), this.getShortWeekDayName(this.meeting.getStartTime()), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getTime(this.item.getStartTime()).toStringLocalTime(), this.getAbbreviatedMeetingTitle());
    }

    public List<VEvent> generateEvents(User user, SignupCalendarHelper calendarHelper) {
        return new ArrayList<VEvent>();
    }
}

