/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.util.MergedList;

public abstract class MergedListEntryProviderBase
implements MergedList.EntryProvider {
    @Override
    public boolean isUserChannel(Object channel) {
        String context = this.getContext(channel);
        return context == null ? false : SiteService.isUserSite((String)context);
    }

    @Override
    public boolean isSpecialSite(Object channel) {
        String context = this.getContext(channel);
        return context == null ? true : SiteService.isSpecialSite((String)context);
    }

    @Override
    public String getSiteUserId(Object channel) {
        String context = this.getContext(channel);
        return context == null ? "" : SiteService.getSiteUserId((String)context);
    }

    @Override
    public Site getSite(Object channel) {
        try {
            String context = this.getContext(channel);
            return context == null ? null : SiteService.getSite((String)context);
        }
        catch (IdUnusedException e) {
            return null;
        }
    }

    @Override
    public Iterator getIterator() {
        List siteList = SiteService.getSites((SiteService.SelectionType)SiteService.SelectionType.ACCESS, null, null, null, (SiteService.SortType)SiteService.SortType.TITLE_ASC, null);
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (Site curSite : siteList) {
            Object object;
            if (curSite == null || (object = this.makeObjectFromSiteId(curSite.getId())) == null) continue;
            objectList.add(object);
        }
        return objectList.iterator();
    }

    public abstract Object makeObjectFromSiteId(String var1);
}

