/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.util.ParameterParser;

public class MergedList
extends ArrayList {
    private static final String ID_DELIMITER = "_,_";

    public void loadChannelsFromDelimitedString(boolean isOnWorkspaceTab, EntryProvider entryProvider, String userId, String[] channelArray, boolean isSuperUser, String currentSiteId) {
        this.loadChannelsFromDelimitedString(isOnWorkspaceTab, true, entryProvider, userId, channelArray, isSuperUser, currentSiteId);
    }

    public void loadChannelsFromDelimitedString(boolean isOnWorkspaceTab, boolean mergeAllOnWorkspaceTab, EntryProvider entryProvider, String userId, String[] channelArray, boolean isSuperUser, String currentSiteId) {
        this.clear();
        Map currentlyMergedchannels = this.makeChannelMap(channelArray);
        Iterator it = entryProvider.getIterator();
        while (it.hasNext()) {
            Object channel = it.next();
            if (channel == null) continue;
            boolean addThisChannel = false;
            boolean merged = false;
            boolean hidden = false;
            boolean thisIsUserChannel = entryProvider.isUserChannel(channel);
            boolean isSpecialSite = entryProvider.isSpecialSite(channel);
            boolean thisIsTheUsersMyWorkspaceChannel = false;
            if (thisIsUserChannel && userId.equals(entryProvider.getSiteUserId(channel))) {
                thisIsTheUsersMyWorkspaceChannel = true;
            }
            if (thisIsUserChannel && !thisIsTheUsersMyWorkspaceChannel) continue;
            if (entryProvider.allowGet(entryProvider.getReference(channel))) {
                merged = thisIsTheUsersMyWorkspaceChannel ? isOnWorkspaceTab : (isSuperUser && isOnWorkspaceTab ? false : (isOnWorkspaceTab && mergeAllOnWorkspaceTab ? true : currentlyMergedchannels.containsKey(entryProvider.getReference(channel))));
                addThisChannel = true;
                if (thisIsUserChannel || isSpecialSite) {
                    hidden = true;
                }
            }
            if (!addThisChannel) continue;
            Object siteDisplayName = "";
            if (!hidden) {
                String displayNameProperty = entryProvider.getProperties(channel).getProperty(entryProvider.getProperties(channel).getNamePropDisplayName());
                if (displayNameProperty != null && displayNameProperty.length() != 0) {
                    siteDisplayName = displayNameProperty;
                } else {
                    String channelName = "";
                    Site site = entryProvider.getSite(channel);
                    if (site != null) {
                        boolean isCurrentSite = currentSiteId.equals(site.getId());
                        if (isCurrentSite) {
                            hidden = true;
                            merged = true;
                        } else {
                            channelName = site.getTitle();
                            siteDisplayName = channelName + " (" + site.getId() + ") ";
                        }
                    }
                }
            }
            this.add(new MergedChannelEntryImpl(entryProvider.getReference(channel), (String)siteDisplayName, merged, !hidden));
        }
        Collections.sort(this);
    }

    public String[] getAllPermittedChannels(ChannelReferenceMaker refMaker) {
        ArrayList<String> finalList = new ArrayList<String>();
        String[] returnArray = null;
        List siteList = SiteService.getUserSites((boolean)false);
        for (Site site : siteList) {
            finalList.add(refMaker.makeReference(site.getId()));
        }
        returnArray = new String[finalList.size()];
        for (int i = 0; i < finalList.size(); ++i) {
            returnArray[i] = (String)finalList.get(i);
        }
        return returnArray;
    }

    public String[] getChannelReferenceArrayFromDelimitedString(String primarychannelReference, String mergedInitParameterValue) {
        String mergedChannels = null;
        mergedChannels = StringUtils.trimToNull((String)mergedInitParameterValue);
        String[] mergedChannelArray = null;
        mergedChannelArray = mergedChannels != null ? mergedChannels.split(ID_DELIMITER) : new String[]{primarychannelReference};
        return mergedChannelArray;
    }

    private Map makeChannelMap(String[] mergedChannelArray) {
        HashMap<String, Boolean> currentlyMergedchannels = new HashMap<String, Boolean>();
        if (mergedChannelArray != null) {
            for (int i = 0; i < mergedChannelArray.length; ++i) {
                currentlyMergedchannels.put(mergedChannelArray[i], true);
            }
        }
        return currentlyMergedchannels;
    }

    public void loadFromRunData(ParameterParser params) {
        for (MergedEntry entry : this) {
            if (params.getString(entry.getReference()) != null) {
                entry.setMerged(true);
                continue;
            }
            if (!entry.isVisible()) continue;
            entry.setMerged(false);
        }
    }

    public String getDelimitedChannelReferenceString() {
        StringBuilder mergedReferences = new StringBuilder("");
        Iterator it = this.iterator();
        boolean firstEntry = true;
        while (it.hasNext()) {
            MergedEntry entry = (MergedEntry)it.next();
            if (!entry.isMerged()) continue;
            if (!firstEntry) {
                mergedReferences.append(ID_DELIMITER);
            } else {
                firstEntry = false;
            }
            mergedReferences.append(entry.getReference());
        }
        return mergedReferences.toString();
    }

    public List getReferenceList() {
        ArrayList<String> references = new ArrayList<String>();
        for (MergedEntry mergedEntry : this) {
            if (!mergedEntry.isMerged()) continue;
            references.add(mergedEntry.getReference());
        }
        return references;
    }

    private class MergedChannelEntryImpl
    implements MergedEntry {
        private final String channelReference;
        private final String channelFullName;
        private boolean merged;
        private boolean visible;

        public MergedChannelEntryImpl(String channelReference, String channelFullName, boolean merged, boolean visible) {
            this.channelReference = channelReference;
            this.channelFullName = channelFullName;
            this.merged = merged;
            this.visible = visible;
        }

        @Override
        public String getDisplayName() {
            return this.channelFullName;
        }

        @Override
        public String getReference() {
            return this.channelReference;
        }

        @Override
        public boolean isMerged() {
            return this.merged;
        }

        @Override
        public void setMerged(boolean b) {
            this.merged = b;
        }

        @Override
        public int compareTo(Object arg0) {
            MergedChannelEntryImpl compObj = (MergedChannelEntryImpl)arg0;
            return this.getDisplayName().compareTo(compObj.getDisplayName());
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }
    }

    public static interface EntryProvider {
        public Iterator getIterator();

        public boolean allowGet(String var1);

        public String getContext(Object var1);

        public String getReference(Object var1);

        public ResourceProperties getProperties(Object var1);

        public boolean isUserChannel(Object var1);

        public boolean isSpecialSite(Object var1);

        public String getSiteUserId(Object var1);

        public Site getSite(Object var1);
    }

    public static interface MergedEntry
    extends Comparable {
        public String getDisplayName();

        public String getReference();

        public boolean isMerged();

        public void setMerged(boolean var1);

        public boolean isVisible();

        public int compareTo(Object var1);
    }

    public static interface ChannelReferenceMaker {
        public String makeReference(String var1);
    }
}

