/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitemanage.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.sitemanage.api.model.SiteSetupQuestion;
import org.sakaiproject.sitemanage.api.model.SiteSetupQuestionAnswer;
import org.sakaiproject.sitemanage.api.model.SiteSetupQuestionService;
import org.sakaiproject.sitemanage.api.model.SiteSetupUserAnswer;
import org.sakaiproject.sitemanage.api.model.SiteTypeQuestions;
import org.sakaiproject.sitemanage.impl.SiteSetupQuestionAnswerImpl;
import org.sakaiproject.sitemanage.impl.SiteSetupQuestionImpl;
import org.sakaiproject.sitemanage.impl.SiteSetupUserAnswerImpl;
import org.sakaiproject.sitemanage.impl.SiteTypeQuestionsImpl;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class SiteSetupQuestionServiceImpl
extends HibernateDaoSupport
implements SiteSetupQuestionService {
    private static final String QUERY_ANY_SITETYPE_QUESTIONS = "findAnySiteTypeQuestions";
    private static final String QUERY_ALL_QUESTIONS = "findAllSiteSetupQuestions";
    private static final String QUERY_QUESTIONS_BY_SITETYPE = "findQuestionsBySiteType";
    private static final String QUERY_ANSWER_BY_ID = "findAnswerById";
    private static final Log Log = LogFactory.getLog(SiteSetupQuestionServiceImpl.class);

    public void init() {
        Log.info((Object)"init()");
    }

    public void destroy() {
        Log.info((Object)"destroy()");
    }

    public boolean hasAnySiteTypeQuestions() {
        List rvList = this.getHibernateTemplate().findByNamedQuery(QUERY_ANY_SITETYPE_QUESTIONS);
        return rvList != null && !rvList.isEmpty();
    }

    public void removeAllSiteTypeQuestions() {
        List qList = this.getHibernateTemplate().findByNamedQuery(QUERY_ANY_SITETYPE_QUESTIONS);
        if (qList != null && !qList.isEmpty()) {
            for (SiteTypeQuestions q : qList) {
                this.removeSiteTypeQuestions(q);
            }
        }
    }

    public List<SiteSetupQuestion> getAllSiteQuestions() {
        return this.getHibernateTemplate().findByNamedQuery(QUERY_ALL_QUESTIONS);
    }

    public SiteTypeQuestions getSiteTypeQuestions(String siteType) {
        SiteTypeQuestions rv = null;
        List rvList = this.getHibernateTemplate().findByNamedQueryAndNamedParam(QUERY_QUESTIONS_BY_SITETYPE, "siteType", (Object)siteType);
        if (rvList != null && rvList.size() == 1) {
            rv = (SiteTypeQuestions)rvList.get(0);
        }
        return rv;
    }

    public SiteSetupQuestionAnswer getSiteSetupQuestionAnswer(String answerId) {
        List rvList = this.getHibernateTemplate().findByNamedQueryAndNamedParam(QUERY_ANSWER_BY_ID, "id", (Object)answerId);
        if (rvList != null && rvList.size() == 1) {
            return (SiteSetupQuestionAnswer)rvList.get(0);
        }
        return null;
    }

    public SiteSetupQuestion newSiteSetupQuestion() {
        SiteSetupQuestionImpl question = new SiteSetupQuestionImpl();
        return question;
    }

    public boolean saveSiteSetupQuestion(SiteSetupQuestion q) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)q);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            Log.warn((Object)((Object)((Object)this) + ".saveSiteSetupQuestion() Hibernate could not save. question=" + q.getQuestion()));
            return false;
        }
    }

    public boolean removeSiteSetupQuestion(SiteSetupQuestion question) {
        try {
            this.getHibernateTemplate().delete((Object)question);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            if (Log.isErrorEnabled()) {
                Log.error((Object)((Object)((Object)this) + ".removeSiteSetupQuestion() Hibernate could not delete: question=" + question.getQuestion()));
            }
            return false;
        }
    }

    public SiteSetupQuestionAnswer newSiteSetupQuestionAnswer() {
        SiteSetupQuestionAnswerImpl answer = new SiteSetupQuestionAnswerImpl();
        return answer;
    }

    public boolean saveSiteSetupQuestionAnswer(SiteSetupQuestionAnswer answer) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)answer);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            Log.warn((Object)((Object)((Object)this) + ".saveSiteSetupQuestionAnswer() Hibernate could not save. answer=" + answer.getAnswer()));
            return false;
        }
    }

    public boolean removeSiteSetupQuestionAnswer(SiteSetupQuestionAnswer answer) {
        try {
            this.getHibernateTemplate().delete((Object)answer);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            if (Log.isErrorEnabled()) {
                Log.error((Object)((Object)((Object)this) + ".removeSiteSetupQuestionAnswer() Hibernate could not delete: answer=" + answer.getAnswer()));
            }
            return false;
        }
    }

    public SiteTypeQuestions newSiteTypeQuestions() {
        SiteTypeQuestionsImpl questions = new SiteTypeQuestionsImpl();
        return questions;
    }

    public boolean saveSiteTypeQuestions(SiteTypeQuestions siteTypeQuestions) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)siteTypeQuestions);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            Log.warn((Object)((Object)((Object)this) + ".saveSiteTypeQuestions() Hibernate could not save. siteType=" + siteTypeQuestions.getSiteType()));
            return false;
        }
    }

    public boolean removeSiteTypeQuestions(SiteTypeQuestions siteTypeQuestions) {
        try {
            this.getHibernateTemplate().delete((Object)siteTypeQuestions);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            if (Log.isErrorEnabled()) {
                Log.error((Object)((Object)((Object)this) + ".removeSiteTypeQuestions() Hibernate could not delete: siteType=" + siteTypeQuestions.getSiteType()));
            }
            return false;
        }
    }

    public SiteSetupUserAnswer newSiteSetupUserAnswer() {
        SiteSetupUserAnswerImpl uAnswer = new SiteSetupUserAnswerImpl();
        return uAnswer;
    }

    public boolean saveSiteSetupUserAnswer(SiteSetupUserAnswer siteSetupUserAnswer) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)siteSetupUserAnswer);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            Log.warn((Object)((Object)((Object)this) + ".saveSiteSetupUserAnswer() Hibernate could not save. Site=" + siteSetupUserAnswer.getSiteId() + " user=" + siteSetupUserAnswer.getUserId() + " question=" + siteSetupUserAnswer.getQuestionId()));
            return false;
        }
    }

    public boolean removeSiteSetupUserAnswer(SiteSetupUserAnswer siteSetupUserAnswer) {
        try {
            this.getHibernateTemplate().delete((Object)siteSetupUserAnswer);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            if (Log.isErrorEnabled()) {
                Log.error((Object)((Object)((Object)this) + ".deleteSiteSetupUserAnswer() Hibernate could not delete: Site=" + siteSetupUserAnswer.getSiteId() + " user=" + siteSetupUserAnswer.getUserId() + " question=" + siteSetupUserAnswer.getQuestionId()));
            }
            return false;
        }
    }
}

