/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitemanage.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.sitemanage.api.UserNotificationProvider;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;

public class UserNotificationProviderImpl
implements UserNotificationProvider {
    private static Log M_log = LogFactory.getLog(UserNotificationProviderImpl.class);
    private EmailService emailService;
    private ServerConfigurationService serverConfigurationService;
    private UserDirectoryService userDirectoryService;
    private DeveloperHelperService developerHelperService;

    public void setEmailService(EmailService es) {
        this.emailService = es;
    }

    public void setServerConfigurationService(ServerConfigurationService scs) {
        this.serverConfigurationService = scs;
    }

    public void setUserDirectoryService(UserDirectoryService uds) {
        this.userDirectoryService = uds;
    }

    public void setDeveloperHelperService(DeveloperHelperService dhs) {
        this.developerHelperService = dhs;
    }

    public void init() {
        M_log.info((Object)"init()");
    }

    public void notifyAddedParticipant(boolean newNonOfficialAccount, User user, Site site) {
        String from;
        ResourceLoader rb = new ResourceLoader(user.getId(), "UserNotificationProvider");
        String string = from = this.serverConfigurationService.getBoolean("sitemanage.notifyFromCurrentUser", false) ? this.getCurrentUserEmailAddress() : this.getSetupRequestEmailAddress();
        if (from != null) {
            String emailId;
            String productionSiteName = this.serverConfigurationService.getString("ui.service", "");
            String productionSiteUrl = this.serverConfigurationService.getPortalUrl();
            String nonOfficialAccountUrl = this.serverConfigurationService.getString("nonOfficialAccount.url", null);
            String to = emailId = user.getEmail();
            String headerTo = emailId;
            String replyTo = from;
            String message_subject = productionSiteName + " " + rb.getString("java.sitenoti");
            String content = "";
            StringBuilder buf = new StringBuilder();
            buf.setLength(0);
            buf.append(user.getDisplayName() + ":\n\n");
            buf.append(rb.getString("java.following") + " " + productionSiteName + " " + rb.getString("java.simplesite") + "\n");
            buf.append(site.getTitle() + "\n");
            buf.append(rb.getString("java.simpleby") + " ");
            buf.append(this.userDirectoryService.getCurrentUser().getDisplayName() + ". \n\n");
            if (newNonOfficialAccount) {
                buf.append(this.serverConfigurationService.getString("nonOfficialAccountInstru", "") + "\n");
                if (nonOfficialAccountUrl != null) {
                    buf.append(rb.getString("java.togeta1") + "\n" + nonOfficialAccountUrl + "\n");
                    buf.append(rb.getString("java.togeta2") + "\n\n");
                }
                buf.append(rb.getString("java.once") + " " + productionSiteName + ": \n");
                buf.append(rb.getString("java.loginhow1") + " " + productionSiteName + ": " + productionSiteUrl + "\n");
                buf.append(rb.getString("java.loginhow2") + "\n");
                buf.append(rb.getString("java.loginhow3") + "\n");
            } else {
                buf.append(rb.getString("java.tolog") + "\n");
                buf.append(rb.getString("java.loginhow1") + " " + productionSiteName + ": " + productionSiteUrl + "\n");
                buf.append(rb.getString("java.loginhow2") + "\n");
                buf.append(rb.getString("java.loginhow3u") + "\n");
            }
            buf.append(rb.getString("java.tabscreen"));
            content = buf.toString();
            this.emailService.send(from, to, message_subject, content, headerTo, replyTo, null);
        }
    }

    public void notifyNewUserEmail(User user, String newUserPassword, Site site) {
        String newUserEmail;
        ResourceLoader rb = new ResourceLoader("UserNotificationProvider");
        rb.setContextLocale(rb.getLocale(user.getId()));
        String from = this.getSetupRequestEmailAddress();
        String productionSiteName = this.serverConfigurationService.getString("ui.service", "");
        String productionSiteUrl = this.serverConfigurationService.getPortalUrl();
        String to = newUserEmail = user.getEmail();
        String headerTo = newUserEmail;
        String replyTo = from;
        String message_subject = productionSiteName + " " + rb.getString("java.newusernoti");
        String content = "";
        if (from != null && newUserEmail != null) {
            StringBuilder buf = new StringBuilder();
            buf.setLength(0);
            buf.append(user.getDisplayName() + ":\n\n");
            buf.append(rb.getString("java.addedto") + " " + productionSiteName + " (" + productionSiteUrl + ") ");
            buf.append(rb.getString("java.simpleby") + " ");
            buf.append(this.userDirectoryService.getCurrentUser().getDisplayName() + ". \n\n");
            buf.append(rb.getString("java.passwordis1") + "\n" + newUserPassword + "\n\n");
            buf.append(rb.getString("java.passwordis2") + "\n\n");
            content = buf.toString();
            this.emailService.send(from, to, message_subject, content, headerTo, replyTo, null);
        }
    }

    public void notifyTemplateUse(Site templateSite, User currentUser, Site site) {
        String templateEmailArchive;
        String from = this.getSetupRequestEmailAddress();
        String to = templateEmailArchive = templateSite.getId() + "@" + this.serverConfigurationService.getServerName();
        String headerTo = templateEmailArchive;
        String replyTo = templateEmailArchive;
        String message_subject = templateSite.getId() + ": copied by " + currentUser.getDisplayId();
        if (from != null && templateEmailArchive != null) {
            StringBuffer buf = new StringBuffer();
            buf.setLength(0);
            buf.append("Dear template maintainer,\n\n");
            buf.append("Congratulations!\n\n");
            buf.append("The following user just created a new site based on your template.\n\n");
            buf.append("Template name: " + templateSite.getTitle() + "\n");
            buf.append("User         : " + currentUser.getDisplayName() + " (" + currentUser.getDisplayId() + ")\n");
            buf.append("Date         : " + new Date() + "\n");
            buf.append("New site Id  : " + site.getId() + "\n");
            buf.append("New site name: " + site.getTitle() + "\n\n");
            buf.append("Cheers,\n");
            buf.append("Alliance Team\n");
            String content = buf.toString();
            this.emailService.send(from, to, message_subject, content, headerTo, replyTo, null);
        }
    }

    public void notifySiteCreation(Site site, List notifySites, boolean courseSite, String termTitle, String requestEmail) {
        String id = site.getId();
        String title = site.getTitle();
        SimpleDateFormat dform = (SimpleDateFormat)DateFormat.getDateInstance();
        dform.applyPattern("yyyy-MM-dd HH:mm:ss");
        String dateDisplay = dform.format(new Date());
        User currentUser = this.userDirectoryService.getCurrentUser();
        String currentUserName = currentUser.getDisplayName();
        String currentUserId = currentUser.getId();
        String currentUserEmail = currentUser.getEmail();
        ResourceLoader rb = new ResourceLoader("UserNotificationProvider");
        String message_subject = courseSite ? rb.getString("java.official") + " " + currentUserName + " " + rb.getString("java.for") + " " + termTitle : rb.getString("java.site.createdBy") + " " + currentUserName;
        String from = currentUser.getEmail();
        String to = requestEmail;
        String headerTo = requestEmail;
        String replyTo = currentUserEmail;
        StringBuilder buf = new StringBuilder();
        buf.append("\n" + rb.getString("java.fromwork") + " " + this.serverConfigurationService.getServerName() + " " + rb.getString("java.supp") + ":\n\n");
        buf.append(courseSite ? rb.getString("java.off") : rb.getString("java.site"));
        buf.append(" '" + title + "' (id " + id + "), " + rb.getString("java.wasset") + " ");
        buf.append(currentUserName + " (" + currentUserId + ", " + rb.getString("java.email2") + " " + replyTo + ") ");
        buf.append(rb.getString("java.on") + " " + dateDisplay);
        if (courseSite) {
            buf.append(rb.getString("java.for") + " " + termTitle + ", ");
        }
        if (notifySites != null) {
            int nbr_sections = notifySites.size();
            if (nbr_sections > 1) {
                buf.append(rb.getString("java.withrost") + " " + Integer.toString(nbr_sections) + " " + rb.getString("java.sections") + "\n\n");
            } else {
                buf.append(" " + rb.getString("java.withrost2") + "\n\n");
            }
            for (int i = 0; i < nbr_sections; ++i) {
                String course = (String)notifySites.get(i);
                buf.append(rb.getString("java.course2") + " " + course + "\n");
            }
        }
        this.emailService.send(from, to, message_subject, buf.toString(), headerTo, replyTo, null);
        from = requestEmail;
        to = currentUserEmail;
        headerTo = currentUserEmail;
        replyTo = this.serverConfigurationService.getString("setup.request", "no-reply@" + this.serverConfigurationService.getServerName());
        String content = rb.getFormattedMessage("java.siteCreation.confirmation", new Object[]{title, this.serverConfigurationService.getServerName()});
        content = content + "\n\n" + buf.toString();
        this.emailService.send(from, to, message_subject, content, headerTo, replyTo, null);
    }

    public boolean notifyCourseRequestAuthorizer(String instructorId, String requestEmail, String replyToEmail, String termTitle, String requestSectionInfo, String siteTitle, String siteId, String additionalInfo, String serverName) {
        try {
            User instructor = this.userDirectoryService.getUserByEid(instructorId);
            ResourceLoader rb = new ResourceLoader(instructorId, "UserNotificationProvider");
            StringBuffer buf = new StringBuffer();
            String to = instructor.getEmail();
            String from = requestEmail;
            String headerTo = to;
            String replyTo = replyToEmail;
            User currentUser = this.userDirectoryService.getCurrentUser();
            String currentUserDisplayName = currentUser != null ? currentUser.getDisplayName() : "";
            String message_subject = rb.getString("java.sitereqfrom") + " " + currentUserDisplayName + " " + rb.getString("java.for") + " " + termTitle;
            buf.append(rb.getString("java.hello") + " \n\n");
            buf.append(rb.getString("java.receiv") + " " + currentUserDisplayName + ", ");
            buf.append(rb.getString("java.who") + "\n");
            if (!termTitle.isEmpty()) {
                buf.append(termTitle + "\n");
            }
            buf.append(requestSectionInfo);
            buf.append(rb.getString("java.sitetitle") + "\t" + siteTitle + "\n");
            buf.append(rb.getString("java.siteid") + "\t" + siteId + "\n\n");
            buf.append(rb.getString("java.siteinstr") + "\n" + additionalInfo + "\n\n");
            buf.append(rb.getString("java.according") + " " + currentUserDisplayName + " " + rb.getString("java.record"));
            buf.append(" " + rb.getString("java.canyou") + " " + currentUserDisplayName + " " + rb.getString("java.assoc") + "\n\n");
            buf.append(rb.getString("java.respond") + " " + currentUserDisplayName + rb.getString("java.appoint") + "\n\n");
            buf.append(rb.getString("java.thanks") + "\n");
            buf.append(serverName + " " + rb.getString("java.support"));
            try {
                this.emailService.send(from, to, message_subject, buf.toString(), headerTo, replyTo, null);
                return true;
            }
            catch (Exception ee) {
                M_log.warn((Object)(this + " problem occurs with sending course request email to authorizer " + instructorId));
                return false;
            }
        }
        catch (Exception e) {
            M_log.warn((Object)(this + " cannot find user " + instructorId));
            return false;
        }
    }

    public String notifyCourseRequestSupport(String requestEmail, String serverName, String request, String termTitle, int requestListSize, String requestSectionInfo, String officialAccountName, String siteTitle, String siteId, String additionalInfo, boolean requireAuthorizer, String authorizerNotified, String authorizerNotNotified) {
        String currentUserEmail;
        ResourceLoader rb = new ResourceLoader("UserNotificationProvider");
        User currentUser = this.userDirectoryService.getCurrentUser();
        String currentUserDisplayName = currentUser != null ? currentUser.getDisplayName() : "";
        String currentUserDisplayId = currentUser != null ? currentUser.getDisplayId() : "";
        String from = currentUserEmail = currentUser != null ? currentUser.getEmail() : "";
        String to = requestEmail;
        String headerTo = requestEmail;
        String replyTo = currentUserEmail;
        StringBuffer buf = new StringBuffer();
        buf.append(rb.getString("java.to") + "\t\t" + serverName + " " + rb.getString("java.supp") + "\n");
        buf.append("\n" + rb.getString("java.from") + "\t" + currentUserDisplayName + "\n");
        if ("new".equals(request)) {
            buf.append(rb.getString("java.subj") + "\t" + rb.getString("java.sitereq") + "\n");
        } else {
            buf.append(rb.getString("java.subj") + "\t" + rb.getString("java.sitechreq") + "\n");
        }
        SimpleDateFormat dform = (SimpleDateFormat)DateFormat.getDateInstance();
        dform.applyPattern("yyyy-MM-dd HH:mm:ss");
        String dateDisplay = dform.format(new Date());
        buf.append(rb.getString("java.date") + "\t" + dateDisplay + "\n\n");
        if ("new".equals(request)) {
            buf.append(rb.getString("java.approval") + " " + serverName + " " + rb.getString("java.coursesite") + " ");
        } else {
            buf.append(rb.getString("java.approval2") + " " + serverName + " " + rb.getString("java.coursesite") + " ");
        }
        if (!termTitle.isEmpty()) {
            buf.append(termTitle);
        }
        if (requestListSize > 1) {
            buf.append(" " + rb.getString("java.forthese") + " " + requestListSize + " " + rb.getString("java.sections") + "\n\n");
        } else {
            buf.append(" " + rb.getString("java.forthis") + "\n\n");
        }
        buf.append(requestSectionInfo);
        buf.append(rb.getString("java.name") + "\t" + currentUserDisplayName + " (" + officialAccountName + " " + currentUserDisplayId + ")\n");
        buf.append(rb.getString("java.email") + "\t" + replyTo + "\n");
        buf.append(rb.getString("java.sitetitle") + "\t" + siteTitle + "\n");
        buf.append(rb.getString("java.siteid") + "\t" + siteId + "\n\n");
        buf.append(rb.getString("java.siteinstr") + "\n" + additionalInfo + "\n\n");
        if (requireAuthorizer) {
            if (!authorizerNotified.isEmpty()) {
                buf.append(rb.getString("java.authoriz") + " " + authorizerNotified + " " + rb.getString("java.asreq"));
            }
            if (!authorizerNotNotified.isEmpty()) {
                buf.append(rb.getString("java.thesiteemail") + " " + authorizerNotNotified + " " + rb.getString("java.asreq"));
            }
        }
        String content = buf.toString();
        String message_subject = rb.getString("java.sitereqfrom") + " " + currentUserDisplayName + " " + rb.getString("java.for") + " " + termTitle;
        try {
            this.emailService.send(from, to, message_subject, content, headerTo, replyTo, null);
            return content;
        }
        catch (Exception e) {
            M_log.warn((Object)(this + " problem in send site request email to support for " + currentUserDisplayName));
            return "";
        }
    }

    public void notifyCourseRequestRequester(String requestEmail, String supportEmailContent, String termTitle) {
        String to;
        User currentUser = this.userDirectoryService.getCurrentUser();
        String currentUserDisplayName = currentUser != null ? currentUser.getDisplayName() : "";
        String currentUserDisplayId = currentUser != null ? currentUser.getDisplayId() : "";
        String currentUserId = currentUser != null ? currentUser.getId() : "";
        String currentUserEmail = currentUser != null ? currentUser.getEmail() : "";
        ResourceLoader rb = new ResourceLoader(currentUserId, "UserNotificationProvider");
        String from = requestEmail;
        String headerTo = to = currentUserEmail;
        String replyTo = to;
        String message_subject = rb.getString("java.sitereqfrom") + " " + currentUserDisplayName + " " + rb.getString("java.for") + " " + termTitle;
        StringBuffer buf = new StringBuffer();
        buf.append(rb.getString("java.isbeing") + " ");
        buf.append(rb.getString("java.meantime") + "\n\n");
        buf.append(rb.getString("java.copy") + "\n\n");
        buf.append(supportEmailContent);
        buf.append("\n" + rb.getString("java.wish") + " " + requestEmail);
        this.emailService.send(from, to, message_subject, buf.toString(), headerTo, replyTo, null);
    }

    private String getCurrentUserEmailAddress() {
        String email;
        User currentUser = this.userDirectoryService.getCurrentUser();
        String string = email = currentUser != null ? currentUser.getEmail() : null;
        if (email == null || email.length() == 0) {
            email = this.getSetupRequestEmailAddress();
        }
        return email;
    }

    private String getSetupRequestEmailAddress() {
        String from = this.serverConfigurationService.getString("setup.request", null);
        if (from == null) {
            from = "postmaster@".concat(this.serverConfigurationService.getServerName());
            M_log.warn((Object)(this + " - no 'setup.request' in configuration, using: " + from));
        }
        return from;
    }

    public void notifySiteImportCompleted(String toEmail, String siteId, String siteTitle) {
        if (toEmail != null && !"".equals(toEmail)) {
            String headerTo = toEmail;
            String replyTo = toEmail;
            String link = this.developerHelperService.getLocationReferenceURL("/site/" + siteId);
            ResourceLoader rb = new ResourceLoader("UserNotificationProvider");
            String message_subject = rb.getFormattedMessage("java.siteImport.confirmation.subject", new Object[]{siteTitle});
            String message_body = rb.getFormattedMessage("java.siteImport.confirmation", new Object[]{siteTitle, link});
            this.emailService.send(this.getSetupRequestEmailAddress(), toEmail, message_subject, message_body, headerTo, replyTo, null);
        }
    }
}

