/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitemanage.impl.job;

import com.github.javafaker.Faker;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserAlreadyDefinedException;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserIdInvalidException;
import org.sakaiproject.user.api.UserPermissionException;

public class SeedSitesAndUsersJob
implements Job {
    private static final Log log = LogFactory.getLog(SeedSitesAndUsersJob.class);
    private ServerConfigurationService serverConfigurationService;
    private UserDirectoryService userDirectoryService;
    private SiteService siteService;
    private SecurityAdvisor securityAdvisor;
    private SecurityService securityService;
    private SessionManager sessionManager;
    private ContentHostingService contentHostingService;
    private SqlService sqlService;
    private int numberOfSites = 5;
    private int numberOfStudents = 100;
    private int numberOfEnnrollmentsPerSite = 50;
    private int numberOfInstructorsPerSite = 1;
    private long repositorySize = 0x40000000L;
    private Faker faker = new Faker();
    private Random randomGenerator = new Random();
    private Map<String, User> students;
    private Map<String, User> instructors;
    private Map<String, Site> sites;

    public void init() {
        this.numberOfSites = this.serverConfigurationService.getInt("site.seed.create.sites", 5);
        this.numberOfStudents = this.serverConfigurationService.getInt("site.seed.create.students", 100);
        this.numberOfEnnrollmentsPerSite = this.serverConfigurationService.getInt("site.seed.enrollments.per.site", 50);
        this.numberOfInstructorsPerSite = this.serverConfigurationService.getInt("site.seed.instructors.per.site", 1);
        try {
            this.repositorySize = Long.parseLong(this.serverConfigurationService.getString("site.seed.repository.size", "10485760"));
        }
        catch (NumberFormatException nfe) {
            this.repositorySize = 0x40000000L;
        }
        this.securityAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
    }

    private void seedData() {
        byte[] rawFile;
        for (long totalBytes = 0L; totalBytes < this.repositorySize; totalBytes += (long)rawFile.length) {
            log.info((Object)("seedData, current repository size: " + totalBytes));
            Site site = this.getRandomSite();
            String collectionName = this.getCollectionName(site);
            ContentCollection collection = null;
            try {
                collection = this.contentHostingService.getCollection(collectionName);
            }
            catch (IdUnusedException e) {
                collection = this.createCollection(collectionName);
                this.contentHostingService.commitCollection((ContentCollectionEdit)collection);
            }
            catch (TypeException te) {
                log.error((Object)"seedData, wrong collection type: ", (Throwable)te);
            }
            catch (PermissionException pe) {
                log.error((Object)"seedData, collection permission: ", (Throwable)pe);
            }
            if (collection != null) {
                rawFile = StringUtils.join((Collection)this.faker.lorem().paragraphs(this.randomGenerator.nextInt(500)), (String)"\n\n").getBytes();
                String fileName = StringUtils.join((Collection)this.faker.lorem().words(4), (String)"-") + "_" + String.valueOf(this.randomGenerator.nextInt(5000));
                try {
                    ContentResourceEdit resourceEdit = this.contentHostingService.addResource(collectionName + fileName + ".txt");
                    ResourcePropertiesEdit props = resourceEdit.getPropertiesEdit();
                    props.addProperty("DAV:displayname", fileName);
                    props.addProperty("CHEF:description", "created for testing");
                    props.addProperty("SAKAI:pubview", "false");
                    resourceEdit.setContent(rawFile);
                    resourceEdit.setContentType("text/plain");
                    this.contentHostingService.commitResource(resourceEdit, 0);
                }
                catch (Exception e) {
                    log.error((Object)("seedData, cannot add resource: " + collectionName + fileName + ".txt"), (Throwable)e);
                }
                continue;
            }
            log.error((Object)("seedData, could not get collection: " + collectionName));
            break;
        }
    }

    private long getSizeOfResources() {
        StringBuffer sb = new StringBuffer();
        for (Site site : this.sites.values()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(site.getId()).append("'");
        }
        return (Long)new SizeOfResourcesQuery(sb.toString()).run().returnResult();
    }

    private Site getRandomSite() {
        String[] siteIds = this.sites.keySet().toArray(new String[0]);
        String siteId = siteIds[this.randomGenerator.nextInt(siteIds.length - 1)];
        return this.sites.get(siteId);
    }

    private ContentCollectionEdit createCollection(String collectionName) {
        ContentCollectionEdit collectionEdit = null;
        try {
            collectionEdit = this.contentHostingService.addCollection(collectionName);
            collectionEdit.getPropertiesEdit().addProperty("DAV:displayname", "searchdata");
        }
        catch (IdUsedException iue) {
            log.error((Object)"createCollection, existing collection: ", (Throwable)iue);
        }
        catch (IdInvalidException iie) {
            log.error((Object)"createCollection, invalid collection id: ", (Throwable)iie);
        }
        catch (PermissionException pe) {
            log.error((Object)"createCollection, collection permission: ", (Throwable)pe);
        }
        catch (InconsistentException ie) {
            log.error((Object)"createCollection, collection inconsistent: ", (Throwable)ie);
        }
        return collectionEdit;
    }

    private String getCollectionName(Site site) {
        return "/group/" + site.getId() + "/searchdata/";
    }

    private void createSites() throws PermissionException, IdInvalidException, IdUsedException, IdUnusedException {
        for (long i = 0L; i < (long)this.numberOfSites; ++i) {
            try {
                this.createSite(this.faker.bothify("????_###?_####").toUpperCase(), "course");
                continue;
            }
            catch (IdUsedException e) {
                this.createSite(this.faker.bothify("????_###?_####").toUpperCase(), "course");
            }
        }
    }

    private void createSite(String title, String type) throws IdInvalidException, IdUsedException, PermissionException, IdUnusedException {
        Site site = this.siteService.addSite(title, type);
        site.setPublished(true);
        site.setTitle(title);
        site.addPage().addTool("sakai.search");
        site.addPage().addTool("sakai.resources");
        site.addPage().addTool("sakai.siteinfo");
        this.siteService.save(site);
        this.sites.put(site.getId(), site);
        log.info((Object)("createSite, created site: " + site.getId()));
    }

    private void createStudents() {
        for (long i = 0L; i < (long)this.numberOfStudents; ++i) {
            User user = this.createUser("registered");
            if (user == null) continue;
            this.students.put(user.getEid(), user);
        }
    }

    private void createInstructors() {
        for (long i = 0L; i < (long)this.numberOfInstructorsPerSite; ++i) {
            User user = this.createUser("maintain");
            if (user == null) continue;
            this.instructors.put(user.getEid(), user);
        }
    }

    private User createUser(String userType) {
        User user = null;
        String lastName = this.faker.name().lastName();
        String eid = this.faker.numerify("#########");
        try {
            user = this.userDirectoryService.addUser(null, eid, this.faker.name().firstName(), lastName, eid + "@nowhere.com", this.faker.letterify("???????"), userType, null);
        }
        catch (UserIdInvalidException uiue) {
            log.error((Object)"createUsers, invalid userId: ", (Throwable)uiue);
        }
        catch (UserAlreadyDefinedException uade) {
            log.error((Object)"createUsers, already exists: ", (Throwable)uade);
            user = this.createUser(userType);
        }
        catch (UserPermissionException upe) {
            log.error((Object)"createUsers, permission: ", (Throwable)upe);
        }
        return user;
    }

    private void createEnrollments() {
        String[] studentsArray = this.students.keySet().toArray(new String[0]);
        for (String siteId : this.sites.keySet()) {
            Site site = this.sites.get(siteId);
            HashSet<String> usersInSite = new HashSet<String>(this.numberOfEnnrollmentsPerSite + this.numberOfInstructorsPerSite);
            for (int i = 0; i < this.numberOfEnnrollmentsPerSite; ++i) {
                String studentEid = this.getUnAddedUser(usersInSite, studentsArray);
                User user = this.students.get(studentEid);
                site.addMember(user.getId(), "Student", true, false);
                usersInSite.add(studentEid);
            }
            for (User instructor : this.instructors.values()) {
                site.addMember(instructor.getId(), "Instructor", true, false);
            }
            try {
                this.siteService.save(site);
            }
            catch (IdUnusedException iue) {
                log.error((Object)"createEnrollments, site doesn't exist:", (Throwable)iue);
            }
            catch (PermissionException pe) {
                log.error((Object)"createEnrollments, site save permission:", (Throwable)pe);
            }
        }
    }

    private String getUnAddedUser(Set<String> usersInSite, String[] userArray) {
        String userId;
        while (usersInSite.contains(userId = userArray[this.randomGenerator.nextInt(userArray.length - 1)])) {
        }
        return userId;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info((Object)"SeedSitesAndUsersJob started.");
        this.students = new HashMap<String, User>();
        this.instructors = new HashMap<String, User>();
        this.sites = new HashMap<String, Site>();
        Session session = this.sessionManager.getCurrentSession();
        String currentUser = session.getUserId();
        session.setUserId("admin");
        session.setUserEid("admin");
        this.securityService.pushAdvisor(this.securityAdvisor);
        try {
            this.createSites();
            this.createInstructors();
            this.createStudents();
            this.createEnrollments();
            this.seedData();
        }
        catch (Exception e) {
            log.error((Object)"execute, executing Job: ", (Throwable)e);
        }
        this.securityService.popAdvisor(this.securityAdvisor);
        session.setUserId(currentUser);
        session.setUserEid(currentUser);
        this.students = null;
        this.instructors = null;
        this.sites = null;
        log.info((Object)"SeedSitesAndUsersJob completed.");
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSecurityAdvisor(SecurityAdvisor securityAdvisor) {
        this.securityAdvisor = securityAdvisor;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    class CountUsersQuery
    extends Query<Long> {
        Long count;

        public CountUsersQuery(String sql) {
            super("select COUNT(USER_ID) FROM sakai_user WHERE TYPE IN (" + sql + ")");
        }

        @Override
        void processResult() throws SQLException {
            if (this.result.next()) {
                this.count = this.result.getLong(1);
            }
        }

        @Override
        Long returnResult() {
            return this.count;
        }
    }

    class CountSitesQuery
    extends Query<Long> {
        Long size;

        public CountSitesQuery(String sql) {
            super("SELECT SUM(cr.FILE_SIZE) FROM content_resource cr JOIN sakai_site ss on (cr.CONTEXT = ss.SITE_ID) where ss.TYPE IN (" + sql + ")");
        }

        @Override
        void processResult() throws SQLException {
            if (this.result.next()) {
                this.size = this.result.getLong(1);
            }
        }

        @Override
        Long returnResult() {
            return this.size;
        }
    }

    class SizeOfResourcesQuery
    extends Query<Long> {
        Long size;

        public SizeOfResourcesQuery(String sql) {
            super("SELECT SUM(cr.FILE_SIZE) FROM content_resource cr JOIN sakai_site ss on (cr.CONTEXT = ss.SITE_ID) where ss.SITE_ID IN (" + sql + ")");
        }

        @Override
        void processResult() throws SQLException {
            if (this.result.next()) {
                this.size = this.result.getLong(1);
            }
        }

        @Override
        Long returnResult() {
            return this.size;
        }
    }

    class RandomSiteQuery
    extends Query<Site> {
        Site site;

        public RandomSiteQuery(String sql) {
            super("SELECT SITE_ID FROM sakai_site where TYPE = '" + sql + "' ORDER BY RAND() LIMIT 1");
        }

        @Override
        public void processResult() throws SQLException {
            while (this.result.next()) {
                String siteId = this.result.getString(1);
                try {
                    this.site = SeedSitesAndUsersJob.this.siteService.getSite(siteId);
                }
                catch (IdUnusedException e) {
                    log.warn((Object)"RandomSiteQuery.processResult, No sites found", (Throwable)e);
                }
            }
        }

        @Override
        Site returnResult() {
            return this.site;
        }
    }

    abstract class Query<T> {
        Connection connection;
        PreparedStatement statement;
        ResultSet result;
        String sql;

        public Query(String sql) {
            this.sql = sql;
        }

        Query<T> run() {
            try {
                this.connection = SeedSitesAndUsersJob.this.sqlService.borrowConnection();
                this.statement = this.connection.prepareStatement(this.sql);
                this.result = this.statement.executeQuery();
                this.processResult();
            }
            catch (Exception e) {
                log.error((Object)"Query.run, running query: ", (Throwable)e);
            }
            finally {
                if (this.result != null) {
                    try {
                        this.result.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Query.run, releasing result: ", (Throwable)e);
                    }
                }
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Query.run, closing statement: ", (Throwable)e);
                    }
                }
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Query.run, closing connection: ", (Throwable)e);
                    }
                }
            }
            return this;
        }

        abstract void processResult() throws SQLException;

        abstract T returnResult();
    }
}

