/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitemanage.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.emailtemplateservice.model.RenderedTemplate;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.sitemanage.api.UserNotificationProvider;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETSUserNotificationProviderImpl
implements UserNotificationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ETSUserNotificationProviderImpl.class);
    private static final String NOTIFY_ADDED_PARTICIPANT = "sitemange.notifyAddedParticipant";
    private static final String NOTIFY_NEW_USER = "sitemanage.notifyNewUserEmail";
    private static final String NOTIFY_TEMPLATE_USE = "sitemanage.notifyTemplateUse";
    private static final String NOTITY_COURSE_REQUEST_AUTHORIZER = "sitemanage.notifyCourseRequestAuthorizer";
    private static final String NOTIFY_COURSE_REQUEST_REQUESTER = "sitemanage.notifyCourseRequestRequester";
    private static final String NOTIFY_COURSE_REQUEST_SUPPORT = "sitemanage.notifyCourseRequestSupport";
    private static final String NOTIFY_SITE_CREATION = "sitemanage.notifySiteCreation";
    private static final String NOTIFY_SITE_CREATION_CONFIRMATION = "sitemanage.notifySiteCreation.confirmation";
    private static final String SITE_IMPORT_EMAIL_TEMPLATE_FILE_NAME = "notifySiteImportConfirmation.xml";
    private static final String SITE_IMPORT_EMAIL_TEMPLATE_KEY = "sitemanage.siteImport.Confirmation";
    private static final String SITE_IMPORT_EMAIL_TEMPLATE_VAR_WORKSITE = "worksiteName";
    private static final String SITE_IMPORT_EMAIL_TEMPLATE_VAR_LINK = "linkToWorksite";
    private static final String SITE_IMPORT_EMAIL_TEMPLATE_VAR_INSTITUTION = "institution";
    private static final String SAK_PROP_UI_INSTITUTION = "ui.institution";
    private EmailService emailService;
    private ServerConfigurationService serverConfigurationService;
    private UserDirectoryService userDirectoryService;
    private EmailTemplateService emailTemplateService;
    private DeveloperHelperService developerHelperService;

    public void setEmailService(EmailService es) {
        this.emailService = es;
    }

    public void setServerConfigurationService(ServerConfigurationService scs) {
        this.serverConfigurationService = scs;
    }

    public void setUserDirectoryService(UserDirectoryService uds) {
        this.userDirectoryService = uds;
    }

    public void setEmailTemplateService(EmailTemplateService ets) {
        this.emailTemplateService = ets;
    }

    public void setDeveloperHelperService(DeveloperHelperService dhs) {
        this.developerHelperService = dhs;
    }

    public void init() {
        LOG.info("init()");
        ClassLoader loader = ETSUserNotificationProviderImpl.class.getClassLoader();
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream("notifyAddedParticipants.xml"), NOTIFY_ADDED_PARTICIPANT);
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream("notifyNewuser.xml"), NOTIFY_NEW_USER);
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream("notifyTemplateUse.xml"), NOTIFY_TEMPLATE_USE);
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream("notifyCourseRequestAuthorizer.xml"), NOTITY_COURSE_REQUEST_AUTHORIZER);
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream("notifyCourseRequestRequester.xml"), NOTIFY_COURSE_REQUEST_REQUESTER);
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream("notifyCourseRequestSupport.xml"), NOTIFY_COURSE_REQUEST_SUPPORT);
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream("notifySiteCreation.xml"), NOTIFY_SITE_CREATION);
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream("notifySiteCreationConfirmation.xml"), NOTIFY_SITE_CREATION_CONFIRMATION);
        this.emailTemplateService.importTemplateFromXmlFile(loader.getResourceAsStream(SITE_IMPORT_EMAIL_TEMPLATE_FILE_NAME), SITE_IMPORT_EMAIL_TEMPLATE_KEY);
    }

    public void notifyAddedParticipant(boolean newNonOfficialAccount, User user, Site site) {
        String from;
        String string = from = this.serverConfigurationService.getBoolean("sitemanage.notifyFromCurrentUser", false) ? this.getCurrentUserEmailAddress() : this.getSetupRequestEmailAddress();
        if (from != null) {
            String emailId;
            String productionSiteName = this.serverConfigurationService.getString("ui.service", "");
            String to = emailId = user.getEmail();
            String headerTo = emailId;
            String replyTo = from;
            HashMap<String, String> rv = new HashMap<String, String>();
            rv.put("productionSiteName", productionSiteName);
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put("userName", user.getDisplayName());
            replacementValues.put("userEid", user.getEid());
            replacementValues.put("localSakaiName", productionSiteName);
            replacementValues.put("currentUserName", this.userDirectoryService.getCurrentUser().getDisplayName());
            replacementValues.put("localSakaiUrl", this.serverConfigurationService.getPortalUrl());
            String nonOfficialAccountUrl = this.serverConfigurationService.getString("nonOfficialAccount.url", null);
            replacementValues.put("hasNonOfficialAccountUrl", nonOfficialAccountUrl != null ? Boolean.TRUE.toString().toLowerCase() : Boolean.FALSE.toString().toLowerCase());
            replacementValues.put("nonOfficialAccountUrl", nonOfficialAccountUrl);
            replacementValues.put("siteName", site.getTitle());
            replacementValues.put("productionSiteName", productionSiteName);
            replacementValues.put("newNonOfficialAccount", Boolean.toString(newNonOfficialAccount).toLowerCase());
            replacementValues.put("xloginText", this.serverConfigurationService.getString("xlogin.text", "Login"));
            replacementValues.put("loginText", this.serverConfigurationService.getString("login.text", "Login"));
            replacementValues.put("siteUrl", site.getUrl());
            this.emailTemplateServiceSend(NOTIFY_ADDED_PARTICIPANT, null, user, from, to, headerTo, replyTo, replacementValues);
        }
    }

    public void notifyNewUserEmail(User user, String newUserPassword, Site site) {
        String newUserEmail;
        String from = this.getSetupRequestEmailAddress();
        String productionSiteName = this.serverConfigurationService.getString("ui.service", "");
        String to = newUserEmail = user.getEmail();
        String headerTo = newUserEmail;
        String replyTo = from;
        if (from != null && newUserEmail != null) {
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put("userName", user.getDisplayName());
            replacementValues.put("localSakaiName", this.serverConfigurationService.getString("ui.service", ""));
            replacementValues.put("currentUserName", this.userDirectoryService.getCurrentUser().getDisplayName());
            replacementValues.put("userEid", user.getEid());
            replacementValues.put("localSakaiUrl", this.serverConfigurationService.getPortalUrl());
            replacementValues.put("newPassword", newUserPassword);
            replacementValues.put("siteName", site.getTitle());
            replacementValues.put("productionSiteName", productionSiteName);
            this.emailTemplateServiceSend(NOTIFY_NEW_USER, null, user, from, to, headerTo, replyTo, replacementValues);
        }
    }

    public void notifyTemplateUse(Site templateSite, User currentUser, Site site) {
        String templateEmailArchive;
        String from = this.getSetupRequestEmailAddress();
        String to = templateEmailArchive = templateSite.getId() + "@" + this.serverConfigurationService.getServerName();
        String headerTo = templateEmailArchive;
        String replyTo = templateEmailArchive;
        if (from != null && templateEmailArchive != null) {
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put("templateSiteTitle", templateSite.getTitle());
            replacementValues.put("templateSiteId", templateSite.getId());
            replacementValues.put("currentUserDisplayName", currentUser.getDisplayName());
            replacementValues.put("currentUserDisplayId", currentUser.getDisplayId());
            SimpleDateFormat dform = (SimpleDateFormat)DateFormat.getDateInstance();
            dform.applyPattern("yyyy-MM-dd HH:mm:ss");
            String dateDisplay = dform.format(new Date());
            replacementValues.put("currentDate", dateDisplay);
            replacementValues.put("newSiteId", site.getId());
            replacementValues.put("newSiteTitle", site.getTitle());
            this.emailTemplateServiceSend(NOTIFY_TEMPLATE_USE, new ResourceLoader().getLocale(), currentUser, from, to, headerTo, replyTo, replacementValues);
        }
    }

    public boolean notifyCourseRequestAuthorizer(String instructorId, String requestEmail, String replyToEmail, String termTitle, String requestSectionInfo, String siteTitle, String siteId, String additionalInfo, String serverName) {
        try {
            User instructor = this.userDirectoryService.getUserByEid(instructorId);
            String to = instructor.getEmail();
            String from = requestEmail;
            String headerTo = to;
            String replyTo = replyToEmail;
            User currentUser = this.userDirectoryService.getCurrentUser();
            String currentUserDisplayName = currentUser != null ? currentUser.getDisplayName() : "";
            String currentUserDisplayId = currentUser != null ? currentUser.getDisplayId() : "";
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put("currentUserDisplayName", currentUserDisplayName);
            replacementValues.put("currentUserDisplayId", currentUserDisplayId);
            replacementValues.put("termTitle", termTitle);
            replacementValues.put("requestSectionInfo", requestSectionInfo);
            replacementValues.put("siteTitle", siteTitle);
            replacementValues.put("siteId", siteId);
            replacementValues.put("specialInstruction", additionalInfo);
            replacementValues.put("serverName", serverName);
            return this.emailTemplateServiceSend(NOTITY_COURSE_REQUEST_AUTHORIZER, null, instructor, from, to, headerTo, replyTo, replacementValues) != null;
        }
        catch (Exception e) {
            LOG.warn(this + " cannot find user " + instructorId, (Throwable)e);
            return false;
        }
    }

    public String notifyCourseRequestSupport(String requestEmail, String serverName, String request, String termTitle, int requestListSize, String requestSectionInfo, String officialAccountName, String siteTitle, String siteId, String additionalInfo, boolean requireAuthorizer, String authorizerNotified, String authorizerNotNotified) {
        String currentUserEmail;
        User currentUser = this.userDirectoryService.getCurrentUser();
        String currentUserDisplayName = currentUser != null ? currentUser.getDisplayName() : "";
        String currentUserDisplayId = currentUser != null ? currentUser.getDisplayId() : "";
        String from = currentUserEmail = currentUser != null ? currentUser.getEmail() : "";
        String to = requestEmail;
        String headerTo = requestEmail;
        String replyTo = currentUserEmail;
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("currentUserDisplayName", currentUserDisplayName);
        replacementValues.put("currentUserDisplayId", currentUserDisplayId);
        replacementValues.put("termTitle", termTitle);
        replacementValues.put("requestSectionInfo", requestSectionInfo);
        replacementValues.put("requestListSize", String.valueOf(requestListSize));
        replacementValues.put("siteTitle", siteTitle);
        replacementValues.put("siteId", siteId);
        replacementValues.put("specialInstruction", additionalInfo);
        replacementValues.put("serverName", serverName);
        SimpleDateFormat dform = (SimpleDateFormat)DateFormat.getDateInstance();
        dform.applyPattern("yyyy-MM-dd HH:mm:ss");
        String dateDisplay = dform.format(new Date());
        replacementValues.put("dateDisplay", dateDisplay);
        replacementValues.put("requireAuthorizer", String.valueOf(requireAuthorizer));
        replacementValues.put("authorizerNotified", authorizerNotified);
        replacementValues.put("authorizerNotNotified", authorizerNotNotified);
        try {
            return this.emailTemplateServiceSend(NOTIFY_COURSE_REQUEST_SUPPORT, new ResourceLoader().getLocale(), currentUser, from, to, headerTo, replyTo, replacementValues);
        }
        catch (Exception e) {
            LOG.warn(this + " problem in send site request email to support for " + currentUserDisplayName, (Throwable)e);
            return "";
        }
    }

    public void notifyCourseRequestRequester(String requestEmail, String supportEmailContent, String termTitle) {
        String to;
        User currentUser = this.userDirectoryService.getCurrentUser();
        String currentUserDisplayName = currentUser != null ? currentUser.getDisplayName() : "";
        String currentUserDisplayId = currentUser != null ? currentUser.getDisplayId() : "";
        String currentUserEmail = currentUser != null ? currentUser.getEmail() : "";
        String from = requestEmail;
        String headerTo = to = currentUserEmail;
        String replyTo = to;
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("currentUserDisplayName", currentUserDisplayName);
        replacementValues.put("currentUserDisplayId", currentUserDisplayId);
        replacementValues.put("currentUserEmail", currentUserEmail);
        replacementValues.put("termTitle", termTitle);
        replacementValues.put("supportEmailContent", supportEmailContent);
        replacementValues.put("requestEmail", requestEmail);
        this.emailTemplateServiceSend(NOTIFY_COURSE_REQUEST_REQUESTER, new ResourceLoader().getLocale(), currentUser, from, to, headerTo, replyTo, replacementValues);
    }

    public void notifySiteCreation(Site site, List notifySites, boolean courseSite, String termTitle, String requestEmail) {
        User currentUser = this.userDirectoryService.getCurrentUser();
        String currentUserDisplayName = currentUser != null ? currentUser.getDisplayName() : "";
        String currentUserDisplayId = currentUser != null ? currentUser.getDisplayId() : "";
        String currentUserEmail = currentUser != null ? currentUser.getEmail() : "";
        SimpleDateFormat dform = (SimpleDateFormat)DateFormat.getDateInstance();
        dform.applyPattern("yyyy-MM-dd HH:mm:ss");
        String dateDisplay = dform.format(new Date());
        String from = currentUserEmail;
        String to = requestEmail;
        String headerTo = requestEmail;
        String replyTo = currentUserEmail;
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("currentUserDisplayName", currentUserDisplayName);
        replacementValues.put("currentUserDisplayId", currentUserDisplayId);
        replacementValues.put("currentUserEmail", currentUserEmail);
        replacementValues.put("dateDisplay", dateDisplay);
        replacementValues.put("termTitle", termTitle);
        replacementValues.put("serviceName", this.serverConfigurationService.getString("ui.service", this.serverConfigurationService.getServerName()));
        replacementValues.put("siteTitle", site != null ? site.getTitle() : "");
        replacementValues.put("siteId", site != null ? site.getId() : "");
        replacementValues.put("courseSite", String.valueOf(courseSite));
        StringBuilder buf = new StringBuilder();
        if (notifySites != null) {
            int nbr_sections = notifySites.size();
            replacementValues.put("numSections", String.valueOf(nbr_sections));
            for (int i = 0; i < nbr_sections; ++i) {
                String course = (String)notifySites.get(i);
                buf.append(course).append("\n");
            }
        } else {
            replacementValues.put("numSections", "0");
        }
        replacementValues.put("sections", buf.toString());
        this.emailTemplateServiceSend(NOTIFY_SITE_CREATION, new ResourceLoader().getLocale(), currentUser, from, to, headerTo, replyTo, replacementValues);
        from = requestEmail;
        to = currentUserEmail;
        headerTo = currentUserEmail;
        replyTo = this.serverConfigurationService.getString("setup.request", "no-reply@" + this.serverConfigurationService.getServerName());
        this.emailTemplateServiceSend(NOTIFY_SITE_CREATION_CONFIRMATION, new ResourceLoader().getLocale(), currentUser, from, to, headerTo, replyTo, replacementValues);
    }

    private String getSetupRequestEmailAddress() {
        String from = this.serverConfigurationService.getString("setup.request", null);
        if (from == null) {
            LOG.warn(this + " - no 'setup.request' in configuration");
            from = "postmaster@".concat(this.serverConfigurationService.getServerName());
        }
        return from;
    }

    private String getCurrentUserEmailAddress() {
        String email;
        User currentUser = this.userDirectoryService.getCurrentUser();
        String string = email = currentUser != null ? currentUser.getEmail() : null;
        if (email == null || email.length() == 0) {
            email = this.getSetupRequestEmailAddress();
        }
        return email;
    }

    private String emailTemplateServiceSend(String templateName, Locale locale, User user, String from, String to, String headerTo, String replyTo, Map<String, String> replacementValues) {
        LOG.debug("getting template: " + templateName);
        try {
            RenderedTemplate template = locale == null ? this.emailTemplateService.getRenderedTemplateForUser(templateName, user != null ? user.getReference() : "", replacementValues) : this.emailTemplateService.getRenderedTemplate(templateName, locale, replacementValues);
            if (template != null) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("Precedence: bulk");
                String content = template.getRenderedMessage();
                this.emailService.send(from, to, template.getRenderedSubject(), content, headerTo, replyTo, headers);
                return content;
            }
        }
        catch (Exception e) {
            LOG.warn(this + e.getMessage());
            return null;
        }
        return null;
    }

    public void notifySiteImportCompleted(String toEmail, String siteId, String siteTitle) {
        if (toEmail != null && !"".equals(toEmail)) {
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put(SITE_IMPORT_EMAIL_TEMPLATE_VAR_WORKSITE, siteTitle);
            replacementValues.put(SITE_IMPORT_EMAIL_TEMPLATE_VAR_LINK, this.developerHelperService.getLocationReferenceURL("/site/" + siteId));
            replacementValues.put(SITE_IMPORT_EMAIL_TEMPLATE_VAR_INSTITUTION, this.serverConfigurationService.getString(SAK_PROP_UI_INSTITUTION));
            String headerTo = toEmail;
            String replyTo = toEmail;
            this.emailTemplateServiceSend(SITE_IMPORT_EMAIL_TEMPLATE_KEY, Locale.ENGLISH, this.userDirectoryService.getCurrentUser(), this.getSetupRequestEmailAddress(), toEmail, headerTo, replyTo, replacementValues);
        }
    }
}

