/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitemanage.impl;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.sitemanage.api.SectionField;
import org.sakaiproject.sitemanage.api.SectionFieldProvider;
import org.sakaiproject.sitemanage.impl.SectionFieldImpl;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionFieldProviderImpl
implements SectionFieldProvider {
    private static final Logger log = LoggerFactory.getLogger(SectionFieldProviderImpl.class);
    private static ServerConfigurationService serverConfigurationService;

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        SectionFieldProviderImpl.serverConfigurationService = serverConfigurationService;
    }

    public List<SectionField> getRequiredFields() {
        ResourceLoader resourceLoader = new ResourceLoader("SectionFields");
        ArrayList<SectionField> fieldList = new ArrayList<SectionField>();
        fieldList.add(new SectionFieldImpl(resourceLoader.getString("required_fields_subject"), null, serverConfigurationService.getInt("wsetup.sectionfield.required_fields_subject.max", 8)));
        fieldList.add(new SectionFieldImpl(resourceLoader.getString("required_fields_course"), null, serverConfigurationService.getInt("wsetup.sectionfield.required_fields_course.max", 3)));
        fieldList.add(new SectionFieldImpl(resourceLoader.getString("required_fields_section"), null, serverConfigurationService.getInt("wsetup.sectionfield.required_fields_section.max", 3)));
        return fieldList;
    }

    public String getSectionEid(String academicSessionEid, List<SectionField> fields) {
        if (fields == null || fields.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Returning an empty sectionEID for an empty (or null) list of fields");
            }
            return "";
        }
        StringBuffer sectionEid = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            SectionField sf = fields.get(i);
            sectionEid.append(sf.getValue()).append("_");
        }
        sectionEid.append(academicSessionEid);
        if (log.isDebugEnabled()) {
            log.debug(this + ":getSectionEid: Generated section eid = " + sectionEid.toString());
        }
        return sectionEid.toString();
    }

    public String getSectionTitle(String academicSessionEid, List<SectionField> fields) {
        if (fields == null || fields.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(this + ":getSectionTitle: Returning an empty section title for an empty (or null) list of fields");
            }
            return "";
        }
        StringBuffer rv = new StringBuffer();
        String[] values = new String[fields.size() + 1];
        for (int i = 0; i < fields.size(); ++i) {
            SectionField sf = fields.get(i);
            rv.append(sf.getValue()).append(" ");
        }
        rv.append(academicSessionEid);
        return rv.toString();
    }

    public void init() {
    }

    public void destroy() {
    }
}

