/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.site.util;

import java.util.ArrayList;
import java.util.Collection;

public class SiteGroupHelper {
    static final char SEPARATOR = ',';
    static final char ESCAPE = '\\';
    static final String ESCAPE_STR = Character.toString('\\');
    static final String SEPARATOR_STR = Character.toString(',');

    private SiteGroupHelper() {
    }

    public static Collection<String> unpack(String ids) {
        ArrayList<String> unpacked = new ArrayList<String>();
        if (ids != null) {
            StringBuilder id = new StringBuilder();
            boolean inEscape = false;
            block4: for (int i = 0; i < ids.length(); ++i) {
                if (inEscape) {
                    id.append(ids.charAt(i));
                    inEscape = false;
                    continue;
                }
                switch (ids.charAt(i)) {
                    case '\\': {
                        inEscape = true;
                        continue block4;
                    }
                    case ',': {
                        unpacked.add(id.toString());
                        id = new StringBuilder();
                        continue block4;
                    }
                    default: {
                        id.append(ids.charAt(i));
                    }
                }
            }
            unpacked.add(id.toString());
        }
        return unpacked;
    }

    public static String pack(Collection<String> ids) {
        String packed = null;
        if (ids != null) {
            StringBuilder builder = new StringBuilder();
            String separator = "";
            for (String id : ids) {
                builder.append(separator);
                separator = SEPARATOR_STR;
                builder.append(id.replace(ESCAPE_STR, ESCAPE_STR + ESCAPE_STR).replace(SEPARATOR_STR, ESCAPE_STR + SEPARATOR_STR));
            }
            packed = builder.toString();
        }
        return packed;
    }
}

