/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.site.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;

public class Participant {
    protected String NULL_STRING;
    public String name;
    public String displayName;
    public String uniqname;
    public String role;
    public String providerRole;
    public String credits;
    public String section;
    private Set sectionEidList;
    public String regId;
    public boolean removeable;
    public boolean active;

    public Participant() {
        this.name = this.NULL_STRING = "";
        this.displayName = this.NULL_STRING;
        this.uniqname = this.NULL_STRING;
        this.role = this.NULL_STRING;
        this.providerRole = this.NULL_STRING;
        this.credits = this.NULL_STRING;
        this.section = this.NULL_STRING;
        this.regId = this.NULL_STRING;
        this.removeable = true;
        this.active = true;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.NULL_STRING.equals(this.displayName)) {
            this.displayName = this.name;
        } else {
            try {
                User user = UserDirectoryService.getUser((String)this.uniqname);
                this.displayName = user.getDisplayName();
            }
            catch (UserNotDefinedException e) {
                this.displayName = this.uniqname;
            }
        }
        return this.displayName;
    }

    public String getUniqname() {
        return this.uniqname;
    }

    public String getRole() {
        return this.role;
    }

    public String getProviderRole() {
        return this.providerRole;
    }

    public boolean isRemoveable() {
        return this.removeable;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getCredits() {
        return this.credits;
    }

    public String getSection() {
        if (this.sectionEidList == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = this.sectionEidList.iterator();
        for (int i = 0; i < this.sectionEidList.size(); ++i) {
            String sectionEid = (String)it.next();
            if (i > 0) {
                sb.append(",<br />");
            }
            sb.append(sectionEid);
        }
        return sb.toString();
    }

    public Set getSectionEidList() {
        if (this.sectionEidList == null) {
            this.sectionEidList = new HashSet();
        }
        return this.sectionEidList;
    }

    public void addSectionEidToList(String eid) {
        if (this.sectionEidList == null) {
            this.sectionEidList = new HashSet();
        }
        this.sectionEidList.add(eid);
    }

    public String getRegId() {
        return this.regId;
    }

    public String getEid() {
        try {
            return UserDirectoryService.getUserEid((String)this.uniqname);
        }
        catch (UserNotDefinedException e) {
            return this.uniqname;
        }
    }

    public String getDisplayId() {
        try {
            User user = UserDirectoryService.getUser((String)this.uniqname);
            return user.getDisplayId();
        }
        catch (UserNotDefinedException e) {
            return this.uniqname;
        }
    }
}

