/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.site.util;

import java.util.List;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.site.api.SiteService;

public class SiteTypeUtil {
    private static SiteService siteService = (SiteService)ComponentManager.get(SiteService.class);
    private static ServerConfigurationService serverConfigurationService = (ServerConfigurationService)ComponentManager.get(ServerConfigurationService.class);

    public static List<String> getCourseSiteTypes() {
        return siteService.getSiteTypeStrings("course");
    }

    public static List<String> getProjectSiteTypes() {
        return siteService.getSiteTypeStrings("project");
    }

    public static boolean isCourseSite(String siteType) {
        return SiteTypeUtil.isOfSiteType("course", siteType);
    }

    public static boolean isProjectSite(String siteType) {
        return SiteTypeUtil.isOfSiteType("project", siteType);
    }

    private static boolean isOfSiteType(String targetSiteType, String currentSiteType) {
        boolean rv = false;
        List siteTypes = siteService.getSiteTypeStrings(targetSiteType);
        if (currentSiteType != null && siteTypes != null && siteTypes.contains(currentSiteType)) {
            rv = true;
        }
        return rv;
    }

    public static String getTargetSiteType(String siteType) {
        String rv = siteType;
        if (SiteTypeUtil.isCourseSite(siteType)) {
            rv = serverConfigurationService.getString("courseSiteTargetType", siteType);
        } else if (SiteTypeUtil.isProjectSite(siteType)) {
            rv = serverConfigurationService.getString("projectSiteTargetType", siteType);
        }
        return rv;
    }
}

