/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.site.util;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.util.Participant;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteComparator
implements Comparator {
    private static final Logger log = LoggerFactory.getLogger(SiteComparator.class);
    Collator collator = Collator.getInstance();
    Collator localeCollator = null;
    String m_criterion = null;
    Locale m_loc = null;
    String m_asc = null;

    public SiteComparator(String criterion, String asc) {
        this.m_criterion = criterion;
        this.m_asc = asc;
    }

    public SiteComparator(String criterion, String asc, Locale locale) {
        this(criterion, asc);
        this.m_loc = locale;
        try {
            RuleBasedCollator defaultCollator = (RuleBasedCollator)Collator.getInstance(locale);
            String rules = defaultCollator.getRules();
            this.localeCollator = new RuleBasedCollator(rules.replaceAll("<'_'", "<' '<'_'"));
            this.localeCollator.setStrength(2);
        }
        catch (Exception e) {
            log.warn("SiteComparator failed to create RuleBasedCollator for locale " + locale.toString(), (Throwable)e);
            this.localeCollator = null;
        }
    }

    public int compare(Object o1, Object o2) {
        int result = -1;
        if (this.m_criterion == null) {
            this.m_criterion = "title";
        }
        if (this.m_criterion.equals("title")) {
            String s1 = ((Site)o1).getTitle();
            String s2 = ((Site)o2).getTitle();
            result = this.compareString(s1, s2);
        } else if (this.m_criterion.equals("description")) {
            String s1 = ((Site)o1).getShortDescription();
            String s2 = ((Site)o2).getShortDescription();
            result = this.compareString(s1, s2);
        } else if (this.m_criterion.equals("type")) {
            String s1 = ((Site)o1).getType();
            String s2 = ((Site)o2).getType();
            result = this.compareString(s1, s2);
        } else if (this.m_criterion.equals(SiteService.SortType.CREATED_BY_ASC.toString())) {
            String s1 = ((Site)o1).getProperties().getProperty("CHEF:creator");
            String s2 = ((Site)o2).getProperties().getProperty("CHEF:creator");
            result = this.compareString(s1, s2);
        } else if (this.m_criterion.equals("status")) {
            boolean i2;
            boolean i1 = ((Site)o1).isPublished();
            boolean bl = i2 = ((Site)o2).isPublished();
            result = i1 > i2 ? 1 : -1;
        } else if (this.m_criterion.equals("joinable")) {
            boolean b1 = ((Site)o1).isJoinable();
            boolean b2 = ((Site)o2).isJoinable();
            result = this.compareBoolean(b1, b2);
        } else if (this.m_criterion.equals("participant_name")) {
            String s1 = null;
            if (o1.getClass().equals(Participant.class)) {
                s1 = ((Participant)o1).getName();
            }
            String s2 = null;
            if (o2.getClass().equals(Participant.class)) {
                s2 = ((Participant)o2).getName();
            }
            result = this.compareString(s1, s2);
        } else if (this.m_criterion.equals("participant_uniqname")) {
            String s1 = null;
            if (o1.getClass().equals(Participant.class)) {
                s1 = ((Participant)o1).getUniqname();
            }
            String s2 = null;
            if (o2.getClass().equals(Participant.class)) {
                s2 = ((Participant)o2).getUniqname();
            }
            if ((result = this.compareString(s1, s2)) == 0) {
                result = this.compareParticipantName((Participant)o1, (Participant)o2);
            }
        } else if (this.m_criterion.equals("participant_role")) {
            String s1 = "";
            if (o1.getClass().equals(Participant.class)) {
                s1 = ((Participant)o1).getRole();
            }
            String s2 = "";
            if (o2.getClass().equals(Participant.class)) {
                s2 = ((Participant)o2).getRole();
            }
            if ((result = this.compareString(s1, s2)) == 0) {
                result = this.compareParticipantName((Participant)o1, (Participant)o2);
            }
        } else if (this.m_criterion.equals("participant_course")) {
            String s1 = null;
            if (o1.getClass().equals(Participant.class)) {
                s1 = ((Participant)o1).getSection();
            }
            String s2 = null;
            if (o2.getClass().equals(Participant.class)) {
                s2 = ((Participant)o2).getSection();
            }
            if ((result = this.compareString(s1, s2)) == 0) {
                result = this.compareParticipantName((Participant)o1, (Participant)o2);
            }
        } else if (this.m_criterion.equals("participant_id")) {
            String s1 = null;
            if (o1.getClass().equals(Participant.class)) {
                s1 = ((Participant)o1).getRegId();
            }
            String s2 = null;
            if (o2.getClass().equals(Participant.class)) {
                s2 = ((Participant)o2).getRegId();
            }
            if ((result = this.compareString(s1, s2)) == 0) {
                result = this.compareParticipantName((Participant)o1, (Participant)o2);
            }
        } else if (this.m_criterion.equals("participant_credits")) {
            String s1 = null;
            if (o1.getClass().equals(Participant.class)) {
                s1 = ((Participant)o1).getCredits();
            }
            String s2 = null;
            if (o2.getClass().equals(Participant.class)) {
                s2 = ((Participant)o2).getCredits();
            }
            if ((result = this.compareString(s1, s2)) == 0) {
                result = this.compareParticipantName((Participant)o1, (Participant)o2);
            }
        } else if (this.m_criterion.equals("participant_status")) {
            boolean a1 = true;
            if (o1.getClass().equals(Participant.class)) {
                a1 = ((Participant)o1).isActive();
            }
            boolean a2 = true;
            if (o2.getClass().equals(Participant.class)) {
                a2 = ((Participant)o2).isActive();
            }
            if ((result = -this.compareBoolean(a1, a2)) == 0) {
                result = this.compareParticipantName((Participant)o1, (Participant)o2);
            }
        } else if (this.m_criterion.equals("creationdate")) {
            Date t1 = null;
            Date t2 = null;
            try {
                t1 = ((Site)o1).getProperties().getDateProperty("DAV:creationdate");
            }
            catch (EntityPropertyNotDefinedException entityPropertyNotDefinedException) {
            }
            catch (EntityPropertyTypeException entityPropertyTypeException) {
                // empty catch block
            }
            try {
                t2 = ((Site)o2).getProperties().getDateProperty("DAV:creationdate");
            }
            catch (EntityPropertyNotDefinedException entityPropertyNotDefinedException) {
            }
            catch (EntityPropertyTypeException entityPropertyTypeException) {
                // empty catch block
            }
            result = t1 == null ? -1 : (t2 == null ? 1 : (t1.before(t2) ? -1 : 1));
        } else if (this.m_criterion.equals("group_title")) {
            String s1 = ((Group)o1).getTitle();
            String s2 = ((Group)o2).getTitle();
            result = this.compareString(s1, s2);
        } else if (this.m_criterion.equals("group_size")) {
            int n2;
            int n1 = ((Group)o1).getMembers().size();
            result = n1 > (n2 = ((Group)o2).getMembers().size()) ? 1 : -1;
        } else if (this.m_criterion.equals("member_name")) {
            String s1 = null;
            String s2 = null;
            try {
                s1 = UserDirectoryService.getUser((String)((Member)o1).getUserId()).getSortName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s2 = UserDirectoryService.getUser((String)((Member)o2).getUserId()).getSortName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = this.compareString(s1, s2);
        }
        if (this.m_asc == null) {
            this.m_asc = Boolean.TRUE.toString();
        }
        if (this.m_asc.equals(Boolean.FALSE.toString())) {
            result = -result;
        }
        return result;
    }

    private int compareParticipantName(Participant o1, Participant o2) {
        return this.compareString(o1.getName(), o2.getName());
    }

    private int compareBoolean(boolean b1, boolean b2) {
        int result = b1 == b2 ? 0 : (b1 ? 1 : -1);
        return result;
    }

    private int compareString(String s1, String s2) {
        int result = s1 == null && s2 == null ? 0 : (s2 == null ? 1 : (s1 == null ? -1 : (this.localeCollator != null ? this.localeCollator.compare(s1, s2) : this.collator.compare(s1, s2))));
        return result;
    }
}

