/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.site.util;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.util.SiteSetupQuestionMap;
import org.sakaiproject.sitemanage.api.model.SiteSetupQuestion;
import org.sakaiproject.sitemanage.api.model.SiteSetupQuestionAnswer;
import org.sakaiproject.sitemanage.api.model.SiteSetupQuestionService;
import org.sakaiproject.sitemanage.api.model.SiteTypeQuestions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteSetupQuestionFileParser {
    private static final Logger log = LoggerFactory.getLogger(SiteSetupQuestionFileParser.class);
    private static SiteSetupQuestionService questionService = (SiteSetupQuestionService)ComponentManager.get(SiteSetupQuestionService.class);
    private static ContentHostingService contentHostingService = (ContentHostingService)ComponentManager.get((String)"org.sakaiproject.content.api.ContentHostingService");
    protected static String m_adminSiteName = "setupQuestionsAdmin";
    protected static String m_configFolder = "config";
    protected static String m_configBackupFolder = "configBackup";
    protected static String m_configXml = "questions.xml";
    protected static SiteSetupQuestionMap m_siteSetupQuestionMap;

    public String getAdminSiteName() {
        return m_adminSiteName;
    }

    public void setAdminSiteName(String siteName) {
        m_adminSiteName = siteName;
    }

    public static String getConfigFolderReference() {
        String configFolderRef = null;
        if (StringUtils.trimToNull((String)m_adminSiteName) != null && StringUtils.trimToNull((String)m_configFolder) != null) {
            configFolderRef = "/content/group/" + m_adminSiteName + "/" + m_configFolder + "/";
        }
        return configFolderRef;
    }

    public static String getConfigBackupFolderReference() {
        String configBackupFolderRef = null;
        if (StringUtils.trimToNull((String)m_adminSiteName) != null && StringUtils.trimToNull((String)m_configBackupFolder) != null) {
            configBackupFolderRef = "/content/group/" + m_adminSiteName + "/" + m_configBackupFolder + "/";
        }
        return configBackupFolderRef;
    }

    public static boolean isConfigurationXmlAvailable() {
        try {
            String x = "";
            if (m_configXml == null) {
                return false;
            }
            return SiteSetupQuestionFileParser.exists(m_configXml);
        }
        catch (Exception exception) {
            log.warn("Unexpected exception: " + exception);
            return false;
        }
    }

    protected static boolean exists(String resourceName) {
        String configFolderRef = SiteSetupQuestionFileParser.getConfigFolderReference();
        if (StringUtils.trimToNull((String)configFolderRef) != null && StringUtils.trimToNull((String)resourceName) != null) {
            String referenceName = configFolderRef + resourceName;
            Reference reference = EntityManager.newReference((String)referenceName);
            if (reference == null) {
                return false;
            }
            SiteSetupQuestionFileParser.enableSecurityAdvisor();
            ContentResource resource = null;
            try {
                resource = contentHostingService.getResource(reference.getId());
                log.info("exists(): find new resource " + reference.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            SiteSetupQuestionFileParser.popSecurityAdvisor();
            return resource != null;
        }
        return false;
    }

    protected static void enableSecurityAdvisor() {
        SecurityService.pushAdvisor((SecurityAdvisor)new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        });
    }

    protected static void popSecurityAdvisor() {
        SecurityService.popAdvisor();
    }

    public static SiteSetupQuestionMap updateConfig() {
        String configFolder = SiteSetupQuestionFileParser.getConfigFolderReference();
        Reference configFolderReference = EntityManager.newReference((String)configFolder);
        String configBackupFolder = SiteSetupQuestionFileParser.getConfigBackupFolderReference();
        Reference configBackupolderReference = EntityManager.newReference((String)configBackupFolder);
        Reference ref = EntityManager.newReference((String)(configFolder + m_configXml));
        Reference refBackup = EntityManager.newReference((String)(configBackupFolder + m_configXml));
        if (ref != null) {
            try {
                SiteSetupQuestionFileParser.enableSecurityAdvisor();
                ContentResource resource = contentHostingService.getResource(ref.getId());
                if (resource != null) {
                    List questions = questionService.getAllSiteQuestions();
                    if (questions != null && !questions.isEmpty()) {
                        for (SiteSetupQuestion question : questions) {
                            if (!question.getCurrent().equals("true")) continue;
                            question.setCurrent("false");
                            questionService.saveSiteSetupQuestion(question);
                        }
                    }
                    questionService.removeAllSiteTypeQuestions();
                    m_siteSetupQuestionMap = SiteSetupQuestionFileParser.populateConfig(ref.getReference(), resource.streamContent());
                    if (!contentHostingService.isAvailable(configBackupolderReference.getId())) {
                        try {
                            ContentCollectionEdit fEdit = contentHostingService.addCollection(configBackupolderReference.getId(), m_configBackupFolder);
                            contentHostingService.commitCollection(fEdit);
                        }
                        catch (Exception ee) {
                            log.warn("SiteSetupQuestionMap.updateConfig: Problem of adding backup collection " + configBackupolderReference.getId() + ee.getMessage());
                        }
                    }
                    if (contentHostingService.isAvailable(configBackupolderReference.getId())) {
                        try {
                            contentHostingService.copy(ref.getId(), refBackup.getId());
                        }
                        catch (Exception ee) {
                            log.warn("SiteSetupQuestionMap.updateConfig: Problem of backing up question.xml file " + ee.getMessage());
                        }
                    }
                    try {
                        ContentResourceEdit rEdit = contentHostingService.editResource(ref.getId());
                        contentHostingService.removeResource(rEdit);
                    }
                    catch (Exception ee) {
                        log.warn("SiteSetupQuestionMap.updateConfig: Problem of removing resource " + ref.getId() + ee.getMessage());
                    }
                }
                SiteSetupQuestionFileParser.popSecurityAdvisor();
            }
            catch (PermissionException e) {
                log.warn("Exception: " + e + ", continuing");
            }
            catch (IdUnusedException e) {
                log.info("configuration XML is missing (" + m_configXml + "); Citations ConfigurationService will watch for its creation");
            }
            catch (TypeException e) {
                log.warn("Exception: " + e + ", continuing");
            }
            catch (ServerOverloadException e) {
                log.warn("Exception: " + e + ", continuing");
            }
        }
        return m_siteSetupQuestionMap;
    }

    protected static SiteSetupQuestionMap populateConfig(String configurationXml, InputStream stream) {
        Document document = SiteSetupQuestionFileParser.parseXmlFromStream(stream);
        if (document == null) {
            return null;
        }
        SiteSetupQuestionMap m = new SiteSetupQuestionMap();
        Element rootElement = document.getDocumentElement();
        NodeList childList = rootElement.getChildNodes();
        if (childList == null || childList.getLength() == 0) {
            log.warn("Cannot find elements in SiteSetupQuestions");
        } else {
            block16: for (int i = 0; i < childList.getLength(); ++i) {
                Node currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block16;
                    }
                    case 1: {
                        String siteType;
                        if (!currentNode.hasAttributes()) continue block16;
                        NamedNodeMap nNMap = currentNode.getAttributes();
                        String string = siteType = nNMap.getNamedItem("type") != null ? nNMap.getNamedItem("type").getNodeValue() : null;
                        if (siteType == null) continue block16;
                        SiteTypeQuestions siteTypeQuestions = questionService.newSiteTypeQuestions();
                        siteTypeQuestions.setSiteType(siteType);
                        NodeList qSetList = currentNode.getChildNodes();
                        block17: for (int i2 = 0; i2 < qSetList.getLength(); ++i2) {
                            Node qNode = qSetList.item(i2);
                            switch (qNode.getNodeType()) {
                                case 3: {
                                    continue block17;
                                }
                                case 1: {
                                    if (qNode.getNodeName().equals("header")) {
                                        siteTypeQuestions.setInstruction(qNode.getTextContent());
                                        continue block17;
                                    }
                                    if (qNode.getNodeName().equals("url")) {
                                        NodeList qList = qNode.getChildNodes();
                                        block18: for (int i3 = 0; i3 < qList.getLength(); ++i3) {
                                            Node qDetailNode = qList.item(i3);
                                            switch (qDetailNode.getNodeType()) {
                                                case 3: {
                                                    continue block18;
                                                }
                                                case 1: {
                                                    if (!qDetailNode.getNodeName().equals("a")) continue block18;
                                                    if (qDetailNode.hasAttributes()) {
                                                        NamedNodeMap qDetailMap = qDetailNode.getAttributes();
                                                        if (qDetailMap.getNamedItem("href") != null) {
                                                            siteTypeQuestions.setUrl(qDetailMap.getNamedItem("href").getNodeValue());
                                                        } else if (qDetailMap.getNamedItem("target") != null) {
                                                            siteTypeQuestions.setUrlTarget(qDetailMap.getNamedItem("target").getNodeValue());
                                                        }
                                                    }
                                                    siteTypeQuestions.setUrlLabel(qDetailNode.getTextContent());
                                                }
                                            }
                                        }
                                        continue block17;
                                    }
                                    if (!qNode.getNodeName().equals("question")) continue block17;
                                    SiteSetupQuestion q = questionService.newSiteSetupQuestion();
                                    if (qNode.hasAttributes()) {
                                        NamedNodeMap qMap = qNode.getAttributes();
                                        if (qMap.getNamedItem("required") != null) {
                                            q.setRequired(Boolean.valueOf(qMap.getNamedItem("required").getNodeValue()).booleanValue());
                                        } else {
                                            q.setRequired(false);
                                        }
                                        if (qMap.getNamedItem("multiple_answers") != null) {
                                            q.setIsMultipleAnswers(Boolean.valueOf(qMap.getNamedItem("multiple_answers").getNodeValue()).booleanValue());
                                        } else {
                                            q.setIsMultipleAnswers(false);
                                        }
                                        NodeList qList = qNode.getChildNodes();
                                        block19: for (int i3 = 0; i3 < qList.getLength(); ++i3) {
                                            Node qDetailNode = qList.item(i3);
                                            switch (qDetailNode.getNodeType()) {
                                                case 3: {
                                                    continue block19;
                                                }
                                                case 1: {
                                                    if (qDetailNode.getNodeName().equals("q")) {
                                                        q.setQuestion(qDetailNode.getTextContent());
                                                        continue block19;
                                                    }
                                                    if (!qDetailNode.getNodeName().equals("answer")) continue block19;
                                                    SiteSetupQuestionAnswer answer = questionService.newSiteSetupQuestionAnswer();
                                                    if (qDetailNode.hasAttributes()) {
                                                        NamedNodeMap qDetailMap = qDetailNode.getAttributes();
                                                        if (qDetailMap.getNamedItem("fillin_blank") != null) {
                                                            answer.setIsFillInBlank(Boolean.valueOf(qDetailMap.getNamedItem("fillin_blank").getNodeValue()).booleanValue());
                                                        } else {
                                                            answer.setIsFillInBlank(false);
                                                        }
                                                    }
                                                    answer.setAnswer(qDetailNode.getTextContent());
                                                    questionService.saveSiteSetupQuestionAnswer(answer);
                                                    q.addAnswer(answer);
                                                }
                                            }
                                        }
                                    }
                                    q.setCurrent("true");
                                    questionService.saveSiteSetupQuestion(q);
                                    siteTypeQuestions.addQuestion(q);
                                }
                            }
                        }
                        questionService.saveSiteTypeQuestions(siteTypeQuestions);
                    }
                }
            }
        }
        return m;
    }

    protected void saveParameter(Document document, Map parameterMap, String name) {
        String value = this.getText(document, name);
        if (value != null) {
            parameterMap.put(name, value);
        }
    }

    protected static Document parseXmlFromStream(InputStream stream) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            if (documentBuilder != null) {
                return documentBuilder.parse(stream);
            }
        }
        catch (Exception exception) {
            log.warn("XML parse on \"" + stream + "\" failed: " + exception);
        }
        return null;
    }

    protected static DocumentBuilder getXmlDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            return factory.newDocumentBuilder();
        }
        catch (Exception exception) {
            log.warn("Failed to get XML DocumentBuilder: " + exception);
            return null;
        }
    }

    protected String normalizeText(String original, String update) {
        if (original == null) {
            return update == null ? "" : update.trim();
        }
        StringBuilder result = new StringBuilder(original.trim());
        result.append(' ');
        result.append(update.trim());
        return result.toString();
    }

    protected String getText(Document root, String elementName) {
        return this.getText(root.getDocumentElement(), elementName);
    }

    protected String getText(Element root, String elementName) {
        NodeList nodeList = root.getElementsByTagName(elementName);
        if (nodeList.getLength() == 0) {
            return null;
        }
        String text = null;
        Element parent = (Element)nodeList.item(0);
        block3: for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 3: {
                    text = this.normalizeText(text, child.getNodeValue());
                    continue block3;
                }
            }
        }
        return text == null ? text : text.trim();
    }
}

