/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.site.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.GroupProvider;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.coursemanagement.api.CourseManagementService;
import org.sakaiproject.coursemanagement.api.CourseOffering;
import org.sakaiproject.coursemanagement.api.CourseSet;
import org.sakaiproject.coursemanagement.api.Enrollment;
import org.sakaiproject.coursemanagement.api.EnrollmentSet;
import org.sakaiproject.coursemanagement.api.Membership;
import org.sakaiproject.coursemanagement.api.Section;
import org.sakaiproject.coursemanagement.api.exception.IdNotFoundException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.site.util.Participant;
import org.sakaiproject.user.api.ContextualUserDisplayService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteParticipantHelper {
    private static final Logger log = LoggerFactory.getLogger(SiteParticipantHelper.class);
    private static String NULL_STRING = "";
    private static GroupProvider groupProvider = (GroupProvider)ComponentManager.get(GroupProvider.class);
    private static AuthzGroupService authzGroupService = (AuthzGroupService)ComponentManager.get(AuthzGroupService.class);
    private static CourseManagementService cms = (CourseManagementService)ComponentManager.get(CourseManagementService.class);
    private static ContextualUserDisplayService cus = (ContextualUserDisplayService)ComponentManager.get(ContextualUserDisplayService.class);
    private static SecurityService securityService = (SecurityService)ComponentManager.get(SecurityService.class);
    private static ServerConfigurationService scs = (ServerConfigurationService)ComponentManager.get(ServerConfigurationService.class);
    private static String showOrphanedMembers = scs.getString("site.setup.showOrphanedMembers", "admins");
    private static ResourceLoader rb = new ResourceLoader("UserDirectoryProvider");
    private static final String SAK_PROP_RESTRICTED_ROLES = "sitemanage.addParticipants.restrictedRoles";

    public static void addParticipantsFromEnrollmentSet(Map<String, Participant> participantsMap, AuthzGroup realm, String providerCourseEid, EnrollmentSet enrollmentSet, String sectionTitle) {
        SiteParticipantHelper.addParticipantsFromEnrollmentSet(participantsMap, realm, providerCourseEid, enrollmentSet, sectionTitle, null, null, null);
    }

    public static void addParticipantsFromEnrollmentSet(Map<String, Participant> participantsMap, AuthzGroup realm, String providerCourseEid, EnrollmentSet enrollmentSet, String sectionTitle, String filterType, String filterID, Set<Member> groupMembership) {
        Set enrollments;
        boolean refreshed = false;
        if (enrollmentSet != null && (enrollments = cms.getEnrollments(enrollmentSet.getEid())) != null) {
            Map<String, User> eidToUserMap = SiteParticipantHelper.getEidUserMapFromCollection(enrollments);
            for (Enrollment e : enrollments) {
                if (e.isDropped()) continue;
                try {
                    User user = eidToUserMap.get(e.getUserId());
                    if (user == null) {
                        throw new UserNotDefinedException(e.getUserId());
                    }
                    String userId = user.getId();
                    Member member = realm.getMember(userId);
                    if (member == null && !refreshed) {
                        try {
                            refreshed = true;
                            AuthzGroup realmEdit = authzGroupService.getAuthzGroup(realm.getId());
                            authzGroupService.save(realmEdit);
                            realm = authzGroupService.getAuthzGroup(realm.getId());
                            member = realm.getMember(userId);
                        }
                        catch (Exception exc) {
                            log.warn("SiteParticipantHelper.addParticipantsFromEnrollment " + exc.getMessage());
                        }
                    }
                    if (member == null) continue;
                    try {
                        Participant participant;
                        if (participantsMap.containsKey(userId)) {
                            participant = participantsMap.get(userId);
                            if (!participant.getSectionEidList().contains(sectionTitle)) {
                                participant.addSectionEidToList(sectionTitle);
                            }
                            if (StringUtils.isNotBlank((CharSequence)e.getCredits())) {
                                participant.credits = participant.credits.concat(", <br />" + e.getCredits());
                            }
                        } else {
                            participant = new Participant();
                            participant.credits = e.getCredits() != null ? e.getCredits() : "";
                            String statusId = Optional.ofNullable(e.getEnrollmentStatus()).orElse("");
                            participant.enrollmentStatus = cms.getEnrollmentStatusDescription(statusId);
                            participant.name = user.getSortName();
                            if (member.isProvided()) {
                                participant.providerRole = member.getRole() != null ? member.getRole().getId() : "";
                                participant.removeable = false;
                            } else {
                                participant.providerRole = "";
                                participant.removeable = true;
                            }
                            participant.regId = cus != null ? cus.getUserDisplayId(user, "Site Info") : user.getDisplayId();
                            participant.role = member.getRole() != null ? member.getRole().getId() : "";
                            participant.addSectionEidToList(sectionTitle);
                            participant.uniqname = userId;
                            participant.active = member.isActive();
                        }
                        SiteParticipantHelper.conditionallyAddParticipantToMap(participantsMap, filterType, filterID, userId, participant, groupMembership);
                    }
                    catch (Exception ee) {
                        log.warn("SiteParticipantHelper.addParticipantsFromEnrollmentSet: " + ee.getMessage() + " user id = " + userId, (Throwable)ee);
                    }
                }
                catch (UserNotDefinedException exception) {
                    log.warn("SiteParticipantHelper.addParticipantsFromEnrollmentSet: " + exception.getMessage() + " user id = " + e.getUserId());
                }
            }
        }
    }

    private static void conditionallyAddParticipantToMap(Map<String, Participant> participantsMap, String filterType, String filterID, String userID, Participant participant, Set<Member> groupMembership) {
        if ("[role]".equals(filterType) && participant.role.equals(filterID) || "[all]".equals(filterType) || StringUtils.isEmpty((CharSequence)filterType) || "[section]".equals(filterType)) {
            participantsMap.put(userID, participant);
        } else if ("[group]".equals(filterType) && groupMembership != null) {
            for (Member m : groupMembership) {
                if (!userID.equals(m.getUserId())) continue;
                participantsMap.put(userID, participant);
            }
        }
    }

    public static Map<String, User> getEidUserMapFromCollection(Collection<Object> cObjects) {
        HashSet<String> rvEids = new HashSet<String>();
        for (Object cObject : cObjects) {
            if (cObject instanceof Enrollment) {
                rvEids.add(((Enrollment)cObject).getUserId());
                continue;
            }
            if (cObject instanceof Membership) {
                rvEids.add(((Membership)cObject).getUserId());
                continue;
            }
            if (!(cObject instanceof Member)) continue;
            rvEids.add(((Member)cObject).getUserEid());
        }
        HashMap<String, User> eidToUserMap = new HashMap<String, User>();
        List rvUsers = UserDirectoryService.getUsersByEids(rvEids);
        for (User user : rvUsers) {
            eidToUserMap.put(user.getEid(), user);
        }
        return eidToUserMap;
    }

    public static void addParticipantsFromMemberships(Map participantsMap, AuthzGroup realm, Set memberships, String sectionTitle, String filterType, String filterID, Set<Member> groupMembership) {
        boolean refreshed = false;
        if (memberships != null) {
            Map<String, User> eidToUserMap = SiteParticipantHelper.getEidUserMapFromCollection(memberships);
            for (Membership m : memberships) {
                try {
                    Participant participant;
                    User user = eidToUserMap.get(m.getUserId());
                    if (user == null) {
                        throw new UserNotDefinedException(m.getUserId());
                    }
                    String userId = user.getId();
                    Member member = realm.getMember(userId);
                    if (member == null && !refreshed) {
                        try {
                            refreshed = true;
                            AuthzGroup realmEdit = authzGroupService.getAuthzGroup(realm.getId());
                            authzGroupService.save(realmEdit);
                            realm = authzGroupService.getAuthzGroup(realm.getId());
                            member = realm.getMember(userId);
                        }
                        catch (Exception exc) {
                            log.warn("SiteParticipantHelper:addParticipantsFromMembership " + exc.getMessage());
                        }
                    }
                    if (member == null) continue;
                    if (participantsMap.containsKey(userId)) {
                        participant = (Participant)participantsMap.get(userId);
                        participant.addSectionEidToList(sectionTitle);
                    } else {
                        participant = new Participant();
                        participant.credits = "";
                        participant.name = user.getSortName();
                        if (member.isProvided()) {
                            participant.providerRole = member.getRole() != null ? member.getRole().getId() : "";
                            participant.removeable = false;
                        }
                        participant.regId = user.getDisplayId();
                        participant.role = member.getRole() != null ? member.getRole().getId() : "";
                        participant.addSectionEidToList(sectionTitle);
                        participant.uniqname = userId;
                        participant.active = member.isActive();
                    }
                    SiteParticipantHelper.conditionallyAddParticipantToMap(participantsMap, filterType, filterID, userId, participant, groupMembership);
                }
                catch (UserNotDefinedException exception) {
                    log.debug("SiteParticipantHelper:addParticipantsFromMemberships: user not defined id = " + m.getUserId());
                }
            }
        }
    }

    public static void addParticipantsFromMemberships(Map participantsMap, AuthzGroup realm, Set memberships, String sectionTitle) {
        SiteParticipantHelper.addParticipantsFromMemberships(participantsMap, realm, memberships, sectionTitle, null, null, null);
    }

    private static void addParticipantsFromMembers(Map<String, Participant> participantsMap, Set grants, String realmId, String filterType, String filterID, Set<Member> groupMembership) {
        Map<String, User> eidToUserMap = SiteParticipantHelper.getEidUserMapFromCollection(grants);
        boolean refreshed = false;
        for (Member g : grants) {
            Participant participant;
            String userId;
            try {
                User user = eidToUserMap.get(g.getUserEid());
                if (user == null) {
                    throw new UserNotDefinedException(g.getUserEid());
                }
                userId = user.getId();
                if (participantsMap.containsKey(userId)) continue;
                if (g.isProvided()) {
                    if (refreshed) continue;
                    refreshed = true;
                    try {
                        AuthzGroup realmEdit = authzGroupService.getAuthzGroup(realmId);
                        authzGroupService.save(realmEdit);
                    }
                    catch (Exception exc) {
                        log.warn("SiteParticipantHelper:addParticipantsFromMembers " + exc.getMessage());
                    }
                    continue;
                }
                participant = participantsMap.containsKey(userId) ? participantsMap.get(userId) : new Participant();
                participant.name = user.getSortName();
                participant.regId = user.getDisplayId();
                participant.uniqname = userId;
                participant.role = g.getRole() != null ? g.getRole().getId() : "";
                participant.removeable = true;
                participant.active = g.isActive();
                SiteParticipantHelper.conditionallyAddParticipantToMap(participantsMap, filterType, filterID, userId, participant, groupMembership);
            }
            catch (UserNotDefinedException e) {
                if ("admins".equals(showOrphanedMembers) && securityService.isSuperUser() || "maintainers".equals(showOrphanedMembers)) {
                    userId = g.getUserId();
                    participant = new Participant();
                    participant.name = SiteParticipantHelper.makeUserDisplayName(userId);
                    participant.uniqname = userId;
                    participant.role = g.getRole() != null ? g.getRole().getId() : "";
                    participant.removeable = true;
                    participant.active = g.isActive();
                    SiteParticipantHelper.conditionallyAddParticipantToMap(participantsMap, filterType, filterID, userId, participant, groupMembership);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("SiteParticipantHelper:addParticipantsFromMembers: user not defined " + g.getUserEid());
            }
        }
    }

    private static String getExternalRealmId(String siteId) {
        String realmId = SiteService.siteReference((String)siteId);
        String rv = null;
        try {
            AuthzGroup realm = authzGroupService.getAuthzGroup(realmId);
            rv = realm.getProviderGroupId();
        }
        catch (GroupNotDefinedException e) {
            log.warn("SiteParticipantHelper.getExternalRealmId: site realm not found " + realmId);
        }
        return rv;
    }

    public static List<String> getProviderCourseList(String siteId) {
        String id = SiteParticipantHelper.getExternalRealmId(siteId);
        Vector<String> rv = new Vector<String>();
        if (id == null || NULL_STRING.equals(id)) {
            return rv;
        }
        String[] courseIds = groupProvider.unpackId(id);
        for (int i = 0; i < courseIds.length; ++i) {
            String courseId = courseIds[i];
            rv.add(courseId);
        }
        return rv;
    }

    public static Set<Member> setGroupMembership(String siteID, String groupID) {
        Set<Object> groupMembership = new HashSet<Member>();
        try {
            Set members;
            Group group;
            Site site = SiteService.getSite((String)siteID);
            if (site != null && (group = site.getGroup(groupID)) != null && (members = group.getMembers()) != null) {
                groupMembership = members;
            }
        }
        catch (IdUnusedException ex) {
            log.warn("SiteParticipantHelper.addParticipantsFromGroupMembership: {} siteID={}", (Object)ex.getMessage(), (Object)siteID);
        }
        return groupMembership;
    }

    public static Collection<Participant> prepareParticipants(String siteID, List<String> providerCourseList) {
        return SiteParticipantHelper.prepareParticipants(siteID, providerCourseList, null, null);
    }

    public static Collection<Participant> prepareParticipants(String siteId, List<String> providerCourseList, String filterType, String filterID) {
        boolean isSectionFilter = false;
        ConcurrentHashMap<String, Participant> participantsMap = new ConcurrentHashMap<String, Participant>();
        HashSet<Member> groupMembership = new HashSet();
        if ("[group]".equals(filterType)) {
            groupMembership = SiteParticipantHelper.setGroupMembership(siteId, filterID);
        } else if ("[section]".equals(filterType)) {
            isSectionFilter = true;
        }
        String realmId = SiteService.siteReference((String)siteId);
        try {
            Set nonProvidedMembers;
            AuthzGroup realm = authzGroupService.getAuthzGroup(realmId);
            realm.getProviderGroupId();
            if (providerCourseList != null) {
                for (String sectionEID : providerCourseList) {
                    if (isSectionFilter && (!isSectionFilter || !sectionEID.equals(filterID))) continue;
                    try {
                        Set courseSetEIDs;
                        CourseOffering courseOffering;
                        Section section = cms.getSection(sectionEID);
                        if (section == null) continue;
                        String sectionTitle = section.getTitle();
                        EnrollmentSet enrollmentSet = section.getEnrollmentSet();
                        SiteParticipantHelper.addParticipantsFromEnrollmentSet(participantsMap, realm, sectionEID, enrollmentSet, sectionTitle, filterType, filterID, groupMembership);
                        SiteParticipantHelper.addOfficialInstructorOfRecord(participantsMap, realm, sectionTitle, enrollmentSet, filterType, filterID, groupMembership);
                        Set memberships = cms.getSectionMemberships(sectionEID);
                        if (memberships != null && !memberships.isEmpty()) {
                            SiteParticipantHelper.addParticipantsFromMemberships(participantsMap, realm, memberships, sectionTitle, filterType, filterID, groupMembership);
                        }
                        if ((courseOffering = cms.getCourseOffering(section.getCourseOfferingEid())) == null) continue;
                        Set coMemberships = cms.getCourseOfferingMemberships(section.getCourseOfferingEid());
                        if (coMemberships != null && !coMemberships.isEmpty()) {
                            SiteParticipantHelper.addParticipantsFromMemberships(participantsMap, realm, coMemberships, courseOffering.getTitle(), filterType, filterID, groupMembership);
                        }
                        if ((courseSetEIDs = courseOffering.getCourseSetEids()) == null) continue;
                        for (String courseSetEID : courseSetEIDs) {
                            Set courseSetMemberships;
                            CourseSet courseSet = cms.getCourseSet(courseSetEID);
                            if (courseSet == null || (courseSetMemberships = cms.getCourseSetMemberships(courseSetEID)) == null || courseSetMemberships.isEmpty()) continue;
                            SiteParticipantHelper.addParticipantsFromMemberships(participantsMap, realm, courseSetMemberships, courseSet.getTitle(), filterType, filterID, groupMembership);
                        }
                    }
                    catch (IdNotFoundException e) {
                        log.warn("SiteParticipantHelper.prepareParticipants: {} sectionId={}", (Object)e.getMessage(), (Object)sectionEID);
                    }
                }
            }
            if (!isSectionFilter && (nonProvidedMembers = realm.getMembers()) != null && !nonProvidedMembers.isEmpty()) {
                SiteParticipantHelper.addParticipantsFromMembers(participantsMap, nonProvidedMembers, realmId, filterType, filterID, groupMembership);
            }
        }
        catch (GroupNotDefinedException ee) {
            log.warn("SiteParticipantHelper.prepareParticipants:  IdUnusedException {}", (Object)realmId);
        }
        return participantsMap.values();
    }

    private static void addOfficialInstructorOfRecord(Map<String, Participant> participantsMap, AuthzGroup realm, String sectionTitle, EnrollmentSet enrollmentSet, String filterType, String filterID, Set<Member> groupMembership) {
        Set instructorEids;
        if (enrollmentSet != null && (instructorEids = cms.getInstructorsOfRecordIds(enrollmentSet.getEid())) != null && instructorEids.size() > 0) {
            for (String userEid : instructorEids) {
                try {
                    Participant participant;
                    User user = UserDirectoryService.getUserByEid((String)userEid);
                    String userId = user.getId();
                    Member member = realm.getMember(userId);
                    if (member == null) continue;
                    if (participantsMap.containsKey(userId)) {
                        participant = participantsMap.get(userId);
                        if (!participant.section.contains(sectionTitle)) {
                            participant.section = participant.section.concat(", <br />" + sectionTitle);
                        }
                    } else {
                        participant = new Participant();
                        participant.credits = "";
                        participant.name = user.getSortName();
                        if (member.isProvided()) {
                            participant.providerRole = member.getRole() != null ? member.getRole().getId() : "";
                            participant.removeable = false;
                        }
                        participant.regId = user.getDisplayId();
                        participant.removeable = false;
                        participant.role = member.getRole() != null ? member.getRole().getId() : "";
                        participant.section = sectionTitle;
                        participant.uniqname = userId;
                        participant.active = member.isActive();
                    }
                    SiteParticipantHelper.conditionallyAddParticipantToMap(participantsMap, filterType, filterID, userId, participant, groupMembership);
                }
                catch (UserNotDefinedException exception) {
                    log.warn(exception.getMessage());
                }
            }
        }
    }

    public static Set<String> getRestrictedRoles(String siteType) {
        HashSet<String> retVal = new HashSet<String>();
        retVal.addAll(Arrays.asList(ArrayUtils.nullToEmpty((String[])scs.getStrings(SAK_PROP_RESTRICTED_ROLES))));
        if (siteType != null && !"".equals(siteType)) {
            retVal.addAll(Arrays.asList(ArrayUtils.nullToEmpty((String[])scs.getStrings("sitemanage.addParticipants.restrictedRoles." + siteType))));
        }
        return retVal;
    }

    public static List<Role> getAllowedRoles(String siteType, List<Role> allRolesForSiteType) {
        ArrayList<Role> retVal = new ArrayList<Role>();
        if (siteType == null) {
            siteType = "";
        }
        Set<String> restrictedRoles = SiteParticipantHelper.getRestrictedRoles(siteType);
        for (Role role : allRolesForSiteType) {
            if (!authzGroupService.isRoleAssignable(role.getId())) continue;
            if (securityService.isSuperUser() || restrictedRoles.isEmpty()) {
                retVal.add(role);
                continue;
            }
            if (restrictedRoles.contains(role.getId()) || restrictedRoles.contains(role.getId().toLowerCase())) continue;
            retVal.add(role);
        }
        return retVal;
    }

    public static List<Role> getAllowedRoles(String siteType, Set<Role> allRolesForSiteType) {
        ArrayList<Role> list = new ArrayList<Role>(allRolesForSiteType.size());
        list.addAll(allRolesForSiteType);
        return SiteParticipantHelper.getAllowedRoles(siteType, list);
    }

    public static String makeUserDisplayName(String userId) {
        String userDisplayName = NULL_STRING;
        userDisplayName = rb.getFormattedMessage("udp.unregistered", new Object[]{userId});
        return userDisplayName;
    }
}

