/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.siteassociation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.siteassociation.api.SiteAssocManager;
import org.sakaiproject.siteassociation.impl.AssociationImpl;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class SiteAssocManagerImpl
extends HibernateDaoSupport
implements SiteAssocManager {
    private SiteService siteService;
    private static final String NULL_ARG = "Null Argument";
    private static final String TO_CONTEXT = "toContext";
    private static final String FROM_CONTEXT = "fromContext";

    public void addAssociation(String fromContext, String toContext) {
        if (fromContext == null || toContext == null) {
            throw new IllegalArgumentException(NULL_ARG);
        }
        AssociationImpl association = new AssociationImpl(fromContext, toContext);
        if (this.getHibernateTemplate().get(AssociationImpl.class, (Serializable)association) == null) {
            this.getHibernateTemplate().save((Object)new AssociationImpl(fromContext, toContext));
        }
    }

    public List<String> getAssociatedTo(final String context) {
        if (context == null) {
            throw new IllegalArgumentException(NULL_ARG);
        }
        List associations = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.createCriteria(AssociationImpl.class).add((Criterion)Restrictions.eq((String)SiteAssocManagerImpl.TO_CONTEXT, (Object)context)).list();
            }
        });
        ArrayList<String> fromContexts = new ArrayList<String>();
        for (AssociationImpl ass : associations) {
            fromContexts.add(ass.getFromContext());
        }
        return fromContexts;
    }

    public List<String> getAssociatedFrom(final String context) {
        if (context == null) {
            throw new IllegalArgumentException(NULL_ARG);
        }
        List associations = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.createCriteria(AssociationImpl.class).add((Criterion)Restrictions.eq((String)SiteAssocManagerImpl.FROM_CONTEXT, (Object)context)).list();
            }
        });
        ArrayList<String> toContexts = new ArrayList<String>();
        for (AssociationImpl ass : associations) {
            toContexts.add(ass.getToContext());
        }
        return toContexts;
    }

    public Site getSite(String context) {
        try {
            return this.siteService.getSite(context);
        }
        catch (IdUnusedException idUnusedException) {
            return null;
        }
    }

    public void removeAssociation(String fromContext, String toContext) {
        if (fromContext == null || toContext == null) {
            throw new IllegalArgumentException(NULL_ARG);
        }
        AssociationImpl association = (AssociationImpl)this.getHibernateTemplate().get(AssociationImpl.class, (Serializable)new AssociationImpl(fromContext, toContext));
        if (association != null) {
            this.getHibernateTemplate().delete((Object)association);
        }
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

