/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.siteassociation.tool.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.jsf.util.JsfTool;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.ActiveToolManager;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.util.Web;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteAssocJsfTool
extends JsfTool {
    private static final long serialVersionUID = -976719461956856669L;
    private static final Logger logger = LoggerFactory.getLogger(SiteAssocJsfTool.class);
    private SessionManager sessionManager;
    private ActiveToolManager activeToolManager;
    private ToolManager toolManager;
    private static final String HELPER_EXT = ".helper";
    private static final String PANEL = "panel";
    private static final String HELPER_SESSION_PREFIX = "session.";
    private static final String MYFACES_VIEW_COLLECTION = "org.apache.myfaces.application.jsp.JspStateManagerImpl.SERIALIZED_VIEW";
    private static final String STORED_MYFACES_VIEW_COLLECTION = "STORED_org.apache.myfaces.application.jsp.JspStateManagerImpl.SERIALIZED_VIEW";
    public static final String HELPER_RETURN_NOTIFICATION = "/returnToSender";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.sessionManager = (SessionManager)ComponentManager.get((String)"org.sakaiproject.tool.api.SessionManager");
        this.activeToolManager = (ActiveToolManager)ComponentManager.get((String)"org.sakaiproject.tool.api.ActiveToolManager");
        this.toolManager = (ToolManager)ComponentManager.get((String)"org.sakaiproject.tool.api.ToolManager");
    }

    protected void dispatch(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestDispatcher resourceDispatcher;
        logger.debug("dispatch()");
        String target = req.getPathInfo();
        ToolSession session = this.sessionManager.getCurrentToolSession();
        if (logger.isDebugEnabled()) {
            Map reqParms = req.getParameterMap();
            for (Map.Entry entry : reqParms.entrySet()) {
                String reqParmKey = (String)entry.getKey();
                StringBuffer sb = new StringBuffer();
                sb.append("REQ_PARM: ");
                sb.append(reqParmKey);
                sb.append(" = ");
                sb.append('[');
                String[] reqParm = (String[])reqParms.get(reqParmKey);
                int i = 0;
                while (i < reqParm.length) {
                    sb.append(reqParm[i]);
                    if (++i >= reqParm.length) continue;
                    sb.append(", ");
                }
                sb.append(']');
                logger.debug(sb.toString());
            }
            Enumeration sessionParmNames = session.getAttributeNames();
            while (sessionParmNames.hasMoreElements()) {
                String sessionParmName = (String)sessionParmNames.nextElement();
                logger.debug("SESS_PARM: " + sessionParmName + " = " + session.getAttribute(sessionParmName));
            }
        }
        if (HELPER_RETURN_NOTIFICATION.equals(target) && (target = (String)session.getAttribute(this.toolManager.getCurrentTool().getId() + "sakai.tool.helper.done.url")) != null) {
            Object viewCollection = session.getAttribute(STORED_MYFACES_VIEW_COLLECTION);
            if (viewCollection != null) {
                session.removeAttribute(STORED_MYFACES_VIEW_COLLECTION);
                session.setAttribute(MYFACES_VIEW_COLLECTION, viewCollection);
            }
            session.removeAttribute(this.toolManager.getCurrentTool().getId() + "sakai.tool.helper.done.url");
            res.sendRedirect(target);
            return;
        }
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            if (!paramName.startsWith(HELPER_SESSION_PREFIX)) continue;
            String attributeName = paramName.substring(HELPER_SESSION_PREFIX.length());
            session.setAttribute(attributeName, (Object)req.getParameter(paramName));
        }
        if (this.sendToHelper(req, res, target)) {
            return;
        }
        if (this.isResourceRequest(target) && (resourceDispatcher = this.getServletContext().getRequestDispatcher(target)) != null) {
            resourceDispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if ("Title".equals(req.getParameter(PANEL))) {
            target = "/title.jsf";
        } else {
            if (target == null || "/".equals(target)) {
                target = this.computeDefaultTarget();
                if (!target.startsWith("/")) {
                    target = "/" + target;
                }
                res.sendRedirect(Web.returnUrl((HttpServletRequest)req, (String)target));
                return;
            }
            String newTarget = this.redirectRequestedTarget(target);
            if (!newTarget.startsWith("/")) {
                newTarget = "/" + newTarget;
            }
            if (!newTarget.equals(target)) {
                res.sendRedirect(Web.returnUrl((HttpServletRequest)req, (String)newTarget));
                return;
            }
            target = newTarget;
            if (this.m_defaultToLastView) {
                session.setAttribute("sakai.jsf.tool.last.view.visited", (Object)target);
            }
        }
        target = this.m_path + target;
        int lastSlash = target.lastIndexOf(47);
        int lastDot = target.lastIndexOf(46);
        if (lastDot < 0 || lastDot < lastSlash) {
            target = target + ".jsf";
        }
        req.setAttribute("sakai.jsf.tool.URL.path", (Object)this.m_path);
        req.setAttribute("sakai.jsf.tool.URL.ext", (Object)".jsp");
        req.setAttribute("sakai.request.native.url", (Object)"sakai.request.native.url");
        res.setContentType("text/html; charset=UTF-8");
        res.addDateHeader("Expires", System.currentTimeMillis() - 31536000000L);
        res.addDateHeader("Last-Modified", System.currentTimeMillis());
        res.addHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0");
        res.addHeader("Pragma", "no-cache");
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(target);
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        req.removeAttribute("sakai.request.native.url");
        req.removeAttribute("sakai.jsf.tool.URL.path");
        req.removeAttribute("sakai.jsf.tool.URL.ext");
    }

    protected boolean sendToHelper(HttpServletRequest req, HttpServletResponse res, String target) throws ToolException {
        Object viewCollection;
        String[] parts;
        if (target == null) {
            target = "/";
        }
        if ((parts = target.split("/")).length < 2) {
            return false;
        }
        if (!parts[1].endsWith(HELPER_EXT)) {
            return false;
        }
        int posEnd = parts[1].lastIndexOf(46);
        String helperId = target.substring(1, posEnd + 1);
        ActiveTool helperTool = this.activeToolManager.getActiveTool(helperId);
        ToolSession toolSession = this.sessionManager.getCurrentToolSession();
        if (toolSession.getAttribute(helperTool.getId() + "sakai.tool.helper.done.url") == null) {
            toolSession.setAttribute(helperTool.getId() + "sakai.tool.helper.done.url", (Object)(req.getContextPath() + req.getServletPath() + this.computeDefaultTarget()));
        }
        String context = req.getContextPath() + req.getServletPath() + Web.makePath((String[])parts, (int)1, (int)2);
        String toolPath = Web.makePath((String[])parts, (int)2, (int)parts.length);
        if (toolSession.getAttribute(STORED_MYFACES_VIEW_COLLECTION) == null && (viewCollection = toolSession.getAttribute(MYFACES_VIEW_COLLECTION)) != null) {
            toolSession.removeAttribute(MYFACES_VIEW_COLLECTION);
            toolSession.setAttribute(STORED_MYFACES_VIEW_COLLECTION, viewCollection);
        }
        helperTool.help(req, res, context, toolPath);
        return true;
    }
}

