/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.ToolInfo;

public class PrefsData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ToolInfo> toolEventsDef = new ArrayList<ToolInfo>();
    private boolean useAllTools = false;
    private boolean listToolEventsOnlyAvailableInSite = true;
    private boolean chartIn3D = false;
    private float chartTransparency = 1.0f;
    private boolean itemLabelsVisible = true;

    public List<ToolInfo> getToolEventsDef() {
        return this.toolEventsDef;
    }

    public List<String> getToolEventsStringList() {
        ArrayList<String> toolEventsStringList = new ArrayList<String>();
        for (ToolInfo t : this.getToolEventsDef()) {
            if (!t.isSelected()) continue;
            for (EventInfo e : t.getEvents()) {
                if (!e.isSelected()) continue;
                toolEventsStringList.add(e.getEventId());
            }
        }
        return toolEventsStringList;
    }

    public void setToolEventsDef(List<ToolInfo> toolEventsDef) {
        this.toolEventsDef = toolEventsDef;
    }

    public boolean isListToolEventsOnlyAvailableInSite() {
        return this.listToolEventsOnlyAvailableInSite;
    }

    public void setListToolEventsOnlyAvailableInSite(boolean listToolEventsOnlyAvailableInSite) {
        this.listToolEventsOnlyAvailableInSite = listToolEventsOnlyAvailableInSite;
    }

    public void setUseAllTools(boolean value) {
        this.useAllTools = value;
    }

    public boolean isUseAllTools() {
        return this.useAllTools;
    }

    public void setChartIn3D(boolean value) {
        this.chartIn3D = value;
    }

    public boolean isChartIn3D() {
        return this.chartIn3D;
    }

    public void setChartTransparency(float value) {
        this.chartTransparency = value;
    }

    public void setChartTransparency(String value) {
        this.chartTransparency = Float.parseFloat(value);
    }

    public float getChartTransparency() {
        return this.chartTransparency;
    }

    public void setItemLabelsVisible(boolean itemLabelsVisible) {
        this.itemLabelsVisible = itemLabelsVisible;
    }

    public boolean isItemLabelsVisible() {
        return this.itemLabelsVisible;
    }

    public String toXmlPrefs() {
        StringBuffer buff = new StringBuffer();
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        buff.append("<prefs ");
        buff.append(" listToolEventsOnlyAvailableInSite=\"" + this.isListToolEventsOnlyAvailableInSite() + "\" ");
        buff.append(" chartIn3D=\"" + this.isChartIn3D() + "\" ");
        buff.append(" chartTransparency=\"" + this.getChartTransparency() + "\" ");
        buff.append(" itemLabelsVisible=\"" + this.isItemLabelsVisible() + "\" ");
        buff.append(" useAllTools=\"" + this.isUseAllTools() + "\" ");
        buff.append(">");
        buff.append("\t<toolEventsDef>");
        for (ToolInfo t : this.getToolEventsDef()) {
            buff.append("\t\t<tool toolId=\"" + t.getToolId() + "\" selected=\"" + t.isSelected() + "\">");
            for (EventInfo e : t.getEvents()) {
                buff.append("\t\t\t<event eventId=\"" + e.getEventId() + "\" selected=\"" + e.isSelected() + "\" />");
            }
            buff.append("\t\t</tool>");
        }
        buff.append("\t</toolEventsDef>");
        buff.append("</prefs>");
        return buff.toString();
    }
}

