/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.api.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.parser.EventParserTip;

public class ToolInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String toolId;
    private List<String> additionalToolIds;
    private List<EventInfo> eventInfos;
    private boolean selected;
    private EventParserTip eventParserTip;

    public ToolInfo(String toolId) {
        this.toolId = toolId;
        this.eventInfos = new ArrayList<EventInfo>();
    }

    public ToolInfo(String toolId, List<String> additionalToolIds) {
        this.toolId = toolId;
        this.additionalToolIds = additionalToolIds;
        this.eventInfos = new ArrayList<EventInfo>();
    }

    public ToolInfo(ToolInfo tool) {
        this.toolId = tool.toolId;
        this.additionalToolIds = tool.additionalToolIds != null ? new ArrayList<String>(tool.additionalToolIds) : null;
        this.eventInfos = new ArrayList<EventInfo>(tool.eventInfos.size());
        for (EventInfo info : tool.eventInfos) {
            this.eventInfos.add(info.clone());
        }
        this.selected = tool.selected;
        this.eventParserTip = tool.eventParserTip != null ? tool.eventParserTip.clone() : null;
    }

    public ToolInfo clone() {
        return new ToolInfo(this);
    }

    public List<EventInfo> getEvents() {
        return this.eventInfos;
    }

    public void setEvents(List<EventInfo> eventInfos) {
        this.eventInfos = eventInfos;
    }

    public void addEvent(EventInfo eventInfo) {
        this.eventInfos.add(eventInfo);
    }

    public void removeEvent(EventInfo eventInfo) {
        this.eventInfos.remove(eventInfo);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getToolId() {
        return this.toolId;
    }

    public void setToolId(String toolId) {
        this.toolId = toolId;
    }

    public List<String> getAdditionalToolIds() {
        return this.additionalToolIds;
    }

    public void setAdditionalToolIds(List<String> ids) {
        this.additionalToolIds = ids;
    }

    public void setAdditionalToolIdsStr(String ids) {
        if (ids != null) {
            this.additionalToolIds = new ArrayList<String>();
            String[] _ids = ids.split(",");
            for (int i = 0; i < _ids.length; ++i) {
                this.additionalToolIds.add(_ids[i].trim());
            }
        }
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof ToolInfo)) {
            return false;
        }
        ToolInfo other = (ToolInfo)arg0;
        return this.getToolId().equals(other.getToolId());
    }

    public int hashCode() {
        return this.getToolId().hashCode();
    }

    public EventParserTip getEventParserTip() {
        return this.eventParserTip;
    }

    public void setEventParserTip(EventParserTip eventParserTip) {
        this.eventParserTip = eventParserTip;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("ToolInfo: " + this.getToolId() + " [" + this.isSelected() + "]");
        if (this.additionalToolIds != null) {
            Iterator<String> i = this.additionalToolIds.iterator();
            while (i.hasNext()) {
                buff.append("/" + i.next());
            }
        }
        buff.append("\n");
        for (EventInfo e : this.getEvents()) {
            buff.append(e.toString());
        }
        return buff.toString();
    }
}

