/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.api.report;

import java.io.Serializable;
import java.util.Date;
import org.sakaiproject.sitestats.api.report.ReportParams;

public class ReportDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String siteId;
    private String title;
    private String description;
    private boolean hidden = false;
    private ReportParams reportParams;
    private String reportDefinitionXml;
    private Date createdOn;
    private String createdBy;
    private Date modifiedOn;
    private String modifiedBy;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isTitleLocalized() {
        return this.isStringLocalized(this.title);
    }

    public String getTitleBundleKey() {
        if (this.isStringLocalized(this.title)) {
            return this.title.substring(2, this.title.length() - 1);
        }
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDescriptionLocalized() {
        return this.isStringLocalized(this.description);
    }

    public String getDescriptionBundleKey() {
        if (this.isStringLocalized(this.description)) {
            return this.description.substring(2, this.description.length() - 1);
        }
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public ReportParams getReportParams() {
        if (this.reportParams == null) {
            this.reportParams = new ReportParams(this.siteId);
        }
        return this.reportParams;
    }

    public void setReportParams(ReportParams reportParams) {
        this.reportParams = reportParams;
    }

    public String getReportDefinitionXml() {
        return this.reportDefinitionXml;
    }

    public void setReportDefinitionXml(String prefs) {
        this.reportDefinitionXml = prefs;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date date) {
        this.createdOn = date;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String author) {
        this.createdBy = author;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(Date date) {
        this.modifiedOn = date;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String author) {
        this.modifiedBy = author;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ReportDef)) {
            return false;
        }
        ReportDef other = (ReportDef)o;
        return this.id == other.getId() && this.siteId.equals(other.getSiteId()) && this.title.equals(other.getTitle()) && this.description.equals(other.getDescription()) && this.hidden == other.isHidden() && this.reportParams.equals(other.getReportParams()) && this.reportDefinitionXml.equals(other.getReportDefinitionXml()) && this.createdBy.equals(other.getCreatedBy()) && this.createdOn.equals(other.getCreatedOn()) && this.modifiedBy.equals(other.getModifiedBy()) && this.modifiedOn.equals(other.getModifiedOn());
    }

    public int hashCode() {
        String hashStr = this.getClass().getName() + ":" + this.getId() + this.getSiteId().hashCode() + this.getTitle().hashCode() + this.getDescription().hashCode() + Boolean.toString(this.isHidden()).hashCode() + this.getReportParams().hashCode() + this.getReportDefinitionXml().hashCode() + this.getCreatedBy().hashCode() + this.getCreatedOn().hashCode() + this.getModifiedBy().hashCode() + this.getModifiedOn().hashCode();
        return hashStr.hashCode();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeXml) {
        String context = this.siteId != null ? "Listed for siteId=" + this.siteId : "Predefined report";
        String str = context + " : Title=" + this.title + " : Description=" + this.description + " : Parameters=" + this.reportParams;
        if (includeXml) {
            str = str + " : ParametersXml=" + this.reportDefinitionXml;
        }
        return str;
    }

    private boolean isStringLocalized(String string) {
        return string != null && string.startsWith("${") && string.endsWith("}");
    }
}

