/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.api.report;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sakaiproject.sitestats.api.StatsManager;

public class ReportParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String siteId;
    private String what = "what-visits";
    private String whatEventSelType = "what-events-bytool";
    private List<String> whatToolIds = new ArrayList<String>();
    private List<String> whatEventIds = new ArrayList<String>();
    private boolean whatLimitedAction = false;
    private boolean whatLimitedResourceIds = false;
    private List<String> whatResourceIds = new ArrayList<String>();
    private String whatResourceAction = "new";
    private String when = "when-last7days";
    private Date whenFrom;
    private Date whenTo;
    private String who = "who-all";
    private String whoRoleId;
    private String whoGroupId;
    private List<String> whoUserIds = new ArrayList<String>();
    private List<String> howTotalsBy = new ArrayList<String>();
    private boolean howSort = false;
    private String howSortBy = "default";
    private boolean howSortAscending = true;
    public boolean howLimitedMaxResults = false;
    private Integer howMaxResults = 0;
    private String howPresentationMode = "how-presentation-table";
    private String howChartType = "bar";
    private String howChartSource = "event";
    private String howChartCategorySource = "none";
    private String howChartSeriesSource = "total";
    private String howChartSeriesPeriod = "byday";

    public ReportParams() {
    }

    public ReportParams(String siteId) {
        this.siteId = siteId;
        this.whatToolIds.add("all");
        ZonedDateTime today = ZonedDateTime.now(ZoneId.systemDefault()).truncatedTo(ChronoUnit.DAYS);
        ZonedDateTime yesterday = today.minusDays(1L);
        this.whenFrom = Date.from(yesterday.toInstant());
        this.whenTo = Date.from(today.toInstant());
    }

    public ReportParams(String siteId, String what, List<String> whatToolIds, List<String> whatEventIds, String whatResourceAction, List<String> whatResourceIds, String when, Date whenFrom, Date whenTo, String who, String whoRoleId, String whoGroupId, List<String> whoUserIds) {
        this.siteId = siteId;
        this.what = what;
        this.whatToolIds = whatToolIds;
        this.whatEventIds = whatEventIds;
        this.whatResourceAction = whatResourceAction;
        this.whatLimitedAction = whatResourceAction != null;
        this.whatResourceIds = whatResourceIds;
        this.whatLimitedResourceIds = whatResourceIds != null;
        this.when = when;
        this.whenFrom = whenFrom;
        this.whenTo = whenTo;
        this.who = who;
        this.whoRoleId = whoRoleId;
        this.whoGroupId = whoGroupId;
        this.whoUserIds = whoUserIds;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getWhat() {
        return this.what;
    }

    public void setWhat(String what) {
        this.what = what;
    }

    public String getWhatEventSelType() {
        return this.whatEventSelType;
    }

    public void setWhatEventSelType(String whatEventSelType) {
        this.whatEventSelType = whatEventSelType;
    }

    public List<String> getWhatEventIds() {
        return this.whatEventIds;
    }

    public void setWhatEventIds(List<String> whatEventIds) {
        this.whatEventIds = whatEventIds;
    }

    public void addWhatEventId(String whatEventId) {
        this.whatEventIds.add(whatEventId);
    }

    public void setWhatLimitedAction(boolean whatLimitedAction) {
        this.whatLimitedAction = whatLimitedAction;
    }

    public boolean isWhatLimitedAction() {
        return this.whatLimitedAction;
    }

    public void setWhatLimitedResourceIds(boolean whatLimitedResourceIds) {
        this.whatLimitedResourceIds = whatLimitedResourceIds;
    }

    public boolean isWhatLimitedResourceIds() {
        return this.whatLimitedResourceIds;
    }

    public List<String> getWhatResourceIds() {
        return this.whatResourceIds;
    }

    public void setWhatResourceIds(List<String> whatResourceIds) {
        this.whatResourceIds = whatResourceIds;
    }

    public void addWhatResourceId(String whatResourceId) {
        this.whatResourceIds.add(whatResourceId);
    }

    public String getWhatResourceAction() {
        return this.whatResourceAction;
    }

    public void setWhatResourceAction(String whatResourceAction) {
        this.whatResourceAction = whatResourceAction;
    }

    public List<String> getWhatToolIds() {
        return this.whatToolIds;
    }

    public void setWhatToolIds(List<String> whatToolIds) {
        this.whatToolIds = whatToolIds;
    }

    public void addWhatToolIds(String whatToolId) {
        this.whatToolIds.add(whatToolId);
    }

    public String getWhen() {
        return this.when;
    }

    public void setWhen(String when) {
        this.when = when;
    }

    public Date getWhenTo() {
        return this.whenTo;
    }

    public void setWhenTo(Date whenTo) {
        this.whenTo = whenTo;
    }

    public Date getWhenFrom() {
        return this.whenFrom;
    }

    public void setWhenFrom(Date whenFrom) {
        this.whenFrom = whenFrom;
    }

    public String getWho() {
        return this.who;
    }

    public void setWho(String who) {
        this.who = who;
    }

    public String getWhoGroupId() {
        return this.whoGroupId;
    }

    public void setWhoGroupId(String whoGroupId) {
        this.whoGroupId = whoGroupId;
    }

    public String getWhoRoleId() {
        return this.whoRoleId;
    }

    public void setWhoRoleId(String whoRoleId) {
        this.whoRoleId = whoRoleId;
    }

    public List<String> getWhoUserIds() {
        return this.whoUserIds;
    }

    public void setWhoUserIds(List<String> whoUserIds) {
        this.whoUserIds = whoUserIds;
    }

    public void addWhoUserIds(String whoUserId) {
        this.whoUserIds.add(whoUserId);
    }

    public List<String> getHowTotalsBy() {
        this.howTotalsBy = this.fixedHowTotalsBy(this.howTotalsBy);
        return this.howTotalsBy;
    }

    public void setHowTotalsBy(List<String> totalsBy) {
        this.howTotalsBy = totalsBy;
    }

    public void addHowTotalsBy(String totalsBy) {
        this.howTotalsBy.add(totalsBy);
    }

    public boolean isHowSort() {
        return this.howSort;
    }

    public void setHowSort(boolean sort) {
        this.howSort = sort;
    }

    public String getHowSortBy() {
        this.howSortBy = this.fixedHowSortBy(this.howSortBy);
        return this.howSortBy;
    }

    public void setHowSortBy(String sortBy) {
        this.howSortBy = sortBy;
    }

    public boolean getHowSortAscending() {
        return this.howSortAscending;
    }

    public void setHowSortAscending(boolean sortAscending) {
        this.howSortAscending = sortAscending;
    }

    public boolean isHowLimitedMaxResults() {
        return this.howLimitedMaxResults;
    }

    public void setHowLimitedMaxResults(boolean limitedMaxResults) {
        this.howLimitedMaxResults = limitedMaxResults;
    }

    public Integer getHowMaxResults() {
        return this.howMaxResults;
    }

    public void setHowMaxResults(Integer maxResults) {
        this.howMaxResults = maxResults == null ? Integer.valueOf(0) : maxResults;
    }

    public String getHowPresentationMode() {
        return this.howPresentationMode;
    }

    public void setHowPresentationMode(String howPresentationMode) {
        this.howPresentationMode = howPresentationMode;
    }

    public String getHowChartType() {
        return this.howChartType;
    }

    public void setHowChartType(String howChartType) {
        this.howChartType = howChartType;
    }

    public String getHowChartSource() {
        return this.howChartSource;
    }

    public void setHowChartSource(String howChartSource) {
        this.howChartSource = howChartSource;
    }

    public String getHowChartCategorySource() {
        return this.howChartCategorySource;
    }

    public void setHowChartCategorySource(String howChartCategorySource) {
        this.howChartCategorySource = howChartCategorySource;
    }

    public String getHowChartSeriesSource() {
        return this.howChartSeriesSource;
    }

    public void setHowChartSeriesSource(String howChartSeriesSource) {
        this.howChartSeriesSource = howChartSeriesSource;
    }

    public void setHowChartSeriesPeriod(String howChartSeriesPeriod) {
        this.howChartSeriesPeriod = howChartSeriesPeriod;
    }

    public String getHowChartSeriesPeriod() {
        return this.howChartSeriesPeriod;
    }

    private List<String> fixedHowTotalsBy(List<String> list) {
        List<Object> fixedList = new ArrayList();
        if (list == null || list.isEmpty()) {
            fixedList = this.getWhat().equals("what-resources") ? StatsManager.TOTALSBY_RESOURCE_DEFAULT : StatsManager.TOTALSBY_EVENT_DEFAULT;
        } else {
            for (String t : list) {
                if (t.equals("event") || t.equals("tool")) {
                    if (this.getWhat().equals("what-resources")) continue;
                    fixedList.add(t);
                    continue;
                }
                if (t.equals("resource") || t.equals("resource-action")) {
                    if (!this.getWhat().equals("what-resources")) continue;
                    fixedList.add(t);
                    continue;
                }
                if (t.equals("user")) {
                    if (this.getWhat().equals("what-visits-totals") || this.getWhat().equals("what-activity-totals")) continue;
                    fixedList.add(t);
                    continue;
                }
                if (t.equals("visits") || t.equals("unique-visits")) {
                    if (!this.getWhat().equals("what-events") && !this.getWhat().equals("what-visits-totals")) continue;
                    fixedList.add(t);
                    continue;
                }
                fixedList.add(t);
            }
        }
        return fixedList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String fixedHowSortBy(String sort) {
        if (sort == null) return "default";
        if (sort.equals("event") || sort.equals("tool")) {
            if (this.getWhat().equals("what-resources")) return sort;
            return sort;
        }
        if (sort.equals("resource") || sort.equals("resource-action")) {
            if (!this.getWhat().equals("what-resources")) return sort;
            return sort;
        }
        if (sort.equals("user")) {
            if (this.getWhat().equals("what-visits-totals") || this.getWhat().equals("what-activity-totals")) return sort;
            return sort;
        }
        if (sort.equals("visits") || sort.equals("unique-visits")) {
            if (!this.getWhat().equals("what-events") && !this.getWhat().equals("what-visits-totals")) return sort;
            return sort;
        }
        if ("total".equals(sort) || this.getHowTotalsBy().contains(sort)) return sort;
        return "default";
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('{');
        str.append(this.memberToString("siteId", this.siteId, true));
        str.append(this.memberToString("what", this.what, true));
        if ("what-events".equals(this.what)) {
            str.append(this.memberToString("whatEventSelType", this.whatEventSelType, true));
            if ("what-events-bytool".equals(this.whatEventSelType)) {
                str.append(this.memberToString("whatToolIds", this.whatToolIds, true));
            } else {
                str.append(this.memberToString("whatEventIds", this.whatEventIds, true));
            }
        } else if ("what-resources".equals(this.what)) {
            if (this.whatResourceAction != null) {
                str.append(this.memberToString("whatResourceAction", this.whatResourceAction, true));
            }
            if (this.whatResourceIds != null) {
                str.append(this.memberToString("whatResourceIds", this.whatResourceIds, true));
            }
        }
        str.append(this.memberToString("when", this.when, true));
        if ("when-custom".equals(this.when)) {
            str.append(this.memberToString("whenFrom", this.whenFrom.toString(), true));
            str.append(this.memberToString("whenTo", this.whenTo.toString(), true));
        }
        str.append(this.memberToString("who", this.who, true));
        if ("who-groups".equals(this.who)) {
            str.append(this.memberToString("whoGroupId", this.whoGroupId, true));
        }
        if ("who-role".equals(this.who)) {
            str.append(this.memberToString("whoRoleId", this.whoRoleId, true));
        }
        if ("who-custom".equals(this.who)) {
            str.append(this.memberToString("whoUserIds", this.whoUserIds, true));
        }
        str.append(this.memberToString("howTotalsBy", this.getHowTotalsBy(), true));
        str.append(this.memberToString("howSortBy", this.getHowSortBy() + ", asc? " + this.getHowSortAscending(), true));
        str.append(this.memberToString("howMaxResults", String.valueOf(this.getHowMaxResults()), true));
        String presentation = this.getHowPresentationMode();
        boolean hasChart = "how-presentation-chart".equals(presentation) || "how-presentation-both".equals(presentation);
        str.append(this.memberToString("howPresentationMode", this.getHowPresentationMode(), hasChart));
        if (hasChart) {
            str.append(this.memberToString("howChartType", this.getHowChartType(), true));
            str.append(this.memberToString("howChartSource", this.getHowChartSource(), true));
            if ("bar".equals(this.getHowChartType()) || "line".equals(this.getHowChartType()) || "pie".equals(this.getHowChartType())) {
                str.append(this.memberToString("howChartCategorySource", this.getHowChartCategorySource(), false));
            }
            if ("timeseries".equals(this.getHowChartType()) || "timeseriesbar".equals(this.getHowChartType())) {
                str.append(this.memberToString("howChartSeriesSource", this.getHowChartSeriesSource(), true));
                str.append(this.memberToString("howChartSeriesPeriod", this.getHowChartSeriesPeriod(), false));
            }
        }
        str.append('}');
        return str.toString();
    }

    private String memberToString(String member, String value, boolean hasMore) {
        StringBuilder str = new StringBuilder();
        str.append(member);
        str.append(": ");
        str.append(value);
        if (hasMore) {
            str.append(", ");
        }
        return str.toString();
    }

    private String memberToString(String member, List<String> values, boolean hasMore) {
        StringBuilder str = new StringBuilder();
        str.append(member);
        str.append(": ");
        str.append('[');
        boolean first = true;
        if (values != null) {
            for (String value : values) {
                if (!first) {
                    str.append(", ");
                }
                str.append(value);
                first = false;
            }
        }
        str.append(']');
        if (hasMore) {
            str.append(", ");
        }
        return str.toString();
    }
}

