/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import org.sakaiproject.sitestats.api.LessonBuilderStat;

public class LessonBuilderStatImpl
implements LessonBuilderStat,
Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String userId;
    private String siteId;
    private String pageRef;
    private String pageAction;
    private String pageTitle;
    private long pageId;
    private long count;
    private Date date;

    public int compareTo(LessonBuilderStat other) {
        int val = Objects.compare(this.siteId, other.getSiteId(), Comparator.nullsFirst(String::compareToIgnoreCase));
        if (val != 0) {
            return val;
        }
        val = Objects.compare(this.userId, other.getUserId(), Comparator.nullsFirst(String::compareToIgnoreCase));
        if (val != 0) {
            return val;
        }
        val = Objects.compare(this.pageRef, other.getPageRef(), Comparator.nullsFirst(String::compareToIgnoreCase));
        if (val != 0) {
            return val;
        }
        val = Objects.compare(this.pageAction, other.getPageAction(), Comparator.nullsFirst(String::compareToIgnoreCase));
        if (val != 0) {
            return val;
        }
        val = Objects.compare(this.pageTitle, other.getPageTitle(), Comparator.nullsFirst(String::compareToIgnoreCase));
        if (val != 0) {
            return val;
        }
        val = Long.signum(this.pageId - other.getPageId());
        if (val != 0) {
            return val;
        }
        val = Objects.compare(this.date, other.getDate(), Comparator.nullsFirst(Date::compareTo));
        if (val != 0) {
            return val;
        }
        val = Long.signum(this.count - other.getCount());
        if (val != 0) {
            return val;
        }
        val = Long.signum(this.id - other.getId());
        return val;
    }

    public long getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getPageRef() {
        return this.pageRef;
    }

    public String getPageAction() {
        return this.pageAction;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public long getPageId() {
        return this.pageId;
    }

    public long getCount() {
        return this.count;
    }

    public Date getDate() {
        return this.date;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setPageRef(String pageRef) {
        this.pageRef = pageRef;
    }

    public void setPageAction(String pageAction) {
        this.pageAction = pageAction;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LessonBuilderStatImpl)) {
            return false;
        }
        LessonBuilderStatImpl other = (LessonBuilderStatImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$pageRef = this.getPageRef();
        String other$pageRef = other.getPageRef();
        if (this$pageRef == null ? other$pageRef != null : !this$pageRef.equals(other$pageRef)) {
            return false;
        }
        String this$pageAction = this.getPageAction();
        String other$pageAction = other.getPageAction();
        if (this$pageAction == null ? other$pageAction != null : !this$pageAction.equals(other$pageAction)) {
            return false;
        }
        String this$pageTitle = this.getPageTitle();
        String other$pageTitle = other.getPageTitle();
        if (this$pageTitle == null ? other$pageTitle != null : !this$pageTitle.equals(other$pageTitle)) {
            return false;
        }
        if (this.getPageId() != other.getPageId()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LessonBuilderStatImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $pageRef = this.getPageRef();
        result = result * 59 + ($pageRef == null ? 43 : $pageRef.hashCode());
        String $pageAction = this.getPageAction();
        result = result * 59 + ($pageAction == null ? 43 : $pageAction.hashCode());
        String $pageTitle = this.getPageTitle();
        result = result * 59 + ($pageTitle == null ? 43 : $pageTitle.hashCode());
        long $pageId = this.getPageId();
        result = result * 59 + (int)($pageId >>> 32 ^ $pageId);
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public String toString() {
        return "LessonBuilderStatImpl(id=" + this.getId() + ", userId=" + this.getUserId() + ", siteId=" + this.getSiteId() + ", pageRef=" + this.getPageRef() + ", pageAction=" + this.getPageAction() + ", pageTitle=" + this.getPageTitle() + ", pageId=" + this.getPageId() + ", count=" + this.getCount() + ", date=" + this.getDate() + ")";
    }
}

