/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.io.Serializable;
import java.util.Date;
import org.sakaiproject.sitestats.api.SitePresence;
import org.springframework.util.comparator.NullSafeComparator;

public class SitePresenceImpl
implements SitePresence,
Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String siteId;
    private String userId;
    private Date date;
    private long duration;
    private Date lastVisitStartTime;

    public int compareTo(SitePresence other) {
        int val = this.siteId.compareTo(other.getSiteId());
        if (val != 0) {
            return val;
        }
        val = this.userId.compareTo(other.getUserId());
        if (val != 0) {
            return val;
        }
        val = Long.signum(this.duration - other.getDuration());
        if (val != 0) {
            return val;
        }
        val = NullSafeComparator.NULLS_HIGH.compare((Object)this.date, (Object)other.getDate());
        if (val != 0) {
            return val;
        }
        val = NullSafeComparator.NULLS_HIGH.compare((Object)this.lastVisitStartTime, (Object)other.getLastVisitStartTime());
        if (val != 0) {
            return val;
        }
        val = Long.signum(this.id - other.getId());
        return val;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SitePresenceImpl)) {
            return false;
        }
        SitePresenceImpl other = (SitePresenceImpl)o;
        return this.id == other.getId() && this.siteId.equals(other.getSiteId()) && this.userId.equals(other.getUserId()) && this.date.equals(other.getDate()) && this.duration == other.getDuration() && this.getCount() == other.getCount() && this.lastVisitStartTime == other.getLastVisitStartTime();
    }

    public int hashCode() {
        if (this.siteId == null) {
            return Integer.MIN_VALUE;
        }
        String hashStr = this.getClass().getName() + ":" + this.id + this.getSiteId().hashCode() + this.getUserId().hashCode() + this.getDate().hashCode() + this.duration + this.getLastVisitStartTime();
        return hashStr.hashCode();
    }

    public String toString() {
        return this.siteId + " : " + this.userId + " : " + this.date + " : " + this.duration + " (" + this.lastVisitStartTime + ")";
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Date getLastVisitStartTime() {
        return this.lastVisitStartTime;
    }

    public void setLastVisitStartTime(Date lastVisitStartTime) {
        this.lastVisitStartTime = lastVisitStartTime;
    }

    public Date getDate() {
        return this.date;
    }

    public long getId() {
        return this.id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setCount(long count) {
    }

    public long getCount() {
        return this.duration;
    }
}

