/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.sitestats.api.StatsUpdateManager;

public class SiteStatsMetricsEntityProvider
implements AutoRegisterEntityProvider,
ActionsExecutable,
Inputable,
Outputable,
Describeable {
    public static String PREFIX = "sitestats-metrics";
    private StatsUpdateManager statsUpdateManager;
    private DeveloperHelperService developerHelperService;

    public void setStatsUpdateManager(StatsUpdateManager statsUpdateManager) {
        this.statsUpdateManager = statsUpdateManager;
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    public Object getSampleEntity() {
        return PREFIX;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    @EntityCustomAction(action="get-all-metrics", viewKey="list")
    public ActionReturn getAllMetrics(Search search, Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Number_of_total_events_processed", this.statsUpdateManager.getNumberOfEventsProcessed());
        map.put("Reset_or_Init_time", new Date(this.statsUpdateManager.getResetTime()).toString() + "( " + this.statsUpdateManager.getResetTime() + " ms)");
        map.put("Total_time_ellapsed_since_reset", this.statsUpdateManager.getTotalTimeEllapsedSinceReset() + " ms");
        map.put("Total_time_spent_processing_events", this.statsUpdateManager.getTotalTimeInEventProcessing() + " ms");
        map.put("Number_of_events_processed_per_sec", this.statsUpdateManager.getNumberOfEventsProcessedPerSec());
        map.put("Number_of_events_generated_in_Sakai_per_sec", this.statsUpdateManager.getNumberOfEventsGeneratedPerSec());
        map.put("Average_time_spent_in_event_processing_per_event", this.statsUpdateManager.getAverageTimeInEventProcessingPerEvent() + " ms");
        map.put("Event_queue_size", this.statsUpdateManager.getQueueSize());
        map.put("Idle", this.statsUpdateManager.isIdle());
        return new ActionReturn(map);
    }

    @EntityCustomAction(action="reset-all-metrics", viewKey="list")
    public ActionReturn resetAllMetrics(Search search, Map<String, Object> params) {
        if (this.developerHelperService.isUserAdmin(this.developerHelperService.getCurrentUserReference())) {
            this.statsUpdateManager.resetMetrics();
            return new ActionReturn((Object)Boolean.TRUE);
        }
        throw new SecurityException("Only administrator can perform this action.");
    }

    @EntityCustomAction(action="get-total-events-processed", viewKey="list")
    public ActionReturn getTotalEventsProcessed(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.getNumberOfEventsProcessed());
    }

    @EntityCustomAction(action="get-reset-time", viewKey="list")
    public ActionReturn getResetTime(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.getResetTime());
    }

    @EntityCustomAction(action="get-time-ellapsed-since-reset", viewKey="list")
    public ActionReturn getTimeEllapsedSinceReset(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.getTotalTimeEllapsedSinceReset());
    }

    @EntityCustomAction(action="get-time-spent-processing-events", viewKey="list")
    public ActionReturn getTimeSpentProcessingEvents(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.getTotalTimeInEventProcessing());
    }

    @EntityCustomAction(action="get-events-processed-per-sec", viewKey="list")
    public ActionReturn getEventsProcessedPerSec(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.getNumberOfEventsProcessedPerSec());
    }

    @EntityCustomAction(action="get-events-generated-per-sec", viewKey="list")
    public ActionReturn getEventsGeneratedPerSec(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.getNumberOfEventsGeneratedPerSec());
    }

    @EntityCustomAction(action="get-average-time-event-processing-per-event", viewKey="list")
    public ActionReturn getAverageTimeInEventProcessingPerEvent(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.getAverageTimeInEventProcessingPerEvent());
    }

    @EntityCustomAction(action="get-queue-size", viewKey="list")
    public ActionReturn getQueueSize(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.getQueueSize());
    }

    @EntityCustomAction(action="is-idle", viewKey="list")
    public ActionReturn isIdle(Search search, Map<String, Object> params) {
        return new ActionReturn((Object)this.statsUpdateManager.isIdle());
    }
}

