/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.EventRegistry;
import org.sakaiproject.sitestats.api.event.EventRegistryService;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.parser.EventFactory;
import org.sakaiproject.sitestats.api.parser.ToolFactory;
import org.sakaiproject.sitestats.impl.event.EntityBrokerEventRegistry;
import org.sakaiproject.sitestats.impl.event.EventUtil;
import org.sakaiproject.sitestats.impl.event.FileEventRegistry;
import org.sakaiproject.sitestats.impl.parser.EventFactoryImpl;
import org.sakaiproject.sitestats.impl.parser.ToolFactoryImpl;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.util.ResourceLoader;

public class EventRegistryServiceImpl
implements EventRegistry,
EventRegistryService,
Observer {
    private static Log LOG = LogFactory.getLog(EventRegistryServiceImpl.class);
    private static final String CACHENAME = EventRegistryServiceImpl.class.getName();
    private static final String CACHENAME_EVENTREGISTRY = "eventRegistry";
    private static ResourceLoader msgs = new ResourceLoader("Messages");
    private Set<String> toolEventIds = null;
    private Set<String> anonymousToolEventIds = null;
    private Map<String, ToolInfo> eventIdToolMap = null;
    private Map<String, String> toolIdIconMap = null;
    private boolean checkLocalEventNamesFirst = false;
    private FileEventRegistry fileEventRegistry = null;
    private EntityBrokerEventRegistry entityBrokerEventRegistry = null;
    private List<String> serverEventIds = new ArrayList<String>();
    private Cache eventRegistryCache = null;
    private StatsManager M_sm;
    private SiteService M_ss;
    private ToolManager M_tm;
    private MemoryService M_ms;
    private ServerConfigurationService M_scs;

    public void setStatsManager(StatsManager m_sm) {
        this.M_sm = m_sm;
    }

    public void setSiteService(SiteService siteService) {
        this.M_ss = siteService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.M_tm = toolManager;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.M_ms = memoryService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.M_scs = serverConfigurationService;
    }

    public void setFileEventRegistry(FileEventRegistry fileEventRegistry) {
        this.fileEventRegistry = fileEventRegistry;
    }

    public void setEntityBrokerEventRegistry(EntityBrokerEventRegistry ebEventRegistry) {
        this.entityBrokerEventRegistry = ebEventRegistry;
        this.entityBrokerEventRegistry.addObserver(this);
    }

    public void setCheckLocalEventNamesFirst(boolean checkLocalEventNamesFirst) {
        this.checkLocalEventNamesFirst = checkLocalEventNamesFirst;
    }

    public void init() {
        String willCheckLocalEventNamesFirst = this.checkLocalEventNamesFirst ? "Local event names in sitestats-bundles will be checked first" : "Tool specified event names (Statisticable interface) will be checked first";
        LOG.info((Object)("init(): " + willCheckLocalEventNamesFirst));
        this.eventRegistryCache = this.M_ms.newCache(CACHENAME);
    }

    public Set<String> getEventIds() {
        if (this.toolEventIds == null) {
            this.toolEventIds = new HashSet<String>();
            this.toolEventIds.addAll(this.getEventIdToolMap().keySet());
            this.toolEventIds.add("pres.begin");
            if (this.M_sm.isEnableSitePresences()) {
                this.toolEventIds.add("pres.end");
            }
            this.toolEventIds = Collections.unmodifiableSet(this.toolEventIds);
        }
        return this.toolEventIds;
    }

    public Set<String> getAnonymousEventIds() {
        if (this.anonymousToolEventIds == null) {
            this.anonymousToolEventIds = new HashSet<String>();
            for (ToolInfo ti : this.getEventRegistry()) {
                for (EventInfo ei : ti.getEvents()) {
                    if (!ei.isAnonymous()) continue;
                    this.anonymousToolEventIds.add(ei.getEventId());
                }
            }
            this.anonymousToolEventIds = Collections.unmodifiableSet(this.anonymousToolEventIds);
        }
        return this.anonymousToolEventIds;
    }

    public List<ToolInfo> getEventRegistry() {
        return this.getEventRegistry(null, false);
    }

    public List<ToolInfo> getEventRegistry(String siteId, boolean onlyAvailableInSite) {
        if (siteId == null) {
            return this.getMergedEventRegistry();
        }
        if (onlyAvailableInSite) {
            return EventUtil.getIntersectionWithAvailableToolsInSite(this.M_ss, this.getMergedEventRegistry(), siteId);
        }
        return EventUtil.getIntersectionWithAvailableToolsInSakaiInstallation(this.M_tm, this.getMergedEventRegistry());
    }

    public boolean isEventRegistryExpired() {
        return true;
    }

    public String getEventName(String eventId) {
        if (eventId == null || eventId.trim().equals("")) {
            return "";
        }
        String eventName = null;
        Object firstEr = null;
        Object secondEr = null;
        if (this.checkLocalEventNamesFirst) {
            firstEr = this.fileEventRegistry;
            secondEr = this.entityBrokerEventRegistry;
        } else {
            firstEr = this.entityBrokerEventRegistry;
            secondEr = this.fileEventRegistry;
        }
        eventName = firstEr.getEventName(eventId);
        if (eventName == null) {
            eventName = secondEr.getEventName(eventId);
        }
        if (eventName == null) {
            LOG.warn((Object)("Missing resource bundle for event id: " + eventId));
            eventName = eventId;
        }
        return eventName;
    }

    public String getToolName(String toolId) {
        String toolName;
        if ("all".equals(toolId)) {
            return msgs.getString("all");
        }
        try {
            toolName = this.M_tm.getTool(toolId).getTitle();
        }
        catch (Exception e) {
            try {
                LOG.debug((Object)("No sakai tool found for toolId: " + toolId + " (tool undeployed?). Using bundle (if supplied) in sitestats/sitestats-impl/impl/src/bundle/org/sakaiproject/sitestats/impl/bundle/ for tool name."));
                toolName = msgs.getString(toolId, toolId);
            }
            catch (Exception e1) {
                LOG.debug((Object)("No translation found for toolId: " + toolId + " - using toolId as tool name. Please specify it in sitestats/sitestats-impl/impl/src/bundle/org/sakaiproject/sitestats/impl/bundle/"));
                toolName = toolId;
            }
        }
        return toolName;
    }

    public String getToolIcon(String toolId) {
        if (this.toolIdIconMap == null) {
            this.toolIdIconMap = new HashMap<String, String>();
            this.toolIdIconMap.put("osp.evaluation", "/library/image/silk/thumb_up.png");
            this.toolIdIconMap.put("osp.glossary", "/library/image/silk/text_list_bullets.png");
            this.toolIdIconMap.put("osp.matrix", "/library/image/silk/table.png");
            this.toolIdIconMap.put("osp.presentation", "/library/image/silk/briefcase.png");
            this.toolIdIconMap.put("osp.presLayout", "/library/image/silk/layout_content.png");
            this.toolIdIconMap.put("osp.presTemplate", "/library/image/silk/application_view_tile.png");
            this.toolIdIconMap.put("osp.style", "/library/image/silk/style.png");
            this.toolIdIconMap.put("osp.wizard", "/library/image/silk/wand.png");
            this.toolIdIconMap.put("sakai.announcements", "/library/image/silk/flag_blue.png");
            this.toolIdIconMap.put("sakai.chat", "/library/image/silk/user_comment.png");
            this.toolIdIconMap.put("sakai.datapoint", "/library/image/silk/chart_line.png");
            this.toolIdIconMap.put("sakai.discussion", "/library/image/silk/comments.png");
            this.toolIdIconMap.put("sakai.dropbox", "/library/image/silk/folder_page.png");
            this.toolIdIconMap.put("sakai.gmt", "/library/image/silk/award_star_gold_3.png");
            this.toolIdIconMap.put("sakai.help", "/library/image/silk/help.png");
            this.toolIdIconMap.put("sakai.iframe", "/library/image/silk/page_world.png");
            this.toolIdIconMap.put("sakai.iframe.site", "/library/image/silk/house.png");
            this.toolIdIconMap.put("sakai.mailbox", "/library/image/silk/email.png");
            this.toolIdIconMap.put("sakai.messages", "/library/image/silk/comment.png");
            this.toolIdIconMap.put("sakai.metaobj", "/library/image/silk/application_form.png");
            this.toolIdIconMap.put("sakai.membership", "/library/image/silk/group.png");
            this.toolIdIconMap.put("sakai.news", "/library/image/silk/rss.png");
            this.toolIdIconMap.put("sakai.podcasts", "/library/image/silk/ipod_cast.png");
            this.toolIdIconMap.put("sakai.postem", "/library/image/silk/database_table.png");
            this.toolIdIconMap.put("sakai.preferences", "/library/image/silk/cog.png");
            this.toolIdIconMap.put("sakai.rutgers.linktool", "/library/image/silk/application.png");
            this.toolIdIconMap.put("sakai.sections", "/library/image/silk/group_gear.png");
            this.toolIdIconMap.put("sakai.singleuser", "/library/image/silk/user.png");
            this.toolIdIconMap.put("sakai.syllabus", "/library/image/silk/script.png");
            this.toolIdIconMap.put("blogger", "/library/image/silk/book_edit.png");
            this.toolIdIconMap.put("sakai.assignment.grades", "/library/image/silk/page_edit.png");
            this.toolIdIconMap.put("sakai.forums", "/library/image/silk/comments.png");
            this.toolIdIconMap.put("sakai.gradebook.tool", "/library/image/silk/report.png");
            this.toolIdIconMap.put("sakai.mailtool", "/library/image/silk/email_go.png");
            this.toolIdIconMap.put("sakai.poll", "/library/image/silk/chart_bar.png");
            this.toolIdIconMap.put("sakai.sitestats", "/library/image/silk/chart_bar.png");
            this.toolIdIconMap.put("sakai.presentation", "/library/image/silk/monitor.png");
            this.toolIdIconMap.put("sakai.profile", "/library/image/silk/vcard_edit.png");
            this.toolIdIconMap.put("sakai.reports", "/library/image/silk/report_magnify.png");
            this.toolIdIconMap.put("sakai.resetpass", "/library/image/silk/key.png");
            this.toolIdIconMap.put("sakai.resources", "/library/image/silk/folder.png");
            this.toolIdIconMap.put("sakai.rwiki", "/library/image/silk/page_white_edit.png");
            this.toolIdIconMap.put("sakai.samigo", "/library/image/silk/pencil.png");
            this.toolIdIconMap.put("sakai.schedule", "/library/image/silk/calendar.png");
            this.toolIdIconMap.put("sakai.search", "/library/image/silk/find.png");
            this.toolIdIconMap.put("sakai.siteinfo", "/library/image/silk/application_lightning.png");
            this.toolIdIconMap.put("sakai.sitesetup", "/library/image/silk/application_lightning.png");
            this.toolIdIconMap.put("sakai.site.roster", "/library/image/silk/vcard.png");
            this.toolIdIconMap.put("sakai.synoptic.messagecenter", "/library/image/silk/comment.png");
            this.toolIdIconMap.put("sakai.conferencing", "/library/image/silk/webcam.png");
            this.toolIdIconMap.put("sakai.feeds", "/library/image/silk/rss.png");
            this.toolIdIconMap.put("sakai.blog", "/library/image/silk/book_edit.png");
            this.toolIdIconMap.put("sakai.blogwow", "/library/image/silk/book_edit.png");
            this.toolIdIconMap.put("sakai.yaft", "/library/image/silk/book_edit.png");
            this.toolIdIconMap.put("sakai.mneme", "/sitestats-tool/images/extra-tool-icons/mneme.png");
            this.toolIdIconMap.put("sakai.jforum.tool", "/sitestats-tool/images/extra-tool-icons/jforum.png");
            this.toolIdIconMap.put("sakai.melete", "/sitestats-tool/images/extra-tool-icons/modules.png");
            this.toolIdIconMap.put("sakai.tasklist", "/library/image/silk/note.png");
            this.toolIdIconMap.put("sakai.todolist", "/library/image/silk/note.png");
            this.toolIdIconMap.put("sakai.markup", "/library/image/silk/layout_edit.png");
            this.toolIdIconMap.put("sakai.bbb", "/library/image/silk/webcam.png");
            this.toolIdIconMap.put("sakai.basiclti", "/library/image/silk/application_go.png");
            this.toolIdIconMap.put("sakai.users", "/library/image/silk/folder_user.png");
            this.toolIdIconMap.put("sakai.aliases", "/library/image/silk/tag_blue.png");
            this.toolIdIconMap.put("sakai.sites", "/library/image/silk/application_cascade.png");
            this.toolIdIconMap.put("sakai.realms", "/library/image/silk/sitemap_color.png");
            this.toolIdIconMap.put("sakai.online", "/library/image/silk/report_user.png");
            this.toolIdIconMap.put("sakai.memory", "/library/image/silk/server_chart.png");
            this.toolIdIconMap.put("sakai.archive", "/library/image/silk/page_white_compressed.png");
            this.toolIdIconMap.put("sakai.scheduler", "/library/image/silk/clock.png");
            this.toolIdIconMap.put("sakai.su", "/library/image/silk/user_go.png");
            this.toolIdIconMap.put("sakai.usermembership", "/library/image/silk/drive_user.png");
            this.toolIdIconMap.put("sakai.motd", "/library/image/silk/house.png");
            this.toolIdIconMap.put("sakai-sitebrowser", "/library/image/silk/world.png");
            this.toolIdIconMap.put("sakai-createuser", "/library/image/silk/user_add.png");
            String[] tools = this.M_scs.getStrings("sitestats.toolicons.tools");
            String[] icons = this.M_scs.getStrings("sitestats.toolicons.icons");
            if (tools != null && icons != null) {
                int count = tools.length;
                if (tools.length != icons.length) {
                    LOG.warn((Object)"Number of values for property 'sitestats.toolicons.tools' doesn't match number of values in 'sitestats.toolicons.icons'! Using smaller number.");
                    if (icons.length < count) {
                        count = icons.length;
                    }
                }
                for (int i = 0; i < count; ++i) {
                    this.toolIdIconMap.put(tools[i], icons[i]);
                }
            } else if (tools != null && icons == null || tools == null && icons != null) {
                LOG.warn((Object)"Both 'sitestats.toolicons.tools' and 'sitestats.toolicons.icons' properties are required!");
            }
        }
        return this.toolIdIconMap.get(toolId);
    }

    public Map<String, ToolInfo> getEventIdToolMap() {
        if (this.eventIdToolMap == null) {
            this.eventIdToolMap = new HashMap<String, ToolInfo>();
            for (ToolInfo t : this.getMergedEventRegistry()) {
                for (EventInfo e : t.getEvents()) {
                    this.eventIdToolMap.put(e.getEventId(), t);
                }
            }
        }
        return this.eventIdToolMap;
    }

    public ToolFactory getToolFactory() {
        return new ToolFactoryImpl();
    }

    public EventFactory getEventFactory() {
        return new EventFactoryImpl();
    }

    public boolean isRegisteredEvent(String eventId) {
        return this.getEventIds().contains(eventId);
    }

    private List<ToolInfo> getMergedEventRegistry() {
        List<ToolInfo> eventRegistry = (List<ToolInfo>)this.eventRegistryCache.get(CACHENAME_EVENTREGISTRY);
        if (eventRegistry == null) {
            eventRegistry = this.fileEventRegistry.getEventRegistry();
            eventRegistry = EventUtil.addToEventRegistry(this.entityBrokerEventRegistry.getEventRegistry(), true, eventRegistry);
            this.eventRegistryCache.put(CACHENAME_EVENTREGISTRY, eventRegistry);
            LOG.debug((Object)"Cached EventRegistry.");
        }
        if (eventRegistry == null) {
            eventRegistry = new ArrayList<ToolInfo>(0);
        }
        return eventRegistry;
    }

    @Override
    public void update(Observable obs, Object obj) {
        if ("SiteStats-EventRegistry_expired".equals(obj)) {
            this.eventRegistryCache.remove(CACHENAME_EVENTREGISTRY);
            this.eventIdToolMap = null;
            this.toolEventIds = null;
            this.anonymousToolEventIds = null;
            LOG.debug((Object)"EventRegistry expired. Reloading...");
        }
    }

    public List<String> getServerEventIds() {
        return this.serverEventIds;
    }

    public void setServerEventIds(List<String> eventIds) {
        this.serverEventIds = eventIds;
    }
}

