/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.event;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.sitestats.api.event.EventRegistry;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.impl.event.EventUtil;
import org.sakaiproject.sitestats.impl.parser.DigesterUtil;
import org.sakaiproject.util.ResourceLoader;
import org.springframework.core.io.ClassPathResource;

public class FileEventRegistry
implements EventRegistry {
    public static final String TOOL_EVENTS_DEF_FILE = "toolEventsDef.xml";
    private Log LOG = LogFactory.getLog(FileEventRegistry.class);
    private static ResourceLoader msgs = new ResourceLoader("Events");
    private List<ToolInfo> eventRegistry = null;
    private String customEventRegistryFile = null;
    private String customEventRegistryAdditionsFile = null;
    private String customEventRegistryRemovalsFile = null;

    public void setToolEventsDefinitionFile(String file) {
        this.customEventRegistryFile = file;
    }

    public void setToolEventsAddDefinitionFile(String file) {
        this.customEventRegistryAdditionsFile = file;
    }

    public void setToolEventsRemoveDefinitionFile(String file) {
        this.customEventRegistryRemovalsFile = file;
    }

    public List<ToolInfo> getEventRegistry() {
        if (this.eventRegistry == null) {
            this.loadEventRegistryFile();
        }
        return this.eventRegistry;
    }

    public boolean isEventRegistryExpired() {
        return false;
    }

    public String getEventName(String eventId) {
        String eventName = null;
        try {
            eventName = msgs.getString(eventId, null);
        }
        catch (MissingResourceException e) {
            eventName = null;
        }
        return eventName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEventRegistryFile() {
        boolean customEventRegistryFileLoaded = false;
        if (this.customEventRegistryFile != null) {
            File customDefs = new File(this.customEventRegistryFile);
            if (customDefs.exists()) {
                FileInputStream in = null;
                try {
                    this.LOG.info((Object)("init(): - loading custom event registry from: " + customDefs.getAbsolutePath()));
                    in = new FileInputStream(customDefs);
                    this.eventRegistry = DigesterUtil.parseToolEventsDefinition(in);
                    customEventRegistryFileLoaded = true;
                }
                catch (Throwable t) {
                    this.LOG.warn((Object)("init(): - trouble loading event registry from : " + customDefs.getAbsolutePath()), t);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            this.LOG.warn((Object)("init(): - failed to close inputstream (event registry from : " + customDefs.getAbsolutePath() + ")"));
                        }
                    }
                }
            } else {
                this.LOG.warn((Object)("init(): - custom event registry file not found: " + customDefs.getAbsolutePath()));
            }
        }
        if (!customEventRegistryFileLoaded) {
            ClassPathResource defaultDefs = new ClassPathResource("org/sakaiproject/sitestats/config/toolEventsDef.xml");
            try {
                this.LOG.info((Object)("init(): - loading default event registry from: " + defaultDefs.getPath() + ". A custom one for adding/removing events can be specified in sakai.properties with the property: toolEventsDefinitionFile@org.sakaiproject.sitestats.api.StatsManager=${sakai.home}/toolEventsdef.xml."));
                this.eventRegistry = DigesterUtil.parseToolEventsDefinition(defaultDefs.getInputStream());
            }
            catch (Throwable t) {
                this.LOG.error((Object)("init(): - trouble loading default event registry from : " + defaultDefs.getPath()), t);
            }
        }
        List<ToolInfo> additions = null;
        if (this.customEventRegistryAdditionsFile != null) {
            File customDefs = new File(this.customEventRegistryAdditionsFile);
            if (customDefs.exists()) {
                FileInputStream in = null;
                try {
                    this.LOG.info((Object)("init(): - loading custom event registry additions from: " + customDefs.getAbsolutePath()));
                    in = new FileInputStream(customDefs);
                    additions = DigesterUtil.parseToolEventsDefinition(in);
                }
                catch (Throwable t) {
                    this.LOG.warn((Object)("init(): - trouble loading custom event registry additions from : " + customDefs.getAbsolutePath()), t);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            this.LOG.warn((Object)("init(): - failed to close inputstream (custom event registry additions from : " + customDefs.getAbsolutePath() + ")"));
                        }
                    }
                }
            } else {
                this.LOG.warn((Object)("init(): - custom event registry additions file not found: " + customDefs.getAbsolutePath()));
            }
        }
        if (additions != null) {
            this.eventRegistry = EventUtil.addToEventRegistry(additions, false, this.eventRegistry);
        }
        List<ToolInfo> removals = null;
        if (this.customEventRegistryRemovalsFile != null) {
            File customDefs = new File(this.customEventRegistryRemovalsFile);
            if (customDefs.exists()) {
                FileInputStream in = null;
                try {
                    this.LOG.info((Object)("init(): - loading custom event registry removals from: " + customDefs.getAbsolutePath()));
                    in = new FileInputStream(customDefs);
                    removals = DigesterUtil.parseToolEventsDefinition(in);
                }
                catch (Throwable t) {
                    this.LOG.warn((Object)("init(): - trouble loading custom event registry removals from : " + customDefs.getAbsolutePath()), t);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            this.LOG.warn((Object)("init(): - failed to close inputstream (custom event regitry removals from : " + customDefs.getAbsolutePath() + ")"));
                        }
                    }
                }
            } else {
                this.LOG.warn((Object)("init(): - custom event registry removals file not found: " + customDefs.getAbsolutePath()));
            }
        }
        if (removals != null) {
            this.eventRegistry = EventUtil.removeFromEventRegistry(removals, this.eventRegistry);
        }
    }
}

