/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.sitestats.api.JobRun;
import org.sakaiproject.sitestats.api.StatsUpdateManager;
import org.sakaiproject.sitestats.impl.JobRunImpl;

public class StatsAggregateJobImpl
implements StatefulJob {
    private Log LOG = LogFactory.getLog(StatsAggregateJobImpl.class);
    private int maxEventsPerRun = 0;
    private int sqlBlockSize = 1000;
    private long startEventId = -1L;
    private long lastEventIdInTable = -1L;
    private String driverClassName = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private JobRun jobRun = null;
    private Object extDbdriver = null;
    private String sqlGetEvent = null;
    private String sqlPastSiteEvents = null;
    private boolean isOracle = false;
    private boolean isEventContextSupported = false;
    private static final String LAST_EVENT_ID = "select max(EVENT_ID) LAST_ID from SAKAI_EVENT";
    private static final String MYSQL_DEFAULT_COLUMNS = "EVENT_ID as EVENT_ID,EVENT_DATE as EVENT_DATE,EVENT as EVENT,REF as REF,SESSION_USER as SESSION_USER,e.SESSION_ID as SESSION_ID";
    private static final String ORACLE_DEFAULT_COLUMNS = "EVENT_ID,EVENT_DATE,EVENT,REF,SESSION_USER,e.SESSION_ID SESSION_ID";
    private static final String MYSQL_CHECK_FOR_CONTEXT = "show columns from SAKAI_EVENT like 'CONTEXT'";
    private static final String ORACLE_CHECK_FOR_CONTEXT = "select column_name from USER_TAB_COLUMNS where table_name='SAKAI_EVENT' and column_name='CONTEXT'";
    private static final String MYSQL_CONTEXT_COLUMN = ",CONTEXT as CONTEXT";
    private static final String ORACLE_CONTEXT_COLUMN = ",CONTEXT";
    private String MYSQL_GET_EVENT = "select EVENT_ID as EVENT_ID,EVENT_DATE as EVENT_DATE,EVENT as EVENT,REF as REF,SESSION_USER as SESSION_USER,e.SESSION_ID as SESSION_ID,CONTEXT as CONTEXT from SAKAI_EVENT e join SAKAI_SESSION s on e.SESSION_ID=s.SESSION_ID where EVENT_ID >= ? and EVENT_ID < ? order by EVENT_ID asc ";
    private String ORACLE_GET_EVENT = "SELECT EVENT_ID,EVENT_DATE,EVENT,REF,SESSION_USER,e.SESSION_ID SESSION_ID,CONTEXT FROM sakai_event e JOIN sakai_session s ON e.session_id = s.SESSION_ID WHERE event_id >= ? AND event_id < ? ORDER BY event_id ASC";
    private String MYSQL_PAST_SITE_EVENTS = "select EVENT_ID as EVENT_ID,EVENT_DATE as EVENT_DATE,EVENT as EVENT,REF as REF,SESSION_USER as SESSION_USER,e.SESSION_ID as SESSION_ID,CONTEXT as CONTEXT from SAKAI_EVENT e join SAKAI_SESSION s on e.SESSION_ID=s.SESSION_ID where (CONTEXT = ? or (EVENT in ('pres.begin','pres.end') and REF = ?)) and EVENT_DATE >= ? and EVENT_DATE <= ?";
    private String ORACLE_PAST_SITE_EVENTS = "SELECT EVENT_ID,EVENT_DATE,EVENT,REF,SESSION_USER,e.SESSION_ID SESSION_ID,CONTEXT from SAKAI_EVENT e join SAKAI_SESSION s on e.SESSION_ID=s.SESSION_ID where (CONTEXT = ? or (EVENT in ('pres.begin','pres.end') and REF = ?)) and EVENT_DATE >= ? and EVENT_DATE <= ?";
    private StatsUpdateManager statsUpdateManager = null;
    private SqlService sqlService = null;

    public void init() {
        this.doInitialCheck();
        this.LOG.info((Object)"StatsAggregateJobImpl.init()");
    }

    private void doInitialCheck() {
        JobRun lastJobRun = null;
        try {
            lastJobRun = this.getLastJobRun();
        }
        catch (Exception e) {
            this.LOG.error((Object)"Make sure SST_JOB_RUN table is created before running the StatsAggregateJob job.");
        }
        if (lastJobRun == null && !this.statsUpdateManager.isCollectThreadEnabled()) {
            if (this.getStartEventId() < 0L) {
                long lastEventIdInTable = 0L;
                try {
                    lastEventIdInTable = this.getLastEventIdInTable();
                }
                catch (SQLException e) {
                    this.LOG.warn((Object)"Unable to check last eventId in table SAKAI_EVENT --> assuming 0.", (Throwable)e);
                }
                this.LOG.warn((Object)("First StatsAggregateJob job run will use last SAKAI_EVENT.EVENT_ID (id = " + lastEventIdInTable + "). To override this, please specify a new eventId in sakai.properties (property: startEventId@org.sakaiproject.sitestats.api.StatsAggregateJob=n, where n>=0). This value is for the first job run only."));
            } else {
                this.LOG.warn((Object)("First StatsAggregateJob job run will use 'startEventId' (" + this.getStartEventId() + ") specified in sakai.properties. This value is for the first job run only."));
            }
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobRun lastJobRun;
        String result = null;
        String jobName = context.getJobDetail().getKey().getName();
        try {
            if (this.isJobCurrentlyRunning(context)) {
                String beanId = context.getJobDetail().getJobDataMap().getString("org.sakaiproject.api.app.scheduler.JobBeanWrapper.bean");
                this.LOG.warn((Object)("Another instance of " + beanId + " is currently running - Execution aborted."));
                return;
            }
        }
        catch (SchedulerException e) {
            this.LOG.error((Object)("Aborting job execution due to " + e.toString()), (Throwable)e);
            return;
        }
        this.LOG.info((Object)("Starting job: " + jobName));
        try {
            this.checkForContextColumn();
            this.LOG.debug((Object)("SAKAI_EVENT.CONTEXT exists? " + this.isEventContextSupported));
        }
        catch (SQLException e1) {
            this.LOG.warn((Object)"Unable to check existence of SAKAI_EVENT.CONTEXT", (Throwable)e1);
        }
        try {
            lastJobRun = this.getLastJobRun();
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error accessing SST_JOB_RUN table. Does this table exists? Aborting job...");
            return;
        }
        this.jobRun = new JobRunImpl();
        this.jobRun.setJobStartDate(new Date(System.currentTimeMillis()));
        if (lastJobRun != null) {
            this.jobRun.setStartEventId(lastJobRun.getEndEventId() + 1L);
        } else if (this.getStartEventId() >= 0L) {
            this.LOG.info((Object)("First job run: using 'startEventId' (" + this.getStartEventId() + ") specified in sakai.properties. This value is for the first job run only."));
            this.jobRun.setStartEventId(this.getStartEventId());
        } else {
            long lastEventIdInTable = 0L;
            try {
                lastEventIdInTable = this.getLastEventIdInTable();
            }
            catch (SQLException e) {
                this.LOG.warn((Object)"Unable to check last eventId in table SAKAI_EVENT --> assuming 0.", (Throwable)e);
            }
            this.LOG.info((Object)("First job run: no 'startEventId' specified in sakai.properties; using last SAKAI_EVENT.EVENT_ID (id = " + lastEventIdInTable + "). This value is for the first job run only."));
            this.jobRun.setStartEventId(lastEventIdInTable);
        }
        try {
            result = this.startJob();
            this.LOG.info((Object)("Summary: " + result));
        }
        catch (SQLException e) {
            this.LOG.error((Object)"Summary: job run failed", (Throwable)e);
        }
        this.LOG.info((Object)("Finishing job: " + jobName));
    }

    private boolean isJobCurrentlyRunning(JobExecutionContext context) throws SchedulerException {
        String beanId = context.getJobDetail().getJobDataMap().getString("org.sakaiproject.api.app.scheduler.JobBeanWrapper.bean");
        List jobsRunning = context.getScheduler().getCurrentlyExecutingJobs();
        int jobsCount = 0;
        for (JobExecutionContext j : jobsRunning) {
            if (!beanId.equals(j.getJobDetail().getJobDataMap().getString("org.sakaiproject.api.app.scheduler.JobBeanWrapper.bean"))) continue;
            ++jobsCount;
        }
        return jobsCount > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastEventIdInTable() throws SQLException {
        if (this.lastEventIdInTable == -1L) {
            Connection connection = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                connection = this.getEventDbConnection();
                st = connection.createStatement();
                rs = st.executeQuery(LAST_EVENT_ID);
                if (rs.next()) {
                    this.lastEventIdInTable = rs.getLong("LAST_ID");
                }
            }
            catch (SQLException e) {
                this.LOG.error((Object)"Unable to retrieve events", (Throwable)e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                finally {
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    finally {
                        this.closeEventDbConnection(connection);
                    }
                }
            }
        }
        return this.lastEventIdInTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String startJob() throws SQLException {
        ArrayList<Event> eventsQueue = new ArrayList<Event>();
        long counter = 0L;
        long offset = 0L;
        long lastProcessedEventId = 0L;
        long lastProcessedEventIdWithSuccess = 0L;
        long firstEventIdProcessed = -1L;
        long firstEventIdProcessedInBlock = -1L;
        Date lastEventDate = null;
        Date lastEventDateWithSuccess = null;
        boolean abortIteration = false;
        long start = System.currentTimeMillis();
        boolean sqlError = false;
        String returnMessage = null;
        Connection connection = this.getEventDbConnection();
        long eventIdLowerLimit = this.getEventIdLowerLimit();
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = connection.prepareStatement(this.sqlGetEvent);
            rs = null;
            while (!abortIteration) {
                abortIteration = true;
                if (firstEventIdProcessed == -1L) {
                    offset = eventIdLowerLimit;
                }
                st.setLong(1, offset);
                st.setLong(2, offset + (long)this.sqlBlockSize);
                rs = st.executeQuery();
                while (rs.next()) {
                    abortIteration = false;
                    Date date = null;
                    String event = null;
                    String ref = null;
                    String context = null;
                    String sessionUser = null;
                    String sessionId = null;
                    try {
                        date = new Date(rs.getTimestamp("EVENT_DATE").getTime());
                        event = rs.getString("EVENT");
                        ref = rs.getString("REF");
                        sessionUser = rs.getString("SESSION_USER");
                        sessionId = rs.getString("SESSION_ID");
                        if (this.isEventContextSupported) {
                            context = rs.getString("CONTEXT");
                        }
                        eventsQueue.add(this.statsUpdateManager.buildEvent(date, event, ref, context, sessionUser, sessionId));
                        ++counter;
                        lastProcessedEventId = rs.getInt("EVENT_ID");
                        lastEventDate = date;
                        if (firstEventIdProcessed == -1L) {
                            firstEventIdProcessed = this.jobRun.getStartEventId();
                        }
                        if (firstEventIdProcessedInBlock != -1L) continue;
                        firstEventIdProcessedInBlock = lastProcessedEventId;
                    }
                    catch (Exception e) {
                        if (!this.LOG.isDebugEnabled()) continue;
                        this.LOG.debug((Object)("Ignoring " + event + ", " + ref + ", " + date + ", " + sessionUser + ", " + sessionId + " due to: " + e.toString()));
                    }
                }
                rs.close();
                if (abortIteration) continue;
                boolean processedOk = this.statsUpdateManager.collectEvents(eventsQueue);
                eventsQueue.clear();
                if (processedOk) {
                    lastProcessedEventIdWithSuccess = lastProcessedEventId;
                    lastEventDateWithSuccess = lastEventDate;
                    this.jobRun.setStartEventId(firstEventIdProcessed);
                    this.jobRun.setEndEventId(lastProcessedEventIdWithSuccess);
                    this.jobRun.setLastEventDate(lastEventDateWithSuccess);
                    this.jobRun.setJobEndDate(new Date(System.currentTimeMillis()));
                    this.saveJobRun(this.jobRun);
                    firstEventIdProcessedInBlock = -1L;
                    if (counter >= (long)this.getMaxEventsPerRun()) {
                        abortIteration = true;
                        continue;
                    }
                    if (counter + (long)this.sqlBlockSize < (long)this.getMaxEventsPerRun()) {
                        offset += (long)this.sqlBlockSize;
                        continue;
                    }
                    offset += (long)this.getMaxEventsPerRun() - counter;
                    continue;
                }
                returnMessage = "An error occurred while processing/persisting events to db. Please check your logs, fix possible problems and re-run this job (will start after last successful processed event).";
                this.LOG.error((Object)returnMessage);
                throw new Exception(returnMessage);
            }
        }
        catch (SQLException e) {
            sqlError = true;
            if (returnMessage == null) {
                returnMessage = "Unable to retrieve events due to: " + e.getMessage();
                this.LOG.error((Object)"Unable to retrieve events", (Throwable)e);
            }
        }
        catch (Exception e) {
            sqlError = true;
            if (returnMessage == null) {
                returnMessage = "Unable to retrieve events due to: " + e.getMessage();
                this.LOG.error((Object)"Unable to retrieve events due to an unknown cause", (Throwable)e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                finally {
                    this.closeEventDbConnection(connection);
                }
            }
        }
        if (sqlError) {
            return returnMessage;
        }
        long processingTime = (System.currentTimeMillis() - start) / 1000L;
        if (firstEventIdProcessed == -1L && this.jobRun != null) {
            return "0 events processed in " + processingTime + "s (no entry will be added to SST_JOB_RUN; only events associated with a session are processed)";
        }
        this.saveJobRun(this.jobRun);
        return counter + " events processed (ids: " + firstEventIdProcessed + " - " + lastProcessedEventIdWithSuccess + ") in " + processingTime + "s (only events associated with a session are processed)";
    }

    private long getEventIdLowerLimit() {
        long start = this.getStartEventId();
        long nextEventId = this.jobRun.getStartEventId();
        if (nextEventId > start) {
            start = nextEventId;
        }
        return start;
    }

    private JobRun getLastJobRun() throws Exception {
        return this.statsUpdateManager.getLatestJobRun();
    }

    private boolean saveJobRun(JobRun jobRun) {
        boolean ok = false;
        try {
            ok = this.statsUpdateManager.saveJobRun(jobRun);
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to persist last job information to db.", (Throwable)e);
        }
        return ok;
    }

    /*
     * Exception decompiling
     */
    public long collectPastSiteEvents(String siteId, Date initialDate, Date finalDate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Connection getEventDbConnection() {
        Connection connection = null;
        if (this.getUrl() == null) {
            try {
                connection = this.sqlService.borrowConnection();
                if (this.sqlService.getVendor().equals("oracle")) {
                    this.isOracle = true;
                    this.sqlGetEvent = this.isEventContextSupported ? this.ORACLE_GET_EVENT : this.ORACLE_GET_EVENT.replaceAll(ORACLE_CONTEXT_COLUMN, "");
                    this.sqlPastSiteEvents = this.ORACLE_PAST_SITE_EVENTS;
                }
                this.isOracle = false;
                this.sqlGetEvent = this.isEventContextSupported ? this.MYSQL_GET_EVENT : this.MYSQL_GET_EVENT.replaceAll(MYSQL_CONTEXT_COLUMN, "");
                this.sqlPastSiteEvents = this.MYSQL_PAST_SITE_EVENTS;
            }
            catch (SQLException e) {
                this.LOG.error((Object)"Unable to connect Sakai Db", (Throwable)e);
                return null;
            }
            catch (Exception e) {
                this.LOG.error((Object)"Unable to connect to Sakai Db", (Throwable)e);
                return null;
            }
        } else {
            try {
                if (this.extDbdriver == null) {
                    this.extDbdriver = Class.forName(this.getDriverClassName()).newInstance();
                    if (this.getDriverClassName().equals("oracle.jdbc.driver.OracleDriver")) {
                        this.isOracle = true;
                        this.sqlGetEvent = this.isEventContextSupported ? this.ORACLE_GET_EVENT : this.ORACLE_GET_EVENT.replaceAll(ORACLE_CONTEXT_COLUMN, "");
                    } else {
                        this.isOracle = false;
                        this.sqlGetEvent = this.isEventContextSupported ? this.MYSQL_GET_EVENT : this.MYSQL_GET_EVENT.replaceAll(MYSQL_CONTEXT_COLUMN, "");
                    }
                }
                connection = DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
            }
            catch (SQLException e) {
                this.LOG.error((Object)("Unable to connect to " + this.getUrl()), (Throwable)e);
                return null;
            }
            catch (Exception e) {
                this.LOG.error((Object)("Unable to connect to " + this.getUrl()), (Throwable)e);
                return null;
            }
        }
        return connection;
    }

    private void closeEventDbConnection(Connection connection) {
        if (this.getUrl() == null) {
            if (connection != null) {
                this.sqlService.returnConnection(connection);
            }
        } else {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.LOG.error((Object)("Unable to close connection " + this.getUrl()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForContextColumn() throws SQLException {
        Connection connection = null;
        Statement st = null;
        ResultSet rs = null;
        String sqlCheckForContext = null;
        try {
            connection = this.getEventDbConnection();
            sqlCheckForContext = this.isOracle ? ORACLE_CHECK_FOR_CONTEXT : MYSQL_CHECK_FOR_CONTEXT;
            st = connection.prepareStatement(sqlCheckForContext);
            rs = st.executeQuery();
            if (rs.next()) {
                this.LOG.debug((Object)"SAKAI_EVENT.CONTEXT IS present.");
                this.isEventContextSupported = true;
            } else {
                this.LOG.debug((Object)"SAKAI_EVENT.CONTEXT is NOT present.");
                this.isEventContextSupported = false;
            }
        }
        catch (SQLException e) {
            this.LOG.error((Object)"Unable to determine if SAKAI_EVENT.CONTEXT is present", (Throwable)e);
            this.isEventContextSupported = false;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                finally {
                    this.closeEventDbConnection(connection);
                }
            }
        }
    }

    public int getMaxEventsPerRun() {
        return this.maxEventsPerRun;
    }

    public void setMaxEventsPerRun(int maxEventsPerRun) {
        this.maxEventsPerRun = maxEventsPerRun;
    }

    public int getSqlBlockSize() {
        return this.sqlBlockSize;
    }

    public void setSqlBlockSize(int sqlBlockSize) {
        this.sqlBlockSize = sqlBlockSize;
    }

    public long getStartEventId() {
        return this.startEventId;
    }

    public void setStartEventId(long startEventId) {
        this.startEventId = startEventId;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public StatsUpdateManager getStatsUpdateManager() {
        return this.statsUpdateManager;
    }

    public void setStatsUpdateManager(StatsUpdateManager statsUpdateManager) {
        this.statsUpdateManager = statsUpdateManager;
    }

    public SqlService getSqlService() {
        return this.sqlService;
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }
}

