/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderManager;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Statisticable;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityProviderListener;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.EventRegistry;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.Preferences;
import org.sakaiproject.user.api.PreferencesService;

public class EntityBrokerEventRegistry
extends Observable
implements EventRegistry,
EntityProviderListener<Statisticable> {
    private static Log LOG = LogFactory.getLog(EntityBrokerEventRegistry.class);
    private static final String CACHENAME = EntityBrokerEventRegistry.class.getName();
    private List<ToolInfo> eventRegistry = new ArrayList<ToolInfo>();
    private Map<String, String> eventIdToEPPrefix = new HashMap<String, String>();
    private Cache eventNamesCache = null;
    private SessionManager M_sm;
    private PreferencesService M_ps;
    private EntityProviderManager M_epm;
    private MemoryService M_ms;

    public void setSessionManager(SessionManager sessionManager) {
        this.M_sm = sessionManager;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.M_ps = preferencesService;
    }

    public void setEntityProviderManager(EntityProviderManager entityProviderManager) {
        this.M_epm = entityProviderManager;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.M_ms = memoryService;
    }

    public void init() {
        LOG.info((Object)"init()");
        this.eventNamesCache = this.M_ms.newCache(CACHENAME);
        this.M_epm.registerListener((EntityProviderListener)this, true);
    }

    public List<ToolInfo> getEventRegistry() {
        LOG.debug((Object)("getEventRegistry(): #tools implementing Statisticable = " + this.eventRegistry.size()));
        return this.eventRegistry;
    }

    public boolean isEventRegistryExpired() {
        return this.hasChanged();
    }

    public String getEventName(String eventId) {
        Locale currentUserLocale = this.getCurrentUserLocale();
        EventLocaleKey key = new EventLocaleKey(eventId, currentUserLocale.toString());
        if (this.eventNamesCache.containsKey((Object)key.toString())) {
            return (String)this.eventNamesCache.get((Object)key.toString());
        }
        String eventName = null;
        try {
            String prefix = this.eventIdToEPPrefix.get(eventId);
            Statisticable s = (Statisticable)this.M_epm.getProviderByPrefixAndCapability(prefix, Statisticable.class);
            Map eventIdNamesMap = s.getEventNames(currentUserLocale);
            if (eventIdNamesMap != null) {
                for (String thisEventId : eventIdNamesMap.keySet()) {
                    EventLocaleKey thisCacheKey = new EventLocaleKey(thisEventId, currentUserLocale.toString());
                    String thisEventName = (String)eventIdNamesMap.get(thisEventId);
                    this.eventNamesCache.put((Object)thisCacheKey.toString(), (Object)thisEventName);
                    if (!thisEventId.equals(eventId)) continue;
                    eventName = thisEventName;
                }
                LOG.debug((Object)("Cached event names for EB prefix '" + prefix + "', locale: " + currentUserLocale));
            }
        }
        catch (Exception e) {
            eventName = null;
        }
        return eventName;
    }

    public Class<Statisticable> getCapabilityFilter() {
        return Statisticable.class;
    }

    public String getPrefixFilter() {
        return null;
    }

    public void run(Statisticable provider) {
        LOG.info((Object)("Statisticable capability registered with prefix: " + provider.getEntityPrefix()));
        this.processStatisticableProvider(provider);
    }

    private void processStatisticableProvider(Statisticable provider) {
        String entityPrefix = provider.getEntityPrefix();
        String entityToolId = provider.getAssociatedToolId();
        String[] entityEventIds = provider.getEventKeys();
        ToolInfo tool = new ToolInfo(entityToolId);
        tool.setSelected(true);
        for (String eventId : entityEventIds) {
            EventInfo event = new EventInfo(eventId);
            event.setSelected(true);
            this.eventIdToEPPrefix.put(eventId, entityPrefix);
            tool.addEvent(event);
        }
        this.eventRegistry.add(tool);
        this.setChanged();
        this.notifyObservers("SiteStats-EventRegistry_expired");
    }

    private Locale getCurrentUserLocale() {
        Locale loc = null;
        try {
            String userId = this.M_sm.getCurrentSessionUserId();
            if (userId != null) {
                Preferences prefs = this.M_ps.getPreferences(userId);
                ResourceProperties locProps = prefs.getProperties("sakai:resourceloader");
                String localeString = locProps.getProperty("locale");
                if (localeString != null) {
                    String[] locValues = localeString.split("_");
                    if (locValues.length > 1) {
                        loc = new Locale(locValues[0], locValues[1]);
                    } else if (locValues.length == 1) {
                        loc = new Locale(locValues[0]);
                    }
                }
                if (loc == null) {
                    loc = Locale.getDefault();
                }
            } else {
                loc = (Locale)this.M_sm.getCurrentSession().getAttribute("locale" + this.M_sm.getCurrentSessionUserId());
            }
        }
        catch (NullPointerException e) {
            loc = Locale.getDefault();
        }
        return loc;
    }

    public static class EventLocaleKey {
        String eventId = "";
        String locale = "";

        public EventLocaleKey(String eventId, String locale) {
            this.eventId = eventId;
            this.locale = locale;
        }

        public String getEventId() {
            return this.eventId;
        }

        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("[");
            buff.append(this.getEventId());
            buff.append(", ");
            buff.append(this.getLocale());
            buff.append("]");
            return buff.toString();
        }

        public int hashCode() {
            return this.getEventId().hashCode() + this.getLocale().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof EventLocaleKey)) {
                return false;
            }
            EventLocaleKey o = (EventLocaleKey)obj;
            return o.getEventId().equals(this.getEventId()) && o.getLocale().equals(o.getLocale());
        }
    }
}

