/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolManager;

public class EventUtil {
    public static List<ToolInfo> addMissingAdditionalToolIds(List<ToolInfo> eventRegistrySubset, List<ToolInfo> fullEventRegistry) {
        for (ToolInfo t : eventRegistrySubset) {
            int ix = fullEventRegistry.indexOf(new ToolInfo(t.getToolId()));
            if (ix == -1) continue;
            t.setAdditionalToolIds(fullEventRegistry.get(ix).getAdditionalToolIds());
        }
        return eventRegistrySubset;
    }

    public static List<ToolInfo> getIntersectionWithAvailableToolsInSite(SiteService M_ss, List<ToolInfo> eventRegistrySubset, String siteId) {
        ArrayList<ToolInfo> intersected = new ArrayList<ToolInfo>();
        Site site = null;
        try {
            site = M_ss.getSite(siteId);
        }
        catch (IdUnusedException e) {
            return eventRegistrySubset;
        }
        ArrayList siteTools = new ArrayList();
        for (SitePage page : site.getPages()) {
            siteTools.addAll(page.getTools());
        }
        block3: for (ToolInfo t : eventRegistrySubset) {
            for (ToolConfiguration tc : siteTools) {
                if (!tc.getToolId().equals(t.getToolId())) continue;
                intersected.add(t);
                continue block3;
            }
        }
        return intersected;
    }

    public static List<ToolInfo> getIntersectionWithAvailableToolsInSakaiInstallation(ToolManager M_tm, List<ToolInfo> eventRegistrySubset) {
        ArrayList<ToolInfo> intersected = new ArrayList<ToolInfo>();
        ArrayList sakaiTools = new ArrayList();
        sakaiTools.addAll(M_tm.findTools(null, null));
        block0: for (ToolInfo t : eventRegistrySubset) {
            for (Tool tc : sakaiTools) {
                if (!tc.getId().equals(t.getToolId())) continue;
                intersected.add(t);
                continue block0;
            }
        }
        return intersected;
    }

    public static List<ToolInfo> getUnionWithAllDefaultToolEvents(List<ToolInfo> eventRegistrySubset, List<ToolInfo> fullEventRegistry) {
        ArrayList<ToolInfo> union = new ArrayList<ToolInfo>();
        for (ToolInfo t1 : fullEventRegistry) {
            Iterator<ToolInfo> iPREFS = eventRegistrySubset.iterator();
            boolean foundTool = false;
            ToolInfo t2 = null;
            while (iPREFS.hasNext()) {
                t2 = iPREFS.next();
                if (!t2.getToolId().equals(t1.getToolId())) continue;
                foundTool = true;
                break;
            }
            if (!foundTool) {
                ToolInfo toAdd = t1;
                toAdd.setSelected(false);
                for (int i = 0; i < toAdd.getEvents().size(); ++i) {
                    ((EventInfo)toAdd.getEvents().get(i)).setSelected(false);
                }
                union.add(toAdd);
                continue;
            }
            for (EventInfo e1 : t1.getEvents()) {
                boolean foundEvent = false;
                for (int i = 0; i < t2.getEvents().size(); ++i) {
                    EventInfo e2 = (EventInfo)t2.getEvents().get(i);
                    if (!e2.getEventId().equals(e1.getEventId())) continue;
                    foundEvent = true;
                    break;
                }
                if (foundEvent) continue;
                EventInfo toAdd = e1;
                e1.setSelected(false);
                t2.addEvent(toAdd);
            }
            union.add(t2);
        }
        return union;
    }

    public static List<ToolInfo> addToEventRegistry(List<ToolInfo> additions, boolean replaceEventsForTool, List<ToolInfo> eventRegistry) {
        if (additions == null || additions.size() == 0) {
            return eventRegistry;
        }
        ArrayList<ToolInfo> toBeAdded = new ArrayList<ToolInfo>();
        for (ToolInfo newTool : additions) {
            boolean foundEvent;
            Iterator<ToolInfo> iAll = eventRegistry.iterator();
            boolean foundTool = false;
            ToolInfo existingTool = null;
            while (iAll.hasNext()) {
                existingTool = iAll.next();
                if (!existingTool.equals((Object)newTool)) continue;
                foundTool = true;
                break;
            }
            if (!foundTool) {
                toBeAdded.add(newTool);
                continue;
            }
            if (foundTool && replaceEventsForTool) {
                for (EventInfo newEvent : newTool.getEvents()) {
                    foundEvent = false;
                    EventInfo existingEvent = null;
                    for (int i = 0; i < existingTool.getEvents().size(); ++i) {
                        existingEvent = (EventInfo)existingTool.getEvents().get(i);
                        if (!existingEvent.equals((Object)newEvent)) continue;
                        foundEvent = true;
                        break;
                    }
                    if (!foundEvent || existingEvent == null || !existingEvent.isAnonymous()) continue;
                    newEvent.setAnonymous(true);
                }
                existingTool = newTool;
                continue;
            }
            for (EventInfo newEvent : newTool.getEvents()) {
                foundEvent = false;
                for (int i = 0; i < existingTool.getEvents().size(); ++i) {
                    EventInfo existingEvent = (EventInfo)existingTool.getEvents().get(i);
                    if (!existingEvent.equals((Object)newEvent)) continue;
                    foundEvent = true;
                    break;
                }
                if (foundEvent) continue;
                existingTool.addEvent(newEvent);
            }
        }
        eventRegistry.addAll(toBeAdded);
        return eventRegistry;
    }

    public static List<ToolInfo> removeFromEventRegistry(List<ToolInfo> removals, List<ToolInfo> eventRegistry) {
        if (removals == null || removals.size() == 0) {
            return eventRegistry;
        }
        for (ToolInfo delTool : removals) {
            Iterator<ToolInfo> iAll = eventRegistry.iterator();
            boolean foundTool = false;
            ToolInfo existingTool = null;
            while (iAll.hasNext()) {
                existingTool = iAll.next();
                if (!existingTool.getToolId().equals(delTool.getToolId())) continue;
                foundTool = true;
                break;
            }
            if (!foundTool) continue;
            if (delTool.getEvents().size() == 0) {
                eventRegistry.remove(existingTool);
                continue;
            }
            for (EventInfo delEvent : delTool.getEvents()) {
                boolean foundEvent = false;
                for (int i = 0; i < existingTool.getEvents().size(); ++i) {
                    EventInfo existingEvent = (EventInfo)existingTool.getEvents().get(i);
                    if (!existingEvent.getEventId().equals(delEvent.getEventId())) continue;
                    foundEvent = true;
                    break;
                }
                if (!foundEvent) continue;
                existingTool.removeEvent(delEvent);
            }
        }
        return eventRegistry;
    }
}

