/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.SortOrder;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.db.api.SqlReader;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.event.api.UsageSessionService;
import org.sakaiproject.sitestats.api.ServerWideReportManager;
import org.sakaiproject.sitestats.api.ServerWideStatsRecord;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.impl.ServerWideStatsRecordImpl;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerWideReportManagerImpl
implements ServerWideReportManager {
    private static final Logger log = LoggerFactory.getLogger(ServerWideReportManagerImpl.class);
    private static ResourceLoader msgs = new ResourceLoader("Messages");
    private SqlService sqlService;
    private StatsManager statsManager;
    private UsageSessionService usageSessionService;
    private ServerConfigurationService serverConfigurationService;
    private String dbVendor;
    private String externalDbName;

    public void init() {
        this.dbVendor = StringUtils.lowerCase((String)this.serverConfigurationService.getString("vendor@org.sakaiproject.db.api.SqlService", null));
        log.info("ServerWideReportManagerImpl SQL queries configured to use: " + this.dbVendor);
        this.externalDbName = this.serverConfigurationService.getString("sitestats.externalDb.name", null);
        if (StringUtils.isNotBlank((String)this.externalDbName)) {
            log.info("ServerWideReportManagerImpl will query for Sitestats data in the external database: " + this.externalDbName);
        } else {
            log.info("ServerWideReportManagerImpl will query for Sitestats data in the main Sakai database");
        }
    }

    public void destroy() {
    }

    public List<ServerWideStatsRecord> getMonthlyTotalLogins() {
        String mysql = "select STR_TO_DATE(date_format(ACTIVITY_DATE, '%Y-%m-01'),'%Y-%m-%d') as period, sum(ACTIVITY_COUNT) as user_logins from " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS where EVENT_ID='user.login' group by 1";
        String oracle = "select TO_DATE(TO_CHAR(ACTIVITY_DATE, 'YYYY-MM-\"01\"'), 'YYYY-MM-DD') as period, sum(ACTIVITY_COUNT) as user_logins from " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS where EVENT_ID='user.login' group by TO_DATE(TO_CHAR(ACTIVITY_DATE, 'YYYY-MM-\"01\"'), 'YYYY-MM-DD')";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                }
                catch (SQLException e) {
                    log.error("getMonthlyTotalLogins() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        result.remove(result.size() - 1);
        return result;
    }

    public List<ServerWideStatsRecord> getMonthlyUniqueLogins() {
        String mysql = "select STR_TO_DATE(date_format(LOGIN_DATE, '%Y-%m-01'),'%Y-%m-%d') as period, count(distinct user_id) as unique_users from " + this.getExternalDbNameAsPrefix() + "SST_USERSTATS group by 1";
        String oracle = "select TO_DATE(TO_CHAR(LOGIN_DATE, 'YYYY-MM-\"01\"'),'YYYY-MM-DD') as period, count(distinct user_id) as unique_users from " + this.getExternalDbNameAsPrefix() + "SST_USERSTATS group by TO_DATE(TO_CHAR(LOGIN_DATE, 'YYYY-MM-\"01\"'),'YYYY-MM-DD')";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                }
                catch (SQLException e) {
                    log.error("getMonthlyUniqueLogins() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        result.remove(result.size() - 1);
        return result;
    }

    public List<ServerWideStatsRecord> getWeeklyTotalLogins() {
        String mysql = "select STR_TO_DATE(concat(date_format(ACTIVITY_DATE, '%x-%v'), ' Monday'),'%x-%v %W') as week_start, sum(ACTIVITY_COUNT) as user_logins from " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS where EVENT_ID='user.login' group by 1";
        String oracle = "select next_day(ACTIVITY_DATE - 7, 2) as week_start, sum(ACTIVITY_COUNT) as user_logins from " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS where EVENT_ID='user.login' group by next_day(ACTIVITY_DATE - 7, 2)";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                }
                catch (SQLException e) {
                    log.error("getWeeklyTotalLogins() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        result.remove(result.size() - 1);
        return result;
    }

    public List<ServerWideStatsRecord> getWeeklyUniqueLogins() {
        String mysql = "select STR_TO_DATE(concat(date_format(LOGIN_DATE, '%x-%v'), ' Monday'),'%x-%v %W') as week_start, count(distinct user_id) as unique_users from " + this.getExternalDbNameAsPrefix() + "SST_USERSTATS group by 1";
        String oracle = "select next_day(LOGIN_DATE - 7, 2) as week_start, count(distinct user_id) as unique_users from " + this.getExternalDbNameAsPrefix() + "SST_USERSTATS group by next_day(LOGIN_DATE - 7, 2)";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                }
                catch (SQLException e) {
                    log.error("getWeeklyUniqueLogins() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        result.remove(result.size() - 1);
        return result;
    }

    public List<ServerWideStatsRecord> getDailyTotalLogins() {
        String mysql = "select date(ACTIVITY_DATE) as session_date,  ACTIVITY_COUNT as user_logins from " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS where EVENT_ID='user.login'  and ACTIVITY_DATE > DATE_SUB(CURDATE(), INTERVAL 90 DAY) group by 1";
        String oracle = "select trunc(ACTIVITY_DATE, 'DDD') as session_date, sum(ACTIVITY_COUNT) as user_logins from " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS where EVENT_ID='user.login'  and ACTIVITY_DATE > (SYSDATE - 90) group by trunc(ACTIVITY_DATE, 'DDD')";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                }
                catch (SQLException e) {
                    log.error("getDailyTotalLogins() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        result.remove(result.size() - 1);
        return result;
    }

    public List<ServerWideStatsRecord> getDailyUniqueLogins() {
        String mysql = "select date(LOGIN_DATE) as session_date,  count(distinct user_id) as unique_users from " + this.getExternalDbNameAsPrefix() + "SST_USERSTATS where LOGIN_DATE > DATE_SUB(CURDATE(), INTERVAL 90 DAY) group by 1";
        String oracle = "select trunc(LOGIN_DATE, 'DDD') as session_date,  count(distinct user_id) as unique_users from " + this.getExternalDbNameAsPrefix() + "SST_USERSTATS where LOGIN_DATE > (SYSDATE - 90) group by trunc(LOGIN_DATE, 'DDD')";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                }
                catch (SQLException e) {
                    log.error("getDailyUniqueLogins() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        result.remove(result.size() - 1);
        return result;
    }

    public List<ServerWideStatsRecord> getSiteCreatedDeletedStats(String period) {
        List result;
        String mysqlPeriod = "";
        mysqlPeriod = period.equals("daily") ? "date(ACTIVITY_DATE) as event_period" : (period.equals("weekly") ? "STR_TO_DATE(date_format(ACTIVITY_DATE, '%x-%v Monday'),'%x-%v %W') as event_period" : "STR_TO_DATE(date_format(ACTIVITY_DATE, '%Y-%m-01'),'%Y-%m-%d') as event_period");
        String mysql = "select " + mysqlPeriod + ", sum(if(EVENT_ID = 'site.add',activity_count,0)) as site_created, sum(if(EVENT_ID = 'site.del',activity_count,0)) as site_deleted FROM " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS ";
        if (period.equals("daily")) {
            mysql = mysql + "where ACTIVITY_DATE > DATE_SUB(CURDATE(), INTERVAL 90 DAY) ";
        }
        mysql = mysql + "group by 1";
        String oraclePeriod = "";
        oraclePeriod = period.equals("daily") ? "trunc(ACTIVITY_DATE, 'DDD')" : (period.equals("weekly") ? "next_day(ACTIVITY_DATE - 7, 2)" : "TO_DATE(TO_CHAR(ACTIVITY_DATE, 'YYYY-MM-\"01\"'),'YYYY-MM-DD')");
        String oracle = "select " + oraclePeriod + " as event_period, sum(decode(EVENT_ID, 'site.add',activity_count,0)) as site_created, sum(decode(EVENT_ID, 'site.del',activity_count,0)) as site_deleted FROM " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS ";
        if (period.equals("daily")) {
            oracle = oracle + "where ACTIVITY_DATE > (SYSDATE - 90) ";
        }
        if ((result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle = oracle + "group by " + oraclePeriod), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                    info.add(result.getLong(3));
                }
                catch (SQLException e) {
                    log.error("getSiteCreatedDeletedStats() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        })).size() > 0) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    public List<ServerWideStatsRecord> getNewUserStats(String period) {
        List result;
        String mysqlPeriod = "";
        mysqlPeriod = period.equals("daily") ? "date(ACTIVITY_DATE) as event_period" : (period.equals("weekly") ? "STR_TO_DATE(date_format(ACTIVITY_DATE, '%x-%v Monday'),'%x-%v %W') as event_period" : "STR_TO_DATE(date_format(ACTIVITY_DATE, '%Y-%m-01'),'%Y-%m-%d') as event_period");
        String mysql = "select " + mysqlPeriod + ",  ACTIVITY_COUNT as new_user FROM " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS where EVENT_ID='user.add'";
        if (period.equals("daily")) {
            mysql = mysql + " and ACTIVITY_DATE > DATE_SUB(CURDATE(), INTERVAL 90 DAY) ";
        }
        mysql = mysql + " group by 1";
        String oraclePeriod = "";
        oraclePeriod = period.equals("daily") ? "trunc(ACTIVITY_DATE, 'DDD')" : (period.equals("weekly") ? "next_day(ACTIVITY_DATE - 7, 2)" : "TO_DATE(TO_CHAR(ACTIVITY_DATE, 'YYYY-MM-\"01\"'),'YYYY-MM-DD')");
        String oracle = "select " + oraclePeriod + " as event_period,  sum(ACTIVITY_COUNT) as new_user FROM " + this.getExternalDbNameAsPrefix() + "SST_SERVERSTATS where EVENT_ID='user.add'";
        if (period.equals("daily")) {
            oracle = oracle + " AND ACTIVITY_DATE > (SYSDATE - 90) ";
        }
        if ((result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle = oracle + " group by " + oraclePeriod), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                }
                catch (SQLException e) {
                    log.error("getNewUserStats() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        })).size() > 0) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    public List<ServerWideStatsRecord> getTop20Activities() {
        String mysql = "SELECT event_id, sum(if(event_date > DATE_SUB(CURDATE(), INTERVAL 7 DAY),1,0))/7 as last7, sum(if(event_date > DATE_SUB(CURDATE(), INTERVAL 30 DAY),1,0))/30 as last30, sum(if(event_date > DATE_SUB(CURDATE(), INTERVAL 365 DAY),1,0))/365 as last365 FROM " + this.getExternalDbNameAsPrefix() + "SST_EVENTS where event_id not in ('content.read', 'user.login', 'user.logout', 'pres.begin', 'pres.end', 'realm.upd', 'realm.add', 'realm.del', 'realm.upd.own', 'site.add', 'site.del', 'user.add', 'user.del') and event_date > DATE_SUB(CURDATE(), INTERVAL 365 DAY) group by 1 order by 2 desc, 3 desc, 4 desc LIMIT 20";
        String oracle = "select * from (SELECT event_id, sum(decode(sign(event_date - (SYSDATE - 7)), 1, 1, 0)) / 7 as last7, sum(decode(sign(event_date - (SYSDATE - 30)), 1, 1, 0)) / 30 as last30, sum(decode(sign(event_date - (SYSDATE - 365)), 1, 1, 0)) / 365 as last365 FROM " + this.getExternalDbNameAsPrefix() + "SST_EVENTS where event_id not in ('content.read', 'user.login', 'user.logout', 'pres.begin', 'pres.end', 'realm.upd', 'realm.add', 'realm.del', 'realm.upd.own', 'site.add', 'site.del', 'user.add', 'user.del') and event_date > (SYSDATE - 365) group by event_id order by last7 desc, last30 desc, last365 desc) where rownum <= 20";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getString(1));
                    info.add(result.getDouble(2));
                    info.add(result.getDouble(3));
                    info.add(result.getDouble(4));
                }
                catch (SQLException e) {
                    log.error("getTop20Activities() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        return result;
    }

    public List<ServerWideStatsRecord> getWeeklyRegularUsers() {
        String mysql = "select s.week_start, sum(if(s.user_logins >= 5,1,0)) as five_plus, sum(if(s.user_logins = 4,1,0)) as four, sum(if(s.user_logins = 3,1,0)) as three, sum(if(s.user_logins = 2,1,0)) as twice, sum(if(s.user_logins = 1,1,0)) as once from (select STR_TO_DATE(concat(date_format(login_date, '%x-%v'), ' Monday'),'%x-%v %W') as week_start, user_id, login_count as user_logins from " + this.getExternalDbNameAsPrefix() + "SST_USERSTATS group by 1, 2) as s group by 1";
        String oracle = "select s.week_start, sum(decode(sign(s.user_logins - 4), 1, 1, 0)) as five_plus, sum(decode(s.user_logins, 4, 1, 0)) as four,  sum(decode(s.user_logins, 3, 1, 0)) as three,  sum(decode(s.user_logins, 2, 1, 0)) as twice,  sum(decode(s.user_logins, 1, 1, 0)) as once from (select next_day(LOGIN_DATE - 7, 2) as week_start,       user_id, login_count as user_logins       from " + this.getExternalDbNameAsPrefix() + "SST_USERSTATS       group by next_day(LOGIN_DATE - 7, 2), user_id, login_count) s group by s.week_start";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getLong(2));
                    info.add(result.getLong(3));
                    info.add(result.getLong(4));
                    info.add(result.getLong(5));
                    info.add(result.getLong(6));
                }
                catch (SQLException e) {
                    log.error("getWeeklyRegularUsers() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        result.remove(result.size() - 1);
        return result;
    }

    public List<ServerWideStatsRecord> getHourlyUsagePattern() {
        String mysql = "select date(SESSION_START) as session_date, hour(session_start) as hour_start, count(distinct SESSION_USER) as unique_users from SAKAI_SESSION where SESSION_START > DATE_SUB(CURDATE(), INTERVAL 30 DAY) group by 1, 2";
        String oracle = "select trunc(SESSION_START, 'DDD') as session_date, to_number(to_char(session_start, 'HH24')) as hour_start, count(distinct SESSION_USER) as unique_users from SAKAI_SESSION where SESSION_START > (SYSDATE - 30) group by trunc(SESSION_START, 'DDD'), to_number(to_char(session_start, 'HH24'))";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getDate(1));
                    info.add(result.getInt(2));
                    info.add(result.getLong(3));
                }
                catch (SQLException e) {
                    log.error("getHourlyUsagePattern() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        return result;
    }

    public List<ServerWideStatsRecord> getToolCount() {
        String mysql = "SELECT registration, count(*) as site_count FROM SAKAI_SITE_TOOL where site_id not like '~%' and site_id not like '!%' group by 1 order by 2 desc";
        String oracle = "SELECT registration, count(*) as site_count FROM SAKAI_SITE_TOOL where site_id not like '~%' and site_id not like '!%' group by registration order by site_count desc";
        List result = this.sqlService.dbRead(this.getSqlForVendor(mysql, oracle), null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                ServerWideStatsRecordImpl info = new ServerWideStatsRecordImpl();
                try {
                    info.add(result.getString(1));
                    info.add(result.getInt(2));
                }
                catch (SQLException e) {
                    log.error("getToolCount() exception: " + e.getClass() + ": " + e.getMessage());
                    return null;
                }
                return info;
            }
        });
        return result;
    }

    public byte[] generateReportChart(String reportType, int width, int height) {
        if (reportType.equals("monthlyLogin")) {
            return this.createMonthlyLoginChart(width, height);
        }
        if (reportType.equals("weeklyLogin")) {
            return this.createWeeklyLoginChart(width, height);
        }
        if (reportType.equals("dailyLogin")) {
            return this.createDailyLoginChart(width, height);
        }
        if (reportType.equals("regularUsers")) {
            CategoryDataset dataset = this.getRegularUsersDataSet();
            if (dataset != null) {
                return this.generateStackedAreaChart(dataset, width, height);
            }
            return this.generateNoDataChart(width, height);
        }
        if (reportType.equals("hourlyUsage")) {
            BoxAndWhiskerCategoryDataset dataset = this.getHourlyUsageDataSet();
            if (dataset != null) {
                return this.generateBoxAndWhiskerChart(dataset, width, height);
            }
            return this.generateNoDataChart(width, height);
        }
        if (reportType.equals("topActivities")) {
            CategoryDataset dataset = this.getTopActivitiesDataSet();
            if (dataset != null) {
                return this.generateLayeredBarChart(dataset, width, height);
            }
            return this.generateNoDataChart(width, height);
        }
        if (reportType.equals("toolReport")) {
            return this.createToolAnalysisChart(width, height);
        }
        return this.generateNoDataChart(width, height);
    }

    private IntervalXYDataset getMonthlyLoginsDataSet() {
        Month month;
        List<ServerWideStatsRecord> totalLogins = this.getMonthlyTotalLogins();
        List<ServerWideStatsRecord> uniqueLogins = this.getMonthlyUniqueLogins();
        if (totalLogins == null || uniqueLogins == null) {
            return null;
        }
        TimeSeries s1 = new TimeSeries(msgs.getString("legend_logins"), Month.class);
        TimeSeries s2 = new TimeSeries(msgs.getString("legend_unique_logins"), Month.class);
        for (ServerWideStatsRecord login : totalLogins) {
            month = new Month((Date)login.get(0));
            s1.add((RegularTimePeriod)month, (Number)((Long)login.get(1)));
        }
        for (ServerWideStatsRecord login : uniqueLogins) {
            month = new Month((Date)login.get(0));
            s2.add((RegularTimePeriod)month, (Number)((Long)login.get(1)));
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }

    private IntervalXYDataset getWeeklyLoginsDataSet() {
        Week week;
        List<ServerWideStatsRecord> totalLogins = this.getWeeklyTotalLogins();
        List<ServerWideStatsRecord> uniqueLogins = this.getWeeklyUniqueLogins();
        if (totalLogins == null || uniqueLogins == null) {
            return null;
        }
        TimeSeries s1 = new TimeSeries(msgs.getString("legend_logins"), Week.class);
        TimeSeries s2 = new TimeSeries(msgs.getString("legend_unique_logins"), Week.class);
        for (ServerWideStatsRecord login : totalLogins) {
            week = new Week((Date)login.get(0));
            s1.add((RegularTimePeriod)week, (Number)((Long)login.get(1)));
        }
        for (ServerWideStatsRecord login : uniqueLogins) {
            week = new Week((Date)login.get(0));
            s2.add((RegularTimePeriod)week, (Number)((Long)login.get(1)));
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }

    private IntervalXYDataset getDailyLoginsDataSet() {
        Day day;
        List<ServerWideStatsRecord> totalLogins = this.getDailyTotalLogins();
        List<ServerWideStatsRecord> uniqueLogins = this.getDailyUniqueLogins();
        if (totalLogins == null || uniqueLogins == null) {
            return null;
        }
        TimeSeries s1 = new TimeSeries(msgs.getString("legend_logins"), Day.class);
        TimeSeries s2 = new TimeSeries(msgs.getString("legend_unique_logins"), Day.class);
        for (ServerWideStatsRecord login : totalLogins) {
            day = new Day((Date)login.get(0));
            s1.add((RegularTimePeriod)day, (Number)((Long)login.get(1)));
        }
        for (ServerWideStatsRecord login : uniqueLogins) {
            day = new Day((Date)login.get(0));
            s2.add((RegularTimePeriod)day, (Number)((Long)login.get(1)));
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        TimeSeries mavS1 = MovingAverage.createMovingAverage((TimeSeries)s1, (String)"7 day login moving average", (int)7, (int)7);
        dataset.addSeries(mavS1);
        TimeSeries mavS2 = MovingAverage.createMovingAverage((TimeSeries)s2, (String)"7 day unique login moving average", (int)7, (int)7);
        dataset.addSeries(mavS2);
        return dataset;
    }

    private IntervalXYDataset getMonthlySiteUserDataSet() {
        List<ServerWideStatsRecord> newUserList;
        Month month;
        List<ServerWideStatsRecord> siteCreatedDeletedList = this.getSiteCreatedDeletedStats("monthly");
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        if (siteCreatedDeletedList != null) {
            TimeSeries s1 = new TimeSeries(msgs.getString("legend_site_created"), Month.class);
            TimeSeries s2 = new TimeSeries(msgs.getString("legend_site_deleted"), Month.class);
            for (ServerWideStatsRecord login : siteCreatedDeletedList) {
                month = new Month((Date)login.get(0));
                s1.add((RegularTimePeriod)month, (Number)((Long)login.get(1)));
                s2.add((RegularTimePeriod)month, (Number)((Long)login.get(2)));
            }
            dataset.addSeries(s1);
            dataset.addSeries(s2);
        }
        if ((newUserList = this.getNewUserStats("monthly")) != null) {
            TimeSeries s3 = new TimeSeries(msgs.getString("legend_new_user"), Month.class);
            for (ServerWideStatsRecord login : newUserList) {
                month = new Month((Date)login.get(0));
                s3.add((RegularTimePeriod)month, (Number)((Long)login.get(1)));
            }
            dataset.addSeries(s3);
        }
        return dataset;
    }

    private IntervalXYDataset getWeeklySiteUserDataSet() {
        List<ServerWideStatsRecord> newUserList;
        Week week;
        List<ServerWideStatsRecord> siteCreatedDeletedList = this.getSiteCreatedDeletedStats("weekly");
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        if (siteCreatedDeletedList != null) {
            TimeSeries s1 = new TimeSeries(msgs.getString("legend_site_created"), Week.class);
            TimeSeries s2 = new TimeSeries(msgs.getString("legend_site_deleted"), Week.class);
            for (ServerWideStatsRecord login : siteCreatedDeletedList) {
                week = new Week((Date)login.get(0));
                s1.add((RegularTimePeriod)week, (Number)((Long)login.get(1)));
                s2.add((RegularTimePeriod)week, (Number)((Long)login.get(2)));
            }
            dataset.addSeries(s1);
            dataset.addSeries(s2);
        }
        if ((newUserList = this.getNewUserStats("weekly")) != null) {
            TimeSeries s3 = new TimeSeries(msgs.getString("legend_new_user"), Week.class);
            for (ServerWideStatsRecord login : newUserList) {
                week = new Week((Date)login.get(0));
                s3.add((RegularTimePeriod)week, (Number)((Long)login.get(1)));
            }
            dataset.addSeries(s3);
        }
        return dataset;
    }

    private IntervalXYDataset getDailySiteUserDataSet() {
        List<ServerWideStatsRecord> newUserList;
        Day day;
        List<ServerWideStatsRecord> siteCreatedDeletedList = this.getSiteCreatedDeletedStats("daily");
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        if (siteCreatedDeletedList != null) {
            TimeSeries s1 = new TimeSeries(msgs.getString("legend_site_created"), Day.class);
            TimeSeries s2 = new TimeSeries(msgs.getString("legend_site_deleted"), Day.class);
            for (ServerWideStatsRecord login : siteCreatedDeletedList) {
                day = new Day((Date)login.get(0));
                s1.add((RegularTimePeriod)day, (Number)((Long)login.get(1)));
                s2.add((RegularTimePeriod)day, (Number)((Long)login.get(2)));
            }
            dataset.addSeries(s1);
            dataset.addSeries(s2);
        }
        if ((newUserList = this.getNewUserStats("daily")) != null) {
            TimeSeries s3 = new TimeSeries(msgs.getString("legend_new_user"), Day.class);
            for (ServerWideStatsRecord login : newUserList) {
                day = new Day((Date)login.get(0));
                s3.add((RegularTimePeriod)day, (Number)((Long)login.get(1)));
            }
            dataset.addSeries(s3);
        }
        return dataset;
    }

    private CategoryDataset getRegularUsersDataSet() {
        List<ServerWideStatsRecord> regularUsersList = this.getWeeklyRegularUsers();
        if (regularUsersList == null) {
            return null;
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        for (ServerWideStatsRecord regularUsers : regularUsersList) {
            Date weekStart = (Date)regularUsers.get(0);
            dataset.addValue((Number)((Long)regularUsers.get(1)), (Comparable)((Object)"5+"), (Comparable)((Object)formatter.format(weekStart)));
            dataset.addValue((Number)((Long)regularUsers.get(2)), (Comparable)((Object)"4"), (Comparable)((Object)formatter.format(weekStart)));
            dataset.addValue((Number)((Long)regularUsers.get(3)), (Comparable)((Object)"3"), (Comparable)((Object)formatter.format(weekStart)));
            dataset.addValue((Number)((Long)regularUsers.get(4)), (Comparable)((Object)"2"), (Comparable)((Object)formatter.format(weekStart)));
            dataset.addValue((Number)((Long)regularUsers.get(5)), (Comparable)((Object)"1"), (Comparable)((Object)formatter.format(weekStart)));
        }
        return dataset;
    }

    private BoxAndWhiskerCategoryDataset getHourlyUsageDataSet() {
        List<ServerWideStatsRecord> hourlyUsagePattern = this.getHourlyUsagePattern();
        if (hourlyUsagePattern == null) {
            return null;
        }
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        ArrayList[] hourList = new ArrayList[24];
        for (int ii = 0; ii < 24; ++ii) {
            hourList[ii] = new ArrayList();
        }
        int totalDays = 0;
        Date prevDate = null;
        for (ServerWideStatsRecord regularUsers : hourlyUsagePattern) {
            Date currDate = (Date)regularUsers.get(0);
            if (!currDate.equals(prevDate)) {
                prevDate = currDate;
                ++totalDays;
            }
            hourList[(Integer)regularUsers.get(1)].add((Long)regularUsers.get(2));
        }
        for (int ii = 0; ii < 24; ++ii) {
            for (int jj = hourList[ii].size(); jj < totalDays; ++jj) {
                hourList[ii].add(0L);
            }
            dataset.add((List)hourList[ii], (Comparable)((Object)"Last 30 days"), (Comparable)((Object)("" + ii)));
        }
        return dataset;
    }

    private CategoryDataset getTopActivitiesDataSet() {
        List<ServerWideStatsRecord> topActivitiesList = this.getTop20Activities();
        if (topActivitiesList == null) {
            return null;
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (ServerWideStatsRecord regularUsers : topActivitiesList) {
            String event = (String)regularUsers.get(0);
            dataset.addValue((Number)((Double)regularUsers.get(1)), (Comparable)((Object)"last 7 days"), (Comparable)((Object)event));
            dataset.addValue((Number)((Double)regularUsers.get(2)), (Comparable)((Object)"last 30 days"), (Comparable)((Object)event));
            dataset.addValue((Number)((Double)regularUsers.get(3)), (Comparable)((Object)"last 365 days"), (Comparable)((Object)event));
        }
        return dataset;
    }

    private CategoryDataset getToolAnalysisDataSet() {
        List<ServerWideStatsRecord> toolCountList = this.getToolCount();
        if (toolCountList == null) {
            return null;
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (ServerWideStatsRecord regularUsers : toolCountList) {
            String toolId = (String)regularUsers.get(0);
            dataset.addValue((Number)((Integer)regularUsers.get(1)), (Comparable)((Object)""), (Comparable)((Object)toolId));
        }
        return dataset;
    }

    private byte[] createMonthlyLoginChart(int width, int height) {
        IntervalXYDataset dataset1 = this.getMonthlyLoginsDataSet();
        IntervalXYDataset dataset3 = this.getMonthlySiteUserDataSet();
        if (dataset1 == null || dataset3 == null) {
            return this.generateNoDataChart(width, height);
        }
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
        renderer1.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer1.setSeriesPaint(0, (Paint)Color.RED);
        DateAxis domainAxis = new DateAxis("");
        domainAxis.setTickUnit(new DateTickUnit(1, 1, (DateFormat)new SimpleDateFormat("yyyy-MM")));
        domainAxis.setTickMarkPosition(DateTickMarkPosition.START);
        domainAxis.setVerticalTickLabels(true);
        domainAxis.setLowerMargin(0.01);
        domainAxis.setUpperMargin(0.01);
        NumberAxis axis1 = new NumberAxis("Total Logins");
        axis1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        axis1.setLabelPaint((Paint)Color.RED);
        axis1.setTickLabelPaint((Paint)Color.RED);
        XYPlot plot1 = new XYPlot((XYDataset)dataset1, null, (ValueAxis)axis1, (XYItemRenderer)renderer1);
        plot1.setBackgroundPaint((Paint)Color.lightGray);
        plot1.setDomainGridlinePaint((Paint)Color.white);
        plot1.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer3 = new XYLineAndShapeRenderer(true, false);
        renderer3.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer3.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer3.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer3.setSeriesPaint(0, (Paint)Color.GREEN);
        renderer3.setSeriesPaint(1, (Paint)Color.BLACK);
        renderer3.setSeriesPaint(2, (Paint)Color.CYAN);
        axis1 = new NumberAxis("count");
        axis1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYPlot plot2 = new XYPlot((XYDataset)dataset3, null, (ValueAxis)axis1, (XYItemRenderer)renderer3);
        plot2.setBackgroundPaint((Paint)Color.lightGray);
        plot2.setDomainGridlinePaint((Paint)Color.white);
        plot2.setRangeGridlinePaint((Paint)Color.white);
        CombinedDomainXYPlot cplot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        cplot.add(plot1, 3);
        cplot.add(plot2, 2);
        cplot.setGap(8.0);
        cplot.setDomainGridlinePaint((Paint)Color.white);
        cplot.setDomainGridlinesVisible(true);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)cplot, false);
        LegendTitle legend = new LegendTitle((LegendItemSource)cplot);
        chart.addSubtitle((Title)legend);
        chart.setBackgroundPaint((Paint)ServerWideReportManagerImpl.parseColor(this.statsManager.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ServerWideReportManagerImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            log.warn("Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] createWeeklyLoginChart(int width, int height) {
        IntervalXYDataset dataset1 = this.getWeeklyLoginsDataSet();
        IntervalXYDataset dataset2 = this.getWeeklySiteUserDataSet();
        if (dataset1 == null || dataset2 == null) {
            return this.generateNoDataChart(width, height);
        }
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
        renderer1.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer1.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer1.setSeriesPaint(0, (Paint)Color.RED);
        renderer1.setSeriesPaint(0, (Paint)Color.BLUE);
        DateAxis domainAxis = new DateAxis("");
        domainAxis.setTickUnit(new DateTickUnit(2, 7, (DateFormat)new SimpleDateFormat("yyyy-MM-dd")));
        domainAxis.setTickMarkPosition(DateTickMarkPosition.START);
        domainAxis.setVerticalTickLabels(true);
        domainAxis.setLowerMargin(0.01);
        domainAxis.setUpperMargin(0.01);
        NumberAxis rangeAxis = new NumberAxis("count");
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYPlot plot1 = new XYPlot((XYDataset)dataset1, null, (ValueAxis)rangeAxis, (XYItemRenderer)renderer1);
        plot1.setBackgroundPaint((Paint)Color.lightGray);
        plot1.setDomainGridlinePaint((Paint)Color.white);
        plot1.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(true, false);
        renderer2.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer2.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer2.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer2.setSeriesPaint(0, (Paint)Color.GREEN);
        renderer2.setSeriesPaint(1, (Paint)Color.BLACK);
        renderer2.setSeriesPaint(2, (Paint)Color.CYAN);
        rangeAxis = new NumberAxis("count");
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYPlot plot2 = new XYPlot((XYDataset)dataset2, null, (ValueAxis)rangeAxis, (XYItemRenderer)renderer2);
        plot2.setBackgroundPaint((Paint)Color.lightGray);
        plot2.setDomainGridlinePaint((Paint)Color.white);
        plot2.setRangeGridlinePaint((Paint)Color.white);
        CombinedDomainXYPlot cplot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        cplot.add(plot1, 3);
        cplot.add(plot2, 2);
        cplot.setGap(8.0);
        cplot.setDomainGridlinePaint((Paint)Color.white);
        cplot.setDomainGridlinesVisible(true);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)cplot, false);
        LegendTitle legend = new LegendTitle((LegendItemSource)cplot);
        chart.addSubtitle((Title)legend);
        chart.setBackgroundPaint((Paint)ServerWideReportManagerImpl.parseColor(this.statsManager.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ServerWideReportManagerImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            log.warn("Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] createDailyLoginChart(int width, int height) {
        IntervalXYDataset dataset1 = this.getDailyLoginsDataSet();
        IntervalXYDataset dataset2 = this.getDailySiteUserDataSet();
        if (dataset1 == null || dataset2 == null) {
            return this.generateNoDataChart(width, height);
        }
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
        renderer1.setSeriesPaint(0, (Paint)Color.RED);
        renderer1.setSeriesPaint(1, (Paint)Color.BLUE);
        renderer1.setSeriesPaint(2, (Paint)Color.RED);
        renderer1.setSeriesPaint(3, (Paint)Color.BLUE);
        renderer1.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer1.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 2));
        BasicStroke dashLineStroke = new BasicStroke(2.0f, 0, 1, 0.0f, new float[]{4.0f}, 0.0f);
        renderer1.setSeriesStroke(2, (Stroke)dashLineStroke);
        renderer1.setSeriesStroke(3, (Stroke)dashLineStroke);
        DateAxis domainAxis = new DateAxis("");
        domainAxis.setTickUnit(new DateTickUnit(2, 7, (DateFormat)new SimpleDateFormat("yyyy-MM-dd")));
        domainAxis.setTickMarkPosition(DateTickMarkPosition.START);
        domainAxis.setVerticalTickLabels(true);
        domainAxis.setLowerMargin(0.01);
        domainAxis.setUpperMargin(0.01);
        NumberAxis rangeAxis = new NumberAxis("count");
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYPlot plot1 = new XYPlot((XYDataset)dataset1, null, (ValueAxis)rangeAxis, (XYItemRenderer)renderer1);
        plot1.setBackgroundPaint((Paint)Color.lightGray);
        plot1.setDomainGridlinePaint((Paint)Color.white);
        plot1.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(true, false);
        renderer2.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer2.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer2.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f, 1, 2));
        renderer2.setSeriesPaint(0, (Paint)Color.GREEN);
        renderer2.setSeriesPaint(1, (Paint)Color.BLACK);
        renderer2.setSeriesPaint(2, (Paint)Color.CYAN);
        rangeAxis = new NumberAxis("count");
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYPlot plot2 = new XYPlot((XYDataset)dataset2, null, (ValueAxis)rangeAxis, (XYItemRenderer)renderer2);
        plot2.setBackgroundPaint((Paint)Color.lightGray);
        plot2.setDomainGridlinePaint((Paint)Color.white);
        plot2.setRangeGridlinePaint((Paint)Color.white);
        CombinedDomainXYPlot cplot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        cplot.add(plot1, 3);
        cplot.add(plot2, 2);
        cplot.setGap(8.0);
        cplot.setDomainGridlinePaint((Paint)Color.white);
        cplot.setDomainGridlinesVisible(true);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)cplot, false);
        LegendTitle legend = new LegendTitle((LegendItemSource)cplot);
        chart.addSubtitle((Title)legend);
        chart.setBackgroundPaint((Paint)ServerWideReportManagerImpl.parseColor(this.statsManager.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ServerWideReportManagerImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            log.warn("Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] generateStackedAreaChart(CategoryDataset dataset, int width, int height) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)ServerWideReportManagerImpl.parseColor(this.statsManager.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ServerWideReportManagerImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.7f);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)new Color(205, 173, 0));
        renderer.setSeriesPaint(1, (Paint)new Color(139, 69, 19));
        renderer.setSeriesPaint(2, (Paint)Color.BLUE);
        renderer.setSeriesPaint(3, (Paint)Color.GREEN);
        renderer.setSeriesPaint(4, (Paint)Color.WHITE);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            log.warn("Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] generateBoxAndWhiskerChart(BoxAndWhiskerCategoryDataset dataset, int width, int height) {
        JFreeChart chart = ChartFactory.createBoxAndWhiskerChart(null, null, null, (BoxAndWhiskerCategoryDataset)dataset, (boolean)false);
        chart.setBackgroundPaint((Paint)ServerWideReportManagerImpl.parseColor(this.statsManager.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ServerWideReportManagerImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            log.warn("Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] generateLayeredBarChart(CategoryDataset dataset, int width, int height) {
        JFreeChart chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)ServerWideReportManagerImpl.parseColor(this.statsManager.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ServerWideReportManagerImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        LayeredBarRenderer renderer = new LayeredBarRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setSeriesBarWidth(0, 0.6);
        renderer.setSeriesBarWidth(1, 0.8);
        renderer.setSeriesBarWidth(2, 1.0);
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setRowRenderingOrder(SortOrder.DESCENDING);
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, new Color(0, 0, 64));
        GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, new Color(0, 64, 0));
        GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, new Color(64, 0, 0));
        renderer.setSeriesPaint(0, (Paint)gp0);
        renderer.setSeriesPaint(1, (Paint)gp1);
        renderer.setSeriesPaint(2, (Paint)gp2);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            log.warn("Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] createToolAnalysisChart(int width, int height) {
        CategoryDataset dataset = this.getToolAnalysisDataSet();
        if (dataset == null) {
            return this.generateNoDataChart(width, height);
        }
        JFreeChart chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)ServerWideReportManagerImpl.parseColor(this.statsManager.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ServerWideReportManagerImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.7f);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(false);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setLowerMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setUpperMargin(0.2);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        StandardCategoryItemLabelGenerator generator = new StandardCategoryItemLabelGenerator("{1}", NumberFormat.getInstance(new ResourceLoader().getLocale()));
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)generator);
        renderer.setBaseItemLabelFont(new Font("SansSerif", 0, 9));
        renderer.setBaseItemLabelsVisible(true);
        renderer.setItemMargin(0.0);
        renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            log.warn("Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] generateNoDataChart(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2d = img.createGraphics();
        g2d.setBackground(ServerWideReportManagerImpl.parseColor(this.statsManager.getChartBackgroundColor()));
        g2d.clearRect(0, 0, width - 1, height - 1);
        g2d.setColor(ServerWideReportManagerImpl.parseColor("#cccccc"));
        g2d.drawRect(0, 0, width - 1, height - 1);
        Font f = new Font("SansSerif", 0, 12);
        g2d.setFont(f);
        FontMetrics fm = g2d.getFontMetrics(f);
        String noData = msgs.getString("no_data");
        int noDataWidth = fm.stringWidth(noData);
        int noDataHeight = fm.getHeight();
        g2d.setColor(ServerWideReportManagerImpl.parseColor("#555555"));
        g2d.drawString(noData, width / 2 - noDataWidth / 2, height / 2 - noDataHeight / 2 + 2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            log.warn("Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    public static Color parseColor(String color) {
        if (color != null) {
            if (color.trim().startsWith("#")) {
                return new Color(Integer.parseInt(color.substring(1), 16));
            }
            if (color.trim().startsWith("rgb")) {
                String values = color.substring(color.indexOf("(") + 1, color.indexOf(")"));
                String[] rgb = values.split(",");
                return new Color(Integer.parseInt(rgb[0].trim()), Integer.parseInt(rgb[1].trim()), Integer.parseInt(rgb[2].trim()));
            }
            if (color.equalsIgnoreCase("black")) {
                return Color.black;
            }
            if (color.equalsIgnoreCase("grey")) {
                return Color.gray;
            }
            if (color.equalsIgnoreCase("yellow")) {
                return Color.yellow;
            }
            if (color.equalsIgnoreCase("green")) {
                return Color.green;
            }
            if (color.equalsIgnoreCase("blue")) {
                return Color.blue;
            }
            if (color.equalsIgnoreCase("red")) {
                return Color.red;
            }
            if (color.equalsIgnoreCase("orange")) {
                return Color.orange;
            }
            if (color.equalsIgnoreCase("cyan")) {
                return Color.cyan;
            }
            if (color.equalsIgnoreCase("magenta")) {
                return Color.magenta;
            }
            if (color.equalsIgnoreCase("darkgray")) {
                return Color.darkGray;
            }
            if (color.equalsIgnoreCase("lightgray")) {
                return Color.lightGray;
            }
            if (color.equalsIgnoreCase("pink")) {
                return Color.pink;
            }
            if (color.equalsIgnoreCase("white")) {
                return Color.white;
            }
        }
        log.info("Unable to parse body background-color (color:" + color + "). Assuming white.");
        return Color.white;
    }

    private String getSqlForVendor(String mysql, String oracle) {
        if (StringUtils.equals((String)this.dbVendor, (String)"mysql")) {
            return mysql;
        }
        if (StringUtils.equals((String)this.dbVendor, (String)"oracle")) {
            return oracle;
        }
        return null;
    }

    private String getExternalDbNameAsPrefix() {
        if (StringUtils.isNotBlank((String)this.externalDbName)) {
            return this.externalDbName + ".";
        }
        return "";
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public void setStatsManager(StatsManager statsManager) {
        this.statsManager = statsManager;
    }

    public void setUsageSessionService(UsageSessionService usageSessionService) {
        this.usageSessionService = usageSessionService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }
}

